#ifndef ONE_WIRE_C
#define ONE_WIRE_C

#include <htc.h>
#include "config.h"

/*
 * onewire_reset()
 * Description: Initiates the one wire bus.
 */
// OK if just using a single permanently connected device
void onewire_reset() {
	DQ_TRIS = 0;
    DQ_PIN = 0;       				// pull the bus low for reset
    __delay_us(500);
    DQ_TRIS = 1;    			 	// float the bus high
    __delay_us(500);                // wait-out remaining initialisation window
    DQ_TRIS = 1;
}


/*
 * onewire_write(int8 data)
 * Arguments: a byte of data.
 * Description: writes a byte of data to the device.
 */
void onewire_write(unsigned char data)
{
    unsigned char count;
    unsigned char data_bit;

    for(count = 0; count < 8; ++count)
	{
		data_bit = data & 0x01;
		DQ_TRIS = 0;
        DQ_PIN = 0;
        __delay_us(2);                // pull 1-wire low to initiate write time-slot.
        DQ_PIN = data_bit;
        data=data>>1;
        __delay_us(60);               // wait until end of write slot.
        DQ_TRIS = 1;				  // set 1-wire high again,
        __delay_us(2);                // for more than 1us minimum.
    }
}

/*
 * onewire_read()
 * Description: reads and returns a byte of data from the device.
 */
unsigned char onewire_read()
{
    unsigned char count, data, bit_in;
    
    data = 0;

    for(count = 0; count < 8; ++count)
	{
		DQ_TRIS = 0;
        DQ_PIN = 0;
        __delay_us(2);                // pull 1-wire low to initiate read time-slot.
        DQ_TRIS = 1;				  // now let 1-wire float high,
        __delay_us(8);                // let device state stabilise,
        
        bit_in = DQ_PIN;
        data = data >> 1;        	  //-- Shift previous bits across
		if(bit_in == 1)               //-- If data was high then add High bit to data
			data +=0x80;
		
        __delay_us(120);              // wait until end of read slot.
    }
    return data;
} 


/*
 * Reads temp from the DS18B20
 */
float ds1820_read(void)
{
	unsigned char busy=0, temp1, temp2;
    int temp3;
    float result;

    onewire_reset();
    onewire_write(0xCC);            //Skip ROM, address all devices
    onewire_write(0x44);            //Start temperature conversion

    while(busy == 0)                //Wait while busy (bus is low)
        busy = onewire_read();

    onewire_reset();
    onewire_write(0xCC);            //Skip ROM, address all devices
    onewire_write(0xBE);            //Read scratchpad
    temp1 = onewire_read();
    temp2 = onewire_read();
    
    temp3 = temp2;
    temp3 = temp3 << 8;
    temp3 = temp3 | temp1;
 
    //result = (float) temp3 / 2.0;   //Calculation for DS18S20 with 0.5 deg C resolution
    result = (float) temp3 / 16.0;    //Calculation for DS18B20
 
    //__delay_ms(200);
     __delay_us(200);
    return(result);
}	

#endif /*ONE_WIRE_C*/