#include <htc.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "config.h"
#include "lcd.h" 
#include "18f4550.h"
 

#define sw1 PORTEbits.RE0 
#define sw2 PORTEbits.RE1
#define sw3 PORTEbits.RE2
#define sw4 PORTEbits.RA4



__CONFIG(1,0x0200);
__CONFIG(2,0X1E1F);
__CONFIG(3,0X8100);
__CONFIG(4,0X00C1);
__CONFIG(5,0XC00F);


//__CONFIG(WDTE_OFF & FOSC_INTOSCIO & PWRTE_OFF & MCLRE_ON & BOREN_OFF & LVP_OFF);

#include "1wire.h"

void Wait(unsigned int delay)
{
	for(;delay;delay--)
		__delay_us(100);

}

void sendbyte(unsigned char i)
{
	SPEN = 1;
	TXEN = 1;
	TXREG = i;
	while(TRMT == 0);
}

unsigned char recvbyte()
{
	CREN = 0;
	CREN = 1;				//enable receive
	while(RCIF == 0);		//wait for received byte
	return RCREG;
}

void putch(unsigned char c)
{
	sendbyte(c);
}


void setup(void)
{



  ADCON1 = 0b00001110;
  TRISC = 0b11111100;  
  TRISE = 0b00000111;  
	LCDInit(LS_BLINK);
	Wait(200);

    TRISC=0;
    LCDWriteString("START");

	
	TXSTA = 0b00000100;		//configure tx
	RCSTA = 0b10000000;		//configure rx
	SPBRG = 25;				//set baud rate to 19200 (datasheet says 25, bodged to 24 as it works better!)
}  


void main()
{
	float temp;
	int i;
	setup();
 

	while(1)
	{

		temp = ds1820_read();
       
		if (temp > 1) {
         LCDWriteString("-----");
		}


		temp = temp +1;
		i = temp;
		 LCDWriteInt(i,3);

Wait(200);
LCDClear();
	}	
}
