/* LCD Include-Datei
 *
 * 03/2005 Florian Schffer, http://www.blafusel.de
 *
08.2009 uprava Z. Svoboda
 */

#include <avr/io.h>
#include <util/delay.h> 
#include <avr/interrupt.h>           

#define PORT_E     PORTD
#define PIN_E      PD5
#define DDR_E      DDRD
#define DD_E       DDD5
#define PORT_RS    PORTD
#define PIN_RS     PD4
#define DDR_RS     DDRD
#define DD_RS      DDD4
#define PORT_DATA  PORTB
#define DDR_DATA   DDRB

#define delay(us)  _delay_loop_2 (((F_CPU/4000)*us)/1000)		// wartet s

/*--------------------------------------------------------------------------------------------------
                                Private function prototypes
--------------------------------------------------------------------------------------------------*/
void lcd_write (uint8_t data, uint8_t rs);

// Kommando oder Zeichen an Display senden: rs=0 => Kommando, rs=1 => Zeichen
void lcd_write (uint8_t data, uint8_t rs)   
{
  cli();
	if (rs)    				// write data (RS=1, RW=0) 
    PORT_RS |= (1<<PIN_RS); 
  else     				// write instruction (RS=0, RW=0) 
    PORT_RS &=  ~(1<<PIN_RS);		
	PORT_E |= (1<<PIN_E );		// Enable = HIGH
	PORT_DATA = (PORT_DATA & 0xC3) | ((data>>2)&0x3C); 
  PORT_E &= ~(1<<PIN_E );		// Enable = LOW
	PORT_E |= (1<<PIN_E );		// Enable = HIGH
  PORT_DATA = (PORT_DATA & 0xC3) | ((data<<2)&0x3C); 
	PORT_E &= ~(1<<PIN_E );		// Enable = LOW
	sei();
	if(!rs && (data<4)) delay(2000); else delay(64);
}

// Display loeschen
void LcdClear (void)   
{
	lcd_write(0x02,0);   	// B 0000 0010 => Display loeschen
	lcd_write(0x01,0);   	// B 0000 0001 => Cursor Home
}

// Zeichenausgabe
void LcdChr (uint8_t zeichen)   
{
  lcd_write (zeichen, 1);   
}

// gibt eine Zeichenkette auf dem LCD aus
void LcdStr ( char *text)    
{
  uint8_t i = 0;
  while (text[i]!=0) 
  {
    LcdChr(text[i]);
    i++;
  }
}

// Cursorpositionieren (Zeile, Spalte)
void LcdGotoXY (uint8_t zeile, uint8_t spalte)    
{
  if (zeile == 1) lcd_write(0x80+spalte-1,0);   // DD-RAM Adress 1. Zeile + Spalte
  if (zeile == 2) lcd_write(0xC0+spalte-1,0);   // DD-RAM Adress 2. Zeile + Spalte 
}

// Display initialisieren. Einmal als erstes aufrufen
void LcdInit (void)
{
  DDR_E |= (1<<DD_E);
  DDR_RS |= (1<<DD_RS);
  DDR_DATA |= 0x3C;
  PORT_RS &=  ~(1<<PIN_RS);
  PORT_E &=  ~( 1<<PIN_E );
  PORT_DATA &= 0xC3;

	delay(30000);		// 30ms warten bis LCD wirklich bereit (max. Wert lt. Datenblatt)

	lcd_write(0x30,0); 		// B 0011 1000 => 8-Bit-Modus aktivieren
  delay(4200);
  lcd_write(0x30,0);
 	delay(64);	
	lcd_write(0x30,0);
  lcd_write(0x20,0);// B 0010 0000 => mit 8-Bit-Command in 4-Bit-Modus umschalten 
	// ab jetzt 4-Bit-Modus
	lcd_write(0x28,0);     // B 0010 1000 => Function Set: 4Bit (kein 8-Bit Bus), zweizeiliges Display, 5x7 Dots/Zeichen (kein 5x10)
	lcd_write(0x08,0);     // B 0000 1000 => Display On/Off: Display off
	lcd_write(0x01,0);     
	lcd_write(0x06,0);     // B 0000 0110 => Entry Mode Set: DD-RAM autom. inkr., Cursor bewegen
	lcd_write(0x0C,0);     // B 0000 1100 => Display On/Off: Display on
}


