;---------------------------------------------------------------------------;
; Extended itoa                     (C)ChaN, 2006
;
;
; 06.2009 uprava Z. Svoboda

#define SPM_PAGESIZE

.nolist
#include <avr/io.h>	// Include device specific definitions.
.list

#ifdef SPM_PAGESIZE	// Recent devices have "lpm Rd,Z+" and "movw".
.macro	_LPMI	reg
	lpm	\reg, Z+
.endm
.macro	_MOVW	dh,dl, sh,sl
	movw	\dl, \sl
.endm
#else			// Earlier devices do not have "lpm Rd,Z+" nor "movw".
.macro	_LPMI	reg
	lpm
	mov	\reg, r0
	adiw	ZL, 1
.endm
.macro	_MOVW	dh,dl, sh,sl
	mov	\dl, \sl
	mov	\dh, \sh
.endm
#endif

.section .text

;---------------------------------------------------------------------------
; Extended direct numeral string output (32bit version)
;
;Prototype: char* xitoa                // pointer to output string
;                       (long value,   // value to be output
;                       char radix,	   // radix
;                       char width,    // minimum width
;                       char *string); // output string
;

.global xitoa
.func xitoa
xitoa:			;r25:r22 = value, r20 = base, r18 = digits, r16 = string
    push YH;
    push YL;
	clr	r31		;r31 = stack level
  _MOVW	YH, YL, r17, r16
	ldi	r30, ' '	;r30 = sign
	ldi	r19, ' '	;r19 = filler
	sbrs	r20, 7		;When base indicates signd format and the value
	rjmp	0f		;is minus, add a '-'.
	neg	r20		;
	sbrs	r25, 7		;
	rjmp	0f		;
	ldi	r30, '-'	;
	com	r22		;
	com	r23		;
	com	r24		;
	com	r25		;
	adc	r22, r1		;
	adc	r23, r1		;
	adc	r24, r1		;
	adc	r25, r1		;/
0:	sbrs	r18, 7		;When digits indicates zero filled,
	rjmp	1f		;filler is '0'.
	neg	r18		;
	ldi	r19, '0'	;/
				;----- string conversion loop
1:	ldi	r21, 32		;r26 = r25:r22 % r20
	clr	r26		;r25:r22 /= r20
2:	lsl	r22		;
	rol	r23		;
	rol	r24		;
	rol	r25		;
	rol	r26		;
	cp	r26, r20	;
	brcs	3f		;
	sub	r26, r20	;
	inc	r22		;
3:	dec	r21		;
	brne	2b		;/
	cpi	r26, 10		;r26 is a numeral digit '0'-'F'
	brcs	4f		;
	subi	r26, -7		;
4:	subi	r26, -'0'	;/
	st	Y+, r26		;Stack it
	inc	r31		;/
	cp	r22, r1		;Repeat until r25:r22 gets zero
	cpc	r23, r1		;
	cpc	r24, r1		;
	cpc	r25, r1		;
	brne	1b		;/

	cpi	r30, '-'	;Minus sign if needed
	brne	5f		;
	st	Y+, r30		;
	inc	r31		;/
5:	cp	r31, r18	;Filler
	brcc	6f		;
	st	Y+, r19		;
	inc	r31		;
	rjmp	5b		;/

6:	st	Y, r1 ;
    pop YL;
    pop YH;
    _MOVW r25, r24,	r17, r16

	_MOVW r27, r26,	r25, r24  	; zacatek standardni fce strrev
    _MOVW r31, r30,	r25, r24
7:  ld	r0, Z+
    and	r0, r0
    brne	7b      
    sbiw	r30, 0x02
8:  cp	r26, r30
    cpc	r27, r31
    brcc	9f     	
    ld	r23, X
    ld	r22, Z
    st	Z, r23
    sbiw	r30, 0x01	
    st	X+, r22
    rjmp	8b     	
9:  ret                        ; konec standardni fce strrev
	
.endfunc


