/*--------------------------------------------------------------------------------------------------

  Name         :  kw1281.h

  Description  :  Stellt KW1281-Funktionen zur Verfgung

  Author       :  08/2005 Florian Schaeffer

  History      :  08/2005 - First release.

                  07.2009 uprava Z. Svoboda

--------------------------------------------------------------------------------------------------*/
#ifndef _KW1281_H_

#define _KW1281_H_

/*--------------------------------------------------------------------------------------------------
                                  General purpose constants
--------------------------------------------------------------------------------------------------*/
#define CLR_ERR  0x05
#define END      0x06
#define GET_ERR  0x07
#define ACK      0x09
#define GET_GRP  0x29
#define ANS_GRP  0xE7
#define ASCII    0xF6
#define ANS_ERR  0xFC

/*--------------------------------------------------------------------------------------------------
                                 Public function prototypes
--------------------------------------------------------------------------------------------------*/
void delay_ms(uint16_t);
void kw1281_init (void);
int8_t kw1281_ecu_sync (void);
uint8_t kw1281_get_byte (void);
void kw1281_give_byte (uint8_t);
void kw1281_give_bl_end (void);
void kw1281_snd_ack (void);
uint8_t kw1281_get_header (void);
void  kw1281_get_ids (void);
uint8_t kw1281_get_grp_data (uint8_t []);
void kw1281_get_grp (uint8_t);
void kw1281_snd_cmd (uint8_t);
uint8_t kw1281_get_data (uint8_t *,uint8_t []);

#endif  //  _KW1281_H_
/*--------------------------------------------------------------------------------------------------
                                         End of file.
--------------------------------------------------------------------------------------------------*/
