/* Stellt USART-Funktionen zur Verfgung
 *
 * 08/2005 Florian Schaeffer

08.2009 uprava Z. Svoboda
 */


#include <avr/interrupt.h>
#include <util/delay.h>
#include "uart.h"

/*--------------------------------------------------------------------------------------------------
                                Private function prototypes
--------------------------------------------------------------------------------------------------*/
volatile uint8_t udr_data, rbuffcnt, rbuffpos, uart_err = 0;	// Daten aus dem UART (volatile, damit nicht wegoptimiert wird vom Prprozessor)
volatile uint8_t cit_getc;
volatile uint8_t rbuff[RBUFFLEN];

// Interruptroutine, die Zeichen aus dem UART sofort ausliest, wenn empfangen

ISR (USART_RXC_vect) 	 		
{
 	udr_data= UDR; 	//Byte auf jeden Fall abholen, sonst Endlosinterrupt
	if(rbuffcnt < RBUFFLEN)		// keinen Zeichen in einem vollen Ringpuffer berschreiben
		rbuff[(rbuffpos+rbuffcnt++) % RBUFFLEN] = udr_data;	// welche Position? Gelesene Zeichenpos + Anzahl Zeichen MODULO Pufferlnge 
																// (von 0 wieder anfangen, wenn Ende erreicht)  
}

// Nchstes zu lesendes Zeichen aus Ringpuffer zurckgeben
uint8_t ser_getc (void)
{
 	uint8_t c = 0;

  if(!uart_err)
  {
    cit_getc = 40;
	  while(!rbuffcnt && cit_getc);   		// Warte bis ein Zeichen vorhanden ist
    if (cit_getc)	
	  {
	    cli();						// Interruptbehandlung kurz aussetzen. Ab jetzt mu es schnell gehen (wenig Befehle), damit Zeichen, die 
							         	// ab jetzt eintreffen nicht verloren gehen.
	    rbuffcnt--;					// anschl. ein Zeichen weniger zum ausgeben
	    c = rbuff [rbuffpos++];	// Zeichen holen, was nach dem bereits gelesenen liegt
	    if (rbuffpos >= RBUFFLEN)  rbuffpos = 0;	// wenn hinterstes Zeichen (rechts im Puffer) gelesen wurde, dann wieder vorne anfangen

	    sei();						// Interruptbehandlung wieder aktivieren
	  }
	  else uart_err = 1;
  }
	return (c);		// Zeichen zurckgeben
}

void uart_putc(uint8_t c)
{
  while(!(UCSRA & (1 << UDRE)));   	// warte, bis UDR bereit 
  _delay_ms (11);		// WICHTIG! Korrigiert Timing, da sonst ECU berlastet wird. http://www.blafusel.de/misc/obd2_kw1281.html#11
  UDR = c;    		// sende Zeichen  
}

void uart_ini (uint16_t baud_rate)
{
	UCSRB = (1 << TXEN) | (1 << RXEN ) | (1 << RXCIE);	// UART TX, RX einschalten, Interruptauslsung fr eingehende Daten aktivieren
  UCSRC = 0x86;  // 8N1
  UBRRH=(uint16_t)(UART_BAUD_CALC(baud_rate,F_CPU)>>8);           // Baudrate whlen
  UBRRL=(uint16_t)UART_BAUD_CALC(baud_rate,F_CPU);
}

void uart_disable ()
{
  UCSRB = 0;		// kein senden/empfangen
	rbuffpos=0;
	rbuffcnt=0;
  uart_err = 0;
}
