/*--------------------------------------------------------------------------------------------------

  Name         :  uart.h

  Description  :  Stellt USART-Funktionen zur Verfgung

  Author       :  08/2005 Florian Schaeffer

  History      :  08/2005 - First release.

08.2009 uprava Z. Svoboda

--------------------------------------------------------------------------------------------------*/
#ifndef _UART_H_

#define _UART_H_

/*--------------------------------------------------------------------------------------------------
                                  General purpose constants
--------------------------------------------------------------------------------------------------*/
#define RBUFFLEN 50
#define UART_BAUD_CALC(UART_BAUD_RATE,F_CPU) ((F_CPU)/((UART_BAUD_RATE)*16l)-1)

/*--------------------------------------------------------------------------------------------------
                                 Public function prototypes
--------------------------------------------------------------------------------------------------*/
void uart_ini (uint16_t);
void uart_disable (void);
uint8_t ser_getc (void);
void uart_putc(uint8_t );

#endif  //  _UART_H_
/*--------------------------------------------------------------------------------------------------
                                         End of file.
--------------------------------------------------------------------------------------------------*/
