
#include "nokia_5110.h"
#include "english_6x8_pixel.h"


/*-----------------------------------------------------------------------
LCD_init          : 5110 LCD initialization
-----------------------------------------------------------------------*/

void delay_1us(void)                 // 1us delay function
{
  __delay_cycles(1);
   
}

  
void delay_ms(unsigned int n)       //n ms delay function
  {
   unsigned int i=0;
   for (i=0;i<n;i++)
   __delay_cycles(1000);
  }

void LCD_init(void)
  {
  // Generate a low pulse to reset LCD
    // LCD_RST = 0;
	
    LCD_5110_DIR |= (0x01 << LCD_RST) + (0x01 << LCD_CE) + (0x01 << LCD_DC) 
	  				+ (0x01 << LCD_DIN) + (0x01<< LCD_CLK);
	
   LCD_5110_OUT &= ~(0x01 << LCD_RST);
    delay_1us();

   // LCD_RST = 1;
   LCD_5110_OUT |= (0x01 << LCD_RST);
    
		//Close the LCD
   //LCD_CE = 0;
    LCD_5110_OUT &= ~(0x01 << LCD_CE);
    delay_1us();
		// Enable LCD
   //LCD_CE = 1;
    LCD_5110_OUT |= (0x01 << LCD_CE);
    delay_1us();
    LCD_write_byte (0x21, 0);    // use the extended command set the LCD mode
    LCD_write_byte (0xc8, 0);    // set the bias voltage
    LCD_write_byte (0x06, 0);    // temperature correction
    LCD_write_byte (0x13, 0);    // 1:48
    LCD_write_byte (0x20, 0);    // use basic commands
    LCD_clear ();                // clear the screen
    LCD_write_byte (0x0c, 0);    // set display mode, the normal display
        
    // Close the LCD

    LCD_5110_OUT &= ~(0x01 << LCD_CE);
  }

/*-----------------------------------------------------------------------
LCD_clear         : LCD clear screen function
-----------------------------------------------------------------------*/
void LCD_clear(void)
  {
    unsigned int i;

    LCD_write_byte(0x0c, 0);			
    LCD_write_byte(0x80, 0);			

    for (i=0; i<504; i++)
      LCD_write_byte(0, 1);			
  }

/*-----------------------------------------------------------------------
LCD_set_XY: Set LCD coordinate functions

Input parameters: X: 0-83
                  Y: 0-5
-----------------------------------------------------------------------*/
void LCD_set_XY(unsigned char X, unsigned char Y)
  {
    LCD_write_byte(0x40 | Y, 0);		// column
    LCD_write_byte(0x80 | X, 0);          	// row
  }

/*-----------------------------------------------------------------------
LCD_write_char: display English characters

Input parameters: c: the character to be displayed
-----------------------------------------------------------------------*/
void LCD_write_char(unsigned char c)
  {
    unsigned char line;

    c -= 32;

    for (line=0; line<6; line++)
      LCD_write_byte(font6x8[c][line], 1);
  }

/*-----------------------------------------------------------------------
LCD_write_english_String: English string display function

Input Parameters: *s: Pointer to an English string;
                X, Y: the display string position, X: 0-83, Y: 0-5
-----------------------------------------------------------------------*/
void LCD_write_english_string(unsigned char X,unsigned char Y,char *s)
  {
    LCD_set_XY(X,Y);
    while (*s) 
      {
	 LCD_write_char(*s);
	 s++;
      }
  }

void LCD_write_logo(unsigned const char* ptr) 
{
unsigned int ctr = 0; 
  while(ctr++ < 504) {
	LCD_write_byte(*ptr++,1);
  }  
}



/*-----------------------------------------------------------------------
LCD_write_byte: using the SPI interface to write data to LCD

Input Parameters: data: data to be written
               command: data/command selection;

-----------------------------------------------------------------------*/
void LCD_write_byte(unsigned char dat, unsigned char command)
  {
    unsigned char i;
	LCD_5110_OUT &= ~(0x01 << LCD_CE);	// msp430
    
    if (command == 0)
     // PORTB &= ~LCD_DC ;	                // send command
	//     LCD_DC = 0;
	  LCD_5110_OUT &= ~(0x01 << LCD_DC);
    else
     // PORTB |= LCD_DC ;		        //send data
    // LCD_DC = 1;
	 LCD_5110_OUT |= (0x01 << LCD_DC);
		for(i=0;i<8;i++)
		{
			if(dat&0x80)
				//SDIN = 1;
			   LCD_5110_OUT |= (0x01 << LCD_DIN);
			else
				//SDIN = 0;
			   LCD_5110_OUT &= ~(0x01 << LCD_DIN);
			//SCLK = 0;
			LCD_5110_OUT &= ~(0x01 << LCD_CLK);
			dat = dat << 1;
			//SCLK = 1;
			LCD_5110_OUT |= (0x01 << LCD_CLK);
		}
   // SPDR = data;			// send data to the SPI register

    //while ((SPSR & 0x80) == 0);         // wait for data transfer is completed
	
    //PORTB |= LCD_CE ;			// close the LCD
    // LCD_CE = 1;
	 LCD_5110_OUT |= (0x01 << LCD_CE);
  }
