
/*
   Nokia 5110 R1103154 (blue)

pin   description    MSP4302231
1     GND               GND
2     BL                VCC
3     VCC(3.5V)         VCC
4     CLK               P1.4
5     Din               P1.5
6     D/C               P1.6 (LED2)
7     CE                P1.7
8     RST               P1.0 (LED1)

*/
#ifndef __nokia_5110_h_
#define __nokia_5110_h_

#include "msp430.h"

#define LCD_5110_DIR            P1DIR
#define LCD_5110_OUT		P1OUT

#define   LCD_RST    0
#define   LCD_CE     7
#define   LCD_DC     6
#define   LCD_DIN    5
#define   LCD_CLK    4

void LCD_init(void);
void LCD_clear(void);
void LCD_write_english_string(unsigned char X,unsigned char Y,char *s);
void LCD_write_char(unsigned char c);
void LCD_write_byte(unsigned char dat, unsigned char dc);
void LCD_write_logo(unsigned const char* ptr);
void delay_1us(void);                 
void delay_ms(unsigned int n);

#endif
