/************************************************************************************
 *  Launchpad demprogram: ledflash
 *
 * Nokia 5110 grafikus LCD dem
 *
 * Az alaprtelmezett rajel belltsokat hasznljuk: 
 * ACLK = n/a, MCLK = SMCLK = DCO alaprtelmezett belltssal (~ 1 MHz)
 * 
 * Hardver kvetelmnyek:
 *  - Launchpad MSP430G22x1 mikrovezrlvel
 *  - Nokia 5110 (vagy 3110) grafikus LCD krtya
 *
 * 
 *  I. Cserny
 *  MTA ATOMKI, Debrecen
 *  Szept 2011
 *  Fejleszti krnyezet: IAR Embedded Workbench for MSP430 v5.30.1 Kickstart Edition
 ************************************************************************************/
#include  <msp430.h>
#include "nokia_5110.h"
#include "emese2.h"

/******************************************************************************/
void delay_ms(unsigned int n);

void main(void) 
{
	WDTCTL = WDTPW + WDTHOLD;             //Letiltjuk a watchdog idztt

	LCD_init();                           // LCD inicializls
	LCD_clear();                          // Kperny trls
	while(1)
	{       LCD_write_logo(emese);        // Bitkp megjelents
                delay_ms(5000);               // 5 s vrakozs 
	        LCD_clear();                  // Kperny trls                
	        LCD_write_english_string(0,0,"Nokia5110 LCD ");
                LCD_write_english_string(0,1,"on MSP430G2231");
                LCD_write_english_string(0,2,"*TI Launchpad*");
                LCD_write_english_string(0,3,"--------------");                 
                LCD_write_english_string(0,4,"(c) I. Cserny,"); 
                LCD_write_english_string(0,5,"Sept 03, 2011.");                  
                delay_ms(5000);                        
	}	  
        
}
