/*********************************************************************
 *                Flowcode 128x64 gLCD Component Code
 *
 * File: 128x64_gLCD_Code.c
 *
 * (c) 2007 Matrix Multimedia Ltd.
 * http://www.matrixmultimedia.com
 *
 * Software License Agreement
 *
 * The software supplied herewith by Matrix Multimedia Ltd (the
 * Company) for its Flowcode graphical programming language is
 * intended and supplied to you, the Companys customer, for use
 * solely and exclusively on the Company's products. The software
 * is owned by the Company, and is protected under applicable
 * copyright laws. All rights are reserved. Any use in violation
 * of the foregoing restrictions may subject the user to criminal
 * sanctions under applicable laws, as well as to civil liability
 * for the breach of the terms and conditions of this licence.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Changelog:
 *
 *  date  | by | description
 * -------+----+-----------------------------------------------------
 * 010708 | BR | Created
 * 040908 | BR | Fixed Print Number function
 *        |    |
 *        |    |
 *        |    |
 *
 *
 *
 ********************************************************************/

/*********************************************************************

 Return & parameter types:
   void
   char
   short
   char*

 Pin directions:
   0 = OUTPUT
   2 = INPUT
   3 = BIDIRECTIONAL

 Macro substitutions:
   %a = ??
   %b = ??
   %c = ??
   %d = ??
   %e = ??
   %f = ??
   %g = ??
   %h = ??
   %i = ??
   %j = ??

**********************************************************************

[Settings]
CLSID={4B174520-75AB-4B14-A0F7-2AA6C203F1DC}
IsAnalogue=0
MultipleAllowed=0
Description=128x64 gLCD Flowcode Component

**********************************************************************

[Port]
DesiredPort=0
PortMandatory=0
SamePortAsID=0

[Pins]
Count=0

[PinPort]
# PortA = 0
# PortB = 1
# PortC = 2
# PortD = 3
# PortE = 4

[PinDesiredBit]

[PinDirection]
# DIR_INPUT = 2
# DIR_OUTPUT = 0
# DIR_BIDIRECTIONAL = 3

[PinMustUsePort]
# boolean

[SamePortAsPinX]
# -1 = any pin
# otherwise, the pin number

[PinMustUsePin]
# boolean

[PinValue]
# boolean (0 = off, 1 = on)

**********************************************************************

[MacroNames]
Count=9
1=GetDefines
2=LCD_Init
3=LCD_Clear
4=LCD_PlotPixel
5=LCD_Draw_Line
6=LCD_Draw_Rect
7=LCD_Print_String
8=LCD_Print_Number
9=LCD_Invert_Rect

[MacroReturns]
1=void
2=void
3=void
4=void
5=void
6=void
7=void
8=void
9=void

[MacroIsPrivate]
1=1
2=0
3=0
4=0
5=0
6=0
7=0
8=0
9=0

[MacroParameters_GetDefines]
Count=0

[MacroParamTypes_GetDefines]


[MacroParameters_LCD_Init]
Count=0

[MacroParamTypes_LCD_Init]


[MacroParameters_LCD_Clear]
Count=0

[MacroParamTypes_LCD_Clear]


[MacroParameters_LCD_PlotPixel]
Count=3
1=x
2=y
3=colour

[MacroParamTypes_LCD_PlotPixel]
1=char
2=char
3=char

[MacroParameters_LCD_Draw_Line]
Count=5
1=x
2=y
3=x2
4=y2
5=colour

[MacroParamTypes_LCD_Draw_Line]
1=char
2=char
3=char
4=char
5=char

[MacroParameters_LCD_Draw_Rect]
Count=5
1=x
2=y
3=width
4=height
5=colour

[MacroParamTypes_LCD_Draw_Rect]
1=char
2=char
3=char
4=char
5=char

[MacroParameters_LCD_Print_String]
Count=6
1=String
2=X
3=Y
4=Font
5=Transparent
6=Colour

[MacroParamTypes_LCD_Print_String]
1=char*
2=char
3=char
4=char
5=char
6=char

[MacroParameters_LCD_Print_Number]
Count=6
1=Number
2=X
3=Y
4=Font
5=Transparent
6=Colour

[MacroParamTypes_LCD_Print_Number]
1=short
2=char
3=char
4=char
5=char
6=char

[MacroParameters_LCD_Invert_Rect]
Count=4
1=x
2=y
3=width
4=height

[MacroParamTypes_LCD_Invert_Rect]
1=char
2=char
3=char
4=char

 ********************************************************************/


/********************************************************************
 * ADDITIONAL CODE
 ********************************************************************/

/*InitialisationCode_Start*/
/*InitialisationCode_End*/


/*InterruptCode_Start*/
/*InterruptCode_End*/


/********************************************************************
 * FUNCTIONS
 ********************************************************************/


void GetDefines()
{
/*Macro_GetDefines_Start*/

}  //Dummy end of function to allow defines to be added correctly

#include <string.h>

//Common defines
#define MX_DATA_PORT 		portd	//%a
#define MX_DATA_TRIS		trisd	//%b
#define MX_CONTROL_PORT		portc	//%c
#define MX_CONTROL_TRIS		trisc	//%d
#define MX_CS1				0		//%e
#define MX_CS2				1		//%f
#define MX_DAT_INST			2		//%g
#define MX_ENABLE			3		//%h
#define MX_READ_WRITE		4		//%i


//Static defines
#define MX_CHIP1			0x00
#define MX_CHIP2			0x01
#define MX_LCD_ON			0x3F
#define MX_LCD_OFF			0x3E
#define MX_LCD_SET_ADD		0x40
#define MX_LCD_SET_PAGE		0xB8
#define MX_LCD_DISP_START	0xC0
#define MX_BLACK			0xFF
#define MX_WHITE			0x00


//ASCII Pixel data
rom char* ASCII1 = {0x00 , 0x00 , 0x00 , 0x00 , 0x00,       // space // 32  - 43
					0x00 , 0x06 , 0x5F , 0x06 , 0x00,       // !
					0x07 , 0x03 , 0x00 , 0x07 , 0x03,       // ''
					0x24 , 0x7E , 0x24 , 0x7E , 0x24,       // #
					0x24 , 0x2B , 0x6A , 0x12 , 0x00,       // $
					0x63 , 0x13 , 0x08 , 0x64 , 0x63,       // %
					0x36 , 0x49 , 0x56 , 0x20 , 0x50,       // &
					0x00 , 0x07 , 0x03 , 0x00 , 0x00,       // '
					0x00 , 0x3E , 0x41 , 0x00 , 0x00,       // (
					0x00 , 0x41 , 0x3E , 0x00 , 0x00,       // )
					0x08 , 0x3E , 0x1C , 0x3E , 0x08,       // *
					0x08 , 0x08 , 0x3E , 0x08 , 0x08};      // +
rom char* ASCII2 = {0x00 , 0xE0 , 0x60 , 0x00 , 0x00,       // , // 44 - 55
					0x08 , 0x08 , 0x08 , 0x08 , 0x08,       // -
					0x00 , 0x60 , 0x60 , 0x00 , 0x00,       // .
					0x20 , 0x10 , 0x08 , 0x04 , 0x02,       // /
					0x3E , 0x51 , 0x49 , 0x45 , 0x3E,       // 0
					0x00 , 0x42 , 0x7F , 0x40 , 0x00,       // 1
					0x62 , 0x51 , 0x49 , 0x49 , 0x46,       // 2
					0x22 , 0x49 , 0x49 , 0x49 , 0x36,       // 3
					0x18 , 0x14 , 0x12 , 0x7F , 0x10,       // 4
					0x2F , 0x49 , 0x49 , 0x49 , 0x31,       // 5
					0x3C , 0x4A , 0x49 , 0x49 , 0x30,       // 6
					0x01 , 0x71 , 0x09 , 0x05 , 0x03};      // 7
rom char* ASCII3 = {0x36 , 0x49 , 0x49 , 0x49 , 0x36,       // 8 // 56 - 67
					0x06 , 0x49 , 0x49 , 0x29 , 0x1E,       // 9
					0x00 , 0x6C , 0x6C , 0x00 , 0x00,       // :
					0x00 , 0xEC , 0x6C , 0x00 , 0x00,       // ;
					0x08 , 0x14 , 0x22 , 0x41 , 0x00,       // <
					0x24 , 0x24 , 0x24 , 0x24 , 0x24,       // =
					0x00 , 0x41 , 0x22 , 0x14 , 0x08,       // >
					0x02 , 0x01 , 0x59 , 0x09 , 0x06,       // ?
					0x3E , 0x41 , 0x5D , 0x55 , 0x1E,       // @
					0x7E , 0x09 , 0x09 , 0x09 , 0x7E,       // A
					0x7F , 0x49 , 0x49 , 0x49 , 0x36,       // B
					0x3E , 0x41 , 0x41 , 0x41 , 0x22};      // C
rom char* ASCII4 = {0x7F , 0x41 , 0x41 , 0x41 , 0x3E,       // D // 68 - 79
					0x7F , 0x49 , 0x49 , 0x49 , 0x41,       // E
					0x7F , 0x09 , 0x09 , 0x09 , 0x01,       // F
					0x3E , 0x41 , 0x49 , 0x49 , 0x7A,       // G
					0x7F , 0x08 , 0x08 , 0x08 , 0x7F,       // H
					0x00 , 0x41 , 0x7F , 0x41 , 0x00,       // I
					0x30 , 0x40 , 0x40 , 0x40 , 0x3F,       // J
					0x7F , 0x08 , 0x14 , 0x22 , 0x41,       // K
					0x7F , 0x40 , 0x40 , 0x40 , 0x40,       // L
					0x7F , 0x02 , 0x04 , 0x02 , 0x7F,       // M
					0x7F , 0x02 , 0x04 , 0x08 , 0x7F,       // N
					0x3E , 0x41 , 0x41 , 0x41 , 0x3E};      // O
rom char* ASCII5 = {0x7F , 0x09 , 0x09 , 0x09 , 0x06,       // P // 80 - 91
					0x3E , 0x41 , 0x51 , 0x21 , 0x5E,       // Q
					0x7F , 0x09 , 0x09 , 0x19 , 0x66,       // R
					0x26 , 0x49 , 0x49 , 0x49 , 0x32,       // S
					0x01 , 0x01 , 0x7F , 0x01 , 0x01,       // T
					0x3F , 0x40 , 0x40 , 0x40 , 0x3F,       // U
					0x1F , 0x20 , 0x40 , 0x20 , 0x1F,       // V
					0x3F , 0x40 , 0x3C , 0x40 , 0x3F,       // W
					0x63 , 0x14 , 0x08 , 0x14 , 0x63,       // X
					0x07 , 0x08 , 0x70 , 0x08 , 0x07,       // Y
					0x71 , 0x49 , 0x45 , 0x43 , 0x00,       // Z
					0x00 , 0x7F , 0x41 , 0x41 , 0x00};      // [
rom char* ASCII6 = {0x02 , 0x04 , 0x08 , 0x10 , 0x20,       // \ // 92 - 103
					0x00 , 0x41 , 0x41 , 0x7F , 0x00,       // ]
					0x04 , 0x02 , 0x01 , 0x02 , 0x04,       // ^
					0x80 , 0x80 , 0x80 , 0x80 , 0x80,       // _
					0x00 , 0x03 , 0x07 , 0x00 , 0x00,       // `
					0x20 , 0x54 , 0x54 , 0x54 , 0x78,       // a
					0x7F , 0x44 , 0x44 , 0x44 , 0x38,       // b
					0x38 , 0x44 , 0x44 , 0x44 , 0x28,       // c
					0x38 , 0x44 , 0x44 , 0x44 , 0x7F,       // d
					0x38 , 0x54 , 0x54 , 0x54 , 0x18,       // e
					0x08 , 0x7E , 0x09 , 0x09 , 0x00,       // f
					0x18 , 0xA4 , 0xA4 , 0xA4 , 0x7C};      // g
rom char* ASCII7 = {0x7F , 0x04 , 0x04 , 0x78 , 0x00,       // h // 104 - 115
					0x00 , 0x00 , 0x7D , 0x00 , 0x00,       // i
					0x40 , 0x80 , 0x84 , 0x7D , 0x00,       // j
					0x7F , 0x10 , 0x28 , 0x44 , 0x00,       // k
					0x00 , 0x00 , 0x7F , 0x40 , 0x00,       // l
					0x7C , 0x04 , 0x18 , 0x04 , 0x78,       // m
					0x7C , 0x04 , 0x04 , 0x78 , 0x00,       // n
					0x38 , 0x44 , 0x44 , 0x44 , 0x38,       // o
					0xFC , 0x44 , 0x44 , 0x44 , 0x38,       // p
					0x38 , 0x44 , 0x44 , 0x44 , 0xFC,       // q
					0x44 , 0x78 , 0x44 , 0x04 , 0x08,       // r
					0x08 , 0x54 , 0x54 , 0x54 , 0x20};      // s
rom char* ASCII8 = {0x04 , 0x3E , 0x44 , 0x24 , 0x00,       // t // 116 - 126
					0x3C , 0x40 , 0x20 , 0x7C , 0x00,       // u
					0x1C , 0x20 , 0x40 , 0x20 , 0x1C,       // v
					0x3C , 0x60 , 0x30 , 0x60 , 0x3C,       // w
					0x6C , 0x10 , 0x10 , 0x6C , 0x00,       // x
					0x9C , 0xA0 , 0x60 , 0x3C , 0x00,       // y
					0x64 , 0x54 , 0x54 , 0x4C , 0x00,       // z
					0x08 , 0x3E , 0x41 , 0x41 , 0x00,       // {
					0x00 , 0x00 , 0x7F , 0x00 , 0x00,       // |
					0x00 , 0x41 , 0x41 , 0x3E , 0x08,       // }
					0x02 , 0x01 , 0x02 , 0x01 , 0x00};      // ~


//Global Variables
char mx_page;
char mx_currentx;
char mx_currenty;


//Internal Prototypes
void MX_LCD_Enable (void);
void MX_Write_Command(char cmd, char chip);
void GotoXY(char x, char y);
void MX_WriteData(char data);
char MX_ReadData(void);


//Internal Functions
void MX_LCD_Enable (void)
{
	set_bit(MX_CONTROL_PORT, MX_ENABLE);
	//delay_10us(1);								//Min delay 450ns
	nop();
	nop();
	nop();
	nop();
	nop();

	clear_bit(MX_CONTROL_PORT, MX_ENABLE);
	//delay_10us(1);								//Min delay 1.5us
	nop();
	nop();
	nop();
	nop();
	nop();
}


void MX_Write_Command(char cmd, char chip)
{
	if(chip == MX_CHIP1)						//Select Chip 1
	{
		clear_bit(MX_CONTROL_PORT, MX_CS2);
		set_bit(MX_CONTROL_PORT, MX_CS1);
	}
	else if(chip == MX_CHIP2)					//Select Chip 2
	{
		clear_bit(MX_CONTROL_PORT, MX_CS1);
		set_bit(MX_CONTROL_PORT, MX_CS2);
	}
	clear_bit(MX_CONTROL_PORT, MX_READ_WRITE);	//Write Command
	clear_bit(MX_CONTROL_PORT, MX_DAT_INST);	//Instruction code
	MX_DATA_TRIS = 0x00;						//Configure data port as output
	MX_DATA_PORT = cmd;
	MX_LCD_Enable();
	MX_DATA_PORT = 0x00;
}


void MX_GotoXY(char x, char y)
{
	char chip = MX_CHIP1;
	char cmd;

	if(x > 127) x = 0;							//Ensure that coordinates are legal
	if(y > 63)  y = 0;

	mx_currentx = x;
	mx_currenty = y;
	mx_page = y / 8;

	if(x >= 64) 								//Select the right chip
	{
		x = x - 64;
		chip = MX_CHIP2;
	}

	cmd = MX_LCD_SET_PAGE | mx_page;			//Set y address on both chips
	MX_Write_Command(cmd, MX_CHIP1);
	MX_Write_Command(cmd, MX_CHIP2);

	cmd = MX_LCD_SET_ADD | x;					//Set x address on active chip
	MX_Write_Command(cmd, chip);
}



void MX_WriteData(char data)
{
	char displayData, yOffset, cmdPort;

	if(mx_currentx >= 128)
		return;

	if(mx_currentx < 64)
	{
		clear_bit(MX_CONTROL_PORT, MX_CS2);			//Select chip 1
		set_bit(MX_CONTROL_PORT, MX_CS1);
	}

	else if(mx_currentx >= 64)
	{
		clear_bit(MX_CONTROL_PORT, MX_CS1);			//Select chip 2
		set_bit(MX_CONTROL_PORT, MX_CS2);
	}

	if(mx_currentx == 64)							//Chip 2 X Address = 0
		MX_Write_Command(MX_LCD_SET_ADD, MX_CHIP2);

	set_bit(MX_CONTROL_PORT, MX_DAT_INST);			//Configure to send data
	clear_bit(MX_CONTROL_PORT, MX_READ_WRITE);		//Configure to write data
	MX_DATA_TRIS = 0x00;							//Configure data port to Output
	yOffset = mx_currenty % 8;

	if(yOffset != 0) 								//First page?
	{
		cmdPort = MX_CONTROL_PORT;					//Save command port
		displayData = MX_ReadData();
		MX_CONTROL_PORT = cmdPort;					//Restore command port
		MX_DATA_TRIS = 0x00;						//Data port is output
		displayData = displayData | (data << yOffset);
		MX_DATA_PORT = displayData;					//Write data
		MX_LCD_Enable();							//Enable

		// second page
		MX_GotoXY(mx_currentx, (mx_currenty + 8));
		displayData = MX_ReadData();
		MX_CONTROL_PORT = cmdPort;					//Restore command port
		MX_DATA_TRIS = 0x00;						//Data port is output
		displayData = displayData | (data >> (8-yOffset));
		MX_DATA_PORT = displayData;					//Write data
		MX_LCD_Enable();							//Enable
		MX_GotoXY(mx_currentx + 1, (mx_currenty - 8));
	}
	else
	{
		MX_DATA_PORT = data;						//Write data
		MX_LCD_Enable();							//Enable
		mx_currentx = mx_currentx + 1;
	}
	MX_DATA_PORT = 0x00;
}


char MX_ReadData(void)
{
	char data, i;

	MX_DATA_PORT = 0x00;
	MX_DATA_TRIS = 0xFF;							//Data port is input
	set_bit(MX_CONTROL_PORT, MX_READ_WRITE);		//Configure to read data
	set_bit(MX_CONTROL_PORT, MX_DAT_INST);			//Configure to send data

	if(mx_currentx < 64)
	{
		clear_bit(MX_CONTROL_PORT, MX_CS2);			//Select chip 1
		set_bit(MX_CONTROL_PORT, MX_CS1);
	}

	else if(mx_currentx >= 64)
	{
		clear_bit(MX_CONTROL_PORT, MX_CS1);			//Select chip 2
		set_bit(MX_CONTROL_PORT, MX_CS2);
	}

	set_bit(MX_CONTROL_PORT, MX_ENABLE);			//Set the enable bit
	for (i=0; i<3; i++);
	clear_bit(MX_CONTROL_PORT, MX_ENABLE);			//Clear the enable bit
	for (i=0; i<8; i++);							//Min 1.5us delay
	set_bit(MX_CONTROL_PORT, MX_ENABLE);			//Set the enable bit
	for (i=0; i<15; i++);							//Min 450ns delay

	data = MX_DATA_PORT;							//Read Data
	clear_bit(MX_CONTROL_PORT, MX_ENABLE);			//Clear the enable bit
	MX_DATA_TRIS = 0x00;							//Configure port as output
	MX_GotoXY(mx_currentx, mx_currenty);
	return data;
}


// Dummy function to close the defines section off
void CUSTOM_Dummy_Function();
void CUSTOM_Dummy_Function()
{

/*Macro_GetDefines_End*/
}


void LCD_Init ()
{
/*Macro_LCD_Init_Start*/

	mx_currentx = 0;
	mx_currenty = 0;
	mx_page = 0;

	MX_DATA_TRIS = 0x00;								//Convert data port to output
	MX_DATA_PORT = 0x00;

	clear_bit(MX_CONTROL_TRIS, MX_ENABLE);				//Convert control pins to output
	clear_bit(MX_CONTROL_TRIS, MX_DAT_INST);
	clear_bit(MX_CONTROL_TRIS, MX_CS1);
	clear_bit(MX_CONTROL_TRIS, MX_CS2);
	clear_bit(MX_CONTROL_TRIS, MX_READ_WRITE);

	set_bit(MX_CONTROL_PORT, MX_ENABLE);
	clear_bit(MX_CONTROL_PORT, MX_READ_WRITE);			//Write Command
	clear_bit(MX_CONTROL_PORT, MX_DAT_INST);			//Instruction code
	set_bit(MX_CONTROL_PORT, MX_CS1);					//Select Chip 1
	clear_bit(MX_CONTROL_PORT, MX_CS2);

	MX_Write_Command(MX_LCD_ON, MX_CHIP1);				//Switch on LCD controller chips
	MX_Write_Command(MX_LCD_ON, MX_CHIP2);

	MX_Write_Command(MX_LCD_DISP_START, MX_CHIP1);		//Configure the display start address
	MX_Write_Command(MX_LCD_DISP_START, MX_CHIP2);

	LCD_Clear();
	MX_GotoXY(0,0);

/*Macro_LCD_Init_End*/
}


void LCD_Clear ()
{
/*Macro_LCD_Clear_Start*/
	LCD_Draw_Rect(0, 0, 127, 63, MX_WHITE);
/*Macro_LCD_Clear_End*/
}


void LCD_PlotPixel(char x, char y, char colour)
{
/*Macro_LCD_PlotPixel_Start*/
	char data, mod_y;

	mod_y = y%8;
	MX_GotoXY(x, y - mod_y);
	data = MX_ReadData();							//Read 8 pixels from display
	if (colour)
		data = data | (0x01 << mod_y);				//Set Pixel
	else
		data = data & (~(0x01 << mod_y));			//Clear Pixel
	MX_WriteData(data);
/*Macro_LCD_PlotPixel_End*/
}



void LCD_Draw_Line(char x, char y, char x2, char y2, char colour)
{
/*Macro_LCD_Draw_Line_Start*/
	int C1, M1;
	signed int D1 = 0;
	signed int Pixelx = x2 - x;    //number of X-pixels;
	signed int Pixely = y2 - y;    //Number of Y-pixels
	signed char Xinc = 1;
	signed char Yinc = 1;

	if (Pixelx < 0)        //If negative X direction
	{
		Xinc = -1;
		Pixelx = Pixelx * -1;
	}
	if (Pixely < 0)        //If negative Y direction
	{
		Yinc = -1;
		Pixely = Pixely * -1;
	}
	if (Pixely <= Pixelx)
	{
		C1 = 2 * Pixelx;
		M1 = 2 * Pixely;
		while (x != x2)
		{
			LCD_PlotPixel(x, y, colour);    //ForePlot line
			x = x + Xinc;
			D1 = D1 + M1;
			if (D1 > Pixelx)
			{
				y = y + Yinc;
				D1 = D1 - C1;
			}
		}
	}
	else
	{
		C1 = 2 * Pixely;
		M1 = 2 * Pixelx;
		while (y != y2)
		{
			LCD_PlotPixel(x, y, colour);    //ForePlot Line
			y = y + Yinc;
			D1 = D1 + M1;
			if (D1 > Pixely)
			{
				x = x + Xinc;
				D1 = D1 - C1;
			}
		}
		LCD_PlotPixel(x, y, colour);
	}
/*Macro_LCD_Draw_Line_End*/
}


void LCD_Draw_Rect(char x, char y, char width, char height, char colour)
{
/*Macro_LCD_Draw_Rect_Start*/
	char mask, pageOffset, h, i, data;

	if(colour)
		colour = 255;

	height = height + 1;

	pageOffset = y % 8;
	y = y - pageOffset;
	mask = 0xFF;

	if(height < (8 - pageOffset))
	{
		mask = mask >> (8-height);
		h = height;
	}
	else
		h = (8 - pageOffset);

	mask = mask << pageOffset;

	MX_GotoXY(x, y);

	for(i=0; i<=width; i++)
	{
		data = MX_ReadData();
		if(colour)
			data = data | mask;
		else
			data = data & (~mask);

		MX_WriteData(data);
	}

	while((h + 8) <= height)
	{
		h = h + 8;
		y = y + 8;
		MX_GotoXY(x, y);

		for(i=0; i<=width; i++)
			MX_WriteData(colour);
	}

	if(h < height)
	{
		mask = ~(0xFF << (height - h));
		MX_GotoXY(x, (y + 8));

		for(i=0; i<=width; i++)
		{
			data = MX_ReadData();

			if(colour)
				data = data | mask;
			else
				data = data & (~mask);

			MX_WriteData(data);
		}
	}
/*Macro_LCD_Draw_Rect_End*/
}



void LCD_Print_String(char* String, char X, char Y, char Font, char Transparent, char Colour)
{
/*Macro_LCD_Print_String_Start*/
    char xpix, ypix, pos_Str, count, xcount, ycount, height, width, i;
    char Fontwidth = 1;                //First we assume small font
    char Fontheight = 1;
	char inv_colour = 1;

    char temp[6];
    temp[5] = 0x00;                        //Spacing Line

	if (Colour)
		inv_colour = 0;

    if (Font == 1)                     	//Double Height Sizes //Double Width
    {
        Fontwidth = 2;
    }
    if (Font == 2)                         //Double Height and Width Sizes
    {
        Fontwidth = 2;
        Fontheight = 2;
    }
    if (Font == 3)                         //Double Height Sizes
    {
        Fontheight = 2;
    }

    xcount = 0;
    for (i=0;i<MSZ_String;i++)         //Start at beginning of string and work along
    {
        if (String[i] == 0)
        	return;
        pos_Str = String[i] - 32;      //Calculate place in ASCII memory

        for (count = 0; count < 5; count++)        //Use correct buffer location
        {
            if (pos_Str < 12)
            {
                temp[count]=ASCII1[(pos_Str*5)+count];
            }
            else if (pos_Str < 24)
            {
                temp[count]=ASCII2[((pos_Str - 12)*5)+count];
            }
            else if (pos_Str < 36)
            {
                temp[count]=ASCII3[((pos_Str - 24)*5)+count];
            }
            else if (pos_Str < 48)
            {
                temp[count]=ASCII4[((pos_Str - 36)*5)+count];
            }
            else if (pos_Str < 60)
            {
                temp[count]=ASCII5[((pos_Str - 48)*5)+count];
            }
            else if (pos_Str < 72)
            {
                temp[count]=ASCII6[((pos_Str - 60)*5)+count];
            }
            else if (pos_Str < 84)
            {
                temp[count]=ASCII7[((pos_Str - 72)*5)+count];
            }
            else if (pos_Str < 95)
            {
                temp[count]=ASCII8[((pos_Str - 84)*5)+count];
            }
        }
        for (xpix=0;xpix<6;xpix++)    //For 6 ASCII bytes 0 - 5
        {
            for (width=0;width<Fontwidth;width++)
            {
                ycount = 0;
                for (ypix=0;ypix<8;ypix++)    //For 8 data bits in bytes 0 - 7
                {
                    for (height=0;height<Fontheight;height++)
                    {
                        if (test_bit(temp[xpix],ypix))
                        {
                            LCD_PlotPixel(X + xcount, Y + ycount, Colour);
                        }
                        else if (Transparent == 0)
                        {
                            LCD_PlotPixel(X+xcount, Y+ycount, inv_colour);
                        }
                        ycount++;
                    }
                }
                xcount++;
            }
        }
    }
/*Macro_LCD_Print_String_End*/
}


void LCD_Print_Number(short Number, char X, char Y, char Font, char Transparent, char Colour)
{
/*Macro_LCD_Print_Number_Start*/
	char string_length;

	if (Number < -10000	)
		string_length = 6;

	else if(Number > 10000 || Number < -1000)
		string_length = 5;

	else if(Number > 1000 || Number < -100)
		string_length = 4;

	else if(Number > 100 || Number < -10)
		string_length = 3;

	else if(Number > 10 || Number < -1)
		string_length = 2;

	else
		string_length = 1;

	char temp_str[6];

	FCI_TOSTRING(Number,temp_str,string_length);									//Convert number to String
	LCD_Print_String(temp_str, string_length, X, Y, Font, Transparent, Colour);		//Send string to Print function
/*Macro_LCD_Print_Number_End*/
}



void LCD_Invert_Rect(char x, char y, char width, char height)
{
/*Macro_LCD_Invert_Rect_Start*/
	char mask, pageOffset, h, i, data, tmpData;
	height++;

	pageOffset = y % 8;
	y = y - pageOffset;
	mask = 0xFF;
	if(height < (8 - pageOffset))
	{
		mask = mask >> (8-height);
		h = height;
	}
	else
	{
		h = 8 - pageOffset;
	}
	mask = mask << pageOffset;

	MX_GotoXY(x, y);
	for(i=0; i<=width; i++)
	{
		data = MX_ReadData();
		tmpData = ~data;
		data = (tmpData & mask) | (data & ~mask);
		MX_WriteData(data);
	}

	while((h + 8) <= height)
	{
		h = h + 8;
		y = y + 8;
		MX_GotoXY(x, y);

		for(i=0; i<=width; i++)
		{
			data = MX_ReadData();
			MX_WriteData(~data);
		}
	}

	if(h < height)
	{
		mask = ~(0xFF << (height-h));
		MX_GotoXY(x, y+8);

		for(i=0; i<=width; i++)
		{
			data = MX_ReadData();
			tmpData = ~data;
			data = (tmpData & mask) | (data & ~mask);
			MX_WriteData(data);
		}
	}
/*Macro_LCD_Invert_Rect_End*/
}