//-----------------------------------------------------------//
//                      onLoad / onUnload                    //
//-----------------------------------------------------------//

window.handlersLoad = [];
window.handlersUnload = [];

function addHandlerLoad(cFunc) { window.handlersLoad[window.handlersLoad.length] = cFunc; }
function addHandlerUnload(cFunc) { window.handlersUnload[window.handlersUnload.length] = cFunc; }

function handleWindowLoad() {
  for(var i = 0; i < window.handlersLoad.length; i++) window.handlersLoad[i]();
  if(!window.onpagehide) {
    window.onbeforeunload = function() { handleWindowUnload(); window.onunload = null; };
    window.onunload = handleWindowUnload;
  }
};
function handleWindowUnload() {
  for(var i = 0; i < window.handlersUnload.length; i++) window.handlersUnload[i]();
};
window.onload = function() {
  window.onpageshow = function() { window.onpagehide = handleWindowUnload; };
  setTimeout(handleWindowLoad, 0);
};

docLang = undefined;
docBase = undefined;
if(document.getElementsByTagName) {
  var elems = document.getElementsByTagName('html')
  if(elems.length) docLang = elems[0].lang;
  var elems = document.getElementsByTagName('base');
  if(elems.length) docBase = elems[0].href.replace(/\/+$/, '');
}

//-----------------------------------------------------------//
//                      General functions                    //
//-----------------------------------------------------------//

// Tells whether a variable exists or not
function isSet(cVar)
{
  return (typeof cVar !== "undefined");
}

// Tells whether a value is in an array or not
function inArray(cValue, cArray)
{
  for(var i = 0; i < cArray.length; i++) if(cArray[i] == cValue) return true;
  return false;
}

// URLEncodes a string
function urlEncode(str)
{
  return encodeURIComponent(str).replace(/%20/g, "+").replace(/'/g, "%27");
}

// URLDecodes a string
function urlDecode(str)
{
  return decodeURIComponent(str.replace(/%27/g, "'").replace(/\+/g, "%20"));
}

// Normalizes a string
function textNorm(str)
{
  return str.replace(/\s+/g, " ").replace(/^ | $/g, "");
}

// Converts a number to string, padding it on the left side
function numLPad(num, chr, len)
{
  var ret = num.toString();
  for(var currLen = ret.length; currLen < len; currLen++) ret = chr + ret;
  return ret;
}

// Popup window
function popup(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'top=80,left=190,width=700,height=660,titlebar,menubar,scrollbars,resizable');
  return prevDef(cEvent);
}

// Email link
function email(cAddress)
{
  b64_link('mailto:', cAddress);
}

// Prepares forward link
function prepFwdLink(cLink)
{
  cLink.canForward = true;
  cLink.doForward = function() {
    if(!this.canForward) return;
    if(this.pathname == '-' || this.pathname == '/-') window.close();
    else location.replace(this.href);
  };
  cLink.onclick = function(cEvent) { this.doForward(); return prevDef(cEvent); };
}

// Goes forward to the next page or closes window
function gofwd(cInterval)
{
  var cLink = document.getElementById('fwd_link');
  if(!cLink) return;
  prepFwdLink(cLink); cLink.canForward = false;
  var doWait = isSet(cInterval);
  if(doWait) setTimeout(function() { doWait = false; cLink.doForward(); }, cInterval);
  addHandlerLoad(function() { cLink.canForward = true; if(!doWait) cLink.doForward(); });
}

// Goes back to previous page or closes window
function goback()
{
  history.back();
  setTimeout(function() { window.close(); }, 100);
}

// Prevents execution of default event handler
function prevDef(cEvent)
{
  if(!cEvent) cEvent = window.event;
  if(cEvent) {
    if(cEvent.preventDefault) cEvent.preventDefault();
    cEvent.returnValue = false;
  }
  return false;
}

// Erases textbox on first call
function eraseDef(txt)
{
  var doErase = (!txt.erased && txt.value == txt.defaultValue);
  if(doErase) {
    txt.value = '';
    txt.select();
  }
  txt.erased = true;
  return doErase;
}

// Gets the document's full height (in pixels)
function docHeight()
{
  var html = document.documentElement;
  return (html.clientHeight !== html.scrollHeight ? html.scrollHeight : html.offsetHeight);
}

// Resizes container frame
function resizeFrame(height)
{
  var cFrame = window.frameElement;
  if(!cFrame) return false;
  if(!isSet(cFrame.defHeight)) cFrame.defHeight = cFrame.style.height;
  height = (height == null ? cFrame.defHeight : height + "px");
  cFrame.style.height = height;
  return true;
}

// Automatically resizes container frame
function autoSizeFrame()
{
  if(resizeFrame(docHeight())) addHandlerLoad(function() { resizeFrame(docHeight()); });
}

// Gets the text content of an HTML element
function getTextContent(cElement)
{
  if(!isSet(cElement.nodeType)) return null;
  if(cElement.nodeType == 3) return cElement.nodeValue;
  else if(cElement.nodeType == 1) {
    var cText = "";
    for(var i = 0; i < cElement.childNodes.length; i++) cText += getTextContent(cElement.childNodes[i]);
    return cText;
  }
  else return "";
}

// Gets the child elements of an HTML element
function getChildElems(cElement)
{
  if(!cElement.childNodes || !cElement.nodeType) return null;
  var childNodes = cElement.childNodes, childElems = [];
  for(var i = 0; i < childNodes.length; i++) if(childNodes[i].nodeType == 1) childElems[childElems.length] = childNodes[i];
  return childElems;
}

// Tells whether an HTML element has a CSS class or not
function hasClass(cElement, cClass)
{
  if(!cElement.className) return false;
  else return inArray(cClass, cElement.className.split(/\s/));
}

// Adds/removes a CSS class to/from an HTML element
function setClass(cElement, cClass, value)
{
  var classes = (cElement.className ? cElement.className : "");
  if(classes) {
    classes = classes.split(/\s/);
    for(var i = 0; i < classes.length; i++) if(classes[i] == cClass) classes[i] = "";
    classes = classes.join(" ");
  }
  if(value) classes += " " + cClass;
  cElement.className = textNorm(classes);
}

// Gets the first child of an HTML element that has the given CSS class
function getClassChild(cElement, cClass)
{
  var childElems = getChildElems(cElement);
  if(childElems) for(var i = 0; i < childElems.length; i++)
    if(hasClass(childElems[i], cClass)) return childElems[i];
  return null;
}

// Returns value of jump-selector and resets it before jump
function jumpVal(sel)
{
  if(sel.jumping) return false;
  sel.jumping = true;
  var val = sel.options[sel.selectedIndex].value;
  sel.blur();
  sel.form.reset();
  sel.jumping = false;
  return val;
}

// Jumps to specified absolute URL under the domain specified in BASE element
function siteJump(url)
{
  if(url.charAt(0) != '/') url = '/' + url;
  if(isSet(docBase)) url = docBase + url;
  location.href = url;
}

// Fills up specified jump-selectors with options
function fillJumpSels(formName, selName, numItems, block, defVal, latest, asc, blockClass, rangeClass)
{
  if(numItems <= 0) return;
  var sels = [];
  for(var i = 0; i < document.forms.length; i++)
    if(document.forms[i].name == formName)
      sels[sels.length] = document.forms[i].elements[selName];
  if(sels.length == 0) return;

  var opts = [];
  var padLen = numItems.toString().length
  var detStr = defVal - (defVal % 1000), detEnd = detStr + 1000;
  var rngStr = 0, rngEnd, optStr = 0, optEnd, optSel, optClass, optTxtStr, optTxtEnd, optTxt;
  do {
    rngEnd = rngStr + 1000; if(rngEnd > numItems) rngEnd = numItems;
    if(detStr <= optStr && optStr < detEnd) {
      optEnd = optStr + block; if(optEnd > rngEnd) optEnd = rngEnd;
      optSel = (optStr <= defVal && defVal < optEnd);
      if(optSel && latest) optEnd = numItems;
      optClass = (optSel ? null : blockClass);
    }
    else {
      optEnd = rngEnd;
      optSel = false;
      optClass = rangeClass;
    }

    optTxtStr = numLPad(optStr + 1, ' ', padLen); optTxtEnd = numLPad(optEnd, ' ', padLen);
    optTxt = (asc ? optTxtStr : optTxtEnd) + ' - ' + (asc ? optTxtEnd : optTxtStr);
    opts[opts.length] = [optTxt, optStr, optSel, optClass];

    optStr = optEnd;
    if(optEnd == rngEnd) rngStr = rngEnd;
  } while(optStr < numItems);

  var currIdx, currOpt;
  var start = (asc ? 0 : opts.length - 1), step = (asc ? 1 : -1);
  for(var i = 0; i < sels.length; i++) {
    sels[i].options.length = 0;
    for(currIdx = start; 0 <= currIdx && currIdx < opts.length; currIdx += step) {
      currOpt = new Option(opts[currIdx][0], opts[currIdx][1], opts[currIdx][2]);
      currOpt.className = opts[currIdx][3];
      sels[i].options[sels[i].options.length] = currOpt;
      if(opts[currIdx][2] && !currOpt.selected) currOpt.selected = true;
    }
  }
}

// Sends a GET request in the background
function sendGet(url)
{
  if(!isSet(window.sendGet_Image)) window.sendGet_Image = new Image();
  window.sendGet_Image.src = null;
  setTimeout(function() { window.sendGet_Image.src = url; }, 0);
}

// Sends a POST request to a link's href (instead of a GET)
function postLink(cLink, cEvent, confQues)
{
  confQues = (confQues ? confirm(confQues) : true);
  if(document.createElement && document.body && confQues) {
    var form = document.createElement('form');
    form.action = cLink.href; form.target = cLink.target;
    form.method = 'post'; form.style.display = 'none';
    document.body.appendChild(form);
    form.submit();
  }
  return prevDef(cEvent);
}

// Prepares auto-refreshing form for use
function prepAutoRefrForm(nForm)
{
  var elems = document.forms[nForm].elements;
  for(var i = 0; i < elems.length; i++) if(elems[i].className == 'refresh') {
    if(elems[i].type != 'submit') elems[i].onchange = function() { autoRefreshForm(this.form); }
    else if(elems[i].parentNode && elems[i].parentNode.removeChild) elems[i].parentNode.removeChild(elems[i]);
    else { elems[i].style.display = 'none'; elems[i].disabled = true; }
  }
}

// Auto-refreshes form by submitting it
function autoRefreshForm(cForm)
{
  var elems = cForm.elements;
  var qs = "", currName, currVals;
  for(var i = 0; i < elems.length; i++) if(elems[i].name && !elems[i].disabled) {
    currName = urlEncode(elems[i].name);
    currVals = [];
    switch(elems[i].type) {
      case 'checkbox':
      case 'radio':
        if(elems[i].checked) currVals[currVals.length] = urlEncode(elems[i].value);
        break;
      case 'select-one':
      case 'select-multiple':
        for(var j = 0; j < elems[i].options.length; j++)
          if(elems[i].options[j].selected) currVals[currVals.length] = urlEncode(elems[i].options[j].value);
        break;
      case 'hidden':
      case 'text':
      case 'password':
      case 'textarea':
        currVals[currVals.length] = urlEncode(elems[i].value);
        break;
    }
    for(var j = 0; j < currVals.length; j++) qs += (qs ? '&' : '?') + currName + '=' + currVals[j];
  }
  var url = cForm.action.indexOf('?');
  url = (url != -1 ? cForm.action.substr(0, url) : cForm.action) + qs;
  location.replace(url);
}

// Gets the nearest ancestor that has the specified attribute
function getAncestorWithAttr(cObj, nAttr)
{
  var cElement = cObj, cWin = window;
  do {
    if(cElement.parentNode) cElement = cElement.parentNode;
    else if(cWin.frameElement) { cElement = cWin.frameElement; cWin = cWin.parent; }
    else break;
  } while(!isSet(cElement[nAttr]));
  if(isSet(cElement[nAttr])) return cElement;
}

// Gets the specified attribute from the nearest ancestor that has it
function getAttrFromAncestor(cObj, nAttr)
{
  var cElement = getAncestorWithAttr(cObj, nAttr);
  if(cElement) return cElement[nAttr];
}

// Audits
function audit_median(code)
{
  document.write('<img src="http://audit.median.hu/cgi-bin/track.cgi?uc=' + code + '&amp;dc=1&amp;ui=' + same + '" alt="" />');
}

// Audits
function audit_szonda(code)
{
  pp_gemius_identifier = code;
  if(window.attachEvent) {
    window.attachEvent("onload", gemius_load_script);
  } else if(window.addEventListener) {
    window.addEventListener("load", gemius_load_script, false);
  }
  pp_gemius_url += pp_gemius_identifier + gemius_parameters();
  pp_gemius_image.src = pp_gemius_url;
}

// Audits
function audit_google(code)
{
  var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
  document.write('<script type="text/javascript" src="' + gaJsHost + 'google-analytics.com/ga.js"></script>');
  document.write('<script type="text/javascript">try { var pageTracker = _gat._getTracker("' + code + '"); pageTracker._trackPageview(); } catch(err) {}</script>');
}

// Index Adserver banner
function adindex(code, width, height)
{
  document.write('<iframe class="adifr" src="http://sher.index.hu/ad?lc=' + code + '&amp;ui=' + same + '&amp;co=1&amp;cn=1&amp;do=index.hu&amp;ho=' + width + '&amp;ve=' + height + '" marginwidth="0" marginheight="0" frameborder="0" scrolling="no"></iframe>');
}

// Google Adsense banner
function adsense(channel, width, height, color)
{
  if(!color) color = "ffffff";

  google_ad_client = "pub-3023840094153539";
  google_ad_type = "text";
  google_ad_channel = channel;

  google_ad_width = width;
  google_ad_height = height;
  google_ad_format = width + "x" + height + "_as";

  google_alternate_color = color;
  google_color_bg = color;
  google_color_border = color;
  google_color_link = "b42224";
  google_color_text = "666666";
  google_color_url = "008000";

  document.write('<script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js"></script>');
}


//-----------------------------------------------------------//
//                       Cookie functions                    //
//-----------------------------------------------------------//


function cookieGet(name)
{
  var nameEQ = urlEncode(name) + "=";
  var ca = document.cookie.split(';');
  for(var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while(c.charAt(0) == ' ') c = c.substr(1);
    if(c.indexOf(nameEQ) == 0) return urlDecode(c.substr(nameEQ.length));
  }
  return null;
}

function cookieSet(name, value, days)
{
  var expires = "";
  if(days != null) {
    var date = new Date();
    date.setTime(date.getTime() + (days * 24 * 3600 * 1000));
    expires = "; expires=" + date.toGMTString();
  }
  document.cookie = urlEncode(name) + "=" + urlEncode(value) + expires + "; path=/";
}

function cookieDel(name)
{
  cookieSet(name, "", -1);
}


//-----------------------------------------------------------//
//                       Tabbing functions                   //
//-----------------------------------------------------------//


function tab_Prepare(iCont, showClass)
{
  var cont = document.getElementById(iCont), actLink;
  if(!cont || !cont.nodeName || !cont.parentNode || !cont.getElementsByTagName) return null;
  var tabs = getClassChild(cont, "tabs"), menu = getClassChild(cont, "menu");
  if(!tabs || !menu) return null;
  cont.tabElems = getChildElems(tabs); cont.tabMenu = menu; cont.tabLinks = menu.getElementsByTagName("a");
  for(var i = 0; i < cont.tabElems.length; i++) cont.tabElems[i].style.display = 'none';
  for(var i = 0; i < cont.tabLinks.length; i++) {
    var link = cont.tabLinks[i];
    link.tabCont = cont; link.tabLinkIdx = i; link.tabChange = tab_Change;
    link.onclick = tab_LinkClick; link.className = null;
    if(hasClass(link.parentNode, showClass)) actLink = link;
  }
  if(isSet(actLink)) actLink.tabChange();
  return cont;
}

function tab_LinkClick(cEvent)
{
  this.tabChange();
  return prevDef(cEvent);
}

function tab_Change()
{
  var cont = this.tabCont, showClass = this.parentNode.className;
  var tabElems = cont.tabElems, tabLinks = cont.tabLinks;
  for(var i = 0; i < tabElems.length; i++) tabElems[i].style.display = (hasClass(tabElems[i], showClass) ? 'block' : 'none');
  for(var i = 0; i < tabLinks.length; i++) tabLinks[i].className = null;
  this.className = "act"; cont.tabActLinkIdx = this.tabLinkIdx;
}


//-----------------------------------------------------------//
//                       Megabox functions                   //
//-----------------------------------------------------------//


function mbx_Prepare(iCont, cInterval)
{
  var cont = tab_Prepare(iCont, null);
  if(!cont || !cont.tabLinks.length) return;
  cont.mbxChange = mbx_Change; cont.mbxPlay = mbx_Play; cont.mbxPause = mbx_Pause;
  cont.mbxAuto = null; cont.mbxAutoIval = cInterval; cont.mbxAutoFunc = function() { cont.mbxChange(); };
  for(var i = 0; i < cont.tabLinks.length; i++) cont.tabLinks[i].onclick = mbx_LinkClick;
  var func = getClassChild(cont, "func");
  if(func) {
    var play = getClassChild(func, "play"), pause = getClassChild(func, "pause");
    if(play) play.onclick = function() { cont.mbxPlay(); };
    if(pause) pause.onclick = function() { cont.mbxPause(); };
  }
  cont.mbxPlay();
}

function mbx_LinkClick(cEvent)
{
  this.tabCont.mbxPause();
  this.tabChange();
  return prevDef(cEvent);
}

function mbx_Change()
{
  var nextIdx = (isSet(this.tabActLinkIdx) ? (this.tabActLinkIdx + 1) % this.tabLinks.length : 0);
  this.tabLinks[nextIdx].tabChange();
}

function mbx_Play()
{
  if(this.mbxAuto != null) clearInterval(this.mbxAuto);
  this.mbxChange(); this.mbxAuto = setInterval(this.mbxAutoFunc, this.mbxAutoIval);
  setClass(this.tabMenu, "menuact", true);
}

function mbx_Pause()
{
  if(this.mbxAuto != null) clearInterval(this.mbxAuto);
  this.mbxAuto = null;
  setClass(this.tabMenu, "menuact", false);
}


//-----------------------------------------------------------//
//                       Gallery functions                   //
//-----------------------------------------------------------//


function gal_Popup(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'width=757,height=489,titlebar');
  return prevDef(cEvent);
}

function gal_PopupPic(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'titlebar');
  return prevDef(cEvent);
}

function gal_Prepare(iCont)
{
  var cont = document.getElementById(iCont);
  if(!cont || !cont.getElementsByTagName) return;
  var links = cont.getElementsByTagName('a');
  for(var i = 0; i < links.length; i++) if(links[i].target == iCont) {
    links[i].onclick = gal_LinkClick;
    links[i].thumbClass = null;
  }
  cont.thumbLinks = links;
}

function gal_PreparePic(iCont)
{
  var cont = document.getElementById(iCont);
  if(!cont || !cont.getElementsByTagName) return;
  var links = cont.getElementsByTagName('a');
  for(var i = 0; i < links.length; i++) if(!links[i].target) links[i].onclick = gal_LinkClick;
  addHandlerLoad(function() { gal_Highlight(location, false); });
}

function gal_LinkClick(cEvent)
{
  gal_Highlight(this, true);
}

function gal_Highlight(cLink, isLoading)
{
  var links = getAttrFromAncestor(cLink, 'thumbLinks');
  if(!links) return;
  for(var i = 0; i < links.length; i++) {
    var link = links[i], cont = link.parentNode, match = (link.href == cLink.href);
    if(isLoading) {
      link.thumbClass = (match ? 'loading' : null);
      if(cont.className != 'active') cont.className = link.thumbClass;
      if(match) gal_ThumbShow(cont);
    }
    else cont.className = (match ? 'active' : link.thumbClass);
  }
}

function gal_ThumbShow(cElement)
{
  var cont = cElement;
  while(cont && !hasClass(cont, 'thumbs')) cont = cont.parentNode;
  if(!cont) return;
  var min = cElement.offsetTop + cElement.offsetHeight - cont.clientHeight, max = cElement.offsetTop;
  if(cont.scrollTop < min) cont.scrollTop = min;
  if(cont.scrollTop > max) cont.scrollTop = max;
}


//-----------------------------------------------------------//
//                     Base64 decode functions               //
//-----------------------------------------------------------//


var b64_ValueChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
var b64_CharValues = [];
for(var i = 0; i <= b64_ValueChars.length; i++)
  b64_CharValues[b64_ValueChars.charCodeAt(i)] = i;

// Base64 and UTF8 decode
function b64_Decode(data)
{
  data = data.replace(/[^A-Za-z0-9\+\/=]/g, '');
  while((data.length % 4) != 0) data += '=';

  var ch1, ch2, ch3, ch4, byte1, byte2, byte3;
  var charIdx = 0, decoded = [], byteIdx = 0;
  while(charIdx < data.length) {
    ch1 = b64_CharValues[data.charCodeAt(charIdx++)];
    ch2 = b64_CharValues[data.charCodeAt(charIdx++)];
    ch3 = b64_CharValues[data.charCodeAt(charIdx++)];
    ch4 = b64_CharValues[data.charCodeAt(charIdx++)];
    byte1 = (ch1 << 2) | (ch2 >> 4);
    byte2 = ((ch2 & 15) << 4) | (ch3 >> 2);
    byte3 = ((ch3 & 3) << 6) | ch4;
    decoded[byteIdx++] = byte1;
    if(ch3 != 64) decoded[byteIdx++] = byte2;
    if(ch4 != 64) decoded[byteIdx++] = byte3;
  }

  byteIdx = 0;
  var charCode, seqLen, retStr = '';
  while(byteIdx < decoded.length) {
    charCode = decoded[byteIdx++]; seqLen = 1;
    if(charCode >= 192) seqLen++;
    if(charCode >= 224) seqLen++;
    if(charCode >= 240) seqLen++;
    if(seqLen > 1) {
      charCode = (charCode & (255 >> (seqLen + 1)));
      while(seqLen-- > 1) charCode = ((charCode << 6) | (decoded[byteIdx++] & 63));
    }
    retStr += String.fromCharCode(charCode);
  }
  return(retStr);
}

// Create link to Base64 address
function b64_link(cPrefix, cAddress)
{
  var cAddress = b64_Decode(cAddress);
  document.write('<a href="' + cPrefix + cAddress + '">' + cAddress + '</a>');
}


//-----------------------------------------------------------//
//                       MultiDel functions                  //
//-----------------------------------------------------------//


function mdelPrepForm(nForm, cLimit, cMsgFull)
{
  var cForm = document.forms[nForm];
  var checkArray = mdelGetCheckArray(cForm);
  cForm.checkLimit = cLimit;
  cForm.messageFull = cMsgFull;
  for(var i = 0; i < checkArray.length; i++) checkArray[i].onclick = mdelOnCheckClick;
}

function mdelDo(nForm, cVal, cEvent)
{
  var cForm = document.forms[nForm];
  if(mdelCheckVal(cForm, cVal)) cForm.submit();
  return prevDef(cEvent);
}

function mdelGetCheckArray(cForm)
{
  var checkArray = cForm.elements['ids[]'];
  if(!checkArray) checkArray = [];
  else if(!checkArray.length) checkArray = [checkArray];
  return checkArray;
}

function mdelGetCurrChecked(cForm)
{
  var checkArray = mdelGetCheckArray(cForm), currChecked = 0;
  for(var i = 0; i < checkArray.length; i++) if(checkArray[i].checked) currChecked++;
  return currChecked;
}

function mdelOnCheckClick(cEvent) {
  if(mdelGetCurrChecked(this.form) > this.form.checkLimit) {
    alert(this.form.messageFull);
    this.checked = false;
  }
}

function mdelCheckVal(cForm, cVal)
{
  var checkArray = mdelGetCheckArray(cForm), checkBox;
  for(i = 0 ; i < checkArray.length ; i++) if(checkArray[i].value == cVal) {
    checkBox = checkArray[i]; break;
  }
  if(!checkBox) return false;
  var wasChacked = checkBox.checked;
  checkBox.checked = true; checkBox.onclick();
  return wasChacked && checkBox.checked;
}


//-----------------------------------------------------------//
//                 Interstitial ad functions                 //
//-----------------------------------------------------------//


// Interstitial ad vars
var ints_PageReal, ints_PageInts, ints_AdShown;

// Interstitial ad init
function ints_Init(scriptSrc, fwdLink, autoClose, cookieName, expDays)
{
  if(cookieGet(cookieName) != null) return;
  cookieSet(cookieName, 1, expDays);
  ints_PageReal = document.getElementById('page');
  ints_PageInts = document.getElementById('ints');
  if(!ints_PageReal || !ints_PageInts || !document.body || !document.body.replaceChild) return;
  if(fwdLink) document.write('<p><a href="/" onclick="ints_Switch(); return prevDef(event);">' + fwdLink + '</a></p>');
  document.write('<script type="text/javascript" src="' + scriptSrc + '"></script>');
  ints_AdShown = false;
  addHandlerLoad(function() {
    setTimeout('ints_Switch()', 0);
    if(autoClose) setTimeout('ints_Switch()', autoClose * 1000);
  });
}

// Interstitial ad show / hide
function ints_Switch()
{
  if(!ints_AdShown) document.body.replaceChild(ints_PageInts, ints_PageReal);
  else document.body.replaceChild(ints_PageReal, ints_PageInts);
  ints_AdShown = !ints_AdShown;
}


//-----------------------------------------------------------//
//                    Audit & Ad functions                   //
//-----------------------------------------------------------//


// ** Median Webaudit needed functions
WEBAUDIT = function () {
  this.WACID=null;
  this.WACIDName="WACID";

  this.getCookie=function(name)  {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
      var c = ca[i];
      while (c.charAt(0)==' ') c = c.substring(1,c.length);
      if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
  }

  this.setCookie=function(name,value,topDomain) {
    var date = new Date(2020,12,31,23,59,59);
    var expires = "; expires="+date.toGMTString();
    document.cookie = name+"="+value+expires+"; path=/; domain=" + topDomain;
  }

  this.generateID=function(splitter) {
    var sp=(splitter) ? splitter : 'A';
    var now=new Date();
    return Date.parse(now.toGMTString()) + sp + Math.floor(Math.random()*1000000);
  }

  this.getTopDomain=function(fullDomain) {
    var darabok=fullDomain.split('.');
    return darabok[(darabok.length-2)] + '.' + darabok[(darabok.length-1)];
  }

  this.getDomain=function(url) {
    var urlDarabok=url.split('/');
    return urlDarabok[2];
  }

  this.WACID=this.getCookie(this.WACIDName);
}

var wa=new WEBAUDIT();
var felbontas = "";
var same = Math.floor(Math.random()*1000000);
if(wa.WACID==null)
{
  wa.WACID=wa.generateID('A');
  wa.setCookie(wa.WACIDName,wa.WACID,wa.getTopDomain(wa.getDomain(document.URL)));
}
same = same + "@welid=" + wa.WACID;
if(screen) felbontas='@felbontas='+screen.width+'x'+screen.height;
same = same + felbontas;

// ** Szonda Geminus needed functions..
var pp_gemius_image = new Image();
var pp_gemius_proto;
if (document.location && document.location.protocol && document.location.protocol=='https:') {
  pp_gemius_proto = 'https:';
} else {
  pp_gemius_proto = 'http:';
}
var pp_gemius_host = new String(pp_gemius_proto+'//hu.hit.gemius.pl/_'+(new Date()).getTime());
var pp_gemius_url = pp_gemius_host+'/rexdot.gif?l=11&id=';

function gemius_load_script() {
  if (pp_gemius_image.width && pp_gemius_image.width>1) {
    if (document.createElement) {
      var xp_body = document.body;
      var xp_javascript = document.createElement('script');
      var xp_url = pp_gemius_host+'/pp.js?id='+pp_gemius_identifier;
      if (typeof(Error) != 'undefined') {
        eval("try { xp_javascript.src = xp_url; xp_javascript.type = 'text/javascript'; xp_javascript.defer = true; } catch(gemius_ex) { }")
        if (xp_body && xp_body.appendChild) void(xp_body.appendChild(xp_javascript));
      }
    }
  }
}

function gemius_parameters() {
  var d = document;
  var href = new String(d.location.href);
  var ref;
  if (d.referrer) { ref = new String(d.referrer); } else { ref = ""; }
  var t = typeof Error;
  if(t != 'undefined') {
    eval("try { if (typeof(top.document.referrer)=='string') { ref = top.document.referrer } } catch(gemius_ex) { }")
  }
  var url='&tz='+(new Date()).getTimezoneOffset()+'&href='+escape(href.substring(0,299))+'&ref='+escape(ref.substring(0,299));
  if (screen) {
    var s=screen;
    if (s.width) url+='&screen='+s.width+'x'+s.height;
    if (s.colorDepth) url+='&col='+s.colorDepth;
  }
  return url;
}