//-----------------------------------------------------------//
//                     Basic preparations                    //
//-----------------------------------------------------------//

window.handlersLoad = [];
window.handlersUnload = [];
function addHandlerLoad(cFunc) { window.handlersLoad[window.handlersLoad.length] = cFunc; }
function addHandlerUnload(cFunc) { window.handlersUnload[window.handlersUnload.length] = cFunc; }
function handleWindowLoad() { for(var i = 0; i < window.handlersLoad.length; i++) window.handlersLoad[i](); }
function handleWindowUnload() { for(var i = 0; i < window.handlersUnload.length; i++) window.handlersUnload[i](); }

function initLoadHandlers() {
  window.onpageshow = doOnPageShow;
  setTimeout(doOnLoad, 0);
}
function doOnPageShow() { handleWindowLoad(); window.onpagehide = handleWindowUnload; }
function doOnLoad() {
  if(window.onpagehide) return;
  handleWindowLoad(); window.onbeforeunload = doOnBeforeUnload; window.onunload = handleWindowUnload;
}
function doOnBeforeUnload() { handleWindowUnload(); window.onunload = null; }
window.onload = initLoadHandlers;

function handleOnce(saveVal) {
  if(window.handleOnceVal !== null) return window.handleOnceVal;
  window.handleOnceVal = saveVal;
  setTimeout(window.handleOnceReset, 0);
  return null;
}
function handleOnceReset() {
  window.handleOnceVal = null;
}
window.handleOnceReset();

if(document.getElementsByTagName) {
  var temp;
  temp = document.getElementsByTagName('html');
  if(temp[0] && temp[0].lang) docLang = temp[0].lang;
  temp = document.getElementsByTagName('base');
  if(temp[0] && temp[0].href) {
    temp = temp[0].href.match(/^(https?:\/\/[^\/]+)?.*$/);
    if(temp && temp[1]) docDomain = temp[1];
  }
}


//-----------------------------------------------------------//
//                          General                          //
//-----------------------------------------------------------//

// Tells whether a variable exists or not
function isSet(cVar)
{
  return (typeof cVar !== "undefined");
}

// Tells whether a value is in an array or not
function inArray(cValue, cArray)
{
  for(var i = 0; i < cArray.length; i++) if(cArray[i] == cValue) return true;
  return false;
}

// URLEncodes a string
function urlEncode(str)
{
  return encodeURIComponent(str).replace(/%20/g, "+").replace(/'/g, "%27");
}

// URLDecodes a string
function urlDecode(str)
{
  return decodeURIComponent(str.replace(/%27/g, "'").replace(/\+/g, "%20"));
}

// Normalizes a string
function textNorm(str)
{
  return str.replace(/\s+/g, " ").replace(/^ | $/g, "");
}

// Converts a number to string, padding it on the left side
function numLPad(num, chr, len)
{
  var ret = num.toString();
  for(var currLen = ret.length; currLen < len; currLen++) ret = chr + ret;
  return ret;
}

// Prevents execution of default event handler
function prevDef(cEvent)
{
  if(!cEvent) cEvent = window.event;
  if(cEvent.preventDefault) cEvent.preventDefault();
  cEvent.returnValue = false;
  return false;
}

// Email link
function email(cAddress)
{
  b64_CreateLink('mailto:', cAddress);
}

// Popup window
function popup(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'top=80,left=190,width=700,height=660,titlebar,menubar,scrollbars,resizable');
  return prevDef(cEvent);
}

// Goes forward to the next page or closes window
function gofwd(cInterval)
{
  var cLink = document.getElementById('fwd_link');
  if(!cLink) return;
  cLink.fwdLoad = false; cLink.fwdTime = !isSet(cInterval);
  cLink.fwdLoadOk = function() { cLink.fwdLoad = true; cLink.fwdGo(); };
  cLink.fwdTimeOk = function() { cLink.fwdTime = true; cLink.fwdGo(); };
  cLink.fwdGo = function() {
    if(!this.fwdLoad || !this.fwdTime) return;
    if(this.hash && this.hash == '#close') window.close();
    else location.replace(this.href);
  };
  cLink.onclick = function(cEvent) { this.fwdGo(); return prevDef(cEvent); };
  if(!cLink.fwdLoad) addHandlerLoad(cLink.fwdLoadOk);
  if(!cLink.fwdTime) setTimeout(cLink.fwdTimeOk, cInterval);
}

// Goes back to the previous page or closes window
function goback()
{
  var cTimer = setTimeout(window.close, 0);
  addHandlerUnload(function() { clearTimeout(cTimer); });
  history.back();
}

// Tells if this is a desktop browser or not
function onDesktopBrowser()
{
  if(!navigator || !navigator.platform || !navigator.userAgent) return null;
  if(navigator.platform.match(/^(win(?!ce)|mac|linux)/i) && !navigator.userAgent.match(/android/i)) return true;
  return false;
}

// Tells whether an HTML element has a CSS class or not
function hasClass(cElement, cClass)
{
  if(!cElement.className) return false;
  else return inArray(cClass, cElement.className.split(/\s/));
}

// Adds/removes a CSS class to/from an HTML element
function setClass(cElement, cClass, value)
{
  var classes = (cElement.className ? cElement.className : "");
  if(classes) {
    classes = classes.split(/\s/);
    for(var i = 0; i < classes.length; i++) if(classes[i] == cClass) classes[i] = "";
    classes = classes.join(" ");
  }
  if(value) classes += " " + cClass;
  cElement.className = textNorm(classes);
}

// Gets the current style of an HTML element
function getStyle(cElement)
{
  if(cElement.currentStyle) return cElement.currentStyle;
  else if(window.getComputedStyle) return window.getComputedStyle(cElement, null);
}

// Gets the distance between the left border edges of an HTML element and its offsetParent
function getOffsetLeft(cElement)
{
  var cOffsPar = cElement.offsetParent, offset = cElement.offsetLeft;
  if(!cOffsPar) return 0;
  else if(!isSet(cOffsPar.currentStyle)) return offset + cOffsPar.clientLeft;
  else if(isSet(cOffsPar.currentStyle.hasLayout) && (!isSet(document.documentMode) || document.documentMode < 8)) {
    var hasLO = cElement.currentStyle.hasLayout, cCont = cElement.parentNode;
    if(!hasLO) while(cCont && cCont != cOffsPar) {
      if(cCont.currentStyle.hasLayout) { hasLO = true; offset += cCont.clientLeft; }
      cCont = cCont.parentNode;
    }
    if(cOffsPar != document.documentElement) {
      if(cOffsPar.currentStyle.hasLayout) return offset + cOffsPar.clientLeft;
      else if(cElement.currentStyle.position == "static" || hasLO) return offset - cOffsPar.offsetLeft;
    }
  }
  return offset;
}

// Gets the distance between the top border edges of an HTML element and its offsetParent
function getOffsetTop(cElement)
{
  var cOffsPar = cElement.offsetParent, offset = cElement.offsetTop;
  if(!cOffsPar) return 0;
  else if(!isSet(cOffsPar.currentStyle)) return offset + cOffsPar.clientTop;
  else if(isSet(cOffsPar.currentStyle.hasLayout) && (!isSet(document.documentMode) || document.documentMode < 8)) {
    var hasLO = cElement.currentStyle.hasLayout, cCont = cElement.parentNode;
    if(!hasLO) while(cCont && cCont != cOffsPar) {
      if(cCont.currentStyle.hasLayout) { hasLO = true; offset += cCont.clientTop; }
      cCont = cCont.parentNode;
    }
    if(cOffsPar != document.documentElement) {
      if(cOffsPar.currentStyle.hasLayout) return offset + cOffsPar.clientTop;
      else if(cElement.currentStyle.position == "static" && !hasLO) return offset - cOffsPar.offsetTop;
    }
  }
  return offset;
}

// Gets the distance the element has scrolled horizontally
function getScrollLeft(cElement)
{
  if(cElement != document.documentElement) return (cElement != document.body ? cElement.scrollLeft : 0);
  else if(isSet(window.pageXOffset)) return window.pageXOffset;
  else return Math.max(cElement.scrollLeft, document.body.scrollLeft);
}

// Gets the distance the element has scrolled vertically
function getScrollTop(cElement)
{
  if(cElement != document.documentElement) return (cElement != document.body ? cElement.scrollTop : 0);
  else if(isSet(window.pageYOffset)) return window.pageYOffset;
  else return Math.max(cElement.scrollTop, document.body.scrollTop);
}

// Gets the distance the element should be scrolled horizontally
function setScrollLeft(cElement, scroll)
{
  if(cElement != document.body) cElement.scrollLeft = scroll;
  if(cElement == document.documentElement && cElement.scrollLeft != scroll) document.body.scrollLeft = scroll;
}

// Sets the distance the element should be scrolled vertically
function setScrollTop(cElement, scroll)
{
  if(cElement != document.body) cElement.scrollTop = scroll;
  if(cElement == document.documentElement && cElement.scrollTop != scroll) document.body.scrollTop = scroll;
}

// True if the first HTML element is the same as the second or is a descendant of it
function elemSameOrDesc(cElement1, cElement2)
{
  if(cElement2) while(cElement1) {
    if(cElement1 == cElement2) return true;
    cElement1 = cElement1.parentNode;
  }
  return false;
}

// Gets the text content of an HTML element
function getTextContent(cElement)
{
  if(!isSet(cElement.nodeType)) return null;
  if(cElement.nodeType == 3) return cElement.nodeValue;
  else if(cElement.nodeType == 1) {
    var cText = "";
    for(var i = 0; i < cElement.childNodes.length; i++) cText += getTextContent(cElement.childNodes[i]);
    return cText;
  }
  else return "";
}

// Gets the child elements of an HTML element
function getChildElems(cElement)
{
  if(!cElement.childNodes || !cElement.nodeType) return null;
  var childNodes = cElement.childNodes, childElems = [];
  for(var i = 0; i < childNodes.length; i++) if(childNodes[i].nodeType == 1) childElems[childElems.length] = childNodes[i];
  return childElems;
}

// Gets the first child of an HTML element that has the given CSS class
function getClassChild(cElement, cClass)
{
  var childElems = getChildElems(cElement);
  if(childElems) for(var i = 0; i < childElems.length; i++)
    if(hasClass(childElems[i], cClass)) return childElems[i];
  return null;
}

// Gets the nearest ancestor that has the specified attribute
function getAncestorWithAttr(cObj, nAttr)
{
  var cElement = cObj, cWin = window;
  do {
    if(cElement.parentNode) cElement = cElement.parentNode;
    else if(cWin.frameElement) { cElement = cWin.frameElement; cWin = cWin.parent; }
    else break;
  } while(!isSet(cElement[nAttr]));
  return (isSet(cElement[nAttr]) ? cElement : null);
}

// Gets the nearest ancestor that has the specified class
function getAncestorWithClass(cObj, cClass)
{
  var cElement = cObj;
  do { cElement = getAncestorWithAttr(cElement, 'className'); }
  while(cElement && !hasClass(cElement, cClass));
  return cElement;
}

// Gets the specified attribute from the nearest ancestor that has it
function getAttrFromAncestor(cObj, nAttr)
{
  var cElement = getAncestorWithAttr(cObj, nAttr);
  if(cElement) return cElement[nAttr];
}

// Scrolls to show the specified HTML element
function scrollToShow(cElement, cRoot, centerX, centerY)
{
  if(!cRoot || !elemSameOrDesc(cRoot, document.documentElement)) cRoot = document.documentElement;
  if(!isSet(centerX)) centerX = null; if(!isSet(centerY)) centerY = null;
  if(!cRoot || !cElement || !cElement.parentNode || !cElement.offsetParent || (centerX === null && centerY === null)) return false;
  var left = getOffsetLeft(cElement), top = getOffsetTop(cElement), width = cElement.offsetWidth, height = cElement.offsetHeight;
  var cOffPar = cElement, sstyle, soffset, limn, limf, min, max, sval;
  while(elemSameOrDesc(cElement.parentNode, cRoot)) {
    if(cElement == cOffPar) cOffPar = cElement.offsetParent;
    cElement = cElement.parentNode; sstyle = getStyle(cElement);
    if(centerX !== null) {
      soffset = getOffsetLeft(cElement);
      if(cElement == document.documentElement || (sstyle.overflowX ? sstyle.overflowX : sstyle.overflow) != "visible") {
        limn = left - (cElement == cOffPar ? 0 : soffset); limf = limn + width - cElement.clientWidth;
        min = Math.min(limn, limf); max = Math.max(limn, limf); sval = getScrollLeft(cElement);
        if(centerX) sval = Math.round((min + max) / 2);
        else if(min <= sval || sval <= max) {
          if(sval < min) sval = min;
          if(sval > max) sval = max;
        }
        setScrollLeft(cElement, sval);
        if(width <= cElement.clientWidth) left -= getScrollLeft(cElement);
        else { left = (cElement == cOffPar ? 0 : soffset); width = cElement.clientWidth; }
      }
      if(cElement == cOffPar) left += soffset;
    }
    if(centerY !== null) {
      soffset = getOffsetTop(cElement);
      if(cElement == document.documentElement || (sstyle.overflowY ? sstyle.overflowY : sstyle.overflow) != "visible") {
        limn = top - (cElement == cOffPar ? 0 : soffset); limf = limn + height - cElement.clientHeight;
        min = Math.min(limn, limf); max = Math.max(limn, limf); sval = getScrollTop(cElement);
        if(centerY) sval = Math.round((min + max) / 2);
        else if(min <= sval || sval <= max) {
          if(sval < min) sval = min;
          if(sval > max) sval = max;
        }
        setScrollTop(cElement, sval);
        if(height <= cElement.clientHeight) top -= getScrollTop(cElement);
        else { top = (cElement == cOffPar ? 0 : soffset); height = cElement.clientHeight; }
      }
      if(cElement == cOffPar) top += soffset;
    }
  }
  return true;
}

// Resizes container frame to the document's full height
function resizeFrameToFit()
{
  var cFrame = window.frameElement, cHtml = document.documentElement, height;
  if(!cFrame || !cHtml) return false;
  cFrame.style.height = "0px";
  cFrame.style.height = Math.max(cHtml.clientHeight, cHtml.scrollHeight, cHtml.offsetHeight) + "px";
  return true;
}

// Automatically resizes container frame
function autoSizeFrame()
{
  if(resizeFrameToFit()) addHandlerLoad(resizeFrameToFit);
}

// Sends a GET request in the background
function sendGet(url)
{
  if(!isSet(window.sendGetImage)) window.sendGetImage = new Image();
  window.sendGetImage.src = null;
  setTimeout(function() { window.sendGetImage.src = url; }, 0);
}

// Sends a POST request to a link's href (instead of a GET)
function postLink(cLink, cEvent, confQues)
{
  confQues = (confQues ? confirm(confQues) : true);
  if(document.createElement && document.body && confQues) {
    var form = document.createElement('form');
    form.action = cLink.href; form.target = cLink.target;
    form.method = 'post'; form.style.display = 'none';
    document.body.appendChild(form);
    form.submit();
  }
  return prevDef(cEvent);
}

// Sets a form's action and fields and returns the form
function formSetAction(nForm, newAction, modFields)
{
  var cForm = document.forms[nForm];
  if(!cForm) return null;
  if(isSet(modFields)) {
    for(var nElement in modFields) if(!cForm.elements[nElement]) return null;
    var cElement, newValue;
    for(var nElement in modFields) {
      cElement = cForm.elements[nElement]; newValue = modFields[nElement];
      cElement.value = newValue; cElement.disabled = (newValue === null);
    }
  }
  cForm.action = newAction;
  return cForm;
}

// Gets a cookie's value
function getCookie(name)
{
  var nameEQ = urlEncode(name) + "=";
  var ca = document.cookie.split(';');
  for(var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while(c.charAt(0) == ' ') c = c.substr(1);
    if(c.indexOf(nameEQ) == 0) return urlDecode(c.substr(nameEQ.length));
  }
  return null;
}

// Sets a cookie's value
function setCookie(name, value, days)
{
  var expires = "";
  if(days != null) {
    var date = new Date();
    date.setTime(date.getTime() + (days * 24 * 3600 * 1000));
    expires = "; expires=" + date.toGMTString();
  }
  document.cookie = urlEncode(name) + "=" + urlEncode(value) + expires + "; path=/";
}

// Deletes a cookie
function delCookie(name)
{
  cookieSet(name, "", -1);
}


//-----------------------------------------------------------//
//                       Jump-selector                       //
//-----------------------------------------------------------//

// Returns value of jump-selector and resets it before jump
function jumpVal(sel)
{
  if(sel.jumping) return false;
  sel.jumping = true;
  var val = sel.options[sel.selectedIndex].value;
  sel.blur();
  sel.form.reset();
  sel.jumping = false;
  return val;
}

// Jumps to specified URL under the domain specified in BASE element
function siteJump(url)
{
  if(url.charAt(0) != '/') url = '/' + url;
  if(isSet(docDomain)) url = docDomain + url;
  location.href = url;
}

// Fills up specified jump-selectors with options
function fillJumpSels(formName, selName, numItems, block, defVal, latest, asc, blockClass, rangeClass)
{
  if(numItems <= 0) return;
  var sels = [];
  for(var i = 0; i < document.forms.length; i++)
    if(document.forms[i].name == formName)
      sels[sels.length] = document.forms[i].elements[selName];
  if(sels.length == 0) return;

  var opts = [];
  var padLen = numItems.toString().length
  var detStr = defVal - (defVal % 1000), detEnd = detStr + 1000;
  var rngStr = 0, rngEnd, optStr = 0, optEnd, optSel, optClass, optTxtStr, optTxtEnd, optTxt;
  do {
    rngEnd = rngStr + 1000; if(rngEnd > numItems) rngEnd = numItems;
    if(detStr <= optStr && optStr < detEnd) {
      optEnd = optStr + block; if(optEnd > rngEnd) optEnd = rngEnd;
      optSel = (optStr <= defVal && defVal < optEnd);
      if(optSel && latest) optEnd = numItems;
      optClass = (optSel ? null : blockClass);
    }
    else {
      optEnd = rngEnd;
      optSel = false;
      optClass = rangeClass;
    }

    optTxtStr = numLPad(optStr + 1, ' ', padLen); optTxtEnd = numLPad(optEnd, ' ', padLen);
    optTxt = (asc ? optTxtStr : optTxtEnd) + ' - ' + (asc ? optTxtEnd : optTxtStr);
    opts[opts.length] = [optTxt, optStr, optSel, optClass];

    optStr = optEnd;
    if(optEnd == rngEnd) rngStr = rngEnd;
  } while(optStr < numItems);

  var currIdx, currOpt;
  var start = (asc ? 0 : opts.length - 1), step = (asc ? 1 : -1);
  for(var i = 0; i < sels.length; i++) {
    sels[i].options.length = 0;
    for(currIdx = start; 0 <= currIdx && currIdx < opts.length; currIdx += step) {
      currOpt = new Option(opts[currIdx][0], opts[currIdx][1], opts[currIdx][2]);
      currOpt.className = opts[currIdx][3];
      sels[i].options[sels[i].options.length] = currOpt;
      if(opts[currIdx][2] && !currOpt.selected) currOpt.selected = true;
    }
  }
}


//-----------------------------------------------------------//
//                        Scroll-link                        //
//-----------------------------------------------------------//

function scl_Prepare(iCont)
{
  if(!onDesktopBrowser()) return;
  var cont = document.getElementById(iCont);
  if(!cont || !cont.getElementsByTagName) return null;
  var links = cont.getElementsByTagName("a");
  for(var i = 0; i < links.length; i++) links[i].onclick = scl_LinkClick;
}

function scl_LinkClick(cEvent)
{
  if(!this.hash || this.hash.charAt(0) != '#') return;
  var cElement = document.getElementById(this.hash.substr(1));
  if(cElement && scrollToShow(cElement, null, false, false)) return prevDef(cEvent);
}


//-----------------------------------------------------------//
//                         Tabbed box                        //
//-----------------------------------------------------------//

function tab_Prepare(iCont, showClass)
{
  var cont = document.getElementById(iCont), actLink;
  if(!cont || !cont.parentNode || !cont.getElementsByTagName) return null;
  var tabs = getClassChild(cont, "tabs"), menu = getClassChild(cont, "menu"), link, item;
  if(!tabs || !menu) return null;
  cont.tabElems = getChildElems(tabs); cont.tabMenu = menu; cont.tabLinks = menu.getElementsByTagName("a");
  for(var i = 0; i < cont.tabElems.length; i++) cont.tabElems[i].style.display = 'none';
  for(var i = 0; i < cont.tabLinks.length; i++) {
    link = cont.tabLinks[i]; item = link;
    while(item.parentNode != menu) item = item.parentNode;
    setClass(item, "act", false);
    link.tabCont = cont; link.tabLinkIdx = i; link.tabItem = item; link.tabClass = item.className;
    link.tabChange = tab_Change; link.onclick = tab_LinkClick;
    if(hasClass(item, showClass)) actLink = link;
  }
  if(isSet(actLink)) actLink.tabChange();
  return cont;
}

function tab_LinkClick(cEvent)
{
  this.tabChange();
  return prevDef(cEvent);
}

function tab_Change()
{
  var tabElems = this.tabCont.tabElems, tabLinks = this.tabCont.tabLinks;
  for(var i = 0; i < tabElems.length; i++) tabElems[i].style.display = (hasClass(tabElems[i], this.tabClass) ? 'block' : 'none');
  for(var i = 0; i < tabLinks.length; i++) setClass(tabLinks[i].tabItem, "act", (tabLinks[i] == this));
  this.tabCont.tabActLinkIdx = this.tabLinkIdx;
}


//-----------------------------------------------------------//
//                          Megabox                          //
//-----------------------------------------------------------//

function mbx_Prepare(iCont, cInterval)
{
  var cont = tab_Prepare(iCont, null);
  if(!cont || !cont.tabLinks.length) return;
  cont.mbxChange = mbx_Change; cont.mbxPlay = mbx_Play; cont.mbxPause = mbx_Pause;
  cont.mbxAuto = null; cont.mbxAutoIval = cInterval; cont.mbxAutoFunc = function() { cont.mbxChange(); };
  for(var i = 0; i < cont.tabLinks.length; i++) cont.tabLinks[i].onclick = mbx_LinkClick;
  var func = getClassChild(cont, "func");
  if(func) {
    var play = getClassChild(func, "play"), pause = getClassChild(func, "pause");
    if(play) play.onclick = function() { cont.mbxPlay(); };
    if(pause) pause.onclick = function() { cont.mbxPause(); };
  }
  cont.mbxPlay();
}

function mbx_LinkClick(cEvent)
{
  this.tabCont.mbxPause();
  this.tabChange();
  return prevDef(cEvent);
}

function mbx_Change()
{
  var nextIdx = (isSet(this.tabActLinkIdx) ? (this.tabActLinkIdx + 1) % this.tabLinks.length : 0);
  this.tabLinks[nextIdx].tabChange();
}

function mbx_Play()
{
  if(this.mbxAuto != null) clearInterval(this.mbxAuto);
  this.mbxChange(); this.mbxAuto = setInterval(this.mbxAutoFunc, this.mbxAutoIval);
  setClass(this.tabMenu, "menuact", true);
}

function mbx_Pause()
{
  if(this.mbxAuto != null) clearInterval(this.mbxAuto);
  this.mbxAuto = null;
  setClass(this.tabMenu, "menuact", false);
}


//-----------------------------------------------------------//
//                          Gallery                          //
//-----------------------------------------------------------//

function gal_Popup(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'width=757,height=489,titlebar');
  return prevDef(cEvent);
}

function gal_PopupPic(cLink, cEvent)
{
  window.open(cLink.href, cLink.target, 'titlebar');
  return prevDef(cEvent);
}

function gal_Prepare(iCont)
{
  var cont = document.getElementById(iCont);
  if(!cont || !cont.getElementsByTagName) return;
  var links = cont.getElementsByTagName('a');
  for(var i = 0; i < links.length; i++) if(links[i].target == iCont) {
    links[i].onclick = gal_LinkClick;
    links[i].thumbClass = null;
  }
  cont.thumbLinks = links;
}

function gal_PreparePic(iCont)
{
  var cont = document.getElementById(iCont);
  if(!cont || !cont.getElementsByTagName) return;
  var links = cont.getElementsByTagName('a');
  for(var i = 0; i < links.length; i++) if(!links[i].target) links[i].onclick = gal_LinkClick;
  addHandlerLoad(function() { gal_Highlight(location, false); });
}

function gal_LinkClick(cEvent)
{
  gal_Highlight(this, true);
}

function gal_Highlight(cLink, isLoading)
{
  var links = getAttrFromAncestor(cLink, 'thumbLinks');
  if(!links) return;
  for(var i = 0; i < links.length; i++) {
    var link = links[i], cont = link.parentNode, match = (link.href == cLink.href);
    if(isLoading) {
      link.thumbClass = (match ? 'loading' : null);
      if(cont.className != 'active') cont.className = link.thumbClass;
      if(match) gal_ThumbShow(cont);
    }
    else cont.className = (match ? 'active' : link.thumbClass);
  }
}

function gal_ThumbShow(cElement)
{
  var cont = cElement;
  while(cont && !hasClass(cont, 'thumbs')) cont = cont.parentNode;
  if(!cont) return;
  var min = cElement.offsetTop + cElement.offsetHeight - cont.clientHeight, max = cElement.offsetTop;
  if(cont.scrollTop < min) cont.scrollTop = min;
  if(cont.scrollTop > max) cont.scrollTop = max;
}


//-----------------------------------------------------------//
//                  Informative text-input                   //
//-----------------------------------------------------------//

function iti_Prepare(nForm)
{
  var cForm = document.forms[nForm];
  if(!cForm || !cForm.parentNode || !cForm.insertBefore || !cForm.removeAttribute) return;
  var cElems = cForm.elements, cTxts = [];
  for(var i = 0; i < cElems.length; i++) if(cElems[i].type == 'text' && hasClass(cElems[i], "iti") && cElems[i].alt) cTxts[cTxts.length] = cElems[i];
  if(!cTxts.length) return;
  var cText, cSave;
  for(var i = 0; i < cTxts.length; i++) {
    cText = cTxts[i]; cText.itiSave = document.createElement("input");
    cText.itiSave.type = "hidden"; cText.itiSave.disabled = true; cText.itiSave.value = "";
    cText.parentNode.insertBefore(cText.itiSave, cText); cText.itiSave.style.display = "none";
    cText.itiShowsInfo = (cText.value == "");
    if(cText.itiShowsInfo) cText.value = cText.alt;
    cText.onfocus = iti_TxtFocus; cText.onblur = iti_TxtBlur;
  }
  cForm.itiDoSubmitPrepare = function() {
    for(var i = 0; i < cTxts.length; i++) {
      cTxts[i].itiSave.name = cTxts[i].name; cTxts[i].removeAttribute("name");
      cTxts[i].itiSave.disabled = cTxts[i].disabled;
      cTxts[i].itiSave.value = (cTxts[i].itiShowsInfo ? "" : cTxts[i].value);
    }
  };
  cForm.itiDoSubmitRestore = function() {
    for(var i = 0; i < cTxts.length; i++) {
      cTxts[i].name = cTxts[i].itiSave.name; cTxts[i].itiSave.removeAttribute("name");
      cTxts[i].itiSave.disabled = true;
      cTxts[i].itiSave.value = "";
    }
  };
  cForm.onsubmit = iti_FormSubmit;
  addHandlerLoad(function() {
    for(var i = 0; i < cTxts.length; i++) {
      if(cTxts[i].itiSave.value == "") continue;
      cTxts[i].alt = cTxts[i].itiSave.value;
      cTxts[i].itiShowsInfo = (cTxts[i].value == "");
      if(cTxts[i].itiShowsInfo) cTxts[i].value = cTxts[i].alt;
    }
  });
  addHandlerUnload(function() {
    for(var i = 0; i < cTxts.length; i++) {
      cTxts[i].itiSave.value = cTxts[i].alt;
      if(cTxts[i].itiShowsInfo) cTxts[i].value = "";
    }
  });
}

function iti_TxtFocus(cEvent)
{
  if(this.itiShowsInfo) this.value = "";
  this.itiShowsInfo = false;
}

function iti_TxtBlur(cEvent)
{
  this.itiShowsInfo = (this.value == "");
  if(this.itiShowsInfo) this.value = this.alt;
}

function iti_FormSubmit(cEvent)
{
  this.itiDoSubmitPrepare();
  setTimeout(this.itiDoSubmitRestore, 0);
}

function iti_ChangeDefault(cForm, nElement, newValue)
{
  var cText = cForm.elements[nElement];
  if(!cText || !isSet(cText.itiShowsInfo)) return null;
  cText.alt = newValue;
  if(cText.itiShowsInfo) cText.value = cText.alt;
  return cText.itiShowsInfo;
}


//-----------------------------------------------------------//
//                       DropDown menu                       //
//-----------------------------------------------------------//

function ddm_Prepare(iRoot)
{
  var root = document.getElementById(iRoot);
  if(!root || !root.parentNode || !root.getElementsByTagName) return;
  var links = root.getElementsByTagName("a"), link, cont;
  for(var i = 0; i < links.length; i++) {
    link = links[i]; cont = getAncestorWithClass(link, "ddm");
    if(!elemSameOrDesc(cont, root) || !ddm_PrepareCont(cont)) continue;
    if(elemSameOrDesc((hasClass(link, "act") ? link : getAncestorWithClass(link, "act")), cont.ddmMenu)) cont.ddmActLink = link;
    link.ddmCont = cont;
    link.onmousedown = ddm_LinkMouseDown;
    link.onfocus = ddm_LinkFocus; link.onblur = null;
    link.onkeydown = ddm_LinkKeyEvent; link.onkeypress = ddm_LinkKeyEvent;
  }
  if(!isSet(window.ddmToClose)) {
    window.ddmToClose = null;
    addHandlerUnload(function() {
      var cont;
      while(window.ddmToClose) { cont = window.ddmToClose; cont.ddmDoCloseFocus(); }
      if(cont) setTimeout(cont.ddmDoCloseFocus, 0);
    });
  }
}

function ddm_PrepareCont(cCont)
{
  if(isSet(cCont.ddmTimer)) return true;
  var cOpen = getClassChild(cCont, "open"), cMenu = getClassChild(cCont, "menu");
  if(!cOpen || !cMenu) return false;
  cCont.ddmTimer = null; cCont.ddmOpen = cOpen; cCont.ddmMenu = cMenu;
  cOpen.ddmCont = cCont; cMenu.ddmCont = cCont; cMenu.tabIndex = -1;
  cCont.ddmDoOpen = function() {
    cCont.style.zIndex = 1;
    cCont.ddmMenu.style.display = "block";
    scrollToShow(cCont.ddmMenu, null, false, false);
    if(cCont.ddmActLink) scrollToShow(cCont.ddmActLink, cCont.ddmMenu, null, true);
    cCont.ddmIsOpen = true;
    window.ddmToClose = cCont;
  };
  cCont.ddmDoClose = function() {
    cCont.style.zIndex = 0;
    cCont.ddmMenu.style.display = "none";
    cCont.ddmIsOpen = false;
    window.ddmToClose = getAncestorWithAttr(cCont, "ddmTimer");
  };
  cCont.ddmDoCloseFocus = function() {
    cCont.ddmOpen.focus();
    cCont.ddmDoClose();
  };
  cOpen.onclick = ddm_OpenClick;
  cOpen.ondblclick = ddm_OpenDblClick;
  cMenu.onfocus = ddm_MenuFocus;
  return true;
}

function ddm_OpenClick(cEvent)
{
  if(this.ddmCont.ddmIsOpen) this.ddmCont.ddmDoClose();
  else this.ddmCont.ddmDoOpen();
  this.focus();
  return prevDef(cEvent);
}

function ddm_OpenDblClick(cEvent)
{
  window.open(this.href, (this.target ? this.target : "_self"));
  return prevDef(cEvent);
}

function ddm_MenuFocus(cEvent)
{
  this.ddmCont.ddmOpen.focus();
}

function ddm_LinkMouseDown(cEvent)
{
  this.focus();
}

function ddm_LinkFocus(cEvent)
{
  var cont = this.ddmCont;
  while(cont) {
    if(cont.ddmTimer) clearTimeout(cont.ddmTimer);
    cont.ddmTimer = null;
    cont = getAncestorWithAttr(cont, "ddmTimer");
  }
  this.onblur = ddm_LinkBlur;
}

function ddm_LinkBlur(cEvent)
{
  var cont = this.ddmCont;
  while(cont) {
    if(cont.ddmTimer) clearTimeout(cont.ddmTimer);
    cont.ddmTimer = setTimeout(cont.ddmDoClose, 0);
    cont = getAncestorWithAttr(cont, "ddmTimer");
  }
  this.onblur = null;
}

function ddm_LinkKeyEvent(cEvent)
{
  var cont = this.ddmCont;
  if(!cEvent) cEvent = window.event;
  switch(cEvent.keyCode) {
    case 27:
      while(cont && !cont.ddmIsOpen) cont = getAncestorWithAttr(cont, "ddmTimer");
      if(!cont && !handleOnce(false)) return;
      if(handleOnce(true)) break;
      cont.ddmDoCloseFocus();
      break;
    default:
      return;
  }
  return prevDef(cEvent);
}


//-----------------------------------------------------------//
//                      DropDown select                      //
//-----------------------------------------------------------//

function dds_Prepare(nForm)
{
  if(!document.createElement || !document.createTextNode) return;
  var cForm = document.forms[nForm];
  if(!cForm || !cForm.parentNode || !cForm.insertBefore) return;
  var cElement, cSels = [];
  for(var i = 0; i < cForm.elements.length; i++) {
    cElement = cForm.elements[i];
    if(cElement.type != 'select-one') continue;
    dds_PrepareSel(cElement);
    cSels[cSels.length] = cElement;
  }
  cForm.ddsDoShowAct = function() { for(var i = 0; i < cSels.length; i++) cSels[i].onchange(); };
  cForm.onreset = dds_FormReset;
  cForm.ddsDoShowAct(); addHandlerLoad(cForm.ddsDoShowAct);
  if(!isSet(window.ddsToClose)) {
    window.ddsToClose = null;
    addHandlerUnload(function() { if(window.ddsToClose) window.ddsToClose.ddsDoClose(); });
  }
}

function dds_PrepareSel(cSel)
{
  var cCont = document.createElement("div"), cDisp = document.createElement("div"), cList = document.createElement("ul");
  cCont.className = cSel.className; setClass(cCont, "dds", true); setClass(cDisp, "disp", true); setClass(cList, "opts", true);
  cCont.ddsSel = cSel; cCont.ddsDisp = cDisp; cCont.ddsList = cList;
  cSel.ddsCont = cCont; cDisp.ddsCont = cCont; cList.ddsCont = cCont;
  cCont.appendChild(cDisp); cCont.appendChild(cList);
  cCont.ddsOpts = []; cSel.ddsGroup = cList;
  var sitem, litem, sgroup, lgroup;
  for(var i = 0; i < cSel.options.length; i++) {
    sitem = cSel.options[i]; sgroup = sitem.parentNode;
    litem = document.createElement("li"); litem.innerHTML = "<span>" + sitem.innerHTML + "</span>";
    cCont.ddsOpts[i] = litem; litem.ddsCont = cCont; litem.ddsIndex = i;
    litem.onclick = dds_OptClick; litem.onmouseover = dds_OptMouseOver; litem.onmouseout = dds_OptMouseOut;
    while(!isSet(sgroup.ddsGroup)) {
      lgroup = document.createElement("ul"); lgroup.appendChild(litem);
      sgroup.ddsGroup = lgroup; litem = lgroup;
      lgroup = document.createElement("li"); setClass(lgroup, "optgr", true);
      if(sgroup.label) lgroup.appendChild(document.createElement("p")).appendChild(document.createTextNode(sgroup.label));
      lgroup.appendChild(litem);
      litem = lgroup;
      sgroup = sgroup.parentNode;
    }
    sgroup.ddsGroup.appendChild(litem);
  }
  cSel.ddsActIndex = cSel.selectedIndex; cSel.ddsDoChange = dds_SelDoChange; cSel.onchange = dds_SelChange;
  cCont.ddsDoOpen = function() {
    cCont.style.zIndex = 1;
    cCont.ddsList.style.display = "block";
    scrollToShow(cCont.ddsList, null, false, false);
    scrollToShow(cCont.ddsOpts[cCont.ddsSel.ddsActIndex], cCont.ddsList, null, true);
    cCont.ddsIsOpen = true;
    window.ddsToClose = cCont;
  };
  cCont.ddsDoClose = function() {
    cCont.style.zIndex = 0;
    cCont.ddsList.style.display = "none";
    cCont.ddsIsOpen = false;
    window.ddsToClose = null;
  };
  cDisp.tabIndex = (cSel.tabIndex ? cSel.tabIndex : 0); cDisp.onclick = dds_DispClick;
  cDisp.onfocus = dds_DispFocus; cDisp.onblur = null;
  cDisp.onkeydown = dds_DispKeyEvent; cDisp.onkeypress = dds_DispKeyEvent;
  cList.tabIndex = -1; cList.onfocus = dds_ListFocus;
  cSel.parentNode.insertBefore(cCont, cSel);
  cSel.style.display = "none";
}

function dds_FormReset(cEvent)
{
  setTimeout(this.ddsDoShowAct, 0);
}

function dds_SelDoChange(newIndex)
{
  if(newIndex < 0 || newIndex > this.options.length - 1) return;
  this.selectedIndex = newIndex;
  this.onchange();
}

function dds_SelChange(cEvent)
{
  var cont = this.ddsCont;
  setClass(cont.ddsOpts[this.ddsActIndex], "act", false);
  this.ddsActIndex = this.selectedIndex;
  setClass(cont.ddsOpts[this.ddsActIndex], "act", true);
  cont.ddsDisp.innerHTML = cont.ddsOpts[this.ddsActIndex].innerHTML;
}

function dds_DispClick(cEvent)
{
  if(this.ddsCont.ddsIsOpen) this.ddsCont.ddsDoClose();
  else this.ddsCont.ddsDoOpen();
  this.focus();
}

function dds_DispFocus(cEvent)
{
  var cont = this.ddsCont;
  if(cont.ddsTimer) clearTimeout(cont.ddsTimer);
  cont.ddsTimer = null;
  this.onblur = dds_DispBlur;
}

function dds_DispBlur(cEvent)
{
  var cont = this.ddsCont;
  if(cont.ddsTimer) clearTimeout(cont.ddsTimer);
  cont.ddsTimer = setTimeout(cont.ddsDoClose, 0);
  this.onblur = null;
}

function dds_DispKeyEvent(cEvent)
{
  var cont = this.ddsCont;
  if(!cEvent) cEvent = window.event;
  switch(cEvent.keyCode) {
    case 13:
      if(handleOnce(true)) break;
      if(cont.ddsIsOpen) cont.ddsDoClose();
      else cont.ddsDoOpen();
      break;
    case 27:
      if(!cont.ddsIsOpen && !handleOnce(false)) return;
      if(handleOnce(true)) break;
      cont.ddsDoClose();
      break;
    case 37:
    case 38:
      if(handleOnce(true)) break;
      cont.ddsSel.ddsDoChange(cont.ddsSel.selectedIndex - 1);
      break;
    case 39:
    case 40:
      if(handleOnce(true)) break;
      cont.ddsSel.ddsDoChange(cont.ddsSel.selectedIndex + 1);
      break;
    default:
      return;
  }
  return prevDef(cEvent);
}

function dds_ListFocus(cEvent)
{
  this.ddsCont.ddsDisp.focus();
}

function dds_OptClick(cEvent)
{
  var cont = this.ddsCont;
  cont.ddsSel.ddsDoChange(this.ddsIndex);
  cont.ddsDoClose();
}

function dds_OptMouseOver(cEvent)
{
  setClass(this, "hover", true);
}

function dds_OptMouseOut(cEvent)
{
  setClass(this, "hover", false);
}


//-----------------------------------------------------------//
//                     Auto-refresh form                     //
//-----------------------------------------------------------//

function arf_Prepare(nForm)
{
  var cForm = document.forms[nForm], elem;
  if(!cForm || !cForm.parentNode || !cForm.removeChild) return;
  for(var i = 0; i < cForm.elements.length; i++) {
    elem = cForm.elements[i];
    if(!hasClass(elem, 'refresh')) continue;
    if(elem.type == 'submit') elem.parentNode.removeChild(elem);
    else elem.onchange = arf_RefrElemChange;
  }
}

function arf_RefrElemChange(cEvent)
{
  var url = this.form.action, qs = "", elems = this.form.elements, elem, currName, currVals;
  if(url.indexOf('?') != -1) url = url.substr(0, url.indexOf('?'));
  for(var i = 0; i < elems.length; i++) {
    elem = elems[i];
    if(!elem.name || elem.disabled) continue;
    currName = urlEncode(elem.name); currVals = [];
    switch(elem.type) {
      case 'checkbox':
      case 'radio':
        if(elem.checked) currVals[currVals.length] = urlEncode(elem.value);
        break;
      case 'select-one':
      case 'select-multiple':
        for(var j = 0; j < elem.options.length; j++)
          if(elem.options[j].selected) currVals[currVals.length] = urlEncode(elem.options[j].value);
        break;
      case 'hidden':
      case 'text':
      case 'password':
      case 'textarea':
        currVals[currVals.length] = urlEncode(elem.value);
        break;
    }
    for(var j = 0; j < currVals.length; j++) qs += (qs ? '&' : '?') + currName + '=' + currVals[j];
  }
  location.replace(url + qs);
}


//-----------------------------------------------------------//
//                          MultiDel                         //
//-----------------------------------------------------------//

function mdel_Prepare(nForm, cLimit, cMsgFull)
{
  var cForm = document.forms[nForm];
  if(!cForm || !cForm.parentNode) return;
  var checks = cForm.elements['ids[]'];
  if(!checks) return;
  if(!checks.length) checks = [checks];
  cForm.mdelChecks = checks; cForm.mdelLimit = cLimit; cForm.mdelMsgFull = cMsgFull;
  var check, link;
  for(var i = 0; i < checks.length; i++) {
    check = checks[i]; link = getClassChild(check.parentNode, "mdel");
    check.onclick = mdel_CheckClick;
    if(link) {
      link.mdelCheck = check;
      link.onclick = mdel_LinkClick;
    }
  }
}

function mdel_CheckClick(cEvent) {
  var checks = this.form.mdelChecks, currChecked = 0;
  for(var i = 0; i < checks.length; i++) if(checks[i].checked) currChecked++;
  if(currChecked > this.form.mdelLimit) {
    alert(this.form.mdelMsgFull);
    this.checked = false;
  }
}

function mdel_LinkClick(cEvent) {
  var check = this.mdelCheck; var wasChecked = check.checked;
  check.checked = true; check.onclick();
  if(wasChecked && check.checked) check.form.submit();
  return prevDef(cEvent);
}


//-----------------------------------------------------------//
//                      Base64 encoding                      //
//-----------------------------------------------------------//

// Get Base64 character value
function b64_GetCharValue(cChar)
{
  var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
  for(var i = 0; i < chars.length; i++) if(chars.charAt(i) == cChar) return i;
  return null;
}

// Decodes a Base64 string (with UTF-8 charset)
function b64_Decode(cStr)
{
  cStr = cStr.replace(/[^A-Za-z0-9\+\/=]/g, '');
  while((cStr.length % 4) != 0) cStr += '=';

  var ch1, ch2, ch3, ch4, byte1, byte2, byte3;
  var charIdx = 0, decoded = [], byteIdx = 0;
  while(charIdx < cStr.length) {
    ch1 = b64_GetCharValue(cStr.charAt(charIdx++));
    ch2 = b64_GetCharValue(cStr.charAt(charIdx++));
    ch3 = b64_GetCharValue(cStr.charAt(charIdx++));
    ch4 = b64_GetCharValue(cStr.charAt(charIdx++));
    byte1 = (ch1 << 2) | (ch2 >> 4);
    byte2 = ((ch2 & 15) << 4) | (ch3 >> 2);
    byte3 = ((ch3 & 3) << 6) | ch4;
    decoded[byteIdx++] = byte1;
    if(ch3 != 64) decoded[byteIdx++] = byte2;
    if(ch4 != 64) decoded[byteIdx++] = byte3;
  }

  byteIdx = 0;
  var charCode, seqLen, retStr = '';
  while(byteIdx < decoded.length) {
    charCode = decoded[byteIdx++]; seqLen = 1;
    if(charCode >= 192) seqLen++;
    if(charCode >= 224) seqLen++;
    if(charCode >= 240) seqLen++;
    if(seqLen > 1) {
      charCode = (charCode & (255 >> (seqLen + 1)));
      while(seqLen-- > 1) charCode = ((charCode << 6) | (decoded[byteIdx++] & 63));
    }
    retStr += String.fromCharCode(charCode);
  }
  return(retStr);
}

// Create link to Base64 address
function b64_CreateLink(cPrefix, cAddress)
{
  var cAddress = b64_Decode(cAddress);
  document.write('<a href="' + cPrefix + cAddress + '">' + cAddress + '</a>');
}


//-----------------------------------------------------------//
//                        Audits & Ads                       //
//-----------------------------------------------------------//

// Audit code: Median
function audit_median(code)
{
  document.write('<img src="http://audit.median.hu/cgi-bin/track.cgi?uc=' + code + '&amp;dc=1&amp;ui=' + same + '" alt="" />');
}

// Audit code: Szonda
function audit_szonda(code)
{
  pp_gemius_identifier = code;
  if(window.attachEvent) {
    window.attachEvent("onload", gemius_load_script);
  } else if(window.addEventListener) {
    window.addEventListener("load", gemius_load_script, false);
  }
  pp_gemius_url += pp_gemius_identifier + gemius_parameters();
  pp_gemius_image.src = pp_gemius_url;
}

// Audit code: Google
function audit_google(code)
{
  if(!window._gaq) window._gaq = [];
  window._gaq.push(['_setAccount', code]);
  window._gaq.push(['_trackPageview']);
  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
  (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(ga);
}

// Banner: AdOcean Adserver
function ad_adocean(code)
{
  if(!isSet(window.adoInitOk)) { adocean_config(); window.adoInitOk = true; }
  document.write('<div id="' + code + '"></div><script type="text/javascript">ado.placement({id: "' + code + '", server: "indexhu.adocean.pl" });</script>');
}

// Banner: Google Adsense
function ad_google(channel, width, height, color)
{
  if(!color) color = "ffffff";

  google_ad_client = "pub-3023840094153539";
  google_ad_type = "text";
  google_ad_channel = channel;

  google_ad_width = width;
  google_ad_height = height;
  google_ad_format = width + "x" + height + "_as";

  google_alternate_color = color;
  google_color_bg = color;
  google_color_border = color;
  google_color_link = "b42224";
  google_color_text = "666666";
  google_color_url = "008000";

  document.write('<script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js"></script>');
}


//-----------------------------------------------------------//
//                  Needed for Audits & Ads                  //
//-----------------------------------------------------------//

// Median Webaudit needed functions
WEBAUDIT = function () {
  this.WACID=null;
  this.WACIDName="WACID";

  this.getCookie=function(name)  {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
      var c = ca[i];
      while (c.charAt(0)==' ') c = c.substring(1,c.length);
      if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
  }

  this.setCookie=function(name,value,topDomain) {
    var date = new Date(2020,12,31,23,59,59);
    var expires = "; expires="+date.toGMTString();
    document.cookie = name+"="+value+expires+"; path=/; domain=" + topDomain;
  }

  this.generateID=function(splitter) {
    var sp=(splitter) ? splitter : 'A';
    var now=new Date();
    return Date.parse(now.toGMTString()) + sp + Math.floor(Math.random()*1000000);
  }

  this.getTopDomain=function(fullDomain) {
    var darabok=fullDomain.split('.');
    return darabok[(darabok.length-2)] + '.' + darabok[(darabok.length-1)];
  }

  this.getDomain=function(url) {
    var urlDarabok=url.split('/');
    return urlDarabok[2];
  }

  this.WACID=this.getCookie(this.WACIDName);
}

var wa=new WEBAUDIT();
var felbontas = "";
var same = Math.floor(Math.random()*1000000);
if(wa.WACID==null)
{
  wa.WACID=wa.generateID('A');
  wa.setCookie(wa.WACIDName,wa.WACID,wa.getTopDomain(wa.getDomain(document.URL)));
}
same = same + "@welid=" + wa.WACID;
if(screen) felbontas='@felbontas='+screen.width+'x'+screen.height;
same = same + felbontas;

// Szonda Geminus needed functions
var pp_gemius_image = new Image();
var pp_gemius_proto;
if (document.location && document.location.protocol && document.location.protocol=='https:') {
  pp_gemius_proto = 'https:';
} else {
  pp_gemius_proto = 'http:';
}
var pp_gemius_host = new String(pp_gemius_proto+'//hu.hit.gemius.pl/_'+(new Date()).getTime());
var pp_gemius_url = pp_gemius_host+'/rexdot.gif?l=11&id=';

function gemius_load_script() {
  if (pp_gemius_image.width && pp_gemius_image.width>1) {
    if (document.createElement) {
      var xp_body = document.body;
      var xp_javascript = document.createElement('script');
      var xp_url = pp_gemius_host+'/pp.js?id='+pp_gemius_identifier;
      if (typeof(Error) != 'undefined') {
        eval("try { xp_javascript.src = xp_url; xp_javascript.type = 'text/javascript'; xp_javascript.defer = true; } catch(gemius_ex) { }")
        if (xp_body && xp_body.appendChild) void(xp_body.appendChild(xp_javascript));
      }
    }
  }
}

function gemius_parameters() {
  var d = document;
  var href = new String(d.location.href);
  var ref;
  if (d.referrer) { ref = new String(d.referrer); } else { ref = ""; }
  var t = typeof Error;
  if(t != 'undefined') {
    eval("try { if (typeof(top.document.referrer)=='string') { ref = top.document.referrer } } catch(gemius_ex) { }")
  }
  var url='&tz='+(new Date()).getTimezoneOffset()+'&href='+escape(href.substring(0,299))+'&ref='+escape(ref.substring(0,299));
  if (screen) {
    var s=screen;
    if (s.width) url+='&screen='+s.width+'x'+s.height;
    if (s.colorDepth) url+='&col='+s.colorDepth;
  }
  return url;
}

function adocean_config() {
  if(typeof window.ado!=="object"){var f=function(){};window.ado={config:f,preview:f,placement:f,master:f,slave:f};}
  window.ado.config({mode: "old", xml: false, characterEncoding: true});
  window.ado.preview({enabled: true, emiter: "indexhu.adocean.pl", id: "tPb6h8.YQveugZgS_9V716lsgorAfh5dBRodZih71QX.V7"});
}
