/*
 * drv_ds12887.c
 */

#include "types.h"
#include "drv_ds12887.h"

#include <p18cxxx.h>
#include <stdio.h>
#include <string.h>

#define DS12887_ALE (PORTHbits.RH4)		// AS lb
#define DS12887_RD (PORTHbits.RH5)		// DS lb
#define DS12887_WR (PORTHbits.RH6)		// R/W_ lb
#define DS12887_CS (PORTGbits.RG4)		// CS_ lb
#define DS12887_DATA (PORTF)		// multiplexelt adat/cm vezetkek adatregisztere
#define DS12887_TRIS (TRISF)		// multiplexelt adat/cm vezetkek irnyregisztere

struct RTCStatus RTCStatus;
int rtc_Hours;
int rtc_Minutes;
int rtc_Seconds;

static void byteWrite(BYTE addr, BYTE data);
static BYTE byteRead(BYTE addr);
static void DS12887_BitModify(BYTE addr, BYTE mask, BYTE data);

/*
 * byteWrite
 */
static void byteWrite(BYTE addr, BYTE data)
{
	DS12887_TRIS = OUTPUT;
	DS12887_ALE = LOW;
	DS12887_RD = HIGH;
	DS12887_WR = HIGH;
	DS12887_CS = LOW;
	T_ASD;
	DS12887_ALE = HIGH;
	DS12887_DATA = addr;
//	T_ASL;
	PW_ASH;
	DS12887_ALE = LOW;
//	T_AHL;
//	T_ASED;
//	T_CS;
	PW_EL;
	DS12887_WR = LOW;
	DS12887_DATA = data;
//	T_DSW;
	PW_EH;
	DS12887_WR = HIGH;
//	T_DHW;
//	T_CH;
	DS12887_CS = HIGH;
}

/*
 * byteRead
 */
static BYTE byteRead(BYTE addr)
{
	BYTE val;

	DS12887_TRIS = OUTPUT;
	DS12887_ALE = LOW;
	DS12887_RD = HIGH;
	DS12887_WR = HIGH;
	DS12887_CS = LOW;
	T_ASD;
	DS12887_ALE = HIGH;
	DS12887_DATA = addr;
//	T_ASL;
	PW_ASH;
	DS12887_ALE = LOW;
//	T_AHL;
//	T_ASED;
//	T_CS;
	PW_EL;
	DS12887_TRIS = INPUT;
	DS12887_RD = LOW;
//	T_DDR;
	PW_EH;
	val = DS12887_DATA;
	DS12887_RD = HIGH;
//	T_CH;
	T_DHR;
	DS12887_CS = HIGH;

	return val;
}

/*
 * batteryCheck
 * visszatrsi rtk: 0 - minden j, 1 - valszn lemerlt elem
 */
BYTE batteryCheck(void)
{
	return ((byteRead(REGISTER_D) == 0x80) ? 0 : 1);
}

/*
 * ds12887Init
 */
void DS12887_Init(void)
{
	BYTE temp;

	DS12887_ALE = DS12887_RD = DS12887_WR = DS12887_CS = 1;

	byteWrite(REGISTER_A, 0b00101111);
	byteWrite(REGISTER_B, UIE | DM | M2412 | DSE);

	temp = byteRead(REGISTER_C);	/* beragadt IT-k trlse ! */
	RTCStatus.RTC_IRQ_REQUEST = 0;
	RTCStatus.RTC_SEC = 0;
	RTCStatus.RTC_ALARM = 0;
}

/*
 * setDate
 */
void setDate(DS12887_t *date)
{
	BYTE temp;

	// rgi rtk beolvassa
	temp = byteRead(REGISTER_B);

	DS12887_BitModify(REGISTER_B, SET, SET);	// 'SET' bit 1-be
	while (byteRead(REGISTER_A) & UIP)
		continue;

	byteWrite(YEAR_REG, date->Year);
	byteWrite(MONTH_REG, date->Month);
	byteWrite(DAY_OF_THE_MONTH_REG, date->Day_of_the_Month);
	byteWrite(DAY_OF_THE_WEEK_REG, date->Day_of_the_Week);
	byteWrite(HOURS_REG, date->Hours);
	byteWrite(MINUTES_REG, date->Minutes);
	byteWrite(SECONDS_REG, date->Seconds);

	DS12887_BitModify(REGISTER_B, SET, 0);		// 'SET' bit 0-ba

	// ez a trkk azrt kell, mert az 'UIE' bit ha 1-ben van, akkor 0-ba megy,
	// miutn a 'SET' bitet belltottuk 1-be
	// csak akkor lehet az 'UIE' bitet visszalltani, ha a 'SET' bit
	// 0-ban van
	if (temp & UIE)
		DS12887_BitModify(REGISTER_B, UIE, UIE);
}

/*
 * getDate
 */
void getDate(DS12887_t *date)
{
	BYTE temp;

	// rgi rtk beolvassa
	temp = byteRead(REGISTER_B);

	DS12887_BitModify(REGISTER_B, SET, SET);	// 'SET' bit 1-be
	while (byteRead(REGISTER_A) & UIP)
		continue;

	date->Year = byteRead(YEAR_REG);
	date->Month = byteRead(MONTH_REG);
	date->Day_of_the_Month = byteRead(DAY_OF_THE_MONTH_REG);
	date->Day_of_the_Week = byteRead(DAY_OF_THE_WEEK_REG);
	date->Hours = byteRead(HOURS_REG);
	date->Minutes = byteRead(MINUTES_REG);
	date->Seconds = byteRead(SECONDS_REG);

	DS12887_BitModify(REGISTER_B, SET, 0);		// 'SET' bit 0-ba

	// ez a trkk azrt kell, mert az 'UIE' bit ha 1-ben van, akkor 0-ba megy,
	// miutn a 'SET' bitet belltottuk 1-be
	// csak akkor lehet az 'UIE' bitet visszalltani, ha a 'SET' bit
	// 0-ban van
	if (temp & UIE)
		DS12887_BitModify(REGISTER_B, UIE, UIE);
}

/*
 * SetRTCAlarm
 */
void SetRTCAlarm(BYTE hours, BYTE minutes, BYTE seconds)
{
	BYTE temp;

	// rgi rtk beolvassa
	temp = byteRead(REGISTER_B);

	DS12887_BitModify(REGISTER_B, SET, SET);	// 'SET' bit 1-be
	while (byteRead(REGISTER_A) & UIP)
		continue;

	byteWrite(HOURS_ALARM_REG, hours);
	byteWrite(MINUTES_ALARM_REG, minutes);
	byteWrite(SECONDS_ALARM_REG, seconds);

	DS12887_BitModify(REGISTER_B, SET, 0);		// 'SET' bit 0-ba

	// ez a trkk azrt kell, mert az 'UIE' bit ha 1-ben van, akkor 0-ba megy,
	// miutn a 'SET' bitet belltottuk 1-be
	// csak akkor lehet az 'UIE' bitet visszalltani, ha a 'SET' bit
	// 0-ban van
	if (temp & UIE)
		DS12887_BitModify(REGISTER_B, AIE | UIE, AIE | UIE);
	else
		DS12887_BitModify(REGISTER_B, AIE, AIE);		// 'AIE' bit 1-be
}

/*
 * DisableRTCAlarm
 */
void DisableRTCAlarm(void)
{
	DS12887_BitModify(REGISTER_B, AIE, ~AIE);		// 'AIE' bit 0-ba
}

/*
 * DS12887_BitModify
 * ahol a mask bitjei 1-ben vannak, ott a data bitjei rvnyeslnek,
 * ahol a mask bitjei 0-ban vannak, ott maradnak az eredeti bitek
 */
static void DS12887_BitModify(BYTE addr, BYTE mask, BYTE data)
{
	BYTE temp;

	data &= mask;
	temp = byteRead(addr);
	temp &= ~mask;
	temp |= data;
	byteWrite(addr, temp);
}

/*
 * DS12887_INT_handler, fprogrambl !
 */
void DS12887_INT_handler(void)
{
	BYTE regC;

	regC = byteRead(REGISTER_C);
	if (regC & UF) {
		DS12887_t date;

		getDate(&date);
		rtc_Hours = date.Hours;
		rtc_Minutes = date.Minutes;
		rtc_Seconds = date.Seconds;
		RTCStatus.RTC_SEC = 1;
	}

	if (regC & AF) {
		RTCStatus.RTC_ALARM = 1;
	}
}
