#ifndef _DRV_DS12887_H_
#define _DRV_DS12887_H_

#include "delay.h"
#include "types.h"

#define T_ASD					dly100n	// min. 20 ns
#define T_ASL					dly100n	// min. 30 ns
#define PW_ASH				dly100n	// min. 60 ns
#define T_AHL					dly100n	// min. 10 ns, muxed address hold time
#define T_ASED				dly100n	// min. 40 ns
#define PW_EL					dly200n	// min. 150 ns
#define T_DSW					dly200n	// min. 100 ns, data setup time
#define PW_EH					dly200n	// min. 125 ns
#define T_DHW					0		// 0 ns, write-data hold time
#define T_CS					dly100n	// min. 20 ns
#define T_CH					0		// 0 ns, chip-select hold time
#define T_DDR					dly200n	// max. 120 ns
#define T_DHR					dly100n	// max. 80 ns

/*
 * DS12887 regiszterei
 */
#define	SECONDS_REG				0	// 0..59

/* "don't care" alarm code = 0b11XXXXXX */
#define	SECONDS_ALARM_REG		1	// 0..59
#define	MINUTES_REG				2	// 0..59

/* "don't care" alarm code = 0b11XXXXXX */
#define	MINUTES_ALARM_REG		3	// 0..59
#define	HOURS_REG				4	// 1..12, vagy 0..23

/* "don't care" alarm code = 0b11XXXXXX */
#define	HOURS_ALARM_REG		5	// 1..12, vagy 0..23

#define	DAY_OF_THE_WEEK_REG	6	// 1..7, 1 - vasrnap
#define	DAY_OF_THE_MONTH_REG	7	// 1..31
#define	MONTH_REG				8	// 1..12
#define	YEAR_REG					9	// 0..99
#define	REGISTER_A			0x0A
#define	REGISTER_B			0x0B
#define	REGISTER_C			0x0C
#define	REGISTER_D			0x0D

/*
 * REGISTER_A
 */
#define	UIP		BIT(7)	// Update-In-Progress, ha 1, akkor tart egy idfrisstsi ciklus

// oszcilltor vezrl bitek, '010' bersa utn 500 msec mlva indul a frissts
#define	DV2		BIT(6)
#define	DV1		BIT(5)
#define	DV0		BIT(4)

#define	RS3		BIT(3)
#define	RS2		BIT(2)
#define	RS1		BIT(1)
#define	RS0		BIT(0)

/*
 * REGISTER_B
 */
// 0 - msodpercenknt frisst, 1 - letiltja a frisstst, ekkor lehet inicializlni
// illetve olvasni, miutn az UIP bit is 0-ba vonult
#define SET		BIT(7)

#define PIE		BIT(6)	// periodic interrupt enable
#define AIE		BIT(5)	// alarm interrupt enable
#define UIE		BIT(4)	// update-ended interrupt enable
#define SQWE	BIT(3)
#define DM		BIT(2)	// 1 - binris, 0 - BCD
#define M2412	BIT(1)	// 1 - 24 rs md, 0 - 12 rs md
//#define DSE		BIT(0)	// Daylight Savings Enable, tli-nyri idszmts engedlyezse
#define DSE (1)	// Daylight Savings Enable, tli-nyri idszmts engedlyezse

/*
 * REGISTER_C
 * az sszes IT jelz flag trldik, ha az IRQ alacsony szintje mellett
 * olvassuk a REGISTER_C-t
 */
#define	IRQF	BIT(7)
#define	PF		BIT(6)
#define	AF		BIT(5)
#define	UF		BIT(4)

/*
 * REGISTER_D
 */
#define	VRT		BIT(7)	// Valid RAM and Time, 1 = minden j, 0 - valszn lemerlt az elem

typedef struct DS12887 {
	BYTE Year;
	BYTE Month;
	BYTE Day_of_the_Month;
	BYTE Day_of_the_Week;
	BYTE Hours;
	BYTE Minutes;
	BYTE Seconds;
} DS12887_t;

struct RTCStatus {
	unsigned RTC_IRQ_REQUEST:1;
	unsigned RTC_SEC:1;
	unsigned RTC_ALARM:1;
};

extern struct RTCStatus RTCStatus;
extern int rtc_Hours;
extern int rtc_Minutes;
extern int rtc_Seconds;

void DS12887_INT_handler(void);
BYTE batteryCheck(void);
void DS12887_Init(void);
void setDate(DS12887_t *date);
void getDate(DS12887_t *date);
void SetRTCAlarm(BYTE hours, BYTE minutes, BYTE seconds);
void DisableRTCAlarm(void);

#endif
