
; CC5X Version 3.2, Copyright (c) B Knudsen Data
; C compiler for the PICmicro family
; ************  22. Aug 2004  18:26  *************

	processor  16F877
	radix  DEC

INDF        EQU   0x00
TMR0        EQU   0x01
PCL         EQU   0x02
STATUS      EQU   0x03
FSR         EQU   0x04
PORTB       EQU   0x06
TRISB       EQU   0x86
PCLATH      EQU   0x0A
PA0         EQU   3
Carry       EQU   0
Zero_       EQU   2
RP0         EQU   5
RP1         EQU   6
IRP         EQU   7
GIE         EQU   7
OPTION_REG  EQU   0x81
PORTD       EQU   0x08
TXREG       EQU   0x19
RCREG       EQU   0x1A
TRISC       EQU   0x87
TRISD       EQU   0x88
TRISE       EQU   0x89
SPBRG       EQU   0x99
ADCON1      EQU   0x9F
EEDATA      EQU   0x10C
EEADR       EQU   0x10D
EEADRH      EQU   0x10F
EECON2      EQU   0x18D
PEIE        EQU   6
RCIF        EQU   5
CREN        EQU   4
SPEN        EQU   7
RCIE        EQU   5
TRMT        EQU   1
BRGH        EQU   2
SYNC        EQU   4
TXEN        EQU   5
CSRC        EQU   7
RD          EQU   0
WR          EQU   1
WREN        EQU   2
EEPGD       EQU   7
wpointer    EQU   0x45
rpointer    EQU   0x46
flag        EQU   0x47
sv_FSR      EQU   0x48
s1_save     EQU   0x70
s2          EQU   0x20
s3          EQU   0x21
caractere_2 EQU   0x33
caractere_3 EQU   0x22
newwp       EQU   0x23
caractere_4 EQU   0x7F
text        EQU   0x7F
i           EQU   0x7F
valeur      EQU   0x7F
i_2         EQU   0x7F
C1cnt       EQU   0x7F
C2tmp       EQU   0x7F
C3rem       EQU   0x7F
C4cnt       EQU   0x7F
C5tmp       EQU   0x7F
C6cnt       EQU   0x7F
C7tmp       EQU   0x7F
C8rem       EQU   0x7F
C9cnt       EQU   0x7F
C10tmp      EQU   0x7F
time        EQU   0x24
i_3         EQU   0x25
adresse     EQU   0x7F
octet       EQU   0x7F
oldGIE      EQU   0x7F
adresse_2   EQU   0x33
IOW         EQU   6
IOR         EQU   5
RESET       EQU   7
temporary   EQU   0x4A
my_ip       EQU   0x57
source_ip   EQU   0x5B
dest_ip     EQU   0x5F
version     EQU   0x63
IP_length   EQU   0x64
identification EQU   0x66
fragment    EQU   0x68
IP_protocol EQU   0x6A
hdr_len     EQU   0x6B
opt_len     EQU   0x6C
chksum      EQU   0x6D
icmp_type   EQU   0x6F
icmp_code   EQU   0x71
icmp_checksum EQU   0x72
icmp_identifier EQU   0x74
icmp_sequence EQU   0x76
source_port EQU   0x78
dest_port   EQU   0x7A
UDP_length  EQU   0x7C
ip          EQU   0xA0
tcp_source_port EQU   0xA4
tcp_dest_port EQU   0xA6
seq         EQU   0xA8
ack         EQU   0xAC
offset      EQU   0xB0
tcp_options EQU   0xB1
flags       EQU   0xB2
window      EQU   0xB3
max_seg     EQU   0xB5
tcp_data_len EQU   0xB7
html_socket EQU   0xB9
xm_ack      EQU   0x143
xm_seq      EQU   0x147
port        EQU   0x14B
adresse_3   EQU   0x11E
donnee      EQU   0x11F
address     EQU   0x11E
data_2      EQU   0x11F
prev_chksum EQU   0x121
adresse_4   EQU   0x112
donnee_2    EQU   0x113
i_4         EQU   0x110
w           EQU   0
address_2   EQU   0x119
ignore      EQU   0x110
i_5         EQU   0x111
i_6         EQU   0x116
adresse_5   EQU   0x117
IP_packet_length EQU   0x116
IP_send_protocol EQU   0x118
i_7         EQU   0x119
prev_chksum_2 EQU   0x11A
temp        EQU   0x11C
len         EQU   0x116
i_8         EQU   0x110
prev_chksum_3 EQU   0x110
i_9         EQU   0x112
j           EQU   0x113
valeur_2    EQU   0x114
adresse_6   EQU   0x24
in          EQU   0x26
out         EQU   0x27
i_10        EQU   0x28
status      EQU   0x29
next_ptr    EQU   0x2A
type        EQU   0x2B
kind        EQU   0x2D
data_flags  EQU   0x33
tcp_chksum  EQU   0x35
tcp_length  EQU   0x37
prev_chksum_4 EQU   0x39
i_12        EQU   0x2F
j_2         EQU   0x30
j_3         EQU   0x30
cpt         EQU   0x31
i_14        EQU   0x2F
j_4         EQU   0x30
compteur    EQU   0x190
octet_2     EQU   0x192
ci          EQU   0x7F

	ORG 0x0003
	GOTO main

  ; FILE interrupt.c
			;
			;#pragma origin 4
	ORG 0x0004

  ; FILE interrupt.c
			;#include "int16CXX.h"
			;
			;extern void rxint(void);
			;
			;interrupt int_server(void)
			;{
int_server
			;int_save_registers
	MOVWF s1_save
	SWAPF STATUS,W
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF s2
	MOVF  PCLATH,W
	MOVWF s3
	CLRF  PCLATH
			;sv_FSR=FSR;
	MOVF  FSR,W
	MOVWF sv_FSR
			;rxint();
	CALL  rxint
			;FSR=sv_FSR;
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  sv_FSR,W
	MOVWF FSR
			;int_restore_registers
	MOVF  s3,W
	MOVWF PCLATH
	SWAPF s2,W
	MOVWF STATUS
	SWAPF s1_save,1
	SWAPF s1_save,W
			;}
	RETFIE

  ; FILE uart.c
			;
			;
			;void printf(char caractere)	    // criture d'un caractere dans l'UART
			;{
_const1
	MOVWF ci
	CLRF  PCLATH
	MOVF  ci,W
	ANDLW .3
	ADDWF PCL,1
	RETLW .10
	RETLW .13
	RETLW .0
	RETLW .0
printf
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF caractere_2
			;while (!TRMT)			    // registre de transmission vide ?
m001	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSS 0x98,TRMT
			;      ;
	GOTO  m001
			;TXREG=caractere;		    // oui alors envoi du caractere
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  caractere_2,W
	MOVWF TXREG
			;
			;}
	RETURN
			;
			;void rxint(void)
			;{
rxint
			;char caractere;
			;char newwp;
			;
			;if (RCIF)
	BCF   0x03,RP0
	BCF   0x03,RP1
	BTFSS 0x0C,RCIF
	GOTO  m005
			;   {
			;     RCIF=0;
	BCF   0x0C,RCIF
			;     caractere=RCREG;
	MOVF  RCREG,W
	MOVWF caractere_3
			;     if (wpointer!=9)
	MOVF  wpointer,W
	XORLW .9
	BTFSC 0x03,Zero_
	GOTO  m002
			;	newwp=wpointer+1;
	INCF  wpointer,W
	MOVWF newwp
			;     else
	GOTO  m003
			;	newwp=1;
m002	MOVLW .1
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF newwp
			;
			;     if (rpointer!=newwp)
m003	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  rpointer,W
	XORWF newwp,W
	BTFSC 0x03,Zero_
	GOTO  m004
			;	ligne[wpointer++]=caractere;
	MOVLW .59
	ADDWF wpointer,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  caractere_3,W
	MOVWF INDF
	INCF  wpointer,1
			;
			;     if (wpointer==10)
m004	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  wpointer,W
	XORLW .10
	BTFSS 0x03,Zero_
	GOTO  m005
			;	 wpointer=1;
	MOVLW .1
	MOVWF wpointer
			;   }
			;}
m005	RETURN
			;
			;char getch()
			;{
getch
			;char caractere;
			;
			;if (wpointer!=rpointer)
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  wpointer,W
	XORWF rpointer,W
	BTFSC 0x03,Zero_
	GOTO  m007
			;    {
			;    caractere=ligne[rpointer++];
	MOVLW .59
	ADDWF rpointer,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	MOVWF caractere_4
	INCF  rpointer,1
			;    if (rpointer==30)
	MOVF  rpointer,W
	XORLW .30
	BTFSS 0x03,Zero_
	GOTO  m006
			;	rpointer=1;
	MOVLW .1
	MOVWF rpointer
			;    flag=1;
m006	MOVLW .1
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF flag
			;    }
			;    else
	GOTO  m008
			;    {	 flag=0;
m007	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  flag
			;    }
			;return(caractere);
m008	MOVF  caractere_4,W
	RETURN
			;}
			;
			;void setupUART(void)
			;{
setupUART
			;#asm
			;bsf STATUS,RP0
	BSF   0x03,RP0
			;bcf STATUS,RP1
	BCF   0x03,RP1
			;bsf TXSTA,BRGH
	BSF   0x98,BRGH
			;bsf TXSTA,CSRC
	BSF   0x98,CSRC
			;movlw d'77'		   ; 77 = 9600 bauds  12 Mhz
	MOVLW .77
			;movwf SPBRG		   ; 25 = 9600 bauds  4 Mhz
	MOVWF SPBRG
			;bcf TXSTA,SYNC
	BCF   0x98,SYNC
			;bsf TXSTA,TXEN
	BSF   0x98,TXEN
			;bsf PIE1,RCIE
	BSF   0x8C,RCIE
			;bcf STATUS,RP0
	BCF   0x03,RP0
			;bsf RCSTA,CREN
	BSF   0x18,CREN
			;bsf RCSTA,SPEN
	BSF   0x18,SPEN
			;bsf INTCON,PEIE
	BSF   0x0B,PEIE
			;#endasm
			;wpointer=1;
	MOVLW .1
	MOVWF wpointer
			;rpointer=1;
	MOVLW .1
	MOVWF rpointer
			;}
	RETURN
			;
			;
			;
			;void print_str(const char* text)    // criture d'une chaine de caractre
			;{
print_str
			;char i=0;
	CLRF  i
			;while ( text[i] != 0 ) 
m009	MOVF  i,W
	ADDWF text,W
	CALL  _const1
	XORLW .0
	BTFSC 0x03,Zero_
	GOTO  m010
			;    printf( text[i++] );
	MOVF  i,W
	ADDWF text,W
	CALL  _const1
	CALL  printf
	INCF  i,1
	GOTO  m009
			;}
m010	RETURN
			;
			;void print_dec(char valeur)
			;{
print_dec
	MOVWF valeur
			;  char i;
			;  
			;  i=valeur/100;
	MOVF  valeur,W
	MOVWF C2tmp
	CLRF  C3rem
	MOVLW .8
	MOVWF C1cnt
m011	RLF   C2tmp,1
	RLF   C3rem,1
	MOVLW .100
	SUBWF C3rem,W
	BTFSS 0x03,Carry
	GOTO  m012
	MOVLW .100
	SUBWF C3rem,1
	BSF   0x03,Carry
m012	RLF   i_2,1
	DECFSZ C1cnt,1
	GOTO  m011
			;  printf(i+48);
	MOVLW .48
	ADDWF i_2,W
	CALL  printf
			;  valeur=valeur%100;
	MOVF  valeur,W
	MOVWF C5tmp
	CLRF  valeur
	MOVLW .8
	MOVWF C4cnt
m013	RLF   C5tmp,1
	RLF   valeur,1
	MOVLW .100
	SUBWF valeur,W
	BTFSS 0x03,Carry
	GOTO  m014
	MOVLW .100
	SUBWF valeur,1
m014	DECFSZ C4cnt,1
	GOTO  m013
			;  i=valeur/10;
	MOVF  valeur,W
	MOVWF C7tmp
	CLRF  C8rem
	MOVLW .8
	MOVWF C6cnt
m015	RLF   C7tmp,1
	RLF   C8rem,1
	MOVLW .10
	SUBWF C8rem,W
	BTFSS 0x03,Carry
	GOTO  m016
	MOVLW .10
	SUBWF C8rem,1
	BSF   0x03,Carry
m016	RLF   i_2,1
	DECFSZ C6cnt,1
	GOTO  m015
			;  printf(i+48);
	MOVLW .48
	ADDWF i_2,W
	CALL  printf
			;  i=valeur%10;
	MOVF  valeur,W
	MOVWF C10tmp
	CLRF  i_2
	MOVLW .8
	MOVWF C9cnt
m017	RLF   C10tmp,1
	RLF   i_2,1
	MOVLW .10
	SUBWF i_2,W
	BTFSS 0x03,Carry
	GOTO  m018
	MOVLW .10
	SUBWF i_2,1
m018	DECFSZ C9cnt,1
	GOTO  m017
			;  printf(i+48);
	MOVLW .48
	ADDWF i_2,W
	CALL  printf
			;  print_str("\n\r");
	CLRF  text
	GOTO  print_str
			;}  

  ; FILE timer.c
			;// routine de traitement des interruptions du timer 0
			;
			;void setupTMR0(void)
			;{
setupTMR0
			; OPTION=0x07;                // diviseur du timer 0 = 256 -> 85,3 S par debordement
	MOVLW .7
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF OPTION_REG
			; TMR0=0;
	BCF   0x03,RP0
	CLRF  TMR0
			;}
	RETURN
			;
			;void delay(char time)
			;{
delay
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF time
			;char i;
			;
			;  for (i=1;i<=time;i++)
	MOVLW .1
	MOVWF i_3
m019	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  i_3,W
	SUBWF time,W
	BTFSS 0x03,Carry
	GOTO  m021
			;           {
			;            TMR0=245;
	MOVLW .245
	MOVWF TMR0
			;            while (TMR0>0) ;
m020	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  TMR0,W
	BTFSS 0x03,Zero_
	GOTO  m020
			;           }
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_3,1
	GOTO  m019
			;}
m021	RETURN

  ; FILE flash.c
			;// bibliotheque de lecture/ecriture en mmoire FLASH
			;// JEAN-PIERRE MANDON
			;
			;
			;
			;void writeFLASH(uns16 adresse,char octet)
			;{
writeFLASH
	MOVWF octet
			;char adresseH,adresseL;
			;char oldGIE;
			;
			;EEADRH=adresse.high8;                   // extrait les 8 bits de poids fort de l'adresse et les place dans EEADRH
	MOVF  adresse+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF EEADRH
			;EEADR=adresse.low8;                     // extrait les 8 bits de poids faible de l'adresse et les place dans EEADR
	MOVF  adresse,W
	MOVWF EEADR
			;EEDATA=octet;                           // place la valeur  crire dans le registre interne EEDATA
	MOVF  octet,W
	MOVWF EEDATA
			;EEPGD=1;                                // bit 7 du registre EECON1
	BSF   0x03,RP0
	BSF   0x18C,EEPGD
			;WREN=1;                                 // bit 2 du registre EECON1
	BSF   0x18C,WREN
			;if (GIE==1) oldGIE=1;
	BTFSS 0x0B,GIE
	GOTO  m022
	MOVLW .1
	MOVWF oldGIE
			;else        oldGIE=0;                   // sauvegarde de la valeur de GIE pour restituer le mme contexte en sortie
	GOTO  m023
m022	CLRF  oldGIE
			;GIE=0;                                  // devalider les interruptions
m023	BCF   0x0B,GIE
			;EECON2=0x55;                            // ces 2 valeurs doivent tre crites dans
	MOVLW .85
	BSF   0x03,RP0
	BSF   0x03,RP1
	MOVWF EECON2
			;EECON2=0xAA;                            // EECON2 pour valider l'criture dans la FLASH ( MICROCHIP )
	MOVLW .170
	MOVWF EECON2
			;WR=1;                                   // bit 1 du registre EECON1
	BSF   0x18C,WR
			;nop();                                  //
	NOP  
			;nop();                                  //
	NOP  
			;if (oldGIE==1) GIE=1;                   // restitution du contexte d'interruptions d'entre de la fonction
	DECF  oldGIE,W
	BTFSC 0x03,Zero_
	BSF   0x0B,GIE
			;WR=0;                                   // bit 1 du registre EECON1
	BSF   0x03,RP0
	BSF   0x03,RP1
	BCF   0x18C,WR
			;}
	RETURN
			;
			;char readFLASH(uns16 adresse)
			;{
readFLASH
			;char adresseH,adresseL;
			;char oldGIE;
			;
			;EEADRH=adresse.high8;                   // extrait les 8 bits de poids fort de l'adresse et les place dans EEADRH
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  adresse_2+1,W
	BSF   0x03,RP1
	MOVWF EEADRH
			;EEADR=adresse.low8;                     // extrait les 8 bits de poids faible de l'adresse et les place dans EEADR
	BCF   0x03,RP1
	MOVF  adresse_2,W
	BSF   0x03,RP1
	MOVWF EEADR
			;EEPGD=1;                                // bit 7 du registre EECON1
	BSF   0x03,RP0
	BSF   0x18C,EEPGD
			;RD=1;                                   // bit 0 du registre EECON1
	BSF   0x18C,RD
			;nop();
	NOP  
			;nop();
	NOP  
			;return EEDATA;                          // la valeur pointe par ADRESSE est dans EEDATA
	BCF   0x03,RP0
	MOVF  EEDATA,W
	RETURN

  ; FILE picoip.c
			;// systeme IP  base de PIC16F877 et carte reseau ISA
			;// AUTEUR
			;// Jean-Pierre Mandon 2003
			;// VERSION
			;// version 1.0.2 du 20 juin 2003
			;// initialisations de la carte reseau
			;// gestion du protocole ARP  ( resolution d'dresses )
			;// gestion du protocole ICMP ( Protocole de controle des messages internet )
			;//                      - rponse  un PING ( demande d'echo )
			;// gestion du protocole UDP - uniquement dans le sens PC -> carte
			;// gestion du protocole TCP avec serveur HTTP
			;// CREDIT
			;// crit avec CC5X Free version 4k
			;// CC5X est une marque de B.KNUDSEN DATA
			;// PERFORMANCE
			;// temps de rponse sur un ping en rseau domestique 5 millisecondes
			;// EXTENSIONS ENVISAGEES
			;// intgration de page web en flash ( ralisation d'un utilitaire delphi 4 )
			;// SUIVI DES VERSIONS
			;// 1er juin 2003 - version Beta    - init carte rseau, ARP, ICMP
			;// 7 juin 2003   - version 1.0.0   - UDP et test avec les composants delphi de F.Piette
			;//                                   Sortie des trames UDP sur le port srie du PIC
			;// 9 juin 2003   - version 1.0.1   - correction d'un bug sur le calcul du CRC des trames IP
			;// 20 juin 2003  - version 1.0.2   - gestion d'une connexion TCP
			;//                                 - test HTTP avec une ligne en HTML
			;
			;
			;
			;#pragma chip PIC16F877
			;#include "define.h"
			;#include "interrupt.c"
			;#include "uart.c"
			;#include "timer.c"
			;#include "flash.c"
			;#pragma config WDTE=off, FOSC=HS
			;#pragma bit IOW @ PORTD.6
			;#pragma bit IOR @ PORTD.5
			;#pragma bit RESET @ PORTD.7
			;
			;#define READ  0
			;#define WRITE 1
			;// NIC Page 0 read register assignments
			;
			;#define CR	0x00						// Command
			;#define CLDA0	0x01						// Current Local DMA Address 0
			;#define CLDA1	0x02						// Current Local DMA Address 1
			;#define BNDRY	0x03						// Boundary Pointer
			;#define TSR	0x04						// Transmit Status Register
			;#define NCR	0x05						// Number of Collisions Register
			;#define FIFO	0x06						// FIFO
			;#define ISR	0x07						// Interupt Status Register
			;#define CRDA0	0x08						// Current Remote DMA Address 0
			;#define CRDA1	0x09						// Current Remote DMA Address 1
			;#define RES1	0x0A						// Reserved
			;#define RES2	0x0B						// Reserved
			;#define	RSR	0x0C						// Receive Status Register
			;#define CNTR0	0x0D						// Tally Counter 0 (Frame Alignment Errors)
			;#define CNTR1	0x0E						// Tally Counter 1 (CRC Errors)
			;#define CNTR2	0x0F						// Tally Counter 2 (Missed Packet Errors)
			;
			;// NIC Page 0 write register assignments
			;
			;#define PSTART	0x01						// Page Start Register
			;#define PSTOP	0x02						// Page Stop Register
			;#define	TPSR	0x04						// Transmit Page Start Address
			;#define	TBCR0	0x05						// Transmit Byte Count Register 0
			;#define TBCR1	0x06						// Transmit Byte Count Register 1
			;#define RSAR0	0x08						// Remote Start Address Register 0
			;#define RSAR1	0x09						// Remote Start Address Register 1
			;#define RBCR0	0x0A						// Remote Byte Count Register 0
			;#define RBCR1	0x0B						// Remote Byte Count Register 1
			;#define RCR	0x0C						// Receive Configuration Register
			;#define TCR	0x0D						// Transmit Configuration Register
			;#define DCR	0x0E						// Data Configuration Register
			;#define IMR	0x0F						// Interrupt Mask Register
			;
			;// NIC Page 1 register assignments
			;
			;#define PAR0	0x01						// Physical Address Register 0
			;#define PAR1	0x02						// Physical Address Register 1
			;#define PAR2	0x03						// Physical Address Register 2
			;#define PAR3	0x04						// Physical Address Register 3
			;#define PAR4	0x05						// Physical Address Register 4
			;#define PAR5	0x06						// Physical Address Register 5
			;#define CURR	0x07						// Current Page Register
			;#define MAR0	0x08						// Multicast Address Register 0
			;#define MAR1	0x09						// Multicast Address Register 1
			;#define MAR2	0x0A						// Multicast Address Register 2
			;#define MAR3	0x0B						// Multicast Address Register 3
			;#define MAR4	0x0C						// Multicast Address Register 4
			;#define MAR5	0x0D						// Multicast Address Register 5
			;#define MAR6	0x0E						// Multicast Address Register 6
			;#define MAR7	0x0F						// Multicast Address Register 7
			;
			;
			;// NIC Other registers
			;
			;#define NIC_DATA	0x10					// Data Register for I/O port mode
			;#define	NIC_RESET	0x18					// Reset Register
			;
			;// NIC Other Defines
			;			                                        // 8-bit mode - wasting ram but saving I/O count
			;#define RCV_BUF_START	0x40				        // Room for three full ethernet packets
			;#define XMT_BUF_START	0x54				        // Leave room for two full packet transmit buffers
			;
			;// protocoles de communication
			;
			;#define	ARP  0x06
			;#define IP   0x00
			;#define	ICMP 0x01
			;#define UDP  0x17
			;#define TCP  0x06
			;
			;#define TCP_FIN	0x01
			;#define TCP_SYN 0x02
			;#define TCP_RST	0x04
			;#define TCP_PSH 0x08
			;#define TCP_ACK 0x10
			;#define TCP_URG 0x20
			;
			;#define LISTEN      0
			;#define SYN_SENT    1
			;#define SYN_RCVD    2
			;#define ESTAB       3
			;#define FIN_WAIT_1  4
			;#define FIN_WAIT_2  5
			;#define CLOSING     6
			;#define TIME_WAIT   7
			;#define CLOSE_WAIT  8
			;#define LAST_ACK    9
			;#define CLOSED      10
			;
			;#define ECHO  0x08
			;#define REPLY 0x00
			;
			;
			;#pragma rambank 0
			;
			;uns8 temporary ;
			;uns8 physical_address[6];
			;uns8 source_address[6];
			;uns8 my_ip[4];
			;uns8 source_ip[4];
			;uns8 dest_ip[4];
			;uns8 version;
			;uns16 IP_length;
			;uns16 identification;
			;uns16 fragment;
			;uns8 IP_protocol;
			;uns8 hdr_len;
			;uns8 opt_len;
			;uns16 chksum;
			;uns8 icmp_type;
			;uns8 icmp_code;
			;uns16 icmp_checksum;
			;uns16 icmp_identifier;
			;uns16 icmp_sequence;
			;
			;// variables utilises pour UDP
			;
			;uns16 source_port;                         // port source
			;uns16 dest_port;                           // port destination
			;uns16 UDP_length;                          // longueur de la trame UDP
			;
			;
			;
			;
			;#pragma rambank 1
			;
			;uns8    ip[4];
			;
			;// variables utilises pour TCP
			;
			;uns16 tcp_source_port;
			;uns16 tcp_dest_port;
			;uns16 seq[2];
			;uns16 ack[2];
			;uns8 offset;
			;uns8 tcp_options;
			;uns8 flags;
			;uns16 window;
			;uns16 max_seg;
			;uns16 tcp_data_len;
			;uns8 html_socket;
			;
			;#pragma rambank 2
			;
			;uns8 data[32];
			;uns16	xm_ack[2];
			;uns16   xm_seq[2];
			;uns16   port;
			;
			;
			;void tcp_listen(void);
			;void tcp_syn_rcvd(void);
			;void tcp_estab(void);
			;void tcp_response(void);
			;void tcp_end(void);
			;
			;void init_pic(void)
			;{
init_pic
			;ADCON1=0x06;
	MOVLW .6
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF ADCON1
			;TRISC=0x80;
	MOVLW .128
	MOVWF TRISC
			;TRISE=0x00;
	CLRF  TRISE
			;TRISB=0xFF;
	MOVLW .255
	MOVWF TRISB
			;TRISD=0x00;
	CLRF  TRISD
			;PORTD=0;
	BCF   0x03,RP0
	CLRF  PORTD
			;setupUART();
	CALL  setupUART
			;setupTMR0();
	CALL  setupTMR0
			;IOW=1;
	BCF   0x03,RP0
	BCF   0x03,RP1
	BSF   0x08,IOW
			;IOR=1;
	BSF   0x08,IOR
			;RESET=0;
	BCF   0x08,RESET
			;delay(25);
	MOVLW .25
	CALL  delay
			;PORTD=PORTD&0xE0;
	MOVLW .224
	BCF   0x03,RP0
	BCF   0x03,RP1
	ANDWF PORTD,1
			;}
	RETURN
			;
			;void outport(uns8 adresse,uns8 donnee)
			;{
outport
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF donnee
			;  PORTD=PORTD^adresse;
	MOVF  adresse_3,W
	BCF   0x03,RP1
	XORWF PORTD,1
			;  TRISB=0;
	BSF   0x03,RP0
	CLRF  TRISB
			;  PORTB=donnee;
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  donnee,W
	BCF   0x03,RP1
	MOVWF PORTB
			;  IOW=0;
	BCF   0x08,IOW
			;  IOW=1;
	BSF   0x08,IOW
			;  TRISB=0xFF;
	MOVLW .255
	BSF   0x03,RP0
	MOVWF TRISB
			;  PORTD=PORTD&0xE0;
	MOVLW .224
	BCF   0x03,RP0
	ANDWF PORTD,1
			;}
	RETURN
			;
			;void outportw(uns8 address, uns16 data)
			;{
outportw
			; uns16 prev_chksum;
			;
			; prev_chksum = chksum;
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum+1
			; PORTD = PORTD^address;
	MOVF  address,W
	BCF   0x03,RP1
	XORWF PORTD,1
			; TRISB=0;
	BSF   0x03,RP0
	CLRF  TRISB
			; PORTB=data.high8;
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  data_2+1,W
	BCF   0x03,RP1
	MOVWF PORTB
			; IOW=0;
	BCF   0x08,IOW
			; IOW=1;
	BSF   0x08,IOW
			; nop();
	NOP  
			; nop();
	NOP  
			; PORTB=data.low8;
	BSF   0x03,RP1
	MOVF  data_2,W
	BCF   0x03,RP1
	MOVWF PORTB
			; IOW=0;
	BCF   0x08,IOW
			; IOW=1;
	BSF   0x08,IOW
			; TRISB=0xFF;
	MOVLW .255
	BSF   0x03,RP0
	MOVWF TRISB
			; PORTD=PORTD&0xE0;
	MOVLW .224
	BCF   0x03,RP0
	ANDWF PORTD,1
			; chksum += data;
	BSF   0x03,RP1
	MOVF  data_2+1,W
	BCF   0x03,RP1
	ADDWF chksum+1,1
	BSF   0x03,RP1
	MOVF  data_2,W
	BCF   0x03,RP1
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum < prev_chksum ) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m024
	BTFSS 0x03,Zero_
	GOTO  m025
	BSF   0x03,RP1
	MOVF  prev_chksum,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m025
m024	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;}
m025	RETURN
			;
			;
			;uns8 inport(uns8 adresse)
			;{
inport
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_4
			;  uns8 donnee;
			;
			;  PORTD=PORTD^adresse;
	MOVF  adresse_4,W
	BCF   0x03,RP1
	XORWF PORTD,1
			;  IOR=0;
	BCF   0x08,IOR
			;  donnee=PORTB;
	MOVF  PORTB,W
	BSF   0x03,RP1
	MOVWF donnee_2
			;  IOR=1;
	BCF   0x03,RP1
	BSF   0x08,IOR
			;  PORTD=PORTD&0xE0;
	MOVLW .224
	ANDWF PORTD,1
			;  return(donnee);
	BSF   0x03,RP1
	MOVF  donnee_2,W
	RETURN
			;}
			;
			;void init_carte(void)
			;{
init_carte
			;   uns8 i;
			;
			;   outport(CR, 0x21);			// arrt de la carte rseau
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .33
	CALL  outport
			;                                        // arrt du DMA
			;                                        // selection de la page 0 des registres
			;   delay(25);			        // attendre l'arrt de la carte
	MOVLW .25
	CALL  delay
			;   outport(NIC_RESET, 0xFF);		// Reset the NIC
	MOVLW .24
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .255
	CALL  outport
			;   delay(25);		                // Wait for it to reset
	MOVLW .25
	CALL  delay
			;
			;   outport(DCR, 0x48);			// mode de fonctionnement 8 bits
	MOVLW .14
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .72
	CALL  outport
			;			                // Fonctionnement normal ( pas loopback )
			;			                // FIFO 8 octets
			;   outport(RBCR0, 0x00);		// effacement des registres compteurs
	MOVLW .10
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			;   outport(RBCR1, 0x00);
	MOVLW .11
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			;
			;   outport(RCR, 0x0C);			// accepter le broadcast et le multicast
	MOVLW .12
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .12
	CALL  outport
			;                                        // rejeter les paquets avec erreurs
			;                                        // sauver les paquets en mmoire
			;                                        // accepter tous les paquets
			;   outport(TCR, 0x02);			// placer la carte en mode boucle en mission
	MOVLW .13
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .2
	CALL  outport
			;
			;   outport(BNDRY, RCV_BUF_START);	// pointeur de adresse courante du buffer
	MOVLW .3
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .64
	CALL  outport
			;   outport(PSTART, RCV_BUF_START);	// pointeur de dbut du Buffer
	MOVLW .1
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .64
	CALL  outport
			;   outport(PSTOP, XMT_BUF_START);	// pointeur de fin du buffer
	MOVLW .2
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .84
	CALL  outport
			;
			;
			;   outport(ISR, 0xFF);			// effacement du registre d'tat des interruptions
	MOVLW .7
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .255
	CALL  outport
			;   outport(IMR, 0x00);			// pas d'interruptions
	MOVLW .15
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			;
			;   outport(CR, 0x61);			// selectionner la page 1 de registres
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .97
	CALL  outport
			;
			;   for (i=0;i<6;i++)
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_4
m026	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_4,W
	BTFSC 0x03,Carry
	GOTO  m027
			;       outport(PAR0+i,physical_address[i]); // fixer une adresse physique ( n'importe laquelle )
	INCF  i_4,W
	MOVWF adresse_3
	MOVLW .75
	ADDWF i_4,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	CALL  outport
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_4,1
	GOTO  m026
			;
			;   outport(CURR, RCV_BUF_START);        // le pointeur doit tre initialis avec la mme valeur que PSTART
m027	MOVLW .7
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .64
	CALL  outport
			;
			;   outport(CR, 0x22);			// la carte rseau est mise en marche
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .34
	GOTO  outport
			;			                // ( on est toujours en mode boucle )
			;}
			;
			;void remote_dma_setup(bit w, uns16 address)
			;{
remote_dma_setup
			;   outport(CR, 0x22);						// Abort Remote DMA
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .34
	CALL  outport
			;   outport(RBCR0, 0xFF);					// Set maximum number of bytes to read/write
	MOVLW .10
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .255
	CALL  outport
			;   outport(RBCR1, 0xFF);
	MOVLW .11
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .255
	CALL  outport
			;   outport(RSAR0, address.low8);
	MOVLW .8
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVF  address_2,W
	CALL  outport
			;   outport(RSAR1, address.high8);
	MOVLW .9
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVF  address_2+1,W
	CALL  outport
			;   if (w) outport(CR, 0x12);
	BCF   0x03,RP0
	BSF   0x03,RP1
	BTFSS 0x11B,w
	GOTO  m028
	CLRF  adresse_3
	MOVLW .18
	CALL  outport
			;   else outport(CR, 0x0A);
	GOTO  m029
m028	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .10
	GOTO  outport
			;}
m029	RETURN
			;
			;void read_phy_addr(void)
			;{
read_phy_addr
			;   uns8 ignore,i;
			;
			;   remote_dma_setup(0, 0x0000);
	BCF   0x03,RP0
	BSF   0x03,RP1
	BCF   0x11B,w
	CLRF  address_2
	CLRF  address_2+1
	CALL  remote_dma_setup
			;   for (i=0;i<6;i++)
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_5
m030	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_5,W
	BTFSC 0x03,Carry
	GOTO  m031
			;       {
			;         ignore=inport(NIC_DATA);
	MOVLW .16
	CALL  inport
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF ignore
			;         physical_address[i]=ignore;
	MOVLW .75
	ADDWF i_5,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  ignore,W
	MOVWF INDF
			;         ignore=inport(NIC_DATA);
	MOVLW .16
	CALL  inport
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF ignore
			;       }
	INCF  i_5,1
	GOTO  m030
			;}
m031	RETURN
			;
			;void load_ethernet_header(void)
			;{
load_ethernet_header
			; uns8 i;
			; uns16 adresse = 0 ;
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_5
	CLRF  adresse_5+1
			; adresse.high8 = XMT_BUF_START ;
	MOVLW .84
	MOVWF adresse_5+1
			; remote_dma_setup(WRITE,adresse);
	BSF   0x11B,w
	MOVF  adresse_5,W
	MOVWF address_2
	MOVF  adresse_5+1,W
	MOVWF address_2+1
	CALL  remote_dma_setup
			; for(i=0 ; i<6 ; i++) {
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_6
m032	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_6,W
	BTFSC 0x03,Carry
	GOTO  m033
			;        temporary = source_address[i];
	MOVLW .81
	ADDWF i_6,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;        outport(NIC_DATA,temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;        }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_6,1
	GOTO  m032
			; for(i=0 ; i<6 ; i++) {
m033	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_6
m034	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_6,W
	BTFSC 0x03,Carry
	GOTO  m035
			;        temporary = physical_address[i] ;
	MOVLW .75
	ADDWF i_6,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;        outport(NIC_DATA,temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;        }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_6,1
	GOTO  m034
			;}
m035	RETURN
			;
			;void load_IP_header(uns16 IP_packet_length, uns8 IP_send_protocol)
			;{
load_IP_header
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF IP_send_protocol
			; uns8 i;
			; uns16 prev_chksum;
			; uns16 temp ;
			;
			; outport(NIC_DATA, 0x08 );
	MOVLW .16
	MOVWF adresse_3
	MOVLW .8
	CALL  outport
			; outport(NIC_DATA, IP);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			; chksum = 0;
	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  chksum
	CLRF  chksum+1
			; outportw(NIC_DATA, 0x4500);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF address
	CLRF  data_2
	MOVLW .69
	MOVWF data_2+1
	CALL  outportw
			; outportw(NIC_DATA, IP_packet_length);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  IP_packet_length,W
	MOVWF data_2
	MOVF  IP_packet_length+1,W
	MOVWF data_2+1
	CALL  outportw
			; outportw(NIC_DATA, identification);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	BCF   0x03,RP1
	MOVF  identification,W
	BSF   0x03,RP1
	MOVWF data_2
	BCF   0x03,RP1
	MOVF  identification+1,W
	BSF   0x03,RP1
	MOVWF data_2+1
	CALL  outportw
			; outportw(NIC_DATA, 0x0000);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	CLRF  data_2
	CLRF  data_2+1
	CALL  outportw
			; temp = 0x8000 + IP_send_protocol ;              // Time to live
	MOVLW .128
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF temp+1
	MOVF  IP_send_protocol,W
	MOVWF temp
			; outportw(NIC_DATA,temp );
	MOVLW .16
	MOVWF address
	MOVF  temp,W
	MOVWF data_2
	MOVF  temp+1,W
	MOVWF data_2+1
	CALL  outportw
			; prev_chksum=chksum;                             // correction du 9 juin 2003
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2+1
			; chksum.high8 += my_ip[0] ;
	BCF   0x03,RP1
	MOVF  my_ip,W
	ADDWF chksum+1,1
			; chksum += my_ip[1] ;
	MOVF  my_ip+1,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum < prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_2+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m036
	BTFSS 0x03,Zero_
	GOTO  m037
	BSF   0x03,RP1
	MOVF  prev_chksum_2,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m037
m036	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; prev_chksum = chksum;
m037	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2+1
			; chksum.high8 += my_ip[2] ;
	BCF   0x03,RP1
	MOVF  my_ip+2,W
	ADDWF chksum+1,1
			; chksum += my_ip[3] ;
	MOVF  my_ip+3,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum < prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_2+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m038
	BTFSS 0x03,Zero_
	GOTO  m039
	BSF   0x03,RP1
	MOVF  prev_chksum_2,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m039
m038	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; prev_chksum = chksum;
m039	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2+1
			; chksum.high8 += source_ip[0] ;
	BCF   0x03,RP1
	MOVF  source_ip,W
	ADDWF chksum+1,1
			; chksum += source_ip[1] ;
	MOVF  source_ip+1,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum < prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_2+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m040
	BTFSS 0x03,Zero_
	GOTO  m041
	BSF   0x03,RP1
	MOVF  prev_chksum_2,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m041
m040	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; prev_chksum = chksum;
m041	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_2+1
			; chksum.high8 += source_ip[2] ;
	BCF   0x03,RP1
	MOVF  source_ip+2,W
	ADDWF chksum+1,1
			; chksum += source_ip[3] ;
	MOVF  source_ip+3,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum < prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_2+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m042
	BTFSS 0x03,Zero_
	GOTO  m043
	BSF   0x03,RP1
	MOVF  prev_chksum_2,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m043
m042	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; chksum = 0xFFFF - chksum ;
m043	BCF   0x03,RP0
	BCF   0x03,RP1
	COMF  chksum+1,1
	COMF  chksum,1
			; outportw(NIC_DATA, chksum);          // complement  1 de chksum
	MOVLW .16
	BSF   0x03,RP1
	MOVWF address
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF data_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF data_2+1
	CALL  outportw
			; for (i=0 ; i<4 ; i++) {
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_7
m044	MOVLW .4
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_7,W
	BTFSC 0x03,Carry
	GOTO  m045
			;          temporary = my_ip[i] ;
	MOVLW .87
	ADDWF i_7,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;          outport(NIC_DATA,temporary );
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;          }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_7,1
	GOTO  m044
			; for (i=0 ; i<4 ; i++) {
m045	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_7
m046	MOVLW .4
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_7,W
	BTFSC 0x03,Carry
	GOTO  m047
			;          temporary = source_ip[i] ;
	MOVLW .91
	ADDWF i_7,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;          outport(NIC_DATA,temporary );
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;          }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_7,1
	GOTO  m046
			;}
m047	RETURN
			;
			;void send_packet(long int len)
			;{
send_packet
			; outport(CR, 0x22);
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .34
	CALL  outport
			; outport(TBCR0, len.low8 );
	MOVLW .5
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVF  len,W
	CALL  outport
			; outport(TBCR1, len.high8 );
	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVF  len+1,W
	CALL  outport
			; outport(TPSR, XMT_BUF_START);
	MOVLW .4
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .84
	CALL  outport
			; outport(CR, 0x26);
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .38
	GOTO  outport
			;}
			;
			;void arp_reponse(void)
			;{
arp_reponse
			; uns8 i ;
			; load_ethernet_header();          // entte ethernet ( MAC expediteur et destinataire )
	CALL  load_ethernet_header
			; outport(NIC_DATA,0x08);          // poids fort type de paquet
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .8
	CALL  outport
			; outport(NIC_DATA,ARP);           // poids faible type de paquet
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .6
	CALL  outport
			; outport(NIC_DATA, 0x00);         // poids fort type de trame ( ethernet )
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			; outport(NIC_DATA, 0x01);         // poids faible type de trame
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .1
	CALL  outport
			; outport(NIC_DATA, 0x08);         // poids fort type de protocole ( IP )
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .8
	CALL  outport
			; outport(NIC_DATA, 0x00);         // poids faible type de protocole
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			; outport(NIC_DATA, 0x06);         // longueur de l'adresse MAC
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .6
	CALL  outport
			; outport(NIC_DATA, 0x04);         // longueur du descripteur de protocole
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .4
	CALL  outport
			; outport(NIC_DATA, 0x00);         // reponse ARP
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			; outport(NIC_DATA, 0x02);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .2
	CALL  outport
			; for (i=0 ; i<6 ; i++) {          // adresse MAC expediteur
	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_8
m048	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_8,W
	BTFSC 0x03,Carry
	GOTO  m049
			;                temporary = physical_address[i] ;
	MOVLW .75
	ADDWF i_8,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;		outport(NIC_DATA,temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;	        }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_8,1
	GOTO  m048
			; for (i=0 ; i<4 ; i++) {          // adresse IP de l'expediteur
m049	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_8
m050	MOVLW .4
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_8,W
	BTFSC 0x03,Carry
	GOTO  m051
			;                temporary = my_ip[i] ;
	MOVLW .87
	ADDWF i_8,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;		outport(NIC_DATA, temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;		}
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_8,1
	GOTO  m050
			; for (i=0 ; i<6 ; i++) {          // adresse MAC du destinataire
m051	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_8
m052	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_8,W
	BTFSC 0x03,Carry
	GOTO  m053
			;                temporary = source_address[i] ;
	MOVLW .81
	ADDWF i_8,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;		outport(NIC_DATA,temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;		}
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_8,1
	GOTO  m052
			; for (i=0 ; i<4 ; i++) {
m053	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_8
m054	MOVLW .4
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_8,W
	BTFSC 0x03,Carry
	GOTO  m055
			;                temporary = source_ip[i] ;
	MOVLW .91
	ADDWF i_8,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	BCF   0x03,RP1
	MOVWF temporary
			;		outport(NIC_DATA,temporary);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  temporary,W
	CALL  outport
			;	        }
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_8,1
	GOTO  m054
			; for (i=0 ; i<18 ;i++) outport(NIC_DATA, 0x00); // completer le paquet pour aller  46 octets
m055	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  i_8
m056	MOVLW .18
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_8,W
	BTFSC 0x03,Carry
	GOTO  m057
	MOVLW .16
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_8,1
	GOTO  m056
			; send_packet(60);
m057	MOVLW .60
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF len
	CLRF  len+1
	GOTO  send_packet
			;}
			;
			;void ping_reponse()
			;{
ping_reponse
			; uns16 prev_chksum;
			; uns8 i,j;
			; uns16 valeur;
			;
			; load_ethernet_header();                 // entte ethernet ( adresses MAC )
	CALL  load_ethernet_header
			; load_IP_header(60,ICMP);                // entte IP
	MOVLW .60
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF IP_packet_length
	CLRF  IP_packet_length+1
	MOVLW .1
	CALL  load_IP_header
			; chksum=0;
	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  chksum
	CLRF  chksum+1
			; valeur.high8=0;
	BSF   0x03,RP1
	CLRF  valeur_2+1
			; valeur.low8=icmp_code;                  // type + code ICMP
	MOVF  icmp_code,W
	MOVWF valeur_2
			; outportw(NIC_DATA, valeur);
	MOVLW .16
	MOVWF address
	MOVF  valeur_2,W
	MOVWF data_2
	MOVF  valeur_2+1,W
	MOVWF data_2+1
	CALL  outportw
			; chksum += valeur ;                      // calcul du checksum de la trame ICMP
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  valeur_2+1,W
	BCF   0x03,RP1
	ADDWF chksum+1,1
	BSF   0x03,RP1
	MOVF  valeur_2,W
	BCF   0x03,RP1
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; prev_chksum=chksum;
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3+1
			; chksum += icmp_identifier;
	MOVF  icmp_identifier+1,W
	BCF   0x03,RP1
	ADDWF chksum+1,1
	MOVF  icmp_identifier,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum<prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_3+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m058
	BTFSS 0x03,Zero_
	GOTO  m059
	BSF   0x03,RP1
	MOVF  prev_chksum_3,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m059
m058	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; prev_chksum=chksum;
m059	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3+1
			; chksum += icmp_sequence;
	MOVF  icmp_sequence+1,W
	BCF   0x03,RP1
	ADDWF chksum+1,1
	MOVF  icmp_sequence,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			; if (chksum<prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_3+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m060
	BTFSS 0x03,Zero_
	GOTO  m061
	BSF   0x03,RP1
	MOVF  prev_chksum_3,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m061
m060	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			; prev_chksum=chksum;
m061	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3+1
			; for (i=0;i<16;i++)                      // les donne reues avec la demande d'echo
	CLRF  i_9
m062	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_9,W
	BTFSC 0x03,Carry
	GOTO  m065
			;     {                                   // entrent dans le calcul du checksum
			;     j=i*2;                              // de la trame ICMP
	BCF   0x03,Carry
	RLF   i_9,W
	MOVWF j
			;     j++;
	INCF  j,1
			;     valeur=data[j]*256;
	MOVLW .35
	ADDWF j,W
	MOVWF FSR
	BSF   0x03,IRP
	MOVF  INDF,W
	MOVWF valeur_2+1
	CLRF  valeur_2
			;     valeur+=data[j+1];
	MOVLW .36
	ADDWF j,W
	MOVWF FSR
	BSF   0x03,IRP
	MOVF  INDF,W
	ADDWF valeur_2,1
	BTFSC 0x03,Carry
	INCF  valeur_2+1,1
			;     chksum+=valeur;
	MOVF  valeur_2+1,W
	BCF   0x03,RP1
	ADDWF chksum+1,1
	BSF   0x03,RP1
	MOVF  valeur_2,W
	BCF   0x03,RP1
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;     if (chksum<prev_chksum) chksum++;
	BSF   0x03,RP1
	MOVF  prev_chksum_3+1,W
	BCF   0x03,RP1
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m063
	BTFSS 0x03,Zero_
	GOTO  m064
	BSF   0x03,RP1
	MOVF  prev_chksum_3,W
	BCF   0x03,RP1
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m064
m063	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;     prev_chksum=chksum;
m064	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF prev_chksum_3+1
			;     }
	INCF  i_9,1
	GOTO  m062
			; chksum = 0xFFFF - chksum ;
m065	BCF   0x03,RP0
	BCF   0x03,RP1
	COMF  chksum+1,1
	COMF  chksum,1
			; outportw(NIC_DATA, chksum);             // le checksum est en 3eme position de la tame ICMP
	MOVLW .16
	BSF   0x03,RP1
	MOVWF address
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF data_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF data_2+1
	CALL  outportw
			; outportw(NIC_DATA, icmp_identifier);    // identificateur ICMP
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  icmp_identifier,W
	MOVWF data_2
	MOVF  icmp_identifier+1,W
	MOVWF data_2+1
	CALL  outportw
			; outportw(NIC_DATA, icmp_sequence);      // N de sequence ICMP
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  icmp_sequence,W
	MOVWF data_2
	MOVF  icmp_sequence+1,W
	MOVWF data_2+1
	CALL  outportw
			; for (i=1;i<33;i++)
	MOVLW .1
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF i_9
m066	MOVLW .33
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF i_9,W
	BTFSC 0x03,Carry
	GOTO  m067
			;     {
			;     outport(NIC_DATA,data[i]); }        // donne de la trame de demande d'echo
	MOVLW .16
	MOVWF adresse_3
	MOVLW .35
	ADDWF i_9,W
	MOVWF FSR
	BSF   0x03,IRP
	MOVF  INDF,W
	CALL  outport
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  i_9,1
	GOTO  m066
			; send_packet(74);                        // envoi du paquet
m067	MOVLW .74
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF len
	CLRF  len+1
	GOTO  send_packet
			;}
			;
			;#pragma codepage 1
	ORG 0x0800
			;
			;void poll_nic(void)                      // test de la carte reseau
			;{
poll_nic
			; #pragma rambank 0
			; long int adresse = 0 ;
	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  adresse_6
	CLRF  adresse_6+1
			; uns8 in, out;
			; uns8 i;
			; uns8 status, next_ptr;
			; uns16 type;
			; uns8 kind;
			;
			; outport(CR, 0x62);			// Page 1
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .98
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			; in = inport(CURR);			// pointeur lecture
	MOVLW .7
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF in
			; outport(CR, 0x22);			// Page 0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .34
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			; out = inport(BNDRY);			// pointeur ecriture
	MOVLW .3
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF out
			; if (in!=out)
	MOVF  in,W
	XORWF out,W
	BTFSC 0x03,Zero_
	GOTO  m105
			;    {
			;    adresse.high8 = out ;
	MOVF  out,W
	MOVWF adresse_6+1
			;    remote_dma_setup(READ, adresse );
	BSF   0x03,RP1
	BCF   0x11B,w
	BCF   0x03,RP1
	MOVF  adresse_6,W
	BSF   0x03,RP1
	MOVWF address_2
	BCF   0x03,RP1
	MOVF  adresse_6+1,W
	BSF   0x03,RP1
	MOVWF address_2+1
	BCF   0x0A,PA0
	CALL  remote_dma_setup
	BSF   0x0A,PA0
			;    status = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF status
			;    next_ptr = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF next_ptr
			;    for (i=0 ; i<8 ; i++) inport(NIC_DATA);
	CLRF  i_10
m068	MOVLW .8
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m069
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m068
			;    for (i=0 ; i<6 ; i++) {
m069	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m070	MOVLW .6
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m071
			;        temporary = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;        source_address[i] = temporary ;
	MOVLW .81
	ADDWF i_10,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;        }
	INCF  i_10,1
	GOTO  m070
			;    type.high8 = inport(NIC_DATA);
m071	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF type+1
			;    type.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF type
			;    if (type.high8==0x08)         // le poids fort des type est tjrs gal  0x08
	MOVF  type+1,W
	XORLW .8
	BTFSS 0x03,Zero_
	GOTO  m104
			;    switch (type.low8) {
	MOVF  type,W
	XORLW .6
	BTFSC 0x03,Zero_
	GOTO  m072
	XORLW .6
	BTFSC 0x03,Zero_
	GOTO  m083
	XORLW .23
	BTFSC 0x03,Zero_
	GOTO  m101
	GOTO  m104
			;
			;           case ARP: // print_str("ARP");
			;                     // printf(10); printf(13);
			;                     for (i=0; i<8 ; i++) inport(NIC_DATA);
m072	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m073	MOVLW .8
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m074
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m073
			;                     for (i=0; i<6 ; i++) inport(NIC_DATA);
m074	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m075	MOVLW .6
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m076
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m075
			;                     for (i=0; i<4 ; i++) {
m076	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m077	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m078
			;                         temporary =  inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                         source_ip[i] = temporary ;
	MOVLW .91
	ADDWF i_10,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;                         }
	INCF  i_10,1
	GOTO  m077
			;                     for (i=0; i<6 ; i++) inport(NIC_DATA);
m078	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m079	MOVLW .6
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m080
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m079
			;                     for (i=0; i<4 ; i++) {
m080	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m081	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m082
			;                         temporary = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                         dest_ip[i] =  temporary ;
	MOVLW .95
	ADDWF i_10,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;                         }
	INCF  i_10,1
	GOTO  m081
			;                     if (dest_ip[0] == my_ip[0] && dest_ip[1] == my_ip[1] &&
m082	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  dest_ip,W
	XORWF my_ip,W
	BTFSS 0x03,Zero_
	GOTO  m104
	MOVF  dest_ip+1,W
	XORWF my_ip+1,W
	BTFSS 0x03,Zero_
	GOTO  m104
			;			dest_ip[2] == my_ip[2] && dest_ip[3] == my_ip[3])
	MOVF  dest_ip+2,W
	XORWF my_ip+2,W
	BTFSS 0x03,Zero_
	GOTO  m104
	MOVF  dest_ip+3,W
	XORWF my_ip+3,W
	BTFSS 0x03,Zero_
	GOTO  m104
			;			           arp_reponse();
	BCF   0x0A,PA0
	CALL  arp_reponse
	BSF   0x0A,PA0
			;                     break;
	GOTO  m104
			;
			;           case IP:  // print_str("IP");                     // pour le debugage
			;                     // printf(10); printf(13);
			;                     version = inport(NIC_DATA);             // version et IHL
m083	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF version
			;		     hdr_len = (version & 0x0F) << 2;        // 4 bits de poids faible x 4
	MOVLW .15
	ANDWF version,W
	MOVWF hdr_len
	BCF   0x03,Carry
	RLF   hdr_len,1
	BCF   0x03,Carry
	RLF   hdr_len,1
			;		     opt_len = hdr_len - 20;                 // longueur des options
	MOVLW .20
	SUBWF hdr_len,W
	MOVWF opt_len
			;		     version = version >> 4 ;                // version = 4 bits de poids fort
	SWAPF version,W
	ANDLW .15
	MOVWF version
			;		     inport(NIC_DATA);                       // type de service
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;		     IP_length.high8 = inport(NIC_DATA) ;    // longueur du paquet PF
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF IP_length+1
			;		     IP_length.low8 = inport(NIC_DATA) ;     // longueur du paquet pf
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF IP_length
			;		     identification.high8 = inport(NIC_DATA);// numrotation des fragments
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF identification+1
			;                     identification.low8 = inport(NIC_DATA); // poids faible
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF identification
			;                     fragment.high8 = inport(NIC_DATA);      // offset des fragments PF
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF fragment+1
			;                     fragment.low8 = inport(NIC_DATA);       // pffset des fragments pf
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF fragment
			;                     inport(NIC_DATA);                       // TTL dure de vie de la trame
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;                     IP_protocol = inport(NIC_DATA);         // protocole IP
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF IP_protocol
			;                     chksum.high8 = inport(NIC_DATA);        // cheksum de l'entte PF
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF chksum+1
			;                     chksum.low8 = inport(NIC_DATA);         // cheksum de l'entte poids fort
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF chksum
			;                     for (i=0; i<4 ; i++) {                  // adresse IP source
	CLRF  i_10
m084	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m085
			;                               temporary = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;			       source_ip[i] = temporary ;
	MOVLW .91
	ADDWF i_10,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;			       }
	INCF  i_10,1
	GOTO  m084
			;		     for (i=0; i<4 ; i++) {                  // adresse IP cible
m085	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m086	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m087
			;                               temporary = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;			       dest_ip[i] = temporary ;
	MOVLW .95
	ADDWF i_10,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;			       }
	INCF  i_10,1
	GOTO  m086
			;		     for (i=0; i<opt_len ; i++) inport(NIC_DATA); // remplissage
m087	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m088	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  opt_len,W
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m089
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m088
			;                     switch (IP_protocol) {
m089	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  IP_protocol,W
	XORLW .1
	BTFSC 0x03,Zero_
	GOTO  m090
	XORLW .7
	BTFSC 0x03,Zero_
	GOTO  m093
	GOTO  m101
			;
			;                        case ICMP: // print_str("ICMP");          // debugage
			;                                   icmp_type = inport(NIC_DATA);  // type (08=echo request)
m090	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF icmp_type
			;                                   if (icmp_type == ECHO) {       // echo request
	MOVF  icmp_type,W
	XORLW .8
	BTFSS 0x03,Zero_
	GOTO  m101
			;                                          icmp_code = inport(NIC_DATA);  // informations sup
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_code
			;                                          icmp_checksum.high8 = inport(NIC_DATA); // PF
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_checksum+1
			;                                          icmp_checksum.low8 = inport(NIC_DATA);  // pf
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_checksum
			;                                          icmp_identifier.high8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_identifier+1
			;                                          icmp_identifier.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_identifier
			;                                          icmp_sequence.high8 = inport(NIC_DATA);// N sequence
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_sequence+1
			;                                          icmp_sequence.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF icmp_sequence
			;                                          for (i=1;i<33;i++)
	MOVLW .1
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF i_10
m091	MOVLW .33
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m092
			;                                              {
			;                                              temporary=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                                              data[i]=temporary;
	MOVLW .35
	ADDWF i_10,W
	MOVWF FSR
	BSF   0x03,IRP
	MOVF  temporary,W
	MOVWF INDF
			;                                              }
	INCF  i_10,1
	GOTO  m091
			;                                          ping_reponse();
m092	BCF   0x0A,PA0
	CALL  ping_reponse
	BSF   0x0A,PA0
			;                                          }
			;                                   break;
	GOTO  m101
			;
			;                        case TCP:  // print_str("TCP");            // debogage
			;				   tcp_source_port.high8 = inport(NIC_DATA); // port source
m093	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF tcp_source_port+1
			;				   tcp_source_port.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF tcp_source_port
			;				   tcp_dest_port.high8 = inport(NIC_DATA);   // port destination
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF tcp_dest_port+1
			;				   tcp_dest_port.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF tcp_dest_port
			;				   if (tcp_dest_port != 80) break;
	MOVF  tcp_dest_port,W
	XORLW .80
	BTFSS 0x03,Zero_
	GOTO  m101
	MOVF  tcp_dest_port+1,1
	BTFSS 0x03,Zero_
	GOTO  m101
			;				   seq[0].high8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF seq+1
			;				   seq[0].low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF seq
			;				   seq[1].high8 =inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF seq+3
			;				   seq[1].low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF seq+2
			;				   ack[0].high8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF ack+1
			;				   ack[0].low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF ack
			;				   ack[1].high8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF ack+3
			;				   ack[1].low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF ack+2
			;				   offset=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF offset
			;                                   offset &= 0xF0;                 // longueur en tte TCP
	MOVLW .240
	ANDWF offset,1
			;                                   offset = offset >> 2;           // en bloc de 32 bits
	BCF   0x03,Carry
	RRF   offset,1
	BCF   0x03,Carry
	RRF   offset,1
			;				   tcp_options = (offset - 20);    // longueur de l'option
	MOVLW .20
	SUBWF offset,W
	MOVWF tcp_options
			;				   flags = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF flags
			;                                   flags &= 0x3F;                  // on ne garde que les 6 bits
	MOVLW .63
	ANDWF flags,1
			;				   if ((flags & TCP_SYN) == TCP_SYN) max_seg=0;
	MOVLW .2
	ANDWF flags,W
	XORLW .2
	BTFSS 0x03,Zero_
	GOTO  m094
	CLRF  max_seg
	CLRF  max_seg+1
			;				   window.high8 = inport(NIC_DATA);// taille de la fenetre
m094	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF window+1
			;				   window.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF window
			;				   inport(NIC_DATA);               // CRC
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;				   inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;				   inport(NIC_DATA);               // pointeur urgent
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;				   inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;				   for (i=0 ; i < tcp_options ; i++)
	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  i_10
m095	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_options,W
	BCF   0x03,RP0
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m100
			;                                       {
			;					kind = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF kind
			;					switch (kind) {
	MOVF  kind,W
	XORLW .2
	BTFSC 0x03,Zero_
	GOTO  m096
	XORLW .2
	BTFSC 0x03,Zero_
	GOTO  m099
	XORLW .1
	BTFSC 0x03,Zero_
	GOTO  m099
	GOTO  m099
			;						case 2:
			;						        inport(NIC_DATA);
m096	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;							if ((flags & TCP_SYN) == TCP_SYN)
	MOVLW .2
	BSF   0x03,RP0
	BCF   0x03,RP1
	ANDWF flags,W
	XORLW .2
	BTFSS 0x03,Zero_
	GOTO  m097
			;                                                           {
			;							   max_seg.high8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF max_seg+1
			;							   max_seg.low8 = inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF max_seg
			;							   } else
	GOTO  m098
			;                                                           {
			;							   inport(NIC_DATA);
m097	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;							   inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
			;							   }
			;							   i=i+3;
m098	MOVLW .3
	BCF   0x03,RP0
	BCF   0x03,RP1
	ADDWF i_10,1
			;						case 0:
			;						case 1:
			;						      }
			;				        }
m099	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m095
			;
			;				   tcp_response();
m100	CALL  tcp_response
			;
			;				   break;
			;                                   }
			;           case UDP: // print_str("UDP");          // debogage
			;                     // printf(10); printf(13);
			;                     source_port.high8=inport(NIC_DATA);
m101	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF source_port+1
			;                     source_port.low8=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF source_port
			;                     dest_port.high8=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF dest_port+1
			;                     dest_port.low8=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF dest_port
			;                     UDP_length.high8=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF UDP_length+1
			;                     UDP_length.low8=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	MOVWF UDP_length
			;                     if (UDP_length>40) break;                // longueur max de la trame 32 octets
	MOVF  UDP_length+1,W
	BTFSS 0x03,Zero_
	GOTO  m104
	MOVLW .41
	SUBWF UDP_length,W
	BTFSC 0x03,Carry
	GOTO  m104
			;                     temporary=inport(NIC_DATA);              // CRC
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                     temporary=inport(NIC_DATA);
	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                     UDP_length-=8;                           // l'entte UDP  8 octets
	MOVLW .8
	SUBWF UDP_length,1
	BTFSS 0x03,Carry
	DECF  UDP_length+1,1
			;                     for (i=0;i<UDP_length;i++)
	CLRF  i_10
m102	MOVF  UDP_length+1,W
	BTFSS 0x03,Zero_
	GOTO  m103
	MOVF  UDP_length,W
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_10,W
	BTFSC 0x03,Carry
	GOTO  m104
			;                        {
			;                        temporary=inport(NIC_DATA);
m103	MOVLW .16
	BCF   0x0A,PA0
	CALL  inport
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF temporary
			;                        printf(temporary);
	MOVF  temporary,W
	BCF   0x0A,PA0
	CALL  printf
	BSF   0x0A,PA0
			;                        }
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  i_10,1
	GOTO  m102
			;                     break;
			;           }
			;           outport(CR, 0x22);
m104	BCF   0x03,RP0
	BSF   0x03,RP1
	CLRF  adresse_3
	MOVLW .34
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;	   outport(BNDRY, next_ptr);
	MOVLW .3
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  next_ptr,W
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;    }
			;
			;}
m105	RETURN
			;
			;void tcp_response(void)                      // traitement des requtes TCP
			;{
tcp_response
			;
			;uns8 i;
			;
			;switch (html_socket)
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  html_socket,W
	BTFSC 0x03,Zero_
	GOTO  m106
	XORLW .2
	BTFSC 0x03,Zero_
	GOTO  m108
	XORLW .1
	BTFSC 0x03,Zero_
	GOTO  m109
	GOTO  m110
			;       {
			;       case LISTEN:
			;	           if (flags & TCP_SYN)           // si demande de synchro TCP
m106	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSS flags,1
	GOTO  m107
			;                      {
			;	              if (flags & TCP_ACK) {      // et acquit du client
	BTFSC flags,4
			;				           break;
	GOTO  m110
			;				           }
			;	              if (flags & TCP_RST || flags & TCP_FIN) {  // et erreur ou demande de fin
	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSC flags,2
	GOTO  m110
	BTFSC flags,0
			;					   break;
	GOTO  m110
			;					   }
			;
			;
			;	              tcp_listen();               // sinon traitement de demande de synchro
	CALL  tcp_listen
			;	              }
			;                   if ((flags & TCP_FIN)==TCP_FIN) // si demande de fin du client
m107	MOVLW .1
	BSF   0x03,RP0
	BCF   0x03,RP1
	ANDWF flags,W
	XORLW .1
	BTFSS 0x03,Zero_
	GOTO  m110
			;		         {
			;                         tcp_end();
	CALL  tcp_end
			;                         }
			;                   break;
	GOTO  m110
			;
			;        case SYN_RCVD:
			;		   if (port!=tcp_source_port || ip[0]!=source_ip[0] || ip[1]!=source_ip[1] ||
m108	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  port,W
	BSF   0x03,RP0
	BCF   0x03,RP1
	XORWF tcp_source_port,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  port+1,W
	BSF   0x03,RP0
	BCF   0x03,RP1
	XORWF tcp_source_port+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
	MOVF  ip,W
	BCF   0x03,RP0
	XORWF source_ip,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	MOVF  ip+1,W
	BCF   0x03,RP0
	XORWF source_ip+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
			;		   ip[2]!=source_ip[2] || ip[3]!= source_ip[3])
	BSF   0x03,RP0
	MOVF  ip+2,W
	BCF   0x03,RP0
	XORWF source_ip+2,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	MOVF  ip+3,W
	BCF   0x03,RP0
	XORWF source_ip+3,W
	BTFSS 0x03,Zero_
			;		   break;
	GOTO  m110
			;		   if (flags & TCP_ACK)
	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSS flags,4
	GOTO  m110
			;                      {
			;		      if (flags & TCP_SYN) {
	BTFSC flags,1
			;					   break;
	GOTO  m110
			;					   }
			;		      if (flags & TCP_RST || flags & TCP_FIN)
	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSC flags,2
	GOTO  m110
	BTFSC flags,0
			;                                           {
			;					   break;
	GOTO  m110
			;					   }
			;		      tcp_syn_rcvd();
	CALL  tcp_syn_rcvd
			;		      }
			;                   break;
	GOTO  m110
			;	case ESTAB:
			;		   if (flags & TCP_ACK)
m109	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSS flags,4
	GOTO  m110
			;                      {
			;		      if (flags & TCP_SYN) {
	BTFSC flags,1
			;					   break;
	GOTO  m110
			;					   }
			;		      if (flags & TCP_RST ) {
	BSF   0x03,RP0
	BCF   0x03,RP1
	BTFSC flags,2
			;					    break;
	GOTO  m110
			;					    }
			;		      if (seq[0] != xm_ack[0] || seq[1] != xm_ack[1] ||
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_ack,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_ack+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_ack+2,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_ack+3,W
	BTFSS 0x03,Zero_
	GOTO  m110
			;			  ack[0] != xm_seq[0] || ack[1] != xm_seq[1])
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  ack,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_seq,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  ack+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_seq+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  ack+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_seq+2,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  ack+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	XORWF xm_seq+3,W
	BTFSS 0x03,Zero_
			;						break;
	GOTO  m110
			;		      if (port != tcp_source_port) break;
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  port,W
	BSF   0x03,RP0
	BCF   0x03,RP1
	XORWF tcp_source_port,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVF  port+1,W
	BSF   0x03,RP0
	BCF   0x03,RP1
	XORWF tcp_source_port+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
			;		      if (ip[0] != source_ip[0] || ip[1] != source_ip[1] ||
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  ip,W
	BCF   0x03,RP0
	XORWF source_ip,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	MOVF  ip+1,W
	BCF   0x03,RP0
	XORWF source_ip+1,W
	BTFSS 0x03,Zero_
	GOTO  m110
			;			  ip[2] != source_ip[2] || ip[3] != source_ip[3])
	BSF   0x03,RP0
	MOVF  ip+2,W
	BCF   0x03,RP0
	XORWF source_ip+2,W
	BTFSS 0x03,Zero_
	GOTO  m110
	BSF   0x03,RP0
	MOVF  ip+3,W
	BCF   0x03,RP0
	XORWF source_ip+3,W
	BTFSC 0x03,Zero_
	GOTO  tcp_estab
			;						break;
			;		      tcp_estab();
			;		      }
			;
			;		}
			;}
m110	RETURN
			;
			;void load_TCP_header(uns16 data_flags, uns16 tcp_chksum, uns16 tcp_length) {
load_TCP_header
			;                                             // prparation de l'entte TCP
			;uns16 prev_chksum;
			;
			;chksum = tcp_chksum;
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_chksum,W
	MOVWF chksum
	MOVF  tcp_chksum+1,W
	MOVWF chksum+1
			;prev_chksum = chksum;
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum.high8 += my_ip[0] ;
	MOVF  my_ip,W
	ADDWF chksum+1,1
			;chksum += my_ip[1];
	MOVF  my_ip+1,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m111
	BTFSS 0x03,Zero_
	GOTO  m112
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m112
m111	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;prev_chksum = chksum;
m112	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum.high8 += my_ip[2] ;
	MOVF  my_ip+2,W
	ADDWF chksum+1,1
			;chksum += my_ip[3];
	MOVF  my_ip+3,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m113
	BTFSS 0x03,Zero_
	GOTO  m114
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m114
m113	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;prev_chksum = chksum;
m114	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum.high8 += source_ip[0] ;
	MOVF  source_ip,W
	ADDWF chksum+1,1
			;chksum += source_ip[1];
	MOVF  source_ip+1,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m115
	BTFSS 0x03,Zero_
	GOTO  m116
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m116
m115	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;prev_chksum = chksum;
m116	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum += source_ip[2] ;
	MOVF  source_ip+2,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;chksum += source_ip[3];
	MOVF  source_ip+3,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m117
	BTFSS 0x03,Zero_
	GOTO  m118
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m118
m117	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;prev_chksum = chksum;
m118	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum += TCP;
	MOVLW .6
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m119
	BTFSS 0x03,Zero_
	GOTO  m120
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m120
m119	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;prev_chksum = chksum;
m120	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  chksum,W
	MOVWF prev_chksum_4
	MOVF  chksum+1,W
	MOVWF prev_chksum_4+1
			;chksum += tcp_length;
	MOVF  tcp_length+1,W
	ADDWF chksum+1,1
	MOVF  tcp_length,W
	ADDWF chksum,1
	BTFSC 0x03,Carry
	INCF  chksum+1,1
			;if (chksum < prev_chksum) chksum++;
	MOVF  prev_chksum_4+1,W
	SUBWF chksum+1,W
	BTFSS 0x03,Carry
	GOTO  m121
	BTFSS 0x03,Zero_
	GOTO  m122
	MOVF  prev_chksum_4,W
	SUBWF chksum,W
	BTFSC 0x03,Carry
	GOTO  m122
m121	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  chksum,1
	BTFSC 0x03,Zero_
	INCF  chksum+1,1
			;outportw(NIC_DATA, tcp_dest_port);
m122	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_dest_port,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF data_2
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_dest_port+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, tcp_source_port);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF data_2
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, xm_seq[0]);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  xm_seq,W
	MOVWF data_2
	MOVF  xm_seq+1,W
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, xm_seq[1]);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  xm_seq+2,W
	MOVWF data_2
	MOVF  xm_seq+3,W
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, xm_ack[0]);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  xm_ack,W
	MOVWF data_2
	MOVF  xm_ack+1,W
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, xm_ack[1]);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVF  xm_ack+2,W
	MOVWF data_2
	MOVF  xm_ack+3,W
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, data_flags);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	BCF   0x03,RP1
	MOVF  data_flags,W
	BSF   0x03,RP1
	MOVWF data_2
	BCF   0x03,RP1
	MOVF  data_flags+1,W
	BSF   0x03,RP1
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, 1460);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	MOVLW .180
	MOVWF data_2
	MOVLW .5
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;chksum=0xFFFF-chksum;
	BCF   0x03,RP0
	BCF   0x03,RP1
	COMF  chksum+1,1
	COMF  chksum,1
			;outportw(NIC_DATA,chksum);
	MOVLW .16
	BSF   0x03,RP1
	MOVWF address
	BCF   0x03,RP1
	MOVF  chksum,W
	BSF   0x03,RP1
	MOVWF data_2
	BCF   0x03,RP1
	MOVF  chksum+1,W
	BSF   0x03,RP1
	MOVWF data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;outportw(NIC_DATA, 0);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF address
	CLRF  data_2
	CLRF  data_2+1
	BCF   0x0A,PA0
	CALL  outportw
	BSF   0x0A,PA0
			;}
	RETURN
			;
			;void tcp_listen(void)                        // demande de synchronisation TCP
			;{
tcp_listen
			;
			;uns8 i,j;
			;
			;xm_ack[0] = seq[0];
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+1
			;xm_ack[1] = seq[1];
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+2
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+3
			;port = tcp_source_port;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF port
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF port+1
			;for (i=0 ; i<4 ; i++) {    j = source_ip[i];
	BCF   0x03,RP1
	CLRF  i_12
m123	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_12,W
	BTFSC 0x03,Carry
	GOTO  m124
	MOVLW .91
	ADDWF i_12,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	MOVWF j_2
			;                           ip[i] = j ;
	MOVLW .160
	ADDWF i_12,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  j_2,W
	MOVWF INDF
			;                           }
	INCF  i_12,1
	GOTO  m123
			;tcp_data_len = IP_length - hdr_len ;
m124	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  IP_length+1,W
	BSF   0x03,RP0
	MOVWF tcp_data_len+1
	BCF   0x03,RP0
	MOVF  hdr_len,W
	SUBWF IP_length,W
	BSF   0x03,RP0
	MOVWF tcp_data_len
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;tcp_data_len -= offset ;
	MOVF  offset,W
	SUBWF tcp_data_len,1
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;xm_ack[1] += tcp_data_len ;
	MOVF  tcp_data_len+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+3,1
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_data_len,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+2,1
	BTFSC 0x03,Carry
	INCF  xm_ack+3,1
			;xm_ack[1] += 1;
	INCF  xm_ack+2,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+3,1
			;if (xm_ack[1] < seq[1] ) xm_ack[0]++;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+3,W
	BTFSS 0x03,Carry
	GOTO  m125
	BTFSS 0x03,Zero_
	GOTO  m126
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+2,W
	BTFSC 0x03,Carry
	GOTO  m126
m125	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_ack,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+1,1
			;xm_seq[1]++;
m126	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_seq+2,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+3,1
			;if (xm_seq[1] == 0) xm_seq[0]++;
	MOVF  xm_seq+2,W
	IORWF xm_seq+3,W
	BTFSS 0x03,Zero_
	GOTO  m127
	INCF  xm_seq,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+1,1
			;load_ethernet_header();
m127	BCF   0x0A,PA0
	CALL  load_ethernet_header
	BSF   0x0A,PA0
			;load_IP_header(48,TCP);										// 20 for IP header
	MOVLW .48
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF IP_packet_length
	CLRF  IP_packet_length+1
	MOVLW .6
	BCF   0x0A,PA0
	CALL  load_IP_header
	BSF   0x0A,PA0
			;load_TCP_header( 0x7000 | TCP_SYN | TCP_ACK, 0x7B8 , 28);
	MOVLW .18
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF data_flags
	MOVLW .112
	MOVWF data_flags+1
	MOVLW .184
	MOVWF tcp_chksum
	MOVLW .7
	MOVWF tcp_chksum+1
	MOVLW .28
	MOVWF tcp_length
	CLRF  tcp_length+1
	CALL  load_TCP_header
			;outport(NIC_DATA,0x02);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .2
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x04);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .4
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x05);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .5
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0xB4);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .180
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x00);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x00);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x00);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;outport(NIC_DATA,0x00);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;send_packet(62);
	MOVLW .62
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF len
	CLRF  len+1
	BCF   0x0A,PA0
	CALL  send_packet
	BSF   0x0A,PA0
			;xm_seq[1]++;
	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_seq+2,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+3,1
			;if (xm_seq[1] == 0) xm_seq[0]++;
	MOVF  xm_seq+2,W
	IORWF xm_seq+3,W
	BTFSS 0x03,Zero_
	GOTO  m128
	INCF  xm_seq,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+1,1
			;html_socket = SYN_RCVD;
m128	MOVLW .2
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF html_socket
			;}
	RETURN
			;
			;void tcp_syn_rcvd(void)                      // la synchronisation TCP est accepte
			;{
tcp_syn_rcvd
			;tcp_data_len = IP_length - hdr_len ;
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  IP_length+1,W
	BSF   0x03,RP0
	MOVWF tcp_data_len+1
	BCF   0x03,RP0
	MOVF  hdr_len,W
	SUBWF IP_length,W
	BSF   0x03,RP0
	MOVWF tcp_data_len
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;tcp_data_len -= offset ;
	MOVF  offset,W
	SUBWF tcp_data_len,1
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;xm_ack[1] += tcp_data_len;
	MOVF  tcp_data_len+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+3,1
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_data_len,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+2,1
	BTFSC 0x03,Carry
	INCF  xm_ack+3,1
			;if (xm_ack[1] < seq[1] ) xm_ack[0]++;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+3,W
	BTFSS 0x03,Carry
	GOTO  m129
	BTFSS 0x03,Zero_
	GOTO  m130
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+2,W
	BTFSC 0x03,Carry
	GOTO  m130
m129	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_ack,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+1,1
			;html_socket = ESTAB;
m130	MOVLW .3
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVWF html_socket
			;}
	RETURN
			;
			;void tcp_estab(void)                         // la connexion TCP est tablie ( requte HTTP )
			;{
tcp_estab
			;uns8 i,j;
			;uns16 cpt;
			;// static const char chaine[44]="<p>Ceci est un serveur TCP/IP mono carte</p>";
			;
			;tcp_data_len = IP_length - hdr_len ;
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  IP_length+1,W
	BSF   0x03,RP0
	MOVWF tcp_data_len+1
	BCF   0x03,RP0
	MOVF  hdr_len,W
	SUBWF IP_length,W
	BSF   0x03,RP0
	MOVWF tcp_data_len
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;tcp_data_len -= offset ;
	MOVF  offset,W
	SUBWF tcp_data_len,1
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;xm_ack[1] += tcp_data_len;
	MOVF  tcp_data_len+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+3,1
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_data_len,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+2,1
	BTFSC 0x03,Carry
	INCF  xm_ack+3,1
			;if (xm_ack[1] < seq[1] ) xm_ack[0]++;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+3,W
	BTFSS 0x03,Carry
	GOTO  m131
	BTFSS 0x03,Zero_
	GOTO  m132
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+2,W
	BTFSC 0x03,Carry
	GOTO  m132
m131	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_ack,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+1,1
			;load_ethernet_header();
m132	BCF   0x0A,PA0
	CALL  load_ethernet_header
	BSF   0x0A,PA0
			;load_IP_header(760,TCP);
	MOVLW .248
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF IP_packet_length
	MOVLW .2
	MOVWF IP_packet_length+1
	MOVLW .6
	BCF   0x0A,PA0
	CALL  load_IP_header
	BSF   0x0A,PA0
			;load_TCP_header( 0x5000 | TCP_ACK | TCP_FIN, 0x98BB, 740);
	MOVLW .17
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF data_flags
	MOVLW .80
	MOVWF data_flags+1
	MOVLW .187
	MOVWF tcp_chksum
	MOVLW .152
	MOVWF tcp_chksum+1
	MOVLW .228
	MOVWF tcp_length
	MOVLW .2
	MOVWF tcp_length+1
	CALL  load_TCP_header
			;for (cpt=0; cpt<720; cpt++)
	BCF   0x03,RP0
	BCF   0x03,RP1
	CLRF  cpt
	CLRF  cpt+1
m133	MOVLW .2
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF cpt+1,W
	BTFSS 0x03,Carry
	GOTO  m134
	BTFSS 0x03,Zero_
	GOTO  m135
	MOVLW .208
	SUBWF cpt,W
	BTFSC 0x03,Carry
	GOTO  m135
			;    {
			;    j=readFLASH(cpt+0x1000);
m134	MOVLW .16
	BCF   0x03,RP0
	BCF   0x03,RP1
	ADDWF cpt+1,W
	MOVWF adresse_2+1
	MOVF  cpt,W
	MOVWF adresse_2
	BCF   0x0A,PA0
	CALL  readFLASH
	BSF   0x0A,PA0
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF j_3
			;    printf(j);
	MOVF  j_3,W
	BCF   0x0A,PA0
	CALL  printf
	BSF   0x0A,PA0
			;    outport(NIC_DATA,j);
	MOVLW .16
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	BCF   0x03,RP1
	MOVF  j_3,W
	BCF   0x0A,PA0
	CALL  outport
	BSF   0x0A,PA0
			;    }
	BCF   0x03,RP0
	BCF   0x03,RP1
	INCF  cpt,1
	BTFSC 0x03,Zero_
	INCF  cpt+1,1
	GOTO  m133
			;xm_ack[1] += 148;
m135	MOVLW .148
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+2,1
	BTFSC 0x03,Carry
	INCF  xm_ack+3,1
			;if (xm_ack[1] < seq[1]) xm_ack[0]++;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+3,W
	BTFSS 0x03,Carry
	GOTO  m136
	BTFSS 0x03,Zero_
	GOTO  m137
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+2,W
	BTFSC 0x03,Carry
	GOTO  m137
m136	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_ack,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+1,1
			;send_packet(774);                  
m137	MOVLW .6
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF len
	MOVLW .3
	MOVWF len+1
	BCF   0x0A,PA0
	CALL  send_packet
	BSF   0x0A,PA0
			;html_socket = LISTEN;
	BSF   0x03,RP0
	BCF   0x03,RP1
	CLRF  html_socket
			;}
	RETURN
			;
			;void tcp_end(void)                           // fin d'une connexion TCP
			;{
tcp_end
			;uns8 i,j;
			;
			;xm_ack[0] = seq[0];
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+1
			;xm_ack[1] = seq[1];
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+2
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF xm_ack+3
			;port = tcp_source_port;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF port
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_source_port+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF port+1
			;for (i=0 ; i<4 ; i++) {    j = source_ip[i];
	BCF   0x03,RP1
	CLRF  i_14
m138	MOVLW .4
	BCF   0x03,RP0
	BCF   0x03,RP1
	SUBWF i_14,W
	BTFSC 0x03,Carry
	GOTO  m139
	MOVLW .91
	ADDWF i_14,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  INDF,W
	MOVWF j_4
			;                           ip[i] = j ;
	MOVLW .160
	ADDWF i_14,W
	MOVWF FSR
	BCF   0x03,IRP
	MOVF  j_4,W
	MOVWF INDF
			;                           }
	INCF  i_14,1
	GOTO  m138
			;tcp_data_len = IP_length - hdr_len ;
m139	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVF  IP_length+1,W
	BSF   0x03,RP0
	MOVWF tcp_data_len+1
	BCF   0x03,RP0
	MOVF  hdr_len,W
	SUBWF IP_length,W
	BSF   0x03,RP0
	MOVWF tcp_data_len
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;tcp_data_len -= offset ;
	MOVF  offset,W
	SUBWF tcp_data_len,1
	BTFSS 0x03,Carry
	DECF  tcp_data_len+1,1
			;xm_ack[1] += tcp_data_len ;
	MOVF  tcp_data_len+1,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+3,1
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  tcp_data_len,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	ADDWF xm_ack+2,1
	BTFSC 0x03,Carry
	INCF  xm_ack+3,1
			;xm_ack[1] += 1;
	INCF  xm_ack+2,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+3,1
			;if (xm_ack[1] < seq[1] ) xm_ack[0]++;
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+3,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+3,W
	BTFSS 0x03,Carry
	GOTO  m140
	BTFSS 0x03,Zero_
	GOTO  m141
	BSF   0x03,RP0
	BCF   0x03,RP1
	MOVF  seq+2,W
	BCF   0x03,RP0
	BSF   0x03,RP1
	SUBWF xm_ack+2,W
	BTFSC 0x03,Carry
	GOTO  m141
m140	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_ack,1
	BTFSC 0x03,Zero_
	INCF  xm_ack+1,1
			;xm_seq[1]++;
m141	BCF   0x03,RP0
	BSF   0x03,RP1
	INCF  xm_seq+2,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+3,1
			;if (xm_seq[1] == 0) xm_seq[0]++;
	MOVF  xm_seq+2,W
	IORWF xm_seq+3,W
	BTFSS 0x03,Zero_
	GOTO  m142
	INCF  xm_seq,1
	BTFSC 0x03,Zero_
	INCF  xm_seq+1,1
			;load_ethernet_header();
m142	BCF   0x0A,PA0
	CALL  load_ethernet_header
	BSF   0x0A,PA0
			;load_IP_header(40,TCP);										// 20 for IP header
	MOVLW .40
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF IP_packet_length
	CLRF  IP_packet_length+1
	MOVLW .6
	BCF   0x0A,PA0
	CALL  load_IP_header
	BSF   0x0A,PA0
			;load_TCP_header( 0x5000 | TCP_ACK, 0x00 , 20); // OK pour finir la connexion
	MOVLW .16
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF data_flags
	MOVLW .80
	MOVWF data_flags+1
	CLRF  tcp_chksum
	CLRF  tcp_chksum+1
	MOVLW .20
	MOVWF tcp_length
	CLRF  tcp_length+1
	CALL  load_TCP_header
			;send_packet(60);
	MOVLW .60
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF len
	CLRF  len+1
	BCF   0x0A,PA0
	CALL  send_packet
	BSF   0x0A,PA0
			;}
	RETURN
			;
			;
			;#pragma codepage 0
	ORG 0x058B
			;
			;void main(void)
			;{
main
			;  #pragma rambank 3
			;  uns16 compteur;
			;  uns8 octet;
			;
			;  max_seg=0;
	BSF   0x03,RP0
	BCF   0x03,RP1
	CLRF  max_seg
	CLRF  max_seg+1
			;  html_socket = LISTEN;
	CLRF  html_socket
			;
			;  my_ip[0]=192;
	MOVLW .192
	BCF   0x03,RP0
	MOVWF my_ip
			;  my_ip[1]=168;
	MOVLW .168
	MOVWF my_ip+1
			;  my_ip[2]=0;
	CLRF  my_ip+2
			;  my_ip[3]=25;
	MOVLW .25
	MOVWF my_ip+3
			;  init_pic();
	CALL  init_pic
			;  init_carte();
	CALL  init_carte
			;  read_phy_addr();
	CALL  read_phy_addr
			;  init_carte();
	CALL  init_carte
			;  outport(TCR,0x00);
	MOVLW .13
	BCF   0x03,RP0
	BSF   0x03,RP1
	MOVWF adresse_3
	MOVLW .0
	CALL  outport
			;  for (compteur=0;compteur<1150;compteur++) {
	BSF   0x03,RP0
	BSF   0x03,RP1
	CLRF  compteur
	CLRF  compteur+1
m143	MOVLW .4
	BSF   0x03,RP0
	BSF   0x03,RP1
	SUBWF compteur+1,W
	BTFSS 0x03,Carry
	GOTO  m144
	BTFSS 0x03,Zero_
	GOTO  m145
	MOVLW .126
	SUBWF compteur,W
	BTFSC 0x03,Carry
	GOTO  m145
			;                                            	octet=readFLASH(compteur+0x1000);
m144	MOVLW .16
	BSF   0x03,RP0
	BSF   0x03,RP1
	ADDWF compteur+1,W
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF adresse_2+1
	BSF   0x03,RP0
	BSF   0x03,RP1
	MOVF  compteur,W
	BCF   0x03,RP0
	BCF   0x03,RP1
	MOVWF adresse_2
	CALL  readFLASH
	BSF   0x03,RP0
	BSF   0x03,RP1
	MOVWF octet_2
			;                                                printf(octet);
	MOVF  octet_2,W
	CALL  printf
			;  }
	BSF   0x03,RP0
	BSF   0x03,RP1
	INCF  compteur,1
	BTFSC 0x03,Zero_
	INCF  compteur+1,1
	GOTO  m143
			;while(1)
			;{
			;  poll_nic();
m145	BSF   0x0A,PA0
	CALL  poll_nic
	BCF   0x0A,PA0
			;}
	GOTO  m145

	ORG 0x0000
	DATA 018AH
	DATA 0000H
	DATA 0000H
	ORG 0x2007
	DATA 0002H
	END


; *** KEY INFO ***

; 0x002F P0   40 word(s)  1 % : rxint
; 0x0004 P0   22 word(s)  1 % : int_server
; 0x0023 P0   12 word(s)  0 % : printf
; 0x0057 P0   29 word(s)  1 % : getch
; 0x0074 P0   18 word(s)  0 % : setupUART
; 0x0086 P0   14 word(s)  0 % : print_str
; 0x001A P0    9 word(s)  0 % : _const1
; 0x0094 P0   76 word(s)  3 % : print_dec
; 0x00E0 P0    7 word(s)  0 % : setupTMR0
; 0x00E7 P0   23 word(s)  1 % : delay
; 0x00FE P0   35 word(s)  1 % : writeFLASH
; 0x0121 P0   17 word(s)  0 % : readFLASH
; 0x0132 P0   26 word(s)  1 % : init_pic
; 0x014C P0   22 word(s)  1 % : outport
; 0x0162 P0   65 word(s)  3 % : outportw
; 0x01A3 P0   17 word(s)  0 % : inport
; 0x01B4 P0  112 word(s)  5 % : init_carte
; 0x0224 P0   43 word(s)  2 % : remote_dma_setup
; 0x024F P0   34 word(s)  1 % : read_phy_addr
; 0x0271 P0   65 word(s)  3 % : load_ethernet_header
; 0x02B2 P0  275 word(s) 13 % : load_IP_header
; 0x03C5 P0   28 word(s)  1 % : send_packet
; 0x03E1 P0  188 word(s)  9 % : arp_reponse
; 0x049D P0  238 word(s) 11 % : ping_reponse
; 0x058B P0   68 word(s)  3 % : main

; 0x0D25 P1  239 word(s) 11 % : tcp_listen
; 0x0E14 P1   56 word(s)  2 % : tcp_syn_rcvd
; 0x0E4C P1  169 word(s)  8 % : tcp_estab
; 0x0B2C P1  203 word(s)  9 % : tcp_response
; 0x0EF5 P1  157 word(s)  7 % : tcp_end
; 0x0800 P1  812 word(s) 39 % : poll_nic
; 0x0BF7 P1  302 word(s) 14 % : load_TCP_header

; RAM usage: 184 bytes (50 local), 184 bytes free
; Maximum call level: 6 (+2 for interrupt)
;  Codepage 0 has 1487 word(s) :  72 %
;  Codepage 1 has 1938 word(s) :  94 %
;  Codepage 2 has    0 word(s) :   0 %
;  Codepage 3 has    0 word(s) :   0 %
; Total of 3425 code words (43 %)
