// bibliotheque de lecture/ecriture en mmoire FLASH
// JEAN-PIERRE MANDON



void writeFLASH(uns16 adresse,char octet)
{
char adresseH,adresseL;
char oldGIE;

EEADRH=adresse.high8;                   // extrait les 8 bits de poids fort de l'adresse et les place dans EEADRH
EEADR=adresse.low8;                     // extrait les 8 bits de poids faible de l'adresse et les place dans EEADR
EEDATA=octet;                           // place la valeur  crire dans le registre interne EEDATA
EEPGD=1;                                // bit 7 du registre EECON1
WREN=1;                                 // bit 2 du registre EECON1
if (GIE==1) oldGIE=1;
else        oldGIE=0;                   // sauvegarde de la valeur de GIE pour restituer le mme contexte en sortie
GIE=0;                                  // devalider les interruptions
EECON2=0x55;                            // ces 2 valeurs doivent tre crites dans
EECON2=0xAA;                            // EECON2 pour valider l'criture dans la FLASH ( MICROCHIP )
WR=1;                                   // bit 1 du registre EECON1
nop();                                  //
nop();                                  //
if (oldGIE==1) GIE=1;                   // restitution du contexte d'interruptions d'entre de la fonction
WR=0;                                   // bit 1 du registre EECON1
}

char readFLASH(uns16 adresse)
{
char adresseH,adresseL;
char oldGIE;

EEADRH=adresse.high8;                   // extrait les 8 bits de poids fort de l'adresse et les place dans EEADRH
EEADR=adresse.low8;                     // extrait les 8 bits de poids faible de l'adresse et les place dans EEADR
EEPGD=1;                                // bit 7 du registre EECON1
RD=1;                                   // bit 0 du registre EECON1
nop();
nop();
return EEDATA;                          // la valeur pointe par ADRESSE est dans EEDATA
}
