// systeme IP  base de PIC16F877 et carte reseau ISA
// AUTEUR
// Jean-Pierre Mandon 2003
// VERSION
// version 1.0.2 du 20 juin 2003
// initialisations de la carte reseau
// gestion du protocole ARP  ( resolution d'dresses )
// gestion du protocole ICMP ( Protocole de controle des messages internet )
//                      - rponse  un PING ( demande d'echo )
// gestion du protocole UDP - uniquement dans le sens PC -> carte
// gestion du protocole TCP avec serveur HTTP
// CREDIT
// crit avec CC5X Free version 4k
// CC5X est une marque de B.KNUDSEN DATA
// PERFORMANCE
// temps de rponse sur un ping en rseau domestique 5 millisecondes
// EXTENSIONS ENVISAGEES
// intgration de page web en flash ( ralisation d'un utilitaire delphi 4 )
// SUIVI DES VERSIONS
// 1er juin 2003 - version Beta    - init carte rseau, ARP, ICMP
// 7 juin 2003   - version 1.0.0   - UDP et test avec les composants delphi de F.Piette
//                                   Sortie des trames UDP sur le port srie du PIC
// 9 juin 2003   - version 1.0.1   - correction d'un bug sur le calcul du CRC des trames IP
// 20 juin 2003  - version 1.0.2   - gestion d'une connexion TCP
//                                 - test HTTP avec une ligne en HTML



#pragma chip PIC16F877
#include "define.h"
#include "interrupt.c"
#include "uart.c"
#include "timer.c"
#include "flash.c"
#pragma config WDTE=off, FOSC=HS
#pragma bit IOW @ PORTD.6
#pragma bit IOR @ PORTD.5
#pragma bit RESET @ PORTD.7

#define READ  0
#define WRITE 1
// NIC Page 0 read register assignments

#define CR	0x00						// Command
#define CLDA0	0x01						// Current Local DMA Address 0
#define CLDA1	0x02						// Current Local DMA Address 1
#define BNDRY	0x03						// Boundary Pointer
#define TSR	0x04						// Transmit Status Register
#define NCR	0x05						// Number of Collisions Register
#define FIFO	0x06						// FIFO
#define ISR	0x07						// Interupt Status Register
#define CRDA0	0x08						// Current Remote DMA Address 0
#define CRDA1	0x09						// Current Remote DMA Address 1
#define RES1	0x0A						// Reserved
#define RES2	0x0B						// Reserved
#define	RSR	0x0C						// Receive Status Register
#define CNTR0	0x0D						// Tally Counter 0 (Frame Alignment Errors)
#define CNTR1	0x0E						// Tally Counter 1 (CRC Errors)
#define CNTR2	0x0F						// Tally Counter 2 (Missed Packet Errors)

// NIC Page 0 write register assignments

#define PSTART	0x01						// Page Start Register
#define PSTOP	0x02						// Page Stop Register
#define	TPSR	0x04						// Transmit Page Start Address
#define	TBCR0	0x05						// Transmit Byte Count Register 0
#define TBCR1	0x06						// Transmit Byte Count Register 1
#define RSAR0	0x08						// Remote Start Address Register 0
#define RSAR1	0x09						// Remote Start Address Register 1
#define RBCR0	0x0A						// Remote Byte Count Register 0
#define RBCR1	0x0B						// Remote Byte Count Register 1
#define RCR	0x0C						// Receive Configuration Register
#define TCR	0x0D						// Transmit Configuration Register
#define DCR	0x0E						// Data Configuration Register
#define IMR	0x0F						// Interrupt Mask Register

// NIC Page 1 register assignments

#define PAR0	0x01						// Physical Address Register 0
#define PAR1	0x02						// Physical Address Register 1
#define PAR2	0x03						// Physical Address Register 2
#define PAR3	0x04						// Physical Address Register 3
#define PAR4	0x05						// Physical Address Register 4
#define PAR5	0x06						// Physical Address Register 5
#define CURR	0x07						// Current Page Register
#define MAR0	0x08						// Multicast Address Register 0
#define MAR1	0x09						// Multicast Address Register 1
#define MAR2	0x0A						// Multicast Address Register 2
#define MAR3	0x0B						// Multicast Address Register 3
#define MAR4	0x0C						// Multicast Address Register 4
#define MAR5	0x0D						// Multicast Address Register 5
#define MAR6	0x0E						// Multicast Address Register 6
#define MAR7	0x0F						// Multicast Address Register 7


// NIC Other registers

#define NIC_DATA	0x10					// Data Register for I/O port mode
#define	NIC_RESET	0x18					// Reset Register

// NIC Other Defines
			                                        // 8-bit mode - wasting ram but saving I/O count
#define RCV_BUF_START	0x40				        // Room for three full ethernet packets
#define XMT_BUF_START	0x54				        // Leave room for two full packet transmit buffers

// protocoles de communication

#define	ARP  0x06
#define IP   0x00
#define	ICMP 0x01
#define UDP  0x17
#define TCP  0x06

#define TCP_FIN	0x01
#define TCP_SYN 0x02
#define TCP_RST	0x04
#define TCP_PSH 0x08
#define TCP_ACK 0x10
#define TCP_URG 0x20

#define LISTEN      0
#define SYN_SENT    1
#define SYN_RCVD    2
#define ESTAB       3
#define FIN_WAIT_1  4
#define FIN_WAIT_2  5
#define CLOSING     6
#define TIME_WAIT   7
#define CLOSE_WAIT  8
#define LAST_ACK    9
#define CLOSED      10

#define ECHO  0x08
#define REPLY 0x00


#pragma rambank 0

uns8 temporary ;
uns8 physical_address[6];
uns8 source_address[6];
uns8 my_ip[4];
uns8 source_ip[4];
uns8 dest_ip[4];
uns8 version;
uns16 IP_length;
uns16 identification;
uns16 fragment;
uns8 IP_protocol;
uns8 hdr_len;
uns8 opt_len;
uns16 chksum;
uns8 icmp_type;
uns8 icmp_code;
uns16 icmp_checksum;
uns16 icmp_identifier;
uns16 icmp_sequence;

// variables utilises pour UDP

uns16 source_port;                         // port source
uns16 dest_port;                           // port destination
uns16 UDP_length;                          // longueur de la trame UDP




#pragma rambank 1

uns8    ip[4];

// variables utilises pour TCP

uns16 tcp_source_port;
uns16 tcp_dest_port;
uns16 seq[2];
uns16 ack[2];
uns8 offset;
uns8 tcp_options;
uns8 flags;
uns16 window;
uns16 max_seg;
uns16 tcp_data_len;
uns8 html_socket;

#pragma rambank 2

uns8 data[32];
uns16	xm_ack[2];
uns16   xm_seq[2];
uns16   port;


void tcp_listen(void);
void tcp_syn_rcvd(void);
void tcp_estab(void);
void tcp_response(void);
void tcp_end(void);

void init_pic(void)
{
ADCON1=0x06;
TRISC=0x80;
TRISE=0x00;
TRISB=0xFF;
TRISD=0x00;
PORTD=0;
setupUART();
setupTMR0();
IOW=1;
IOR=1;
RESET=0;
delay(25);
PORTD=PORTD&0xE0;
}

void outport(uns8 adresse,uns8 donnee)
{
  PORTD=PORTD^adresse;
  TRISB=0;
  PORTB=donnee;
  IOW=0;
  IOW=1;
  TRISB=0xFF;
  PORTD=PORTD&0xE0;
}

void outportw(uns8 address, uns16 data)
{
 uns16 prev_chksum;

 prev_chksum = chksum;
 PORTD = PORTD^address;
 TRISB=0;
 PORTB=data.high8;
 IOW=0;
 IOW=1;
 nop();
 nop();
 PORTB=data.low8;
 IOW=0;
 IOW=1;
 TRISB=0xFF;
 PORTD=PORTD&0xE0;
 chksum += data;
 if (chksum < prev_chksum ) chksum++;
}


uns8 inport(uns8 adresse)
{
  uns8 donnee;

  PORTD=PORTD^adresse;
  IOR=0;
  donnee=PORTB;
  IOR=1;
  PORTD=PORTD&0xE0;
  return(donnee);
}

void init_carte(void)
{
   uns8 i;

   outport(CR, 0x21);			// arrt de la carte rseau
                                        // arrt du DMA
                                        // selection de la page 0 des registres
   delay(25);			        // attendre l'arrt de la carte
   outport(NIC_RESET, 0xFF);		// Reset the NIC
   delay(25);		                // Wait for it to reset

   outport(DCR, 0x48);			// mode de fonctionnement 8 bits
			                // Fonctionnement normal ( pas loopback )
			                // FIFO 8 octets
   outport(RBCR0, 0x00);		// effacement des registres compteurs
   outport(RBCR1, 0x00);

   outport(RCR, 0x0C);			// accepter le broadcast et le multicast
                                        // rejeter les paquets avec erreurs
                                        // sauver les paquets en mmoire
                                        // accepter tous les paquets
   outport(TCR, 0x02);			// placer la carte en mode boucle en mission

   outport(BNDRY, RCV_BUF_START);	// pointeur de adresse courante du buffer
   outport(PSTART, RCV_BUF_START);	// pointeur de dbut du Buffer
   outport(PSTOP, XMT_BUF_START);	// pointeur de fin du buffer


   outport(ISR, 0xFF);			// effacement du registre d'tat des interruptions
   outport(IMR, 0x00);			// pas d'interruptions

   outport(CR, 0x61);			// selectionner la page 1 de registres

   for (i=0;i<6;i++)
       outport(PAR0+i,physical_address[i]); // fixer une adresse physique ( n'importe laquelle )

   outport(CURR, RCV_BUF_START);        // le pointeur doit tre initialis avec la mme valeur que PSTART

   outport(CR, 0x22);			// la carte rseau est mise en marche
			                // ( on est toujours en mode boucle )
}

void remote_dma_setup(bit w, uns16 address)
{
   outport(CR, 0x22);						// Abort Remote DMA
   outport(RBCR0, 0xFF);					// Set maximum number of bytes to read/write
   outport(RBCR1, 0xFF);
   outport(RSAR0, address.low8);
   outport(RSAR1, address.high8);
   if (w) outport(CR, 0x12);
   else outport(CR, 0x0A);
}

void read_phy_addr(void)
{
   uns8 ignore,i;

   remote_dma_setup(0, 0x0000);
   for (i=0;i<6;i++)
       {
         ignore=inport(NIC_DATA);
         physical_address[i]=ignore;
         ignore=inport(NIC_DATA);
       }
}

void load_ethernet_header(void)
{
 uns8 i;
 uns16 adresse = 0 ;
 adresse.high8 = XMT_BUF_START ;
 remote_dma_setup(WRITE,adresse);
 for(i=0 ; i<6 ; i++) {
        temporary = source_address[i];
        outport(NIC_DATA,temporary);
        }
 for(i=0 ; i<6 ; i++) {
        temporary = physical_address[i] ;
        outport(NIC_DATA,temporary);
        }
}

void load_IP_header(uns16 IP_packet_length, uns8 IP_send_protocol)
{
 uns8 i;
 uns16 prev_chksum;
 uns16 temp ;

 outport(NIC_DATA, 0x08 );
 outport(NIC_DATA, IP);
 chksum = 0;
 outportw(NIC_DATA, 0x4500);
 outportw(NIC_DATA, IP_packet_length);
 outportw(NIC_DATA, identification);
 outportw(NIC_DATA, 0x0000);
 temp = 0x8000 + IP_send_protocol ;              // Time to live
 outportw(NIC_DATA,temp );
 prev_chksum=chksum;                             // correction du 9 juin 2003
 chksum.high8 += my_ip[0] ;
 chksum += my_ip[1] ;
 if (chksum < prev_chksum) chksum++;
 prev_chksum = chksum;
 chksum.high8 += my_ip[2] ;
 chksum += my_ip[3] ;
 if (chksum < prev_chksum) chksum++;
 prev_chksum = chksum;
 chksum.high8 += source_ip[0] ;
 chksum += source_ip[1] ;
 if (chksum < prev_chksum) chksum++;
 prev_chksum = chksum;
 chksum.high8 += source_ip[2] ;
 chksum += source_ip[3] ;
 if (chksum < prev_chksum) chksum++;
 chksum = 0xFFFF - chksum ;
 outportw(NIC_DATA, chksum);          // complement  1 de chksum
 for (i=0 ; i<4 ; i++) {
          temporary = my_ip[i] ;
          outport(NIC_DATA,temporary );
          }
 for (i=0 ; i<4 ; i++) {
          temporary = source_ip[i] ;
          outport(NIC_DATA,temporary );
          }
}

void send_packet(long int len)
{
 outport(CR, 0x22);
 outport(TBCR0, len.low8 );
 outport(TBCR1, len.high8 );
 outport(TPSR, XMT_BUF_START);
 outport(CR, 0x26);
}

void arp_reponse(void)
{
 uns8 i ;
 load_ethernet_header();          // entte ethernet ( MAC expediteur et destinataire )
 outport(NIC_DATA,0x08);          // poids fort type de paquet
 outport(NIC_DATA,ARP);           // poids faible type de paquet
 outport(NIC_DATA, 0x00);         // poids fort type de trame ( ethernet )
 outport(NIC_DATA, 0x01);         // poids faible type de trame
 outport(NIC_DATA, 0x08);         // poids fort type de protocole ( IP )
 outport(NIC_DATA, 0x00);         // poids faible type de protocole
 outport(NIC_DATA, 0x06);         // longueur de l'adresse MAC
 outport(NIC_DATA, 0x04);         // longueur du descripteur de protocole
 outport(NIC_DATA, 0x00);         // reponse ARP
 outport(NIC_DATA, 0x02);
 for (i=0 ; i<6 ; i++) {          // adresse MAC expediteur
                temporary = physical_address[i] ;
		outport(NIC_DATA,temporary);
	        }
 for (i=0 ; i<4 ; i++) {          // adresse IP de l'expediteur
                temporary = my_ip[i] ;
		outport(NIC_DATA, temporary);
		}
 for (i=0 ; i<6 ; i++) {          // adresse MAC du destinataire
                temporary = source_address[i] ;
		outport(NIC_DATA,temporary);
		}
 for (i=0 ; i<4 ; i++) {
                temporary = source_ip[i] ;
		outport(NIC_DATA,temporary);
	        }
 for (i=0 ; i<18 ;i++) outport(NIC_DATA, 0x00); // completer le paquet pour aller  46 octets
 send_packet(60);
}

void ping_reponse()
{
 uns16 prev_chksum;
 uns8 i,j;
 uns16 valeur;

 load_ethernet_header();                 // entte ethernet ( adresses MAC )
 load_IP_header(60,ICMP);                // entte IP
 chksum=0;
 valeur.high8=0;
 valeur.low8=icmp_code;                  // type + code ICMP
 outportw(NIC_DATA, valeur);
 chksum += valeur ;                      // calcul du checksum de la trame ICMP
 prev_chksum=chksum;
 chksum += icmp_identifier;
 if (chksum<prev_chksum) chksum++;
 prev_chksum=chksum;
 chksum += icmp_sequence;
 if (chksum<prev_chksum) chksum++;
 prev_chksum=chksum;
 for (i=0;i<16;i++)                      // les donne reues avec la demande d'echo
     {                                   // entrent dans le calcul du checksum
     j=i*2;                              // de la trame ICMP
     j++;
     valeur=data[j]*256;
     valeur+=data[j+1];
     chksum+=valeur;
     if (chksum<prev_chksum) chksum++;
     prev_chksum=chksum;
     }
 chksum = 0xFFFF - chksum ;
 outportw(NIC_DATA, chksum);             // le checksum est en 3eme position de la tame ICMP
 outportw(NIC_DATA, icmp_identifier);    // identificateur ICMP
 outportw(NIC_DATA, icmp_sequence);      // N de sequence ICMP
 for (i=1;i<33;i++)
     {
     outport(NIC_DATA,data[i]); }        // donne de la trame de demande d'echo
 send_packet(74);                        // envoi du paquet
}

#pragma codepage 1

void poll_nic(void)                      // test de la carte reseau
{
 #pragma rambank 0
 long int adresse = 0 ;
 uns8 in, out;
 uns8 i;
 uns8 status, next_ptr;
 uns16 type;
 uns8 kind;

 outport(CR, 0x62);			// Page 1
 in = inport(CURR);			// pointeur lecture
 outport(CR, 0x22);			// Page 0
 out = inport(BNDRY);			// pointeur ecriture
 if (in!=out)
    {
    adresse.high8 = out ;
    remote_dma_setup(READ, adresse );
    status = inport(NIC_DATA);
    next_ptr = inport(NIC_DATA);
    for (i=0 ; i<8 ; i++) inport(NIC_DATA);
    for (i=0 ; i<6 ; i++) {
        temporary = inport(NIC_DATA);
        source_address[i] = temporary ;
        }
    type.high8 = inport(NIC_DATA);
    type.low8 = inport(NIC_DATA);
    if (type.high8==0x08)         // le poids fort des type est tjrs gal  0x08
    switch (type.low8) {

           case ARP: // print_str("ARP");
                     // printf(10); printf(13);
                     for (i=0; i<8 ; i++) inport(NIC_DATA);
                     for (i=0; i<6 ; i++) inport(NIC_DATA);
                     for (i=0; i<4 ; i++) {
                         temporary =  inport(NIC_DATA);
                         source_ip[i] = temporary ;
                         }
                     for (i=0; i<6 ; i++) inport(NIC_DATA);
                     for (i=0; i<4 ; i++) {
                         temporary = inport(NIC_DATA);
                         dest_ip[i] =  temporary ;
                         }
                     if (dest_ip[0] == my_ip[0] && dest_ip[1] == my_ip[1] &&
			dest_ip[2] == my_ip[2] && dest_ip[3] == my_ip[3])
			           arp_reponse();
                     break;

           case IP:  // print_str("IP");                     // pour le debugage
                     // printf(10); printf(13);
                     version = inport(NIC_DATA);             // version et IHL
		     hdr_len = (version & 0x0F) << 2;        // 4 bits de poids faible x 4
		     opt_len = hdr_len - 20;                 // longueur des options
		     version = version >> 4 ;                // version = 4 bits de poids fort
		     inport(NIC_DATA);                       // type de service
		     IP_length.high8 = inport(NIC_DATA) ;    // longueur du paquet PF
		     IP_length.low8 = inport(NIC_DATA) ;     // longueur du paquet pf
		     identification.high8 = inport(NIC_DATA);// numrotation des fragments
                     identification.low8 = inport(NIC_DATA); // poids faible
                     fragment.high8 = inport(NIC_DATA);      // offset des fragments PF
                     fragment.low8 = inport(NIC_DATA);       // pffset des fragments pf
                     inport(NIC_DATA);                       // TTL dure de vie de la trame
                     IP_protocol = inport(NIC_DATA);         // protocole IP
                     chksum.high8 = inport(NIC_DATA);        // cheksum de l'entte PF
                     chksum.low8 = inport(NIC_DATA);         // cheksum de l'entte poids fort
                     for (i=0; i<4 ; i++) {                  // adresse IP source
                               temporary = inport(NIC_DATA);
			       source_ip[i] = temporary ;
			       }
		     for (i=0; i<4 ; i++) {                  // adresse IP cible
                               temporary = inport(NIC_DATA);
			       dest_ip[i] = temporary ;
			       }
		     for (i=0; i<opt_len ; i++) inport(NIC_DATA); // remplissage
                     switch (IP_protocol) {

                        case ICMP: // print_str("ICMP");          // debugage
                                   icmp_type = inport(NIC_DATA);  // type (08=echo request)
                                   if (icmp_type == ECHO) {       // echo request
                                          icmp_code = inport(NIC_DATA);  // informations sup
                                          icmp_checksum.high8 = inport(NIC_DATA); // PF
                                          icmp_checksum.low8 = inport(NIC_DATA);  // pf
                                          icmp_identifier.high8 = inport(NIC_DATA);
                                          icmp_identifier.low8 = inport(NIC_DATA);
                                          icmp_sequence.high8 = inport(NIC_DATA);// N sequence
                                          icmp_sequence.low8 = inport(NIC_DATA);
                                          for (i=1;i<33;i++)
                                              {
                                              temporary=inport(NIC_DATA);
                                              data[i]=temporary;
                                              }
                                          ping_reponse();
                                          }
                                   break;

                        case TCP:  // print_str("TCP");            // debogage
				   tcp_source_port.high8 = inport(NIC_DATA); // port source
				   tcp_source_port.low8 = inport(NIC_DATA);
				   tcp_dest_port.high8 = inport(NIC_DATA);   // port destination
				   tcp_dest_port.low8 = inport(NIC_DATA);
				   if (tcp_dest_port != 80) break;
				   seq[0].high8 = inport(NIC_DATA);
				   seq[0].low8 = inport(NIC_DATA);
				   seq[1].high8 =inport(NIC_DATA);
				   seq[1].low8 = inport(NIC_DATA);
				   ack[0].high8 = inport(NIC_DATA);
				   ack[0].low8 = inport(NIC_DATA);
				   ack[1].high8 = inport(NIC_DATA);
				   ack[1].low8 = inport(NIC_DATA);
				   offset=inport(NIC_DATA);
                                   offset &= 0xF0;                 // longueur en tte TCP
                                   offset = offset >> 2;           // en bloc de 32 bits
				   tcp_options = (offset - 20);    // longueur de l'option
				   flags = inport(NIC_DATA);
                                   flags &= 0x3F;                  // on ne garde que les 6 bits
				   if ((flags & TCP_SYN) == TCP_SYN) max_seg=0;
				   window.high8 = inport(NIC_DATA);// taille de la fenetre
				   window.low8 = inport(NIC_DATA);
				   inport(NIC_DATA);               // CRC
				   inport(NIC_DATA);
				   inport(NIC_DATA);               // pointeur urgent
				   inport(NIC_DATA);
				   for (i=0 ; i < tcp_options ; i++)
                                       {
					kind = inport(NIC_DATA);
					switch (kind) {
						case 2:
						        inport(NIC_DATA);
							if ((flags & TCP_SYN) == TCP_SYN)
                                                           {
							   max_seg.high8 = inport(NIC_DATA);
							   max_seg.low8 = inport(NIC_DATA);
							   } else
                                                           {
							   inport(NIC_DATA);
							   inport(NIC_DATA);
							   }
							   i=i+3;
						case 0:
						case 1:
						      }
				        }

				   tcp_response();

				   break;
                                   }
           case UDP: // print_str("UDP");          // debogage
                     // printf(10); printf(13);
                     source_port.high8=inport(NIC_DATA);
                     source_port.low8=inport(NIC_DATA);
                     dest_port.high8=inport(NIC_DATA);
                     dest_port.low8=inport(NIC_DATA);
                     UDP_length.high8=inport(NIC_DATA);
                     UDP_length.low8=inport(NIC_DATA);
                     if (UDP_length>40) break;                // longueur max de la trame 32 octets
                     temporary=inport(NIC_DATA);              // CRC
                     temporary=inport(NIC_DATA);
                     UDP_length-=8;                           // l'entte UDP  8 octets
                     for (i=0;i<UDP_length;i++)
                        {
                        temporary=inport(NIC_DATA);
                        printf(temporary);
                        }
                     break;
           }
           outport(CR, 0x22);
	   outport(BNDRY, next_ptr);
    }

}

void tcp_response(void)                      // traitement des requtes TCP
{

uns8 i;

switch (html_socket)
       {
       case LISTEN:
	           if (flags & TCP_SYN)           // si demande de synchro TCP
                      {
	              if (flags & TCP_ACK) {      // et acquit du client
				           break;
				           }
	              if (flags & TCP_RST || flags & TCP_FIN) {  // et erreur ou demande de fin
					   break;
					   }


	              tcp_listen();               // sinon traitement de demande de synchro
	              }
                   if ((flags & TCP_FIN)==TCP_FIN) // si demande de fin du client
		         {
                         tcp_end();
                         }
                   break;

        case SYN_RCVD:
		   if (port!=tcp_source_port || ip[0]!=source_ip[0] || ip[1]!=source_ip[1] ||
		   ip[2]!=source_ip[2] || ip[3]!= source_ip[3])
		   break;
		   if (flags & TCP_ACK)
                      {
		      if (flags & TCP_SYN) {
					   break;
					   }
		      if (flags & TCP_RST || flags & TCP_FIN)
                                           {
					   break;
					   }
		      tcp_syn_rcvd();
		      }
                   break;
	case ESTAB:
		   if (flags & TCP_ACK)
                      {
		      if (flags & TCP_SYN) {
					   break;
					   }
		      if (flags & TCP_RST ) {
					    break;
					    }
		      if (seq[0] != xm_ack[0] || seq[1] != xm_ack[1] ||
			  ack[0] != xm_seq[0] || ack[1] != xm_seq[1])
						break;
		      if (port != tcp_source_port) break;
		      if (ip[0] != source_ip[0] || ip[1] != source_ip[1] ||
			  ip[2] != source_ip[2] || ip[3] != source_ip[3])
						break;
		      tcp_estab();
		      }

		}
}

void load_TCP_header(uns16 data_flags, uns16 tcp_chksum, uns16 tcp_length) {
                                             // prparation de l'entte TCP
uns16 prev_chksum;

chksum = tcp_chksum;
prev_chksum = chksum;
chksum.high8 += my_ip[0] ;
chksum += my_ip[1];
if (chksum < prev_chksum) chksum++;
prev_chksum = chksum;
chksum.high8 += my_ip[2] ;
chksum += my_ip[3];
if (chksum < prev_chksum) chksum++;
prev_chksum = chksum;
chksum.high8 += source_ip[0] ;
chksum += source_ip[1];
if (chksum < prev_chksum) chksum++;
prev_chksum = chksum;
chksum += source_ip[2] ;
chksum += source_ip[3];
if (chksum < prev_chksum) chksum++;
prev_chksum = chksum;
chksum += TCP;
if (chksum < prev_chksum) chksum++;
prev_chksum = chksum;
chksum += tcp_length;
if (chksum < prev_chksum) chksum++;
outportw(NIC_DATA, tcp_dest_port);
outportw(NIC_DATA, tcp_source_port);
outportw(NIC_DATA, xm_seq[0]);
outportw(NIC_DATA, xm_seq[1]);
outportw(NIC_DATA, xm_ack[0]);
outportw(NIC_DATA, xm_ack[1]);
outportw(NIC_DATA, data_flags);
outportw(NIC_DATA, 1460);
chksum=0xFFFF-chksum;
outportw(NIC_DATA,chksum);
outportw(NIC_DATA, 0);
}

void tcp_listen(void)                        // demande de synchronisation TCP
{

uns8 i,j;

xm_ack[0] = seq[0];
xm_ack[1] = seq[1];
port = tcp_source_port;
for (i=0 ; i<4 ; i++) {    j = source_ip[i];
                           ip[i] = j ;
                           }
tcp_data_len = IP_length - hdr_len ;
tcp_data_len -= offset ;
xm_ack[1] += tcp_data_len ;
xm_ack[1] += 1;
if (xm_ack[1] < seq[1] ) xm_ack[0]++;
xm_seq[1]++;
if (xm_seq[1] == 0) xm_seq[0]++;
load_ethernet_header();
load_IP_header(48,TCP);										// 20 for IP header
load_TCP_header( 0x7000 | TCP_SYN | TCP_ACK, 0x7B8 , 28);
outport(NIC_DATA,0x02);
outport(NIC_DATA,0x04);
outport(NIC_DATA,0x05);
outport(NIC_DATA,0xB4);
outport(NIC_DATA,0x00);
outport(NIC_DATA,0x00);
outport(NIC_DATA,0x00);
outport(NIC_DATA,0x00);
send_packet(62);
xm_seq[1]++;
if (xm_seq[1] == 0) xm_seq[0]++;
html_socket = SYN_RCVD;
}

void tcp_syn_rcvd(void)                      // la synchronisation TCP est accepte
{
tcp_data_len = IP_length - hdr_len ;
tcp_data_len -= offset ;
xm_ack[1] += tcp_data_len;
if (xm_ack[1] < seq[1] ) xm_ack[0]++;
html_socket = ESTAB;
}

void tcp_estab(void)                         // la connexion TCP est tablie ( requte HTTP )
{
uns8 i,j;
uns16 cpt;
// static const char chaine[44]="<p>Ceci est un serveur TCP/IP mono carte</p>";

tcp_data_len = IP_length - hdr_len ;
tcp_data_len -= offset ;
xm_ack[1] += tcp_data_len;
if (xm_ack[1] < seq[1] ) xm_ack[0]++;
load_ethernet_header();
load_IP_header(760,TCP);
load_TCP_header( 0x5000 | TCP_ACK | TCP_FIN, 0x98BB, 740);
for (cpt=0; cpt<720; cpt++)
    {
    j=readFLASH(cpt+0x1000);
    printf(j);
    outport(NIC_DATA,j);
    }
xm_ack[1] += 148;
if (xm_ack[1] < seq[1]) xm_ack[0]++;
send_packet(774);                  
html_socket = LISTEN;
}

void tcp_end(void)                           // fin d'une connexion TCP
{
uns8 i,j;

xm_ack[0] = seq[0];
xm_ack[1] = seq[1];
port = tcp_source_port;
for (i=0 ; i<4 ; i++) {    j = source_ip[i];
                           ip[i] = j ;
                           }
tcp_data_len = IP_length - hdr_len ;
tcp_data_len -= offset ;
xm_ack[1] += tcp_data_len ;
xm_ack[1] += 1;
if (xm_ack[1] < seq[1] ) xm_ack[0]++;
xm_seq[1]++;
if (xm_seq[1] == 0) xm_seq[0]++;
load_ethernet_header();
load_IP_header(40,TCP);										// 20 for IP header
load_TCP_header( 0x5000 | TCP_ACK, 0x00 , 20); // OK pour finir la connexion
send_packet(60);
}


#pragma codepage 0

void main(void)
{
  #pragma rambank 3
  uns16 compteur;
  uns8 octet;

  max_seg=0;
  html_socket = LISTEN;

  my_ip[0]=192;
  my_ip[1]=168;
  my_ip[2]=0;
  my_ip[3]=25;
  init_pic();
  init_carte();
  read_phy_addr();
  init_carte();
  outport(TCR,0x00);
  for (compteur=0;compteur<1150;compteur++) {
                                            	octet=readFLASH(compteur+0x1000);
                                                printf(octet);
  }
while(1)
{
  poll_nic();
}
}
