#include <avr/io.h>
#include <avr/power.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <util/delay.h>

#define PIN_OUT1	PB0
#define PIN_OUT2	PB1
#define PIN_OUT3	PB3
#define PIN_GOMB	PB2
#define int0_cli()	GIMSK &= ~(1<<INT0)
#define int0_sei()	GIMSK |= (1<<INT0)

volatile uint8_t gomb, count;
volatile uint16_t c_pwr;
static int8_t lvect;

// INT0 ISR
ISR(INT0_vect) {
    int0_cli();
    if (!gomb)
	count = 0;
    gomb = 1;
    c_pwr = 0;
    int0_sei();
}

ISR(TIMER1_COMPA_vect) {
    c_pwr++;
    if (count < 100);
	count++;
}

//-------------------------------------
void init(void) {
//-------------------------------------
    DDRB = (1<<PIN_OUT1) | (1<<PIN_OUT2) | (1<<PIN_OUT3);    	// Kimenetek
    PORTB = (1<<PIN_GOMB);	// Felhúzás bekapcsolva

    //Init Timer0
    TCCR0A = (1<<COM0A1)
      | (0<<COM0A0)    	//Nem invert. PWM A
      | (1<<WGM01)
      | (1<<WGM00);    	//Fast PWM, mode 3
    
    TCCR0B = (0<<WGM02)
      | (0<<CS02)
      | (0<<CS01)
      | (1<<CS00);      	// 128000/256/8 ~= 3 Hz
    
    //Start folyamat
    count = 0;
    gomb = 0;
    lvect = 1;
    c_pwr = 0;
    TCCR1 = (1<<CTC1)
	| (1<<CS13)	// 1 ms
	| (0<<CS12)
	| (0<<CS11)
	| (0<<CS10);
    OCR1A = 0;
    OCR1C = 100;		// 100 ms

    while(!(PINB & (1<<PIN_GOMB)))
	_delay_ms(10);
    MCUCR |= (1<<ISC01);
    int0_sei();			// Enable INT0
    TIMSK |= (1<<OCIE1A);	// Enable Timer1A
    _delay_ms(100);
    sei();			// Enable global interrupts
}
 
//-------------------------------------
int main(void) {
//-------------------------------------

    uint8_t i;

    OCR0A  = 0;
    init();
    set_sleep_mode(SLEEP_MODE_PWR_DOWN);

    for(;;)  {
	if (gomb && (PINB & (1<<PIN_GOMB))) {
    	    lvect *= -1;
    	    gomb = 0;
    	    if (count < 3)
    		c_pwr = 65000;
	}
	if (gomb) {
	    i = (OCR0A>>4)+1;
	    if ((lvect > 0) && ((OCR0A+i) > 255))
	        lvect = -1;
	    if ((lvect < 0) && ((OCR0A-i) < 0))
	        lvect = 1;
	    if (lvect > 0)
	        OCR0A += i;
	    else
	        OCR0A -= i;
	}
	if (OCR0A > 220)
	    PORTB |= (1<<PIN_OUT2);
	else
	    PORTB &= ~(1<<PIN_OUT2);
	if (OCR0A < 10)
	    PORTB |= (1<<PIN_OUT3);
	else
	    PORTB &= ~(1<<PIN_OUT3);
	if (c_pwr >= 3600) {		// 6 min
	    TCCR0A &= ~(1<<COM0A1);	// Disable Timer0
	    int0_cli();
	    while(!(PINB & (1<<PIN_GOMB)))
	        _delay_ms(10);
	    TCCR1 = 0;
	    MCUCR &= ~(1<<ISC01);
	    PORTB &= ~(1<<PIN_OUT2);
	    PORTB &= ~(1<<PIN_OUT3);
	    _delay_ms(200);
	    int0_sei();
	    sleep_mode();
	    cli();
	    _delay_ms(200);
	    init();
	}
	_delay_ms(50);
   }
}

