;HD44780 LCD Library
;Simon Richards
;LCD_DATA = 8 bit data port for LCD
;LCD_CTRL = port for control
;E = Enable bit of LCD_CTRL
;RS = Register select bit of LCD_CTRL
;RW = R/W bit of LCD_CTRL

LCD_DATA	EQU	PORTD
LCD_CTRL	EQU	PORTC
E	EQU	0
RS	EQU	2
RW	EQU	1

BUSY	EQU	24

DELAY_REG	EQU	25

LCD_INIT ;Initalise LCD
	MOVLW	b'00111000'
	CALL	LCD_WRITE_CMD
	MOVLW	b'00001110'
	CALL	LCD_WRITE_CMD
	CALL	LCD_CLS
	RETURN
	
LCD_WRITE_CHAR ;Write character to LCD, character must be in W reg
	BCF	LCD_CTRL,RW
	BSF	LCD_CTRL,RS
	BSF	LCD_CTRL,E
	;CALL	LCD_DELAY
	MOVWF	LCD_DATA
	CALL	LCD_DELAY
	BCF	LCD_CTRL,E
	RETURN

LCD_WRITE_CMD ;Write command to LCD, command code must be in W reg
	BCF	LCD_CTRL,RW
	BCF	LCD_CTRL,RS
	BSF	LCD_CTRL,E
	;CALL	LCD_DELAY
	MOVWF	LCD_DATA
	CALL	LCD_DELAY
	BCF	LCD_CTRL,E
	RETURN

LCD_CLS ;Clear screen
	MOVLW	b'00000001'
	CALL	LCD_WRITE_CMD
	CALL	DELAY
	RETURN	

LCD_HOME ;Return cursor to first character on first line
	MOVLW	b'00000010'
	CALL	LCD_WRITE_CMD
	CALL	DELAY
	RETURN

LCD_LINE2 ;Move cursor to first character on second line
	MOVLW	b'10101000'
	CALL	LCD_WRITE_CMD
	RETURN

LCD_CURSOR_LEFT
	MOVLW	b'00010000'
	CALL	LCD_WRITE_CMD
	RETURN

LCD_CURSOR_RIGHT
	MOVLW	b'00010100'
	CALL	LCD_WRITE_CMD
	RETURN
	
LCD_DELAY
	MOVLW	d'50'
	MOVWF	DELAY_REG
LCD_DELAY_1
	DECFSZ	DELAY_REG
	GOTO	LCD_DELAY_1
	RETURN