;PIC16F887 LCD Test Program
;Simon Richards

	INCLUDE	"PIC16F887.asm" ;Include the header


CHAR	EQU	0x26


	ORG 0 ;Reset vector
	GOTO MAIN
	
	ORG 4 ;Interrupt vector
	
	INCLUDE	"DELAY.asm" ;Include delays
	INCLUDE	"HD44780.asm" ;Include HD44780 LCD functions
	
MAIN ;Main loop
	MOVLW	b'00100001'
	MOVWF	CHAR
	MOVLW	0x56
	MOVWF	OSCCON ;Set OSC to 4MHz
	
	BSF STATUS,RP0 ;Begin set port direction
	MOVLW	00
	MOVWF	TRISD
	MOVLW	0xFF
	MOVWF	TRISE
	MOVLW	b'11111000'
	MOVWF	TRISC
	BSF	STATUS,RP1
	MOVLW	00
	MOVWF	ANSEL
	MOVWF	ANSELH
	BCF	STATUS,RP0
	BCF	STATUS,RP1
	CLRF	PORTD
	CLRF	PORTC
	CLRF	PORTE ;End port direction set
;Init LCD
	CALL	DELAY
	CALL	LCD_INIT

BUTTONS ;Look for button presses
	BTFSS	PORTC,3
	CALL	BUTTON1
	
	BTFSS	PORTC,4
	CALL	BUTTON2

	BTFSS	PORTC,5
	CALL	BUTTON3

	BTFSS	PORTC,6
	CALL	BUTTON4

	BTFSS	PORTC,7
	CALL	BUTTON5

	GOTO	BUTTONS
	
BUTTON1 
	CALL	INCREMENT
	CALL	DELAY_BOUNCE
	RETURN
	
BUTTON2
	CALL	DECREMENT
	CALL	DELAY_BOUNCE
	RETURN

BUTTON3
	CALL	LCD_LINE2
	CALL	DELAY_BOUNCE
	RETURN

BUTTON4
	CALL	LCD_CLS
	CALL	DELAY_BOUNCE
	RETURN

BUTTON5
	CALL	LCD_CURSOR_RIGHT
	CALL	DELAY_BOUNCE
	RETURN


INCREMENT ;Go to next character
	INCF	CHAR,F
	NOP
	NOP
	MOVLW	00
	ADDWF	CHAR,W
	CALL	LCD_WRITE_CHAR
	CALL	LCD_CURSOR_LEFT
	RETURN

DECREMENT ;Go to previous character
	DECF	CHAR,F
	NOP
	NOP
	MOVLW	00
	ADDWF	CHAR,W
	CALL	LCD_WRITE_CHAR
	CALL	LCD_CURSOR_LEFT
	RETURN

WRITE_PIC16F887 ;Write "PIC16F887" to LCD
	MOVLW	b'01010000'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'01001001'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'01000011'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'00110001'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'00110110'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'01000110'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'00111000'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'00111000'
	CALL	LCD_WRITE_CHAR
	MOVLW	b'00110111'
	CALL	LCD_WRITE_CHAR
	RETURN

	END ;End of program