#include "3310.h"
#include  <msp430g2553.h>


const unsigned char szamx[210] =
 // 0
   {0xE0,0xFC,0xFE,0x06,0x03,0x03,0x06,0xFE,0xFC,0xE0,
   	0x07,0x3F,0x7F,0x70,0xE0,0xE0,0x70,0x7F,0x3F,0x07,
 // 1
   0x00,0x00,0x00,0x04,0x06,0xFE,0xFF,0xFF,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,0x00,
 
 // 2
   0x00,0x00,0x1C,0x0E,0x07,0x83,0x87,0xFE,0xFE,0x38,
   0x00,0x60,0xFC,0xFE,0xEF,0xE7,0xE3,0xE1,0x60,0x30,
 // 3
   0x00,0x00,0x0E,0x0E,0xC6,0xE6,0xF6,0xBE,0x1E,0x06,
   0x00,0x60,0x70,0xF0,0xE0,0xE0,0xF1,0x7F,0x3F,0x0E,
 // 4
   0x00,0xC0,0xE0,0x78,0x1C,0x0E,0x86,0xE2,0x10,0x00,
   0x06,0x07,0x07,0x06,0x06,0xE6,0xFF,0xFF,0x0E,0x0E,
 // 5
   0x00,0x70,0xF8,0xFE,0xCE,0xC6,0xC6,0x86,0x86,0x00,
   0x00,0x30,0x71,0x71,0xE0,0xE0,0xF0,0x7F,0x3F,0x0E,
 // 6
   0xC0,0xF8,0xFC,0x8E,0x86,0xC7,0xC3,0x87,0x82,0x00,
   0x0F,0x3F,0x7F,0x71,0xE0,0xE0,0x61,0x7B,0x3F,0x0E,
 // 7
   0x00,0x00,0x0E,0x0E,0x06,0x86,0xE6,0x7E,0x1E,0x0E,
   0x00,0x00,0x00,0x38,0x7F,0xFF,0xE1,0x40,0x00,0x00,
 // 8
   0x18,0x7E,0xE6,0xC3,0xC3,0xC3,0xE6,0xBE,0x18,0x00,
   0x18,0x7E,0x7F,0xE1,0xE1,0xE1,0xF3,0x7F,0x7F,0x1C,
 // 9
   0xFC,0xCE,0x06,0x03,0x03,0x07,0x86,0xFE,0xFC,0xE0,
   0x41,0xE3,0xE3,0xE3,0x63,0x73,0x79,0x3F,0x1F,0x03};


const unsigned char image[504] = {
0x00, 0x00, 0x00, 0xC0, 0xF0, 0x08, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 
0x18, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF0, 0xFE, 0x7F, 0x70, 0x30, 0x30, 0x30, 
0x70, 0xF0, 0xFE, 0xFE, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xC0, 0xE0, 0xF0, 0x38, 0x0C, 0x0C, 0x0C, 0x0E, 0x1E, 0x64, 0xE0, 
0x60, 0xE0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFE, 0xFF, 0xFF, 0x03, 
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF1, 0xFF, 0xFF, 0x7F, 0x18, 0x0C, 
0x06, 0xFE, 0xFF, 0xFF, 0xFC, 0x38, 0x1C, 0x0E, 0x0E, 0x0F, 0x07, 0x82, 0xE0, 
0xF0, 0xF8, 0x1C, 0x06, 0x06, 0x86, 0xE7, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x00, 
0xE0, 0xF0, 0xF8, 0x3C, 0x06, 0x06, 0x07, 0x0F, 0xFF, 0xFE, 0xFE, 0x00, 0x80, 
0xE0, 0xF8, 0xF8, 0x1C, 0x0E, 0x06, 0x86, 0xE7, 0xFF, 0xFF, 0xFF, 0x06, 0x00, 
0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
0x00, 0x03, 0x0F, 0x0F, 0x1F, 0x38, 0x30, 0x30, 0x30, 0x38, 0x18, 0x1C, 0x0F, 
0x07, 0x07, 0x01, 0x00, 0x00, 0x90, 0xBF, 0xBF, 0xDF, 0xC7, 0xC0, 0xC0, 0xC0, 
0xE0, 0xE0, 0xE0, 0xE0, 0xEF, 0xFF, 0xFF, 0xF8, 0xDC, 0xCE, 0x87, 0x8F, 0x9F, 
0x3F, 0x3F, 0x18, 0x0C, 0x06, 0x07, 0x1F, 0x1F, 0x3F, 0x38, 0x38, 0x18, 0x1C, 
0x0F, 0x07, 0x03, 0x01, 0x00, 0x0F, 0x1F, 0x1F, 0x1D, 0x1C, 0x0C, 0x8F, 0xF3, 
0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xFF, 0xFF, 0x00, 0x01, 0x01, 0x03, 0x07, 0x07, 0x0F, 0x07, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x06, 0x06, 0x03, 0x03, 0x03, 0x01, 0x01, 
0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x07, 0x07, 0x06, 0x0E, 0x0E, 0x1C, 
0x1C, 0x1C, 0x38, 0x38, 0x78, 0x70, 0x70, 0xF0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 
0x70, 0x78, 0x3C, 0x1E, 0x0F, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x18, 0x10, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
0x20, 0x20, 0x20, 0x30, 0x10, 0x0F, 0x03, 0x00, 0x00, 0x00 };

static const  unsigned char tablo [480] = {	
	0x00, 0x00, 0x00, 0x00, 0x00,// 
	0x00, 0x00, 0x5F, 0x00, 0x00,// !
	0x00, 0x07, 0x00, 0x07, 0x00,// "
	0x14, 0x7F, 0x14, 0x7F, 0x14,// #
	0x24, 0x2A, 0x7F, 0x2A, 0x12,// $
	0x23, 0x13, 0x08, 0x64, 0x62,// %
	0x36, 0x49, 0x55, 0x22, 0x50,// &
	0x00, 0x05, 0x03, 0x00, 0x00,// '
	0x00, 0x1C, 0x22, 0x41, 0x00,// (
	0x00, 0x41, 0x22, 0x1C, 0x00,// )
	0x08, 0x2A, 0x1C, 0x2A, 0x08,// *
	0x08, 0x08, 0x3E, 0x08, 0x08,// +
	0x00, 0x50, 0x30, 0x00, 0x00,// ,
	0x08, 0x08, 0x08, 0x08, 0x08,// -
	0x00, 0x60, 0x60, 0x00, 0x00,// .
	0x20, 0x10, 0x08, 0x04, 0x02,// /
	0x3E, 0x51, 0x49, 0x45, 0x3E,// 0
	0x00, 0x42, 0x7F, 0x40, 0x00,// 1
	0x42, 0x61, 0x51, 0x49, 0x46,// 2
	0x21, 0x41, 0x45, 0x4B, 0x31,// 3
	0x18, 0x14, 0x12, 0x7F, 0x10,// 4
	0x27, 0x45, 0x45, 0x45, 0x39,// 5
	0x3C, 0x4A, 0x49, 0x49, 0x30,// 6
	0x01, 0x71, 0x09, 0x05, 0x03,// 7
	0x36, 0x49, 0x49, 0x49, 0x36,// 8
	0x06, 0x49, 0x49, 0x29, 0x1E,// 9
	0x00, 0x36, 0x36, 0x00, 0x00,// :
	0x00, 0x56, 0x36, 0x00, 0x00,// ;
	0x00, 0x08, 0x14, 0x22, 0x41,// <
	0x14, 0x14, 0x14, 0x14, 0x14,// =
	0x41, 0x22, 0x14, 0x08, 0x00,// >
	0x02, 0x01, 0x51, 0x09, 0x06,// ?
	0x32, 0x49, 0x79, 0x41, 0x3E,// @
	0x7E, 0x11, 0x11, 0x11, 0x7E,// A
	0x7F, 0x49, 0x49, 0x49, 0x36,// B
	0x3E, 0x41, 0x41, 0x41, 0x22,// C
	0x7F, 0x41, 0x41, 0x22, 0x1C,// D
	0x7F, 0x49, 0x49, 0x49, 0x41,// E
	0x7F, 0x09, 0x09, 0x01, 0x01,// F
	0x3E, 0x41, 0x41, 0x51, 0x32,// G
	0x7F, 0x08, 0x08, 0x08, 0x7F,// H
	0x00, 0x41, 0x7F, 0x41, 0x00,// I
	0x20, 0x40, 0x41, 0x3F, 0x01,// J
	0x7F, 0x08, 0x14, 0x22, 0x41,// K
	0x7F, 0x40, 0x40, 0x40, 0x40,// L
	0x7F, 0x02, 0x04, 0x02, 0x7F,// M
	0x7F, 0x04, 0x08, 0x10, 0x7F,// N
	0x3E, 0x41, 0x41, 0x41, 0x3E,// O
	0x7F, 0x09, 0x09, 0x09, 0x06,// P
	0x3E, 0x41, 0x51, 0x21, 0x5E,// Q
	0x7F, 0x09, 0x19, 0x29, 0x46,// R
	0x46, 0x49, 0x49, 0x49, 0x31,// S
	0x01, 0x01, 0x7F, 0x01, 0x01,// T
	0x3F, 0x40, 0x40, 0x40, 0x3F,// U
	0x1F, 0x20, 0x40, 0x20, 0x1F,// V
	0x7F, 0x20, 0x18, 0x20, 0x7F,// W
	0x63, 0x14, 0x08, 0x14, 0x63,// X
	0x03, 0x04, 0x78, 0x04, 0x03,// Y
	0x61, 0x51, 0x49, 0x45, 0x43,// Z
	0x00, 0x00, 0x7F, 0x41, 0x41,// [
	0x02, 0x04, 0x08, 0x10, 0x20,// "\"
	0x41, 0x41, 0x7F, 0x00, 0x00,// ]
	0x04, 0x02, 0x01, 0x02, 0x04,// ^
	0x40, 0x40, 0x40, 0x40, 0x40,// _
	0x00, 0x01, 0x02, 0x04, 0x00,// `
	0x20, 0x54, 0x54, 0x54, 0x78,// a
	0x7F, 0x48, 0x44, 0x44, 0x38,// b
	0x38, 0x44, 0x44, 0x44, 0x20,// c
	0x38, 0x44, 0x44, 0x48, 0x7F,// d
	0x38, 0x54, 0x54, 0x54, 0x18,// e
	0x08, 0x7E, 0x09, 0x01, 0x02,// f
	0x08, 0x14, 0x54, 0x54, 0x3C,// g
	0x7F, 0x08, 0x04, 0x04, 0x78,// h
	0x00, 0x44, 0x7D, 0x40, 0x00,// i
	0x20, 0x40, 0x44, 0x3D, 0x00,// j
	0x00, 0x7F, 0x10, 0x28, 0x44,// k
	0x00, 0x41, 0x7F, 0x40, 0x00,// l
	0x7C, 0x04, 0x18, 0x04, 0x78,// m
	0x7C, 0x08, 0x04, 0x04, 0x78,// n
	0x38, 0x44, 0x44, 0x44, 0x38,// o
	0x7C, 0x14, 0x14, 0x14, 0x08,// p
	0x08, 0x14, 0x14, 0x18, 0x7C,// q
	0x7C, 0x08, 0x04, 0x04, 0x08,// r
	0x48, 0x54, 0x54, 0x54, 0x20,// s
	0x04, 0x3F, 0x44, 0x40, 0x20,// t
	0x3C, 0x40, 0x40, 0x20, 0x7C,// u
	0x1C, 0x20, 0x40, 0x20, 0x1C,// v
	0x3C, 0x40, 0x30, 0x40, 0x3C,// w
	0x44, 0x28, 0x10, 0x28, 0x44,// x
	0x0C, 0x50, 0x50, 0x50, 0x3C,// y
	0x44, 0x64, 0x54, 0x4C, 0x44,// z
	0x00, 0x08, 0x36, 0x41, 0x00,// {
	0x00, 0x00, 0x7F, 0x00, 0x00,// |
	0x00, 0x41, 0x36, 0x08, 0x00,// }
	0x08, 0x08, 0x2A, 0x1C, 0x08,// ->
	0x08, 0x1C, 0x2A, 0x08, 0x08 // <-
};

const unsigned char TABLEEK [90] = {
          120,20,18,20,123, //193  0
          124,84,86,85,86,   //201  5
          0,68,126,69,0,    //205  10
          56,68,70,69,56,   //211  15
          56,70,69,70,57,   //213  20
          56,69,68,69,56,   //214   25
          60,66,64,66,60,   //220   30
          60,64,66,65,60,   //218   35
          60,66,65,66,61,   //218  40                 
          32,84,86,85,120,  //225  45
          56,84,86,85,24,    //233  50 
          0,0,122,1,0,      //237  55
          48,72,74,73,48,   //243  60 
          48,74,73,74,49,   //245  65 
          48,74,72,74,48,   //246  70           
          56,66,64,66,56,   //252  75
          56,64,66,65,56,   //250  80
          56,66,65,66,57   //251  85
          };


long ddram;
char char_row,chardata,charsel;
unsigned int charpos;





void nokia_init(void) 
{ 
	
	DCPORT |= nok_dc;  
	CSPORT |= nok_cs;
	RESPORT &= ~nok_res;
	//__delay_cycles(10000);
	__delay_cycles(100000);
	RESPORT |= nok_res;
	
  //output_high(nok_dc);            // bytes are stored in the display data ram, address counter, incremented automatically 
  //output_high(nok_cs);            // chip disabled 
  //  output_low(nok_res);            // reset chip during 250ms 
  //delay_ms(10);         // works with less..... 
  //output_high(nok_res); 

  nokia_write_command(0x21);   // set extins extended instruction set 
  nokia_write_command(0xc2);   // Vop  v1: 0xc8 (for 3V)// v2: 0xa0 (for 3V) // v3: 0xc2 (2v6-5v)   ******************************************************************************************************************** 
  nokia_write_command(0x13);   // bias 
  nokia_write_command(0x20);   // horizontal mode from left to right, X axe are incremented automatically , 0x22 for vertical addressing ,back on normal instruction set too 020
  nokia_write_command(0x09);   // all on 
  //nokia_write_command(0xBF); //0xBf //Contrast
  

  nokia_clean_ddram();      // reset DDRAM, otherwise the lcd is blurred with random pixels 

  nokia_write_command(0x08);   // mod control blank change (all off) 

  nokia_write_command(0x0c);   // mod control normal change 

} 

void nokia_clean_ddram(void) 
{ 
  nokia_gotoxy(0,0);         // 84*6=504      clear LCD 
  for (ddram=504;ddram>0;ddram--){nokia_write_data(0x00);} 

} 


void nokia_write_command(char bytefornokia_command) 
{ 
  DCPORT &= ~nok_dc;
  CSPORT &= ~nok_cs;
  nokia_write_dorc(bytefornokia_command);
  CSPORT|= nok_cs;
  //output_low(nok_dc);   // byte is a command it is read with the eight SCLK pulse 
 // output_low(nok_cs);   // chip enabled 
  //nokia_write_dorc(bytefornokia_command); 
  //output_high(nok_cs);   // chip disabled 

} 

void nokia_write_data(char bytefornokia_data) 
{ 
  
  DCPORT|= nok_dc;
  CSPORT &= ~nok_cs;
  
  //output_high(nok_dc); 
  //output_low(nok_cs);   // chip enabled 
  nokia_write_dorc(bytefornokia_data); 
  //output_high(nok_cs);   // chip disabled 
  CSPORT|= nok_cs;
} 


void nokia_write_dorc(char bytefornokia)         // serial write data or command subroutine 
{ 
  char caa; 
  for (caa=8;caa>0;caa--) {
  	SCLKPORT &= ~nok_sclk; 
    //output_low(nok_sclk); 
    // delay_us(2); 
  //  __delay_cycles(100);
    if ((bytefornokia&0x80)==0){ SDAPORT &= ~nok_sda;}
    	//output_low(nok_sda);} 
    else {SDAPORT |= nok_sda; }
    	//output_high(nok_sda);} 
    SCLKPORT |= nok_sclk;
    //output_high(nok_sclk); 
    bytefornokia=bytefornokia<<1; 
  } 
} 

void nokia_gotoxy(char xnokia, char ynokia)      // Nokia LCD 3310 Position cursor 
{ 
  nokia_write_command(0x40|(ynokia&0x07));   // Y axe initialisation: 0100 0yyy 

  nokia_write_command(0x80|(xnokia&0x7f));   // X axe initialisation: 1xxx xxxx 
} 


void invert(void) 
{
 nokia_write_command(0x0D); 
}


void normal(void) 
{
//nokia_write_command(0x00);
nokia_write_command(0x0C);
}

void logo(void) 
{
long i=0;
for(i=0;i<504;i++)
 {
 	nokia_write_data(image[i]);
 }  
}

void printlcd(const char *s)
{  

	while(*s){
		nokia_printchar(*s++);
	}
}

void    nokia_clear_screen(void)
{
 
long i=0;
for(i=0;i<504;i++)
 {
 	nokia_write_data(0x00);
 }  
}



void nokia_printchar(char cvar)               // Write 1 character to LCD 
{ 
  charsel=cvar;
    //if (cvar==""){charsel=252;} 
  if (charsel > 165 )
 {
    switch ( charsel ) {
     case 193:
     charsel = 0; 
     break;
     
     case 201:
     charsel = 5; 
     break;
     
     case 205:
     charsel = 10;
     break;
     
     
     case 211:
     charsel = 15;
     break;
     
     case 213:
     charsel = 20; 
     break;
     
     case 214:
     charsel = 25; 
     break;
     
     case 218:
     charsel = 35; 
     break;
     
     case 220:
     charsel = 30; 
     break;
     
     case 219:
     charsel = 40; 
     break;
     
     case 225:
     charsel = 45; 
     break;
     
     case 233:
     charsel = 50; 
     break;
     
     case 237:
     charsel = 55; 
     break;
     
     case 243:
     charsel = 60; 
     break;
    
     case 245:
     charsel = 65; 
     break;
     
     case 246:
     charsel = 70; 
     break;
     
     case 250:
     charsel = 80; 
     break;
      
     case 251:
     charsel = 85;      
     break;
     
     case 252:
     charsel = 75;      
     break;
     
     
 
 //ekezet(charsel);
  
  
    }
  nokia_printchar2();
  
    }
  else {nokia_printchar1();}
  //table_to_nokialcd();
  
} 


void nokia_printchar1() 			
{
	

	if (charsel<0x20) return;
	if (charsel>0x7f) return;

	for(char_row=0;char_row<5;char_row++)
	{
	
	charpos=(charsel-0x20)*5;
	chardata=tablo[(charpos+char_row)];
	   nokia_write_data(chardata);	
	}
	   nokia_write_data(0x00);

}

void nokia_printchar2() 			
{
	

   for(char_row=0;char_row<5;char_row++)
	{
	
	charpos=charsel;
	chardata=TABLEEK[(charpos+char_row)];
	   nokia_write_data(chardata);	
	}
	   nokia_write_data(0x00);
}

void kszam(char szam, int x, int y)
   {
   	//nokia_gotoxy(0,0);
   	
   	nokia_gotoxy(x,y);
    char i,ii=20*szam;
     for(i=0;i<10;i++) {  nokia_write_data(szamx[ii+i]); }
    
    
    
  //	nokia_gotoxy(0,0);
   	nokia_gotoxy(x,y+1);
    ii=(20*szam)+10;
     for(i=0;i<10;i++)    {     nokia_write_data(szamx[ii+i]);    }
   	
    
    
   }
   
   void fullchar() 
{ 
  nokia_write_data(0x7F); 
  nokia_write_data(0x7F); 
  nokia_write_data(0x7F); 
  nokia_write_data(0x7F); 
  nokia_write_data(0x7F);   

} 

void felso () 
{ 
  nokia_write_data(0x1F); 
  nokia_write_data(0x1F); 
  nokia_write_data(0x1F); 
  nokia_write_data(0x1F); 
  nokia_write_data(0x1F);   

}


void also () 
{ 
  nokia_write_data(0x7C); 
  nokia_write_data(0x7C); 
  nokia_write_data(0x7C);
  nokia_write_data(0x7C); 
  nokia_write_data(0x7C);   

}

void orapont()
{
  nokia_write_data(0x00); 
  nokia_write_data(0x00); 
  nokia_write_data(0x18);
  nokia_write_data(0x18); 
  nokia_write_data(0x00);   
	
	
}

void also2 ()
{ 
  nokia_write_data(0x60); 
  nokia_write_data(0x60); 
  nokia_write_data(0x60);
  nokia_write_data(0x60); 
  nokia_write_data(0x60);   

}

void felso2 ()
{ 
  nokia_write_data(0x03); 
  nokia_write_data(0x03); 
  nokia_write_data(0x03);
  nokia_write_data(0x03); 
  nokia_write_data(0x03);   

}

void egy1(){
  nokia_write_data(0x00); 
  nokia_write_data(0x00); 
  nokia_write_data(0x00);
  nokia_write_data(0x40); 
  nokia_write_data(0x60);   
}


void egy(){
  nokia_write_data(0x70); 
  nokia_write_data(0x78); 
  nokia_write_data(0x7C);
  nokia_write_data(0x7E); 
  nokia_write_data(0x7F);   
}


void ures ()
{
     nokia_write_data(0x00);
     nokia_write_data(0x00);
     nokia_write_data(0x00);
     nokia_write_data(0x00);
     nokia_write_data(0x00);
}    


void nagyszam(int x,int y,int szam)
{
  
   
  switch (szam){
  
  
     case 0:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      fullchar();
   
      nokia_gotoxy(x+5,y+1);
      ures();
      ures();
      fullchar();
   
      nokia_gotoxy(x,y+2);
      fullchar();
   
      nokia_gotoxy(x+5,y+2);
      ures();
      ures();
      fullchar();
     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
 

     break;
     
     case 1:
     nokia_gotoxy(x,y);
     ures();
     egy1();
     egy();
     fullchar();
     nokia_gotoxy(x,y+1);
     ures();
     ures();
     ures();
     fullchar();
     nokia_gotoxy(x,y+2);
     ures();
     ures();
     ures();
     fullchar();
     nokia_gotoxy(x,y+3);
     ures();
     ures();
     ures();
     fullchar();
     break;
     
      case 2:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      also2();
      also2();
      also2();
      fullchar();
   
   
      nokia_gotoxy(x,y+2);
      fullchar();
      felso2();
      felso2();
      felso2();

     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
  
 
     break;
     
     case 3:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      ures();
      also2();
      also2();
      fullchar();
   
      nokia_gotoxy(x,y+2);
      ures();
      felso2();
      felso2();
      fullchar();
   
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
  
 
     break;
     
     case 4:
      nokia_gotoxy(x,y);
      fullchar();
      nokia_gotoxy(x+5,y);
      ures();
      ures();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      fullchar();
      also2();
      also2();
      fullchar();
   
      nokia_gotoxy(x,y+2);
      felso2();
      felso2();
      felso2();
      fullchar();
     
      nokia_gotoxy(x,y+3);
      nokia_gotoxy(x,y+3);
      ures();
      ures();
      ures();
      fullchar();
  
 
     break;
     
     case 5:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      felso();
   
      nokia_gotoxy(x,y+1);
      fullchar();
      also2();
      also2();
      also2();
      
   
   
      nokia_gotoxy(x,y+2);
      felso2();
      felso2();
      felso2();
      fullchar();
     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
  
     break;
     
     case 6:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      fullchar();
      also2();
      also2();
      also2();
   
   
      nokia_gotoxy(x,y+2);
      fullchar(); 
      felso2();
      felso2();
      fullchar(); 
   
     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
 
     break;
     
        
     case 7:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
      nokia_gotoxy(x,y+1);
      ures();
      ures();
      ures();
      fullchar();
      nokia_gotoxy(x,y+2);
      ures();
      ures();
      fullchar();
      ures();
      nokia_gotoxy(x,y+3);
      ures();
      ures();
      fullchar();
      ures();
     break;
    
     case 8:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      fullchar();
      also2();
      also2();
      fullchar();
   
   
      nokia_gotoxy(x,y+2);
      fullchar();
      felso2();
      felso2();
      fullchar();
   
   
     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar();
 
     break;
     
     case 9:
      nokia_gotoxy(x,y);
      fullchar();
      felso();
      felso();
      fullchar();
   
      nokia_gotoxy(x,y+1);
      fullchar();
      also2();
      also2();
      fullchar();
      nokia_gotoxy(x,y+2);
      ures();
      ures();
      ures();
      fullchar();
      
      nokia_gotoxy(x,y+2);
      felso2();
      felso2();
      felso2();
      
     
      nokia_gotoxy(x,y+3);
      fullchar();
      also();
      also();   
      fullchar(); 
      break;
     
  }
  
  }
void degree(void) 
{ 
  nokia_write_data(0x00); 
  nokia_write_data(0x06); 
  nokia_write_data(0x09); 
  nokia_write_data(0x09); 
  nokia_write_data(0x06); 
  nokia_write_data(0x00); 

} 

void kolomp(void)
{
  nokia_write_data(0x30); 
  nokia_write_data(0x3E); 
  nokia_write_data(0x7F); 
  nokia_write_data(0x3E); 
  nokia_write_data(0x30); 
		 
}
  
void bee(void)
{
	
 nokia_write_data(0x5C); 
 nokia_write_data(0x22); 
 nokia_write_data(0x2F); 
 nokia_write_data(0x2A); 
 nokia_write_data(0x5C); 
	 
}

void on(void)
{
	nokia_write_command(0x20);
}

void off(void)
{
	nokia_write_command(0x24);
}


void nt (void) 
{ 
  nokia_write_data(0x02); 
  nokia_write_data(0x7E); 
  nokia_write_data(0x72); 
  nokia_write_data(0x08); 
  nokia_write_data(0x70);   

}

void aramsz (void) 
{ 
  nokia_write_data(0x38); 
  nokia_write_data(0x7E); 
  nokia_write_data(0x78); 
  nokia_write_data(0x7E); 
  nokia_write_data(0x38);   

}



  



  