#include "ds1820.h"
#include  <msp430g2553.h>
// ????????(???)
//unsigned char decimalH[16]={00,06,12,18,25,31,37,43,50,56,62,68,75,81,87,93};
//unsigned char decimalL[16]={00,25,50,75,00,25,50,75,00,25,50,75,00,25,50,75};


//ezmajd kell
//float decimalHH[16]={0.0,0.06,0.12,0.18,0.25,0.31,0.37,0.43,0.50,0.56,0.62,0.68,0.75,0.81,0.87,0.93};
int decimalH[16]={0,0,1,1,2,3,3,4,5,5,6,6,7,8,8,9};

unsigned char tempH,tempL;

unsigned char GetScratchpad[9];
//unsigned char ResultTemperatureH;  //???????
//unsigned char ResultTemperatureLH;  //???????(??)
//unsigned char ResultTemperatureLL;  //???????(??)



  unsigned char DS18B20_Init(void){
  unsigned char result;
  DS18B20_DIR |= DS18B20_DQ;       // ow output
  DS18B20_OUT &= ~DS18B20_DQ;      // DS18B20_DQ=0;
  DelayX10us(48);       // Bus master pulling low 480us minimum;
  DS18B20_OUT |= DS18B20_DQ;       // DS18B20_DQ=1;
  DelayX10us(6);        // Resister pull up 15-60us;
  DS18B20_DIR &= ~DS18B20_DQ;      // ow input
  result = DS18B20_IN & DS18B20_DQ;
  DS18B20_DIR |= DS18B20_DQ;       // ow output
  DelayX10us(48);       // End of timeslot total 480us;
  return(result);       // any 1 wire device ?result:=1 no devide; ?result:=0 have device;
}//Intialization the 1-wire devices;

unsigned char DS18B20_ReadBit(void){
  unsigned char result;
  DS18B20_DIR |= DS18B20_DQ;       // ow output
  DS18B20_OUT &= ~DS18B20_DQ;      // DS18B20_DQ=0;
  _NOP();               // Start of timeslot;
  DS18B20_OUT |= DS18B20_DQ;       // DS18B20_DQ=1;
  _NOP();_NOP();_NOP();_NOP();
          // Wait from the start;
  DS18B20_DIR &= ~DS18B20_DQ;      // ow input
  result = DS18B20_IN & DS18B20_DQ;
  DS18B20_DIR |= DS18B20_DQ;       // ow output
  return(result);       // return the result of the 1-wire devide;
}//Read a bit on the 1-wire bus;

void DS18B20_WriteBit(unsigned char oww_dat){
  DS18B20_DIR |= DS18B20_DQ;       // ow output
  DS18B20_OUT &= ~DS18B20_DQ;      // DS18B20_DQ=0;
  if (1 == oww_dat) 
    DS18B20_OUT |= DS18B20_DQ;     // DS18B20_DQ=1;
  DelayX10us(10);       // Remain the state for 100us;
  DS18B20_OUT |= DS18B20_DQ;       // DS18B20_DQ=1;
}//Write a bit to the 1-wire bus;

unsigned char DS18B20_ReadByte(void){
  unsigned char i;
  unsigned char result=0;
  for(i = 0; i < 8; i++){
    if(DS18B20_ReadBit())
      result |= 0x01 << i;
    DelayX10us(12);     // ??
  }
  return(result);       // return the result of the 1-wire device;
}//Read a byte from the 1-wire bus;

void DS18B20_WriteByte(unsigned char oww_dat){
  unsigned char i,temp;
  for(i = 0; i < 8; i++){
    temp = oww_dat >> i;
    temp &= 0x01;
    DS18B20_WriteBit(temp);
  }
  DelayX10us(7);        // ??
}//Write a byte to the 1-wire bus;

void DS18B20_ReadTemp(void)
{ //unsigned char tempH,tempL;
 DS18B20_Init();
 DS18B20_WriteByte(SkipRom);
 _NOP();
  //There is just one DS1820 on the bus;
 DS18B20_WriteByte(ConvertTemperature);
 DelayX10us(10);
  //Start to convert temperature;
 DS18B20_Init();
 DS18B20_WriteByte(SkipRom);
 _NOP();
 DS18B20_WriteByte(ReadScratchpad);
 GetScratchpad[0]=DS18B20_ReadByte();  //Master samples the LSB temperature from the scratchpad;
 GetScratchpad[1]=DS18B20_ReadByte();  //Master samples the MSB temperature from the scratchpad;
 GetScratchpad[2]=DS18B20_ReadByte();  //Master samples the Th register or userbyte1 from the scratchpad;
 GetScratchpad[3]=DS18B20_ReadByte();  //Master samples the Tl register or userbyte0 from the scratchpad;
 GetScratchpad[4]=DS18B20_ReadByte();  //Master samples the configuration register from the scratchpad;
 GetScratchpad[5]=DS18B20_ReadByte();  //Master samples the reservedbyte from the scratchpad;
 GetScratchpad[6]=DS18B20_ReadByte();  //Master samples the reservedbyte from the scratchpad;
 GetScratchpad[7]=DS18B20_ReadByte();  //Master samples the reservedbyte from the scratchpad;
 GetScratchpad[8]=DS18B20_ReadByte();  //Master samples the CRC from the scratchpad;
 tempH=(GetScratchpad[1] << 4) | (GetScratchpad[0] >> 4);
 tempL=(GetScratchpad[0] & 0x0f);
 DS18B20_Init();
  /*
 ResultTemperatureH=tempH;
 ResultTemperatureLL=decimalL[tempL];
 ResultTemperatureLH=decimalH[tempL];
  */
 }

/*
float ds1820_temp() 
 {
    float result;
    DS18B20_ReadTemp();
    DelayX10us(254); 
    result = tempH+decimalHH[tempL]; 
    return(result);

 }
 */
 
 int ds1820_egesz() 
 {
    int result;
    DS18B20_ReadTemp();
    DelayX10us(254); 
    result = tempH; 
    return(result);

 }
 
 int ds1820_tized() 
 {
    int result;
    DS18B20_ReadTemp();
    DelayX10us(254); 
    result = decimalH[tempL]; 
    return(result);

 }
 
 

void Delay10us(void){
  unsigned char i;
  for (i=0; i<(SMCLK/500-3); i++);
}


void DelayX10us(unsigned char x10us){
  unsigned int i;
  for (i=0; i<x10us; i++)
    Delay10us();
}

