#include  <msp430g2553.h>
#include  "3310.h"
#include  "ds1820.h"
#include "stdio.h"
#include "nev.h"



const unsigned char menuk[14][10] =
{"ra      ","Perc     ","Msodperc", "v       ", "Hnap    ", "Nap      ","Ht napja","Ht sorsz","br.ra  ","br.perc ","breszts","Csipogs ","Auto.T/NY","Inverz   "};

#define MENU BIT3
#define NEXT BIT4

#define SPK  BIT5

long Tday;
char temp,hr,min,sec,ehr,emin,idz;
int day,dweek,year,month,leepyear,mnu,hrbep,al,inv,bepa,tny,atny,bekap,dtz,parit,weekn;
unsigned char buff[11];
double hhj;

//******************************************************************************
//******************************************************************************

 void sor(char mmc,int y)
 {
     int i;
       for (i=0; i<84;i++)
       {
         nokia_gotoxy(i,y);
         nokia_write_data(mmc);
       }
 }    

//******************************************************************************
//******************************************************************************

 void ms()
  {
	__delay_cycles(5000);
  }

//******************************************************************************
//******************************************************************************


 void beep()
 {
  int i;
   for (i=0;i<100;i++)
   {
    P1OUT|=SPK; ms(); P1OUT &= ~SPK; ms();
   }

 }
 
//******************************************************************************
//******************************************************************************


 void leepyr()
{
 long ev = year +2000;
  if (((ev % 4 ) == 0) && ((ev % 100) != 0 ) || ((ev % 400) == 0))
    {leepyear=1;}
    else {leepyear=0;}
 }
 
//******************************************************************************
//******************************************************************************

void hszam() {month++; day=1;}

//******************************************************************************
//******************************************************************************


void evnapja()
 {
   int i;
   leepyr();
   Tday=0;
    for (i=1;i<month;i++)
    {
      switch (i)
      {
     case 1: Tday=Tday+31; break;
     case 2: if (leepyear==1) {Tday=Tday+29;} if (leepyear==0) {Tday=Tday+28;} break;
     case 3:Tday=Tday+31; break;
     case 4:Tday=Tday+30; break;
     case 5:Tday=Tday+31; break;
     case 6:Tday=Tday+30; break;
     case 7:Tday=Tday+31; break;
     case 8:Tday=Tday+31; break;
     case 9:Tday=Tday+30;break;
     case 10:Tday=Tday+31; break;
     case 11:Tday=Tday+30; break;
     
    }   
   }
  Tday=Tday+day;
}


//******************************************************************************
//******************************************************************************


void FlashWrite(char faddress, char word)
   {
     char *Flash_ptr; /* Flash pointer */
     Flash_ptr = (char *) 0x1040 + faddress; /* Initialize Flash pointer (segment B - start of info. memory) */
     FCTL1 = FWKEY + ERASE; /* Set Erase bit */
     FCTL3 = FWKEY; /* Clear LOCK bit */
     //*Flash_ptr = 0;                           // Dummy write to erase Flash segment
     FCTL1 = FWKEY + WRT; /* Set WRT bit for write operation */
     *Flash_ptr=word; /* Write the word to flash */
     FCTL1 = FWKEY; /* Clear WRT bit */
     FCTL3 = FWKEY + LOCK; /* Reset LOCK bit */
    } /* FlashWrite */


//******************************************************************************
//******************************************************************************

void FlashRead(char faddress)
   {

     char *Flash_ptr; 
     Flash_ptr = (char *) 0x1040 + faddress; 
     temp=*Flash_ptr;
   } /* Flashread*/


//******************************************************************************
//******************************************************************************


void buffer()
{printlcd(buff);}
  
//******************************************************************************
//******************************************************************************
  

void sprint(int aa)
{
sprintf(buff, "%02d\n",aa);
nokia_gotoxy(65,2);	
buffer();
}

//******************************************************************************
//******************************************************************************

 void save()
 {
      char resvec=*(char *)(0xFFFE);// save restart vector 
       FCTL3 = FWKEY;          // Lock = 0  A500 
       FCTL1 = 0xA502;    // ERASE = 1  0xA502   FWKEY+ERASE 
       *((char *)0x1040)=0; // erase Flash segment
    //*((char *)DAT1)=0; // erase Flash segment 
                                 // restore restart vector 
       FCTL1=FWKEY+WRT;        //Enable write 
       *(char *)0xFFFE= resvec;   //restore restart vector 
        FCTL1 = FWKEY;          /* disable erase and write */ 
        FCTL3 = FWKEY+LOCK;     /* set Lock = 1 */ 
   FlashWrite(1,75);
   FlashWrite(2,hr);
   FlashWrite(3,min);
   FlashWrite(4,year);
   FlashWrite(5,month);
   FlashWrite(6,day);
   FlashWrite(7,dweek);
   FlashWrite(8,ehr);
   FlashWrite(9,emin);
   FlashWrite(10,al);
   FlashWrite(11,hrbep);
   FlashWrite(12,inv);
   FlashWrite(13,tny);
   FlashWrite(14,atny);
   FlashWrite(15,weekn); 
   FlashWrite(16,sec);
     
  }
 

//******************************************************************************
//******************************************************************************

void inf()
{
    nokia_gotoxy(0,0);
    logo();
    __delay_cycles(70000000);
    nokia_clear_screen();
    nokia_gotoxy(0,0);printlcd("DecebaL Hw&Sw");
    nokia_gotoxy(0,1);printlcd("  Imre Huba");
    nokia_gotoxy(0,2);printlcd("decebal@inbox.");
    nokia_gotoxy(0,3);printlcd("     com      ");
    nokia_gotoxy(0,4);printlcd("Hw:1.0v 110907");
    nokia_gotoxy(0,5);printlcd("Sw:2.7v 111030");
    __delay_cycles(120000000);
    nokia_clear_screen();
}

//******************************************************************************
//******************************************************************************

void main(void)
{
   
     WDTCTL = WDTPW + WDTHOLD; 
    //WDTCTL = WDT_ADLY_250;                    // WDT 250ms, ACLK, interval timer
    //IE1 |= WDTIE;

    CCTL0 = CCIE;                             // CCR0 interrupt enabled
    CCR0 = 32768-1;
    TACTL = TASSEL_1 + MC_1;                  // ACLK, upmode
    
    //BCSCTL1 |= 0xF;             // 20Mhz  
    //DCOCTL |= 0x70;
    
    BCSCTL1 = CALBC1_16MHZ;                   // Set range
    DCOCTL = CALDCO_16MHZ; 
   	  
    P1REN |= MENU+NEXT;               // Btn1,Btn2: P1.4,P1.3 pullup
    P1IE  |= MENU+NEXT;               // Btn1,Btn2: P1.4,P1.3 interrupt enabled
    P1IES |= MENU+NEXT;               // Btn1,Btn2: P1.4,P1.3 Hi/lo edge
    P1IFG &= ~(MENU+NEXT);            // Btn1,Btn2: P1.4,P1.3 IFG cleared
    
    _BIS_SR(GIE);
    
    P1DIR = 0x20;
    P2DIR = 0x1F;
    P1OUT &= ~SPK;
    
    
    hr=12; min=27; sec=00; year=11; month=10; day=30; dweek=6;weekn=43;
    ehr=0; emin=0; idz=0; leepyear=0; mnu=0; hrbep=1; al=0;
    inv=0; bepa=0; tny=0; atny=1; bekap=1,dtz=0;parit=0;
    
 //****************************Flash Read**********************************    
   int hh=0;
   FlashRead(1);
   hh=temp;
   if (hh==75)
   {
   	FlashRead(2); hr=temp;
    FlashRead(3); min=temp;
    FlashRead(4); year=temp;
    FlashRead(5); month=temp;
    FlashRead(6); day=temp;
    FlashRead(7); dweek=temp;
    FlashRead(8); ehr=temp;
    FlashRead(9); emin=temp;
    FlashRead(10); al=temp;
    FlashRead(11); hrbep=temp;
    FlashRead(12); inv=temp;
    FlashRead(13); tny=temp;
    FlashRead(14); atny=temp;
    FlashRead(15); weekn=temp;
    FlashRead(16); sec=temp;
    
   
   } 

//****************************Flash Read**********************************

    evnapja();
    beep();
    nokia_init();
    inf();
    
    
    if (inv==0){normal();} 
    if (inv==1){invert();}
  
  
  DS18B20_Init();
  int t1,t2,t1x,t2x;
  
  
  
  
  
  
  while(1)
  {
  	
  //***************************raki*************************
  
   nokia_gotoxy(23,0);orapont();
   nokia_gotoxy(50,0);orapont();
   nokia_gotoxy(23,1);orapont();
   nokia_gotoxy(50,1);orapont();
   if (mnu==0)
   {
    sor(0x18,2);
   } 
  
  kszam(hr/10,1,0);
  kszam(hr%10,11,0);
   
  kszam(min/10,28,0);
  kszam(min%10,38,0);
   
  kszam(sec/10,55,0);
  kszam(sec%10,65,0);
  
  if (al==1){nokia_gotoxy(78,0);//bee();
   nokia_write_data(0x5C); nokia_write_data(0x22); nokia_write_data(0x2F); 
   nokia_write_data(0x2A); nokia_write_data(0x5C); }
  
  if (hrbep==1){nokia_gotoxy(78,1);	//kolomp();
  	 nokia_write_data(0x30); nokia_write_data(0x3E); nokia_write_data(0x7F); 
     nokia_write_data(0x3E); nokia_write_data(0x30);  }
  
  if (atny==1){nokia_gotoxy(78,5);
  	//tlinyri tn();
   nokia_write_data(0x02); nokia_write_data(0x7E); nokia_write_data(0x72); 
   nokia_write_data(0x08); nokia_write_data(0x70);	}
  
  if (bekap==1){nokia_gotoxy(78,0);
  	//aramsz();
    nokia_write_data(0x38);nokia_write_data(0x7E);nokia_write_data(0x78); 
    nokia_write_data(0x7E); nokia_write_data(0x38); }
  	
  //***************************raki vge*************************
  
  
  //***************************KIJELZS*************************	
	
	
	if ((parit==0)&&((dtz==0)||(dtz==8)||(dtz==14)||(dtz==20))){parit=1;sor(0x00,3);}
	
	if (dtz<8){nokia_gotoxy(0,3);sprintf(buff,"  20\f\%02d.\%02d.\%02d.\n ",year,month,day);buffer();}
	if ((dtz>=8)&&(dtz<14)){nokia_gotoxy(0,3);printlcd(honap[month-1]);sprintf(buff," \f%02d.\n",day);buffer();}
	if ((dtz>=14)&&(dtz<20)){nokia_gotoxy(0,3);printlcd(hetnap[dweek]);}
	if ((dtz>=20)&&(dtz<26)){nokia_gotoxy(0,3);sprintf(buff,"\f%02d.ht \%03d.nap",weekn,Tday);buffer();}
  	
  	
  	
    
    nokia_gotoxy(0,4);
  	 switch (month)
  	 {
     case 1:  printlcd(nevnap1[day-1]);  break;
     case 2:  printlcd(nevnap2[day-1]);  break;
     case 3:  printlcd(nevnap3[day-1]);  break;
     case 4:  printlcd(nevnap4[day-1]);  break;
     case 5:  printlcd(nevnap5[day-1]);  break;
     case 6:  printlcd(nevnap6[day-1]);  break;
     case 7:  printlcd(nevnap7[day-1]);  break;
     case 8:  printlcd(nevnap8[day-1]);  break;
     case 9:  printlcd(nevnap9[day-1]);  break;
     case 10: printlcd(nevnap10[day-1]); break;
     case 11: printlcd(nevnap11[day-1]); break;
     case 12: printlcd(nevnap12[day-1]); break;
  	 } 
    
    t1=ds1820_egesz();
    t2=ds1820_tized();
    if ((t1<126) && (t2<10))
     {
     	t1x=t1;
     	t2x=t2;
     }
      sprintf(buff, "Hfok:\f\%02d.%d\n",t1x,t2x);
      nokia_gotoxy(0,5);
      buffer(); //fokkijelzs
      nokia_write_data(0x00); nokia_write_data(0x06); nokia_write_data(0x09); 
      nokia_write_data(0x09); nokia_write_data(0x06); nokia_write_data(0x00); 
      printlcd("C ");   
    
   
   //***************************KIJELZS vge*************************
   
   
   
   //***************************Menu*************************
   
   if (mnu>0)
 	{  
        sor(0x00,2);
		nokia_gotoxy(0,2);
		printlcd(menuk[mnu-1]);
		if (mnu==8) {sprint(weekn); }
		if (mnu==9) {sprint(ehr); }
		if (mnu==10) {sprint(emin);}
		if (mnu==11) {sprint(al); }
		if (mnu==12) {sprint(hrbep);}
		if (mnu==13) {sprint(atny); }
		if (mnu==14) {sprint(inv);}
				
 	} 
   
   
   //***************************Menu vge*************************
   
   
   if ((al==1) && (ehr==hr) && (emin==min)) {beep();}
   if ((hrbep==1) && (min==0) && (sec==0) && (bepa==0)) {beep();bepa=1;}
  
   //***************************tlinyri*************************
   if (atny==1)
   {
   	 if ((month==10) && (day>24) && (dweek==6)&&(hr==2) && (min==0) && (sec==0) && (tny==0)){tny=1; hr--;}
     if ((month==3)  && (day>24) && (dweek==6)&&(hr==2) && (min==0) && (sec==0) && (tny==0)){tny=1; hr++;}
 	   	
   	//telinyari();
   	//***************************tlinyri vge*************************
   	}
         
  } ////////////////////////WHILE/////////////////////////////////// 
  
 
}

//******************************************************************************
//******************************************************************************

/*

// Watchdog Timer interrupt service routine
#pragma vector=WDT_VECTOR
__interrupt void watchdog_timer(void)
{

}*/


//******************************************************************************
//******************************************************************************

void frisit()

{mnu=0;save(); 
	beep(); }



//******************************************************************************
//******************************************************************************


// Timer A0 interrupt service routine
#pragma vector=TIMER0_A0_VECTOR
__interrupt void Timer_A (void)
{
  sec++;
  if ((dtz==0)||(dtz==10)||(dtz==18)){parit=0;}
  dtz++;
  if ((mnu>0) && (mnu<7)){dtz=0;parit=0;}
  if (mnu>=7){dtz=14;parit=0;}
  if (dtz>=25) {dtz=0;}
  if (mnu!=0)
  {
  //dtz=0;	
  idz++; if (idz>=210){idz=0;frisit();evnapja();}
  }
  bepa=0;
   if (sec>=60)
    {
    	min++;
    	sec=0;
        nokia_clear_screen(); 
    	if (min>=60)
    	  {
    	  	hr++;
    	  	min=0;
    	  	    	  	
    	  	 if (hr>=24)
    	  	 {
    	  	 	hr=0;sec=0;min=0;
//*************************HONAPRTC*********************************************************    	  	 	
    	  	 	
leepyr();	
   dweek++;
    if (dweek>=7){dweek=0;weekn++;}
   day++;
   Tday++;
    switch (month){
     case 1: if (day==32) {month++; day=1;} break;
     case 2: if ((leepyear==1) && (day==30)) {hszam();} if ((leepyear==0) && (day==29)) {hszam();} break;
     case 3:if (day==32) {hszam();}break;
     case 4:if (day==31) {hszam();}break;
     case 5:if (day==32) {hszam();}break;
     case 6:if (day==31) {hszam();}break;
     case 7:if (day==32) {hszam();}break;
     case 8:if (day==32) {hszam();}break;
     case 9:if (day==31) {hszam();}break;
     case 10:if (day==32) {hszam();}break;
     case 11:if (day==31) {hszam();;}break;
     case 12:if (day==32) {hszam(); if (month>=13){month=0;Tday=1;hszam();year++;weekn=1;}}break;
  
  } 


//*************************HONAPRTC*********************************************************    	  	 	
    	  	 
    	  	 	
    	  	 	tny=0;
    	  	   	frisit();
    	  	 	
    	  	 }
    	  }
    }
 
 
}


//******************************************************************************
//******************************************************************************


#pragma vector=PORT1_VECTOR
__interrupt void Port_1(void)
{
 idz=0;	
 bekap=0;
 if(!(P1IN&MENU)) {
  P1IFG &= ~(MENU);
  mnu++;
   if (mnu==15) {frisit();evnapja();}

 }

  if(!(P1IN&NEXT)) {
	
  //******************************rtk nvels******************************  
 	if (mnu>0)
 	{
   	   
 	 switch (mnu)
	 {
       case 1: hr++; if (hr>=24){hr=0;} break;
       case 2: min++; if (min>=60){min=0;} break;
       case 3: sec=0;  break;
       case 4: year++; if (year>=100){year=11;} break;
       case 5: month++; if (month>=13){month=1;} break;
       case 6: day++; if (day>=32){day=1;} break;
       case 7: dweek++; if (dweek>=7){dweek=0;} break;
       case 8: weekn++; if (weekn>=54){weekn=1;} break;
       case 9: ehr++; if (ehr>=24){ehr=0;} break;
       case 10: emin++; if (emin>=60){emin=0;} break; 
       case 11: al++; if (al>=2){al=0;} break;
       case 12: hrbep++; if (hrbep>=2){hrbep=0;} break;
       case 13: atny++; if (atny>=2){atny=0;} break;
       case 14: inv++; if (inv>=2){inv=0;}if (inv==0){normal();}; if (inv==1){invert();}; break;
     
    }	
  } 
   
//******************************rtk nvels******************************
	if (mnu==0)
	{
	 save();		
	}
}
beep();
__delay_cycles(3000000);
P1IFG &= ~(MENU);
P1IFG &= ~(NEXT);

}

