////////////////////////////////////////////////////////////////
//                DCF BigClock
//             Topor Zoltn - 2007. mrc.
//            http://www.hobbielektronika.hu/
////////////////////////////////////////////////////////////////
#include <16F876A.h>                    
#include <STDLIB.H>


#FUSES NOWDT, HS, NOPUT, NOPROTECT, BROWNOUT, NOLVP, NOCPD
#use delay(clock=20000000)
//#use rs232(baud=500,parity=N,rcv=PIN_A0,bits=8,stream=radio)

#define DAL_SCL   PIN_B4
#define DAL_SDA   PIN_B5
#define LED     PIN_B7
#define SIGNAL     PIN_B6 
#define CAP_PIN   PIN_A0

#use i2c(master,sda=DAL_SDA, scl=DAL_SCL, FORCE_HW)

#define XTAL_FREQUENCY  20000000
#define TIMER1_FREQUENCY (XTAL_FREQUENCY / 4)      // 20000000/4

#define SZD   "%02u"
#define SZDH  "%2u"

#define DECODE_DATE

#define TEMP_CORR    3

int16 TickCount   = 0;            
int32 Ticker;
boolean NeedMeasureTemp = true;
signed int temp_h;
int temp_l;

int act_disp_counter = 0;
int act_disp = 0;
int temp_count = 0;
boolean volt_mar_dcf = false;

#include <display.c>
#include <m_dcf77.c>
//#include <m_manchester.c>
#include <m_DS1621M.C>       

//======================================================================
void chtime() {
//======================================================================
   time.sec++;
   act_disp_counter++;
   if(act_disp_counter == 3) {                  
      act_disp++;
      if(act_disp == 3) {
         act_disp = 0;
         temp_count++;
         if(temp_count == 3) temp_count = 0;
      }
      act_disp_counter = 0;
   }
   if(time.sec == 60) {
      time.sec = 0;
      time.minute++;
      if(time.minute == 60) {
         time.minute = 0;
         time.hour++;
         if(time.hour == 24) {
            time.hour = 0;
            // dtum
            time.day++;
            switch (time.month) {
            case 1 : if(time.day==32)  { time.month++; time.day = 1; break; }  
            case 2 : if(time.year % 4 == 0) {
               if(time.day==30)  { time.month++; time.day = 1; break; } else
               { if(time.day==30)  { time.month++; time.day = 1; break; }
               }
            }
            case 3 : if(time.day==32)  { time.month++; time.day = 1; break; }
            case 4 : if(time.day==31)  { time.month++; time.day = 1; break; }
            case 5 : if(time.day==32)  { time.month++; time.day = 1; break; }
            case 6 : if(time.day==31)  { time.month++; time.day = 1; break; }
            case 7 : if(time.day==32)  { time.month++; time.day = 1; break; }
            case 8 : if(time.day==32)  { time.month++; time.day = 1; break; }
            case 9 :  if(time.day==31) { time.month++; time.day = 1; break; }
            case 10 : if(time.day==32) { time.month++; time.day = 1; break; }
            case 11 : if(time.day==31) { time.month++; time.day = 1; break; }
            case 12 : if(time.day==32) { time.month = 1; time.year++; time.day = 1; break; }
            }
            
         }
      }
   }
}


//======================================================================
void Initialize_RTC(void) {
//======================================================================
  Ticker = TIMER1_FREQUENCY;
  setup_timer_1( T1_INTERNAL | T1_DIV_BY_1 );
  enable_interrupts( INT_TIMER1 );
} 

//======================================================================
#int_RTCC
void RTCC_isr() {
//======================================================================
RedrawDisplay();
}

//======================================================================
#int_TIMER1                               
void TIMER1_isr()                         
//======================================================================
{
  Ticker -= 65535;
  if ( Ticker < 65536 ) {
     Ticker += TIMER1_FREQUENCY;
     chtime();
  }
} 

//======================================================================
#int_timer2
void isr_timer2(void) {
//======================================================================
   TickCount++;
   if(TickCount==150) {
      dcf77_get_input();
   }
}

//======================================================================
#int_EXT
void EXT_isr() {
//======================================================================
   dcf77_isr();
}

//======================================================================
void init() {
//======================================================================
   input(PIN_B0);

   ext_int_edge(L_TO_H);

   init_temp(0);
   setup_timer_0(RTCC_INTERNAL|RTCC_DIV_16);
   setup_timer_2(T2_DIV_BY_4,78,16);
   Initialize_RTC();
   enable_interrupts(INT_TIMER2);
   enable_interrupts(INT_RTCC); 
   enable_interrupts(INT_EXT);
   enable_interrupts(GLOBAL);

   TickCount = 0;
   dcf_index = 0;

   time.hour = 0;
   time.minute = 0;
   time.sec = 0;
   time.year = 11;
   time.month = 1;
   time.day = 1;

   set_tris_c(0x00000000);
}

//======================================================================
void DisplayTime(){
//======================================================================
   display_putc("\f");
   printf(display_putc, SZD,time.hour);   
   display_putc(":");
   printf(display_putc,SZD,time.minute);   
   display_putc(":");
   printf(display_putc,SZD,time.sec);   
   if(!volt_mar_dcf) {
      if(input(PIN_B0)) display_putc(".");
   }
}

//======================================================================
void DisplayDate(){
//======================================================================
   display_putc("\f");
   printf(display_putc,SZD,time.day);
   display_putc(".");
   printf(display_putc,SZD,time.month);   
   display_putc(".");
   printf(display_putc, SZD,time.year);               
  
}


//======================================================================
void DisplayTemp(){
//======================================================================
  if ((temp_h - TEMP_CORR)>=0)
  {
   printf(display_putc,"\f%d",temp_h - TEMP_CORR );  // ugyan nem megolds, de a kijelz beft magnak, a TEMP_CORR rtkkel korriglni kell
   if(bit_test(temp_l,7)) {
      display_putc(".5");
   } else {
      display_putc(".0");
   } display_putc(" C");  
  }
  else
  {
   if(bit_test(temp_l,7))
   {
      printf(display_putc,"\f%d",temp_h - TEMP_CORR+1 );  // ugyan nem megolds, de a kijelz beft magnak, a TEMP_CORR rtkkel korriglni kell
      display_putc(".5");
   }
   else
   {
      printf(display_putc,"\f%d",temp_h - TEMP_CORR );  // ugyan nem megolds, de a kijelz beft magnak, a TEMP_CORR rtkkel korriglni kell
      display_putc(".0");
   }
   display_putc(" C"); 
  }

                             
}                   

//======================================================================          
void main() {
//======================================================================
   init();
   for(;;) {
      if (dcf_time.HasNewTime) {
         dcf_time.HasNewTime = false;
         Ticker = TIMER1_FREQUENCY;
         time = dcf_time;
         time.sec = 0;//ez mr csak az j perc elsjnl fog beesni     
         volt_mar_dcf = true;//tbbet nem nullzdik perckezdetnl
         NeedMeasureTemp = true;
      }

      if(NeedMeasureTemp && act_disp==2) {
                                       // vagyis most jnne az els hmrsklet kirs,
                                       // de kijelzs eltt minden alkalommal beolvassa a DS1621-et
         disable_interrupts(INT_RTCC); // kirs interrupt leltva, belepofzhat az I2C kommunikciba
         output_low(SHIFT_RESET);      // shiftregiszter reset hogy ne legyen semmi a kijelzn
         temp_h = read_high_temp(0);          
         temp_l = read_low_temp(0);
         FlipBuffer();                 // ***
         ClearDisplay();               // alacsony pwm-nl villant egyet a kijelz
         FlipBuffer();                 // ***
         ClearDisplay();               // alacsony pwm-nl villant egyet a kijelz
         enable_interrupts(INT_RTCC);  // mstmr ki lehet rni a mrt rtket
      }                                                   

      if(act_disp<2) {                  
         DisplayTime();
         NeedMeasureTemp = true;       // idkijelzs, azaz a kvetkez hmrskletkijelzs eltt mrni kell 
      } else {
         if(act_disp==2) {
            NeedMeasureTemp=false;                           
            if( temp_count == 2) {
               DisplayDate();            
            } else {
               DisplayTemp();    
            }
         }
      }
      { IF (volt_mar_dcf)
        output_high(SIGNAL); }
       {if (time.hour == 7)                                                       // ON HOUR GONG
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}  
                                {if (time.hour == 7)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 8)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 8)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 9)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 9)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 10)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 10)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 11)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 11)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 12)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 12)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 13)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 13)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 14)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 14)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
         {if (time.hour == 15)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 15)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 16)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 16)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 17)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 17)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 18)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 18)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 19)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 19)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 20)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 20)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 21)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 21)
                                 if (time.minute == 0)    
                                 if (time.sec == 1)
                                 output_low(LED);}
        {if (time.hour == 22)
         if (time.minute == 0)
         if (time.sec == 0)                                       
         output_high(LED);}
                                {if (time.hour == 22)
                                 if (time.minute == 0)
                                 if (time.sec == 1)
                                 output_low(LED);} 
        
        
        
        
        
        

            
      
      FlipBuffer();                                            
   }
}
                                 
