; Define RC5 address of Remote Control
RemoteAddr	EQU	0x06

; Definition of Keys and key-codes on my remote control
; Code: 0278
R_ON		EQU	0x0C	;ON/OFF
R_NUM_0		EQU	0x00	;Number #0
R_NUM_1		EQU	0x01	;Number #1
R_NUM_2		EQU	0x02	;Number #2
R_NUM_3		EQU	0x03	;Number #3
R_NUM_4		EQU	0x04	;Number #4
R_NUM_5		EQU	0x05	;Number #5
R_NUM_6		EQU	0x06	;Number #6
R_NUM_7		EQU	0x07	;Number #7
R_NUM_8		EQU	0x08	;Number #8
R_NUM_9		EQU	0x09	;Number #9
R_NUM_1_11	EQU	0x0A	;Number #1-/11
R_NUM_2_12	EQU	0x23	;Number #2-/12
R_REC		EQU	0x37	;Record
R_ENTER		EQU	0x27	;Enter
R_TP		EQU	0x28	;I>
R_i			EQU	0x22	;<I
R_REWIND	EQU	0x32	;<<
R_FORWARD	EQU	0x34	;>>
R_PAUSE		EQU	0x30	;II
R_PLAY		EQU	0x35	;>
R_STOP		EQU	0x36	;STOP
R_PROG_UP	EQU	0x20	;Program+
R_PROG_DN	EQU	0x21	;Program-
R_MUTE		EQU	0x0D	;Mute
R_VOL_UP	EQU	0x10	;Volume+
R_VOL_DN	EQU	0x11	;Volume-
R_SAT_UP	EQU	0x14	;Saturation+
R_SAT_DN	EQU	0x15	;Saturation-
R_BRI_UP	EQU	0x12	;Brightness+
R_BRI_DN	EQU	0x13	;Brightness-
R_R			EQU	0x0E	;Red
R_G			EQU	0x2F	;Green
R_Y			EQU	0x3B	;Yellow
R_B			EQU	0x3C	;Blue

; Definition of Functions on the Propeller clock
SEC_CL		EQU	R_NUM_0		; Adjust time : Clear Seconds
SEC_UP		EQU	R_TP		; Adjust time : Increment Seconds
SEC_DN		EQU	R_i			; Adjust time : Decrement Seconds
MIN_UP		EQU	R_VOL_UP	; Adjust time : Increment Minutes
MIN_DN		EQU	R_VOL_DN	; Adjust time : Decrement Minutes
HOUR_UP		EQU	R_PROG_UP	; Adjust time : Increment Hours
HOUR_DN		EQU	R_PROG_DN	; Adjust time : Decrement Hours
DAY_UP		EQU	R_G			; Adjust Date : Increment Days
DAY_DN		EQU	R_R			; Adjust Date : Decrement Days
WDAY_UP		EQU	R_B			; Adjust Date : Increment Day of week
WDAY_DN		EQU	R_Y			; Adjust Date : Decrement Day of week
MON_UP		EQU	R_BRI_UP	; Adjust Date : Increment Month
MON_DN		EQU	R_BRI_DN	; Adjust Date : Decrement Month
YEAR_UP		EQU	R_SAT_UP	; Adjust Date : Increment Year
YEAR_DN		EQU	R_SAT_DN	; Adjust Date : Decrement Year
INDEX_UP	EQU	R_FORWARD	; Adjust index sensor Offset, rotate display left
INDEX_DN	EQU	R_REWIND	; Adjust index sensor Offset, rotate display right
; Toggle functions
BlueLine	EQU	R_REC		; Toggle Outer LED
TSecMode	EQU	R_NUM_1		; Toggle Arc / Dot second hand mode
DigiTime	EQU	R_NUM_2		; Digital Time
DigiDate	EQU	R_NUM_3		; Digital Date
TWDay		EQU	R_NUM_4		; Day of week display
AnaTime		EQU	R_NUM_5		; Analog Time
TTicks		EQU	R_NUM_6		; Analog Time Ticks
DemoM		EQU	R_PLAY		; Demo Mode
TRotation	EQU	R_NUM_7		; Rotation data
TextMode	EQU	R_NUM_1_11	; Scrolling Text Mode
TStaticText	EQU	R_NUM_2_12	; Static Text Mode
SET_SP		EQU	R_NUM_8		; Set Scrolling speed
STANDBY		EQU	R_ON		; Disable LEDs
;Base
NUM_9		EQU	R_NUM_9