; Define RC5 address of Remote Control
RemoteAddr	EQU	0x06

; Definition of Keys and key-codes on my remote control
; Code: 0552
R_ON		EQU	0x0C	;ON/OFF
R_NUM_0		EQU	0x00	;Number #0
R_NUM_1		EQU	0x01	;Number #1
R_NUM_2		EQU	0x02	;Number #2
R_NUM_3		EQU	0x03	;Number #3
R_NUM_4		EQU	0x04	;Number #4
R_NUM_5		EQU	0x05	;Number #5
R_NUM_6		EQU	0x06	;Number #6
R_NUM_7		EQU	0x07	;Number #7
R_NUM_8		EQU	0x08	;Number #8
R_NUM_9		EQU	0x09	;Number #9
R_NUM_1_11	EQU	0x0A	;Number #1-/11
R_NUM_2_12	EQU	0x2B	;Number #2-/12
;R_REC		EQU	0xXX	;Record
R_ENTER		EQU	0x2B	;Enter
;R_TP		EQU	0xXX	;I>
R_i			EQU	0x30	;<I
R_REWIND	EQU	0x32	;<<
R_FORWARD	EQU	0x34	;>>
R_PAUSE		EQU	0x30	;II
R_PLAY		EQU	0x35	;>
R_STOP		EQU	0x36	;STOP
R_PROG_UP	EQU	0x20	;Program+
R_PROG_DN	EQU	0x21	;Program-
R_MUTE		EQU	0x0D	;Mute
R_VOL_UP	EQU	0x10	;Volume+
R_VOL_DN	EQU	0x11	;Volume-
R_SAT_UP	EQU	0x1A	;Saturation+
R_SAT_DN	EQU	0x1B	;Saturation-
;R_BRI_UP	EQU	0xXX	;Brightness+
;R_BRI_DN	EQU	0xXX	;Brightness-
R_R			EQU	0x0D	;Red
R_G			EQU	0x11	;Green
R_Y			EQU	0x10	;Yellow
R_B			EQU	0x25	;Blue

; Definition of Functions on the Propeller clock
SEC_CL		; Adjust time : Clear Seconds
SEC_UP		; Adjust time : Increment Seconds
SEC_DN		; Adjust time : Decrement Seconds
MIN_UP		; Adjust time : Increment Minutes
MIN_DN		; Adjust time : Decrement Minutes
HOUR_UP		; Adjust time : Increment Hours
HOUR_DN		; Adjust time : Decrement Hours
DAY_UP		; Adjust Date : Increment Days
DAY_DN		; Adjust Date : Decrement Days
WDAY_UP		; Adjust Date : Increment Day of week
WDAY_DN		; Adjust Date : Decrement Day of week
MON_UP		; Adjust Date : Increment Month
MON_DN		; Adjust Date : Decrement Month
YEAR_UP		; Adjust Date : Increment Year
YEAR_DN		; Adjust Date : Decrement Year
INDEX_UP	; Adjust index sensor Offset, rotate display left
INDEX_DN	; Adjust index sensor Offset, rotate display right
; Toggle functions
BlueLine		; Toggle Outer LED
TSecMode	; Toggle Arc / Dot second hand mode
DigiTime	; Digital Time
DigiDate	; Digital Date
TWDay		; Day of week display
AnaTime		; Analog Time
TTicks		; Analog Time Ticks
DemoM		; Demo Mode
TRotation	; Rotation data
TextMode	; Scrolling Text Mode
TStaticText	; Static Text Mode
SET_SP		; Set Scrolling speed
STANDBY		; Disable LEDs

STANDBY		EQU	R_ON	;Stanby
SEC_UP		EQU	VOL_UP	;Seconds+
SEC_DN		EQU	VOL_DN	;Seconds-
MIN_UP		EQU	BAL_RI	;Minutes+
MIN_DN		EQU	BAL_LE	;Minutes-
HOUR_UP		EQU	CON_UP	;Hours+
HOUR_DN		EQU	CON_DN	;Hours+
DAY_UP		EQU	BRI_UP	;Day+
DAY_DN		EQU	BRI_DN	;Day-
MON_UP		EQU	SAT_UP	;Month+
MON_DN		EQU	SAT_DN	;Month-
YEAR_UP		EQU	HUE_UP	;YEAR+
YEAR_DN		EQU	HUE_DN	;YEAR-
INDEX_UP	EQU	PHA_UP	;Turn left
INDEX_DN	EQU	PHA_DN	;Turn right

BlueLine	EQU	F1		;External circle ON/OFF
DigiTime	EQU	F2		;Digital time ON/OFF
DigiDate	EQU	F3		;Date ON/OFF
AnaTime		EQU	F4		;CH.PIC	Anal ora     ki/be
TTicks		EQU	F5		;Analog points of seconds ON/OFF

DM			EQU	ASTRSK	;Demo Mode
TextMode	EQU	TEXT	;Text mode

;New commands
DemoM		EQU	DM			;Demo Mode
TSecMode 	EQU	MUTE		;?
TRotation  	EQU	ENTER		;Rotation speed
TStaticText	EQU FREEZE		;Static text
TWDay		EQU	EXIT		;Day of the week
WDAY_DN 	EQU	R_SAT_UP	;?
SEC_CL		EQU	NUM_0		;?
SET_SP		EQU	R_ENTER		;?
