;  Combined URC-9960B01 and URC-6960B00 Kameleon extender

;  assemble using S3C8ASM as follows:

;	s3c8asm 6960-9960ext.asm -l6960ext.lst -a6960ext.hex -D remote=6960 
;	s3c8asm 6960-9960ext.asm -l9960ext.lst -a9960ext.hex -D remote=9960 

;	Version	  ver	who	comments/changes/description
;	--------  ---	----	-----------------------------------------------------------------------
;	01/28/07  0.1	wmj	Initial Version (port of Nils Ekberg's 9960B00 EX2)
;	02/05/07  0.11	wmj	add conditional assembly to support 9960B01 version
;				  9960B01 does not fit with this version!
;	02/09/07  0.12	wmj	rearrange things in part 2 to make 9960B01 fit
;				  add blink on device change, won't fit on 9960B01
;				  start debug on 9960B01, correct entry point addresses, etc
;	02/12/07  0.2	wmj	B E T A  R E L E A S E
;	02/14/07  0.21	wmj	fixed bug in special protocol device search
;				fixed bug in "Shift-Cloaking" 
;	02/15/07  0.22	wmj	fixed bug in favorite ending up in keymove code
;				cleaned up some comments, more details, etc
;	02/19/07  0.23	wmj	W I D E  B E T A  R E L E A S E
;	02/21/07  0.30  wmj	add remap keys code (with conditional assembly) (abandoned in v0.34)
;				re-arrange code to make part1 smaller (to make remap fit)
;	02/24/07  0.31	wmj	split remap into two groups (abandoned in v0.34)
;				adjust RDF checking to deal with three variants, add signature for three variants
;	02/28/07  0.32	wmj	fix entry point in 9960 for RemapKey (abandoned in v0.34)
;				fix remap table for differences in 9960B01 and 6960B00 screen numbers
;	03/01/07  0.33	wmj	add version number in EEPROM
;	03/01/07  0.34	wmj	moved Xshift to $40:$7F, pseudo-device keys moved to $C0 and remap keys as in ROM
;				 and use ROM for remap keys, Fix RDF to match, remove variants (not necessary)
;	03/06/07  0.35	wmj	clean up comments in pause protocol mislabeled as ToadTog
;				clean up other comments and documentation
;				remove extra Load of RCA in KM section to save space
;				take out blink on device change (confusing, 6960 only)
;				add default initial HT configuration in EEPROM
;				change default backlight timer value on 9960 to 50 (6960 default set in RDF)
;				add more comments on invalidation of R_DevX for clarity
;	03/08/07  0.35	wmj	B E T A 2   R E L E A S E 
;	03/09/07  0.36	wmj	fixed conflict between shift-cloaking and remapped keys (Beta 2a release)
;	03/21/07  0.37  wmj	increase size of upgrade area, move new keymove area
;				remove terminator of old learn area, add "space waster" to test this feature
;	03/24/07  0.37	wmj	F I N A L   R E L E A S E posted to web
;	04/01/07  0.38	wmj	change PAUSE value to be increments of 100ms
;				add conditional assembly to write registers for special protocol debug 
;				change debug macros, keymoves and specials to use keynames
;	04/03/07  1.00	wmj	changed version number to word, updated to 1.00
;	04/18/07  1.01  wmj 	shortened Pause protocol by not re-searching and reading keymove
;			wmj 	fixed bug in LDKP for 1-key sequence
;			wmj	add brightness control special protocol
;			wmj	fix oddity with RC5/RC6 combo protocol interfering with special protocols, crashing remote
;	04/23/07  1.01	wmj	R E L E A S E   T O   W E B   F O R   V1.01
;	05/03/07  1.02	wmj	add write debug protocol, change writedebug address to variable
;				correct reset-remote device number (conflicted with another) - no impact on release builds
;				compute sizes (in bytes) of ee_part1 and ee_part2
;				fix bug in HT key special screen processing reported by joed in forum
;				add option to disable HT screen and treat HT button as "normal" device button
;				fix data location difference between RDF and extender on 9960 (new RDF for this release)
;				add conditional assembly for experimental (different signature) version
;				set screen to initial O_device on extender load
;	05/08/07		R E L E A S E   T O   W E B   F O R   V1.02
;	05/09/07  1.03	wmj	move screen handling from part 1 to part2 to to save Adv Code space
;				take out some debugging stuff to clean up source code
;	07/16/07		R E L E A S E   T O   W E B   F O R   V1.03
;	07/31/07  1.04	wmj	shrink special protocols by remembering address, remove re-search in protocol code
;				saves 20 bytes/protocol (ToadTog, DSM, LDKP)
;				remove default HT settings now that Extinstall works with this extender
;	09/06/07		fix bug in ignore first key (change JREQ to JRNZ)



	version		= 0104			;version number for EEPROM

; Assembler directives and their meaning

;		xorg	x			;set address of EEPROM to x
;		org	x			;set address of RAM to x
;		x = $$				;set variable x to current EEPROM address
;		x = $				;set variable x to current RAM address

;	Report which remote is being built 

	if	remote eq 6960
		  echo	Building extender for URC-6960B00
		  endif
	if	remote eq 9960
		  echo	Building extender for URC-9960B01
		  endif
	ifdef	experimental
		  echo  ***************** Experimental ******************
		  endif

		echo				;white space

; these conditional assembly flags will build in checking and debug options for debugging the extender
; when the extender is assembled for final use all of should not be defined

;		experimental	= 1		;use to change signature when debugging changes that require new RDF
;		noxmit		= 1		;do not transmit IR (RET only)
;		debugdevices	= 1		;build in debug devices
;		debugmacro	= 1		;build in debug macros
;		debugkeymove	= 1		;build in debug keymoves
;		debugtoadtog	= 1		;build in debug toadtog keymove
;		debugpause	= 1		;build in debug pause keymove
;		debugLDKP	= 1		;build in debug LDKP keymove
;		debugDSM	= 1		;build in debug DSM keymove
;		debugBright	= 1		;build in debug brightness control keymove
;		testbig		= 1		;waste lots of space in an upgrade to test moving upgrade upper limit
;		writeback	= 1		;write to EEPROM permanent parameters when change HT devices
;		InclDebugDev	= 1		;include debug device/protocol
;		InclReset	= 1		;include reset remote device/protocol
;		InclWriteDbg	= 1		;include write debug device/protocol
;		InclDefHT	= 1		;include default HT settings in extender build

; these conditional assembly flags control the extender build.  when the extender is assembled for final 
; use all of these symbols should be defined.

		InclToadTog	= 1		;include ToadTog protocol
		InclDSM		= 1		;include DSM protocol
		InclLDKP	= 1		;include LDKP protocol
		InclPause	= 1		;include pause protocol
		InclBright	= 1		;include brightness control protocol
		checkRDF	= 1		;check parameters from RDF
		defaultmacro	= 1		;build in the default macros for device control

; These values must be the same as the RDF 
; they are used to check assembly of the extender to ensure that the RDF matches the extender

	if	remote eq 6960
		  EEPROM_RDF	 = $800		;EEPROM Size
		  AdvCode_RDF_st = $480		;Advanced code (macro/keymove/fav) starting address
		  AdvCode_RDF_end= $731		;Advance code ending address
		  Upgrade_RDF	 = $100		;upgrade address
		  Shift_Key_RDF  = $7BC		;address of shift keycode
		  XShift_Key_RDF = $7C6		;address of Xshift keycode
		  HT_Key_RDF     = $0CB		;address of HT key 
		  BL_Timer_RDF	 = $1F		;address of backlight timer
		  VPT_Flags_RDF	 = $16		;address of VPT flags
		  Pseudokeys_RDF = $C0		;start of pseudo keys
		  endif

	if	remote eq 9960
		  EEPROM_RDF	 = $1000	;EEPROM Size
		  AdvCode_RDF_st = $600		;Advanced code (macro/keymove/fav) starting address
		  AdvCode_RDF_end= $F30		;Advance code ending address
		  Upgrade_RDF	 = $100		;upgrade address
		  Shift_Key_RDF  = $FBB		;address of shift keycode
		  XShift_Key_RDF = $FC5		;address of Xshift keycode
		  HT_Key_RDF     = $0CB		;address of HT key 
		  BL_Timer_RDF	 = $FFF		;address of backlight timer
		  VPT_Flags_RDF	 = $1A		;address of VPT flags
		  Pseudokeys_RDF = $C0		;start of pseudo keys
		  endif

; a series of checks to ensure that the extender will fit and matches the RDF description

	ifdef checkRDF				;do checking on parameters
		if ee_part2 lt oldkmend
		 echo Error: Part2 will not fit in EEPROM
		 endif
		if Part2RAM gt FF
		 echo Error: Part2 will not fit in RAM
		 endif
		if ee_main lt NewKeyMoveEnd
		 echo Error:  Part1 will not fit in EEPROM
		 endif
		if Part1RAM gt FF
		 echo Error: Part1 will not fit in RAM
		 endif
		if EEPROM_RDF ne EepromSize
		 echo Error: EEPROM size does not match RDF
		 endif
		if AdvCode_RDF_st ne NewKeyMoveArea
		 echo Error: New Keymove start does not match RDF
		 endif
		if AdvCode_RDF_end ne ee_main-1
		 echo Error: New Keymove end does not match RDF
		 endif
		if Upgrade_RDF ne UpgradeArea 
		 echo Error: Upgrade area does not match RDF
		 endif
		if Shift_Key_RDF ne Shift_Key
		 echo Error: Shift Key location does not match RDF
		 endif
		if XShift_Key_RDF ne XShift_Key
		 echo Erorr: XShift key location does not match RDF
		 endif
		if HT_Key_RDF ne HT_Key
		 echo Error: HT Key location does not match RDF
		 endif
		if Pseudokeys_RDF ne _CBL
		 echo Error: Pseudo keys do not match RDF
		 endif
		if VPT_Flags_RDF ne R_VPTFlag-Eep_offset
		  echo Error: VPT Flag register does not match RDF
		  endif
		if remote eq 6960
		  if BL_Timer_RDF ne R_BLTimer-Eep_offset
		    echo Error: Backlight timer register does not match RDF
		    endif ;BLtimer
		  endif ;remote
		if remote eq 9960
		  if BL_Timer_RDF ne BLTimerAddr
		    echo Error: Backlight timer address does not match RDF
		    endif ;BLtimer
		  endif ;remote
		endif ;checkRDF

; EEPROM utilization of this extender

	if	remote eq 6960
		  Checksum	 = 00		;$00:01		EEPROM Checksum
		  Signature	 = 02           ;$02:09		Remote signature
		  DeviceConfig	 = 0A		;$0A:15		configuration info for 6 devices
		  VPT_Flags	 = 16		;$16		flags for motion control, first key use
		  HTConfig	 = 17		;$17:1C		HT setup (X,T,V,C,M,O initial device indexes)
		  Favorite	 = 1E		;$1E		Favorite device index
		  BLtimer	 = 1F		;$1F		Backlight timer
		  OldKeyMoveArea = 20		;$20:xx		short keymove to load extender
		  ExtenderPart2	 = ee_part2	;$xx-FF		extender part 2, computed	
		  UpgradeArea	 = 100		;$100-xxx	upgrade area 
		  NewKeyMoveArea = 480		;$480		new keymove area start for larger upgrade area
		  NewKeyMoveEnd	 = ee_main-1	;$xx		new keymove area end, computed
		  ExtenderMain	 = ee_main	;$xx:7FE	extender main, computed
		  Shift_Key_Adr	 = Shift_Key	;$xx		Key definition used for  shift key ($02 default)
		  XShift_Key_Adr = XShift_Key	;$xx		Key definitino used for Xshift key ($44 default)
		  HT_Key_Addr	 = HT_Key	;$xx		key definition used for HT key ($12 default)
		  endif
	if	remote eq 9960
		  Checksum	 = 00		;$00:01		EEPROM Checksum
		  Signature	 = 02           ;$02:09		Remote signature
		  DeviceConfig	 = 0A		;$0A:19		configuration info for 9 devices
		  VPT_Flags	 = 1A		;$16		flags for motion control, first key use
		  HTConfig	 = 1D		;$1D:20		HT setup (X,T,V,C,M,O initial device indexes)
		  Favorite	 = 21		;$1E		Favorite device index
		  OldKeyMoveArea = 23		;$20:xx		short keymove to load extender
		  ExtenderPart2	 = ee_part2	;$xx-FF		extender part 2, computed	
		  UpgradeArea	 = 100		;$100-xxx	upgrade area 
		  NewKeyMoveArea = 600		;$600		new keymove area start for larger upgrade area
		  NewKeyMoveEnd	 = ee_main-1	;$xx		new keymove area end, computed
		  ExtenderMain	 = ee_main	;$xx:FFE	extender main, computed
		  Shift_Key_Adr	 = Shift_Key	;$xx		Key definition used for  shift key ($02 default)
		  XShift_Key_Adr = XShift_Key	;$xx		Key definition used for Xshift key ($44 default)
		  HT_Key_Addr	 = HT_Key	;$xx		key definition used for HT key ($12 default)
		  endif

		ee_part1_size	= Part1RAM	;size of extender part 1 (in upper memory)
		ee_part2_size	= Part2RAM	;size of extender part 2 (in lower memory)
		Lower_EEPROM	= $100-oldkmend ;space available in lower EEPROM
		Lower_Free	= Lower_EEPROM - ee_part2_size ; space available for extender 


; miscellaneous constants

	if	remote eq 6960
		  EepromSize	= 800		;EEPROM size is 2K
		  WriteDbgAddr	= 380		;EEPROM address for writing debug info
		  endif
	if	remote eq 9960
		  EepromSize	= 1000		;EEPROM size is 4K
		  WriteDbgAddr	= 400		;EEPROM address for writing debug info
		  endif

		Mac		= 80		;advance code type to indicate macro
		FavList		= 30		;advance code type to indicate favorite 
		KM		= 10		;advance code type to indicate keymove
		RAM		= FF00		;address for RAM
		Eep_offset	= 5A		;offset from EEPROM location to register location for setup info
		Delay100ms	= 3800		;DelayWW0 value for 100ms

; processor control registers used in this extender

		SP		= RD9		;Stack Pointer
		InstPtr		= RDA		;instruction pointer used for ENTER instructions
		STOPena		= RFB		;Stop enable register
		P0ena		= RF1		;Port 0 IRQ enable
		P0pend		= RF2		;Port 0 IRQ pending
		P2ena		= RE5		;Port 2 IRQ enable
		P2pend		= RE6		;Port 2 IRQ pending
		P3ena		= REF		;Port 3 IRQ enable

; mask values used in AND, OR and TM instructions
		
		IFlag_keyset	= 80		;flag a key event has been processed 
		IFlag_T0	= 20		;flag a T0 timeout event has been processed
		MotEna		= 40		;motion enable flag
		UseFirstKey	= 20		;use first key flag
		ShiftMask	= 80		;bitmap mask for shifting keys
		XShiftMask	= 40		;bitmap mask for Xshifting keys 

	if	remote eq 6960
		  IFlag_keymotion = 82		;flag that a key or motion event has been processed
		  KeyIRQena	= 7F		;enable key sense interrupts
		  endif
	if	remote eq 9960
		  IFlag_keymotion = 84		;flag that a key or motion event has been processed
		  KeyIRQena	= FF		;enable key sense interrupts
		  endif

; ROM entry points used by this extender

	if	remote eq 6960			;entry points in ROM for URC-6960B00
		  DelayWW0	= 010D		;Delay WW0 units
		  ReadWE	= 01EC		;Read WE bytes EEPROM[WWA] -> @WWC Preserves WE, advances WWC
		  PopWbWa	= 025F		;pop RCB ;pop RCA ;ret
		  LoadKeyMove	= 065E		;Load a key move at EEPROM[RR5] in EEPROM into RAM, C=1=success
		  SearchHeader	= 08E4		;search header for km/mac/fav, return header address in RR5A
		  GetHTKeyset	= 0C7B		;get HT keyset for R_Key, return in R5C and W5
		  SetBright 	= 0D07		;check for up/down key, increase/decrease brightness
		  DoNormalKey	= 2653		;do a normal key
		  SelectTimeout	= 26BC		;Select a timeout value, C=0=no timeout necessary
		  HandleTimeout	= 26FB		;Handle timeout and turn off backlight
		  SelScrHT	= 27D6		;Change Device to HT, select first screen for HT device 
		  DoKeyMove	= 284E		;Do a KeyMove
		  DebounceKeys	= 2C5F		;Debounced scan of keypad
		  ScanKeypad	= 2C7D		;scan the keypad for buttons pressed
		  WaitNoKeys	= 2CD5		;wait for no keys pressed, disable interrupts
		  Read255	= 303C		;Read 225 bytes EEPROM[WWA] -> FF00, Leaves WE=FF, WWC=FFFF, RR56=FF00
		  StartT0	= 315E		;Start Timer0
		  SetupPtrs	= 317D		;set WWA, WWC and WE to write setup data to EEPROM
		  WriteWE	= 0226		;write WE bytes @WWC to EEPROM[WWA]
		  WriteChecksum	= 325C		;calculate and write checksum in EEPROM
		  ScrollScr	= 33FF		;check for scroll key, then Scroll screen based on R_Scr
		  RemapKey	= 3450		;Convert R_Key based on type of R_DevA and R_Scr (ROM table)
		  BacklightOff	= 355F		;Turn off backlight
		  BacklightOn	= 3549		;Turn on backlight
		  ValidateKey	= 3569		;is key valid for current screen?  C=1=success
		  UpdateScreen	= 3431		;If key/screen matches table, update screen to new screen
		  SelectScreen	= 346C		;change current device to active device,screen to first screen for device
		  SetScreen	= 347B		;send R_Screen to screen controller
		  ResetRemote	= 2544		;restart remote
		  Blink		= 2D6F		;Blink LED once
		  Blink2Times	= 2D83		;Blink LED twice
		  BlinkW2Times	= 2D85		;Blink LED W2 times
		  StartBlinkXmit= 3493		;start blinking transmit lights on display
		  StopBlinkXmit	= 34A0		;stop blinking transmit lights on display
		  DelayXLong	= 2DB4		;really long delay (calls DelayMed twice)
		  DelayLong	= 35B1		;long delay ($C2E5)
		  DelayMed	= 2DB7		;medium delay ($74C2)
		  DelayShort	= 2D1E		;short delay ($02BC)
		  endif
	if	remote eq 9960			;entry points in ROM for URC-9960B01
		  DelayWW0	= 010D		;Delay WW0 units
		  ReadWE	= 0C68		;Read WE bytes EEPROM[WWA] -> @WWC Preserves WE, advances WWC
		  PopWbWa	= 0CDB		;pop RCB ;pop RCA ;ret
		  LoadKeyMove	= 1238		;Load a key move at EEPROM[RR5] in EEPROM into RAM, C=1=success
		  SearchHeader	= 106F		;search header for km/mac/fav, return header address in RR5A
		  GetHTKeyset	= 166D		;get HT keyset for R_Key, return in R5C and W5
		  SetBright 	= 093C		;check for up/down key, increase/decrease brightness
		  DoNormalKey	= 0295		;do a normal key
		  SelectTimeout	= 02EA		;Select a timeout value, C=0=no timeout necessary
		  HandleTimeout	= 0329		;Handle timeout and turn off backlight
		  SelScrHT	= 0DFB		;Change Device to HT, select first screen for HT device 
		  DoKeyMove	= 2DF8		;Do a KeyMove
		  DebounceKeys	= 327D		;Debounced scan of keypad
		  ScanKeypad	= 329B		;scan the keypad for buttons pressed
		  WaitNoKeys	= 32F3		;wait for no keys pressed, disable interrupts
		  Read255	= 36D1		;Read 225 bytes EEPROM[WWA] -> FF00, Leaves WE=FF, WWC=FFFF, RR56=FF00
		  StartT0	= 05FC		;Start Timer0
		  SetupPtrs	= 061B		;set WWA, WWC and WE to write setup data to EEPROM
		  WriteWE	= 0CA2		;write WE bytes @WWC to EEPROM[WWA]
		  WriteChecksum	= 06F7		;calculate and write checksum in EEPROM
		  ScrollScr	= 0775		;check for scroll key, then Scroll screen based on R_Scr
		  RemapKey	= 07C6		;Convert R_Key based on type of R_DevA and R_Scr (ROM table)
		  BacklightOff	= 08A2		;Turn off backlight
		  BacklightOn	= 0897		;Turn on backlight
		  ValidateKey	= 08B5		;is key valid for current screen?  C=1=success
		  UpdateScreen	= 07A7		;If key/screen matches table, update screen to new screen
		  SelectScreen	= 07E2		;change current device to active device,screen to first screen for device
		  SetScreen	= 07F1		;send R_Screen to screen controller
		  ResetRemote	= 0176		;restart remote
		  Blink		= 33FF		;Blink LED once
		  Blink2Times	= 3412		;Blink LED twice
		  BlinkW2Times	= 3414		;Blink LED W2 times
		  StartBlinkXmit= 0809		;start blinking transmit lights on display
		  StopBlinkXmit	= 0816		;stop blinking transmit lights on display
		  DelayXLong	= 3449		;really long delay (calls DelayMed twice)
		  DelayLong	= 0934		;long delay ($C2E5)
		  DelayMed	= 344C		;medium delay ($74C2)
		  DelayShort	= 333A		;short delay ($02BC)
		  endif

; Register and register address definitions

	if	remote eq 6960			;register definition for URC-6960B00
		  R_MacFlags	= R00		;bit 5 used to signal in macro
		  R_T0		= R60		;Timer0 countdown value
		  R_SFlags	= R62		;(X)Shift flags
		  R_Dev		= R7A		;Current DevIndex
		  R_FlagsHT	= R7C		;HT Flag
		  R_FavIndex	= R7F		;Position within Fav list
		  R_DevA	= R81		;Active DevIndex
		  R_IFlags	= R82		;Interrupt flags
		  R_Screen	= R84		;current screen
		  R_XFlags	= R85		; some form of flag but not understood
		  R_Key1	= R89		;debounced key from scan keypad
		  R_Key		= R8B		;current key
		  R_Closures	= R8C		;number of keys found while scanning keypad
		  R_Remapped	= RAD		;flag to indicate that key was remapped
		  R_ScreenCall	= RB0		;used to hold address of ROM call for screen handling
		  R_KMAddr	= RB2		;used to save keymove addresses for use in special protocols
		  W_Key		= RC7 
		  R_AdvCodeKey	= R06		;key code returned by SearchHeader
		  R_AdvCodeDev	= R07		;"from device" valid only for keymove returned by SearchHeader
		  R_AdvCodeLen	= R08		;length of adv code returned by SearchHeader
		  R_AdvCodeType	= R09		;type of adv code (in upper nibble) returned by SearchHeader
		  R_FavNumber	= R07		;number of favorite entries for FAV advance codes
		  R_FavFirstKey	= R08		;first key in the favorite/scan list
		  R_AdvSearchKey= R0A		;search key for ROM adv code search routine
		  R_AdvSearchDev= R0B		;search key for ROM adv code search routine
		  R_AdvSearchType= R0C		;search type for ROM adv code search routine
		  R_AdvSearchFlag= R0D		;search flag for ROM adv code search routine	
		  R_Mac		= R3E		;Macro pointer
		  AR_MacBuf	= 3F		;Start of macro buffer
		  R_MacLast	= R51		;Last byte of macro buffer
		  AR_MacLim	= 52		;end of macro buffer + 1
		  endif
	if	remote eq 9960			;register definition for URC-9960B01
		  R_MacFlags	= R00		;bit 5 used to signal in macro
		  R_T0		= R60		;Timer0 countdown value
		  R_SFlags	= R62		;(X)Shift flags
		  R_Dev		= R7D		;Current DevIndex
		  R_FlagsHT	= R7F		;HT Flag
		  R_FavIndex	= R82		;Position within Fav list
		  R_DevA	= R8A		;Active DevIndex
		  R_IFlags	= R8B		;Interrupt flags
		  R_Screen	= R85		;current screen
		  R_XFlags	= R86		; some form of flag but not understood
		  R_BLTimer	= R89		;Backlight Timer, not in EEPROM on 9960B01, read at extender load
		  AR_BLTimer	= 89
		  R_Key1	= R8F		;debounced key from scan keypad
		  R_Key		= R91		;current key
		  R_Closures	= R92		;number of keys found while scanning keypad
		  R_Remapped	= RAD		;flag to indicate that key was remapped
		  R_ScreenCall	= RB0		;used to hold address of ROM call for screen handling
		  R_KMAddr	= RB2		;used to save keymove addresses for use in special protocols
		  W_Key		= RC7 
		  R_AdvCodeKey	= R06		;key code returned by SearchHeader
		  R_AdvCodeDev	= R07		;"from device" valid only for keymove returned by SearchHeader
		  R_AdvCodeLen	= R08		;length of adv code returned by SearchHeader
		  R_AdvCodeType	= R09		;type of adv code (in upper nibble) returned by SearchHeader
		  R_FavNumber	= R07		;number of favorite entries for FAV advance codes
		  R_FavFirstKey	= R08		;first key in the favorite/scan list
		  R_AdvSearchKey= R0A		;search key for ROM adv code search routine
		  R_AdvSearchDev= R0B		;search key for ROM adv code search routine
		  R_AdvSearchType= R0C		;search type for ROM adv code search routine
		  R_AdvSearchFlag= R0D		;search flag for ROM adv code search routine
		  R_Mac		= R3E		;Macro pointer
		  AR_MacBuf	= 3F		;Start of macro buffer
		  R_MacLast	= R51		;Last byte of macro buffer
		  AR_MacLim	= 52		;end of macro buffer + 1
		  endif

; EEPROM registers that are read by default at startup

	if	remote eq 6960			;EEPROM config information for URC-6960B00
						;EEPROM[0A:15] device setup codes
		  R_VPTFlag	= R70		;EEPROM[16]  SStep/Motion/VPT flag 
		  R_DevTbl	= R71		;            beginning of HT device table
		  R_DevX	= R71		;EEPROM[17]  Temporary DevIndex
		  AR_DevT	= 72		;EEPROM[18]  HT Transport device
		  AR_DevV	= 73		;EEPROM[19]  HT Volume device
		  AR_DevC	= 74		;EEPROM[1A]  HT Channel device
		  AR_DevM	= 75		;EEPROM[1B]  HT Menu device
		  R_DevO	= R76		;EEPROM[1C]  HT Other device
		  R_EEPsize	= R77		;EEPROM[1D]  EEPROM size code
		  R_FavDev	= R78		;EEPROM[1E]  FAV device
		  R_BLTimer	= R79		;EEPROM[1F]  Backlight Timer
		  HTConfig	= 17		;$17:1C	     HT setup (X,T,V,C,M,O initial device indexes)
		  Favorite	= 1E		;$1E	     Favorite device index
		  BLtimer	= 1F		;$1F	     Backlight timer
		  endif

	if	remote eq 9960			;EEPROM config information for URC-9960B01
						;EEPROM[0A:19] device setup codes
		  R_VPTFlag	= R74		;EEPROM[1A]  SStep/Motion/VPT flag   
		  R_DevTbl	= R75		;            beginning of HT device table
		  R_DevX	= R75		;EEPROM[1B]  Temporary DevIndex
		  AR_DevT	= 76		;EEPROM[1C]  HT Transport device
		  AR_DevV	= 77		;EEPROM[1D]  HT Volume device
		  AR_DevC	= 78		;EEPROM[1E]  HT Channel device
		  AR_DevM	= 79		;EEPROM[1F]  HT Menu device
		  R_DevO	= R7A		;EEPROM[20]  HT Other device
		  R_EEPsize	= R7B		;EEPROM[21]  EEPROM size code
		  R_FavDev	= R7C		;EEPROM[22]  FAV device
		  HTConfig	= 1B		;$1B:20	     HT setup (X,T,V,C,M,O initial device indexes)
		  Favorite	= 22		;$22	     Favorite device index
		  endif

Sig:		xorg	Signature
		org	Signature

	if	remote eq 6960
		  ifdef	experimental
		    db 	4F,4B,36,58,4F,4B,36,58	;Signature OK6XOK6X
		    else
		    db 	4F,4B,36,30,4F,4B,36,58	;Signature OK60OK6X
		    endif ;experimental
		  endif ;remote
	if	remote eq 9960
		  ifdef	experimental
		    db	4B,41,53,58,4B,41,53,58	;Signature KASAKASX
		    else
		    db	4B,41,53,41,4B,41,53,58	;Signature KASAKASX
		    endif ;experimental
		  endif ;remote

Devices:	xorg	DeviceConfig
		org	DeviceConfig

	ifdef	debugdevices
		  echo Default Devices: Installing default devices CBL/1170, TV/1105 and TV/1110
		  dw	0492			;CBL= CBL/1170 built-in DishPVR 721 (6960 only)
		  dw	102F			;TV=  TV/0047  built-in RCA/ProScan TV
		  dw	1454			;VCR= TV/1108  restart remote
		  dw	1451			;DVD= TV/1105  upgrade Samsung DLP TV
		  endif

OldKM:		xorg	OldKeyMoveArea		;keymove in old keymove area to load extender
		org	OldKeyMoveArea
		db	Power			;key for keymove
		db	11			;Type = $10 (keymove), device = TV ($01)
		db	04			;keymove length
		dw	1708			;1=TV, $708=1800
		dw	0012			;hex command
		db	FF			;mark end of old keymove area
		oldkmend = $$


HT_config:	xorg	HTConfig		;fill in intial HT configuration data
		org	HTConfig
	ifdef	InclDefHT
		  db	00,00,00,00,00,00	;all initial HT devices set to CBL (00)
		  endif


; Key codes used in this extender

		Shift		= Setup		;can be changed by IR
		XShift		= Setup		;can be changed by IR

		Setup		= 02		;miscellaneous keys used by extender
		Power		= 03
		HT     		= 12
		Home		= 13
		Scroll  	= 18
		Info		= 31		;these are used in debug macros, keymoves and special protocols
		Menu		= 14
		Guide		= 25
		Exit		= 32
		OK		= 27
		Input		= 33

		TV     		= 01		;device key values (for making initial macros)
		VCR    		= 0A
		CBL    		= 11
		DVD    		= 21
		AUDIO  		= 22
		PVR    		= 26
		CD_		= 09		;CD and AUX only valid for 9960B01, underscore because CD is a hex digit
		AUX		= 23

	if	remote eq 6960			;
		  Format 	= 23		;format key
		  Enter		= 09		;Enter key
		  endif
	if	remote eq 9960
		  Format 	= 3A		;format key
		  Enter		= 39		;Enter key
		  endif


; define phantom codes for device selection.  The logic to test temporary device selection requires
; that X_Cancel be the 8th device (56 keys from the first key), thus the empty slots on the 6960 remote.  
; there must be no unshifted keys with keycode values higher than the first pseudo-device selection keys
; since the extender assumes that any key after PseudoBase is a device selection key

		X_CANCEL	= F0		;cancel temp device index
		NumHTkey	= O_ +1		;number of HT keysets
		PseudoBase	= C0		;where the pseudo keys start
	if	remote eq 6960
		  NumDev	= 6		;6 devices for URC-6960B00
		  endif
	if	remote eq 9960
		  NumDev	= 8		;8 devices for URC-9960B01
		  endif

		_CBL		= PseudoBase	;stack all of the pseudo-device selection keys up starting at PseudoBase
		_TV		= _CBL+NumHTkey
		_VCR		= _TV+ NumHTkey
		_DVD		= _VCR+NumHTkey
	if	remote eq 9960 
		_CD		= _DVD+NumHTkey
		_PVR		= _CD +NumHTkey
		endif
	if	remote eq 6960
		_PVR		= _DVD+NumHTkey
		endif
		_AUD		= _PVR+NumHTkey
		_AUX		= _AUD+NumHTkey
 	
		O_		= M_ +1		;Other (must always be the highest number)
		M_		= C_ +1		;Menu
		C_		= V_ +1		;Channel
		V_		= T_ +1		;Volume
		T_		= X_ +1		;Transport
		X_		= 0		;Temporary device selection

		xorg	NewKeyMoveArea				
		org	NewKeyMoveArea

	ifdef	defaultmacro			;initial device macros to make remote work
		  echo Macro:           Installing default macros for device keys
;			Key	type len  Menu    Channel  Volume    Trans     Other
		  db	CBL,    Mac,  5, M_+_CBL, C_+_CBL, V_+_CBL, T_+_CBL, O_+_CBL
		  db	HT,     Mac,  5, M_+_CBL, C_+_CBL, V_+_TV,  T_+_CBL, O_+_CBL
		  db	TV,     Mac,  5, M_+_TV,  C_+_TV,  V_+_TV,  T_+_TV,  O_+_TV
		  db	VCR,    Mac,  4, M_+_VCR, C_+_VCR,          T_+_VCR, O_+_VCR
		  db	DVD,    Mac,  4, M_+_DVD, C_+_DVD,          T_+_DVD, O_+_DVD
		  db	PVR,    Mac,  4, M_+_PVR, C_+_PVR,          T_+_PVR, O_+_PVR
		  db	AUDIO,  Mac,  4, M_+_AUD, C_+_AUD, V_+_AUD,          O_+_AUD
		  if	remote eq 9960
		    db	CD_,	Mac,  3, M_+_CD,                    T_+_CD,  O_+_CD
		    db	AUX,    Mac,  5, M_+_AUX, C_+_AUX, V_+_AUX, T_+_AUX, O_+_AUX
		    endif ;remote eq 9960
		  endif ;defaultmacro
	ifdef	debugmacro
		  echo Macro:           Installing debug macros
		  xorg	$$
		  db	CBL, Mac, 6, X_+_CBL,T_+_TV, V_+_VCR,C_+_DVD,M_+_PVR,O_+_AUD	;devtbl=0,1,2,3,4,5
		  db	TV,  Mac, 6, X_+_AUD,T_+_PVR,V_+_DVD,C_+_VCR,M_+_TV, O_+_CBL	;devtbl=5,4,3,2,1,0
		  db	19,  Mac, 5, 1F, 1E, 1D, 1C, 1B					;0,9,8,7,6
		  endif
	ifdef	debugkeymove
		  echo KeyMove:         Installing debug Keymoves, Keys 1/2-CBL, 1/2-TV
		  xorg	$$
		  db	15,KM,  04,  04,92, 00,33 ;1/CBL/1170(ROM) $2C
		  db	16,KM,  03,  04,92, 31	  ;2/CBL/1170(ROM) Key=Info
		  db	15,KM+1,04,  14,51, 00,F7 ;1/TV /1105(UPG) menu
		  db	16,KM+1,03,  14,51, 31    ;2/TV /1105(UPG) key=info
		  endif
	ifdef	debugtoadtog
		  echo ToadTog:         Installing debug ToadTog, Key TV/Menu
		  xorg	$$
		  db	Menu,KM+1,08,   27,08, 13,03,19,1A,16,17 ;Menu/TV, toggle, key=power,4,4,5/2,3
		  endif
	ifdef	debugDSM
		  echo DSM:             Installing debug DSM, Key=TV/Info
		  xorg	$$
		  db	Info,KM+1,07,   14,4F, 15,16,17,19,1A    ;Info/TV, key=1,2,3,4,5
		  endif
	ifdef	debugpause
		  echo Pause:           Installing debug Pause, key=TV/Format-Enter
		  xorg	$$
		  db	Format,KM+1,03, 14,50,  64	;Pause, key=TV/Format, duration=64 (10 sec)
		  db	Enter,KM+1,03,  14,50,  C8	;Pause, key=TV/Enter,  duration=3C (20 sec)
		  endif
	ifdef	debugBright
		  echo Brightness:      Installing debug brightness control key=TV/Format
		  xorg	$$
		  db	Input,KM+1,03,  14,56,  00	;Brigtness, key=TV/Input
		  endif
	ifdef	InclWriteDbg
		  echo Write Debug:     Installing write debug info key key=TV/OK
		  xorg	$$
		  db	OK,KM+1,03,  14,55,  00		;WriteDebug, key=TV/OK
		  endif
	ifdef	debugLDKP
		  echo LDKP:            Installing debug LKP, key=TV/Guide
		  echo DKP:             Installing debug DKP, key=TV/Exit
		  xorg	$$
		  db	Guide,KM+1,07,  14,52, 52, 16,17,19,1A ;LKP,TV/Guide, duration=5, short=2,3/long=4,5
		  db	Exit,KM+1,0A,  14,52, 2C, 16,17,19,1A,1B,1C,1D ;DKP,TV/Exit, dur=2, sgl=2,3,5,4/dbl=6,7,8
		  endif
		db	FF			;signal end of advance code area

; ------------- Device/Protocol upgrade table  ------------------------------------------

		xorg	UpgradeArea		;new upgrade area
		org	UpgradeArea
		dw	D_table			;address of device upgrade table 
		dw	P_table			;address of protocol upgrade table
	
		DT_index = 0			;Initialize counters and variables for building D and P tables
		P_addr  = D_addr		;protocol table starts after device table, computed 2nd pass


; ------------- Device/Protocol upgrades for loading the extender -----------------------

TV_1800:	db	80			;Protocol = $180
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;Update D_addr to point to the end of this device

		xorg	P_addr			;start after end of last protocol upgrade
		org	$$

Protocol_180:	db	00,00,01		;protocol header

		org	RAM
		CALL	StopBlinkXmit		;stop blinking transmit LED's
		CALL	Blink2Times		;Blink LED 2 times to indicate extender loaded
		CLR	R_SFlags		;clear Shift flag

	if	remote eq 9960			;9960 does not have EEPROM setting for BL Timer by default
		  LDW	RCA, BLTimerAddr	;address of BL Timer value
		  LDW	RCC, AR_BLTimer		;address of register for Backlight Timer value from EEPROM
		  LD	RCE,#01			;one byte for read
		  CALL	ReadWE			;read WE bytes
		  endif 

		LD	R_Dev,R_DevO		;Set initial screen to initial O_ device specified by IR
		LDW	R_ScreenCall,SelectScreen ;Enable normal screen processing
		CALL	@R_ScreenCall

		LDW	RCA, ee_main		;Address of extender in eeprom
		LDW	InstPtr, Main		;load start address in ee_main for return from Read255
		ENTER	Read255			;Read 225 bytes EEPROM[WWA] -> FF00 and then execute extender at Main

		P_addr = $$			;update P_addr to point to the end of this protocol

		xorg	D_table+2+DT_index+DT_index ;address of next entry in device table
		org	$$
		dw	1F08			;Type=TV, Protocol>255, setup code = $708 = 1800
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1800			;address of TV 1800 in EEPROM

		xorg	P_table+2+DT_index+DT_index ;address of next entry in protocol table
		org	$$
		dw	180			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_180		;address of protocol_180 in EEPROM

		DT_index = DT_index+1		;update number of device upgrades

; ------------- Device/Protocol for restarting remote ------------------------------------
; ------------- Press "Menu" and the remote will restart without extender ----------------

	ifdef	InclReset
		echo Device/Protocol: Installing device/protocol for Reset Remote
		xorg	D_addr			;Address for next device
		org	$$
						
TV_1108:	db	F8			;Protocol = 0x1F8
		db	00			;no digit map
		db	05			;defined key maps (menu key only)
		db	C5			;fake key value for menu key
		D_addr = $$			;update address for next device in table

		xorg	P_addr			;Address for next protocol
		org	$$

Protocol_1F8:	db	00,00			;no clock
		db	01			;0 fixed, 1 variable

		JP	ResetRemote		;restart remote

		P_addr = $$			;update address for next protocol

		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C54			;Type=TV, Protocol>255, setup code = $454 = 1108
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1108			;address of TV_1108

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1F8			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1F8		;address of Protocol_1FB
		DT_index = DT_index+1		;update number of devices
		endif				;InclRestart

; ------------- Device/Protocol for testing upgrades ------------------------------------

	ifdef	InclDebugDev
		echo Device/Protocol: Installing device/protocol for testing upgrades
;		builtin	= 1			;use builtin protocol if defined
		xorg	D_addr			;Address for next device
		org	$$
						;upgrade for Samsung TV, uses either builtin protocol 5A
						; or copy of 5A that is installed as an upgrade 1FA
TV_1105:

;		builtin 	= 1		;remove this comment to make this upgrade use the builtin protocol
	ifdef	builtin
		  db	5A			;protocol=5A  built-in
		  else
		  db	FA			;protocol=1FA upgrade
		  endif

		db	18			;digit map $18
		db	7E,FE,00,81		;defined key maps
		db	31,1F,1F		;fixed data
		db	1F,2F,0F,B7,F7,BF,2B	;data for defined keys
		db	A7,F9,79,59,B9,07,E9
		db	4B,E9


;	this block to take up space to test moving upgrades into the old learn area and shifting 
;	new advance code area further up.  This space forces the upgrade area to take up the entire 
; 	upgrade space and forces the entire upgrade table to be above the old boundary for learns


	ifdef	testbig
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		  dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		if  remote eq 9960
		    dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		    dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		    dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		    dw	DEAD,DEAD,DEAD,DEAD,DEAD,DEADDEAD,DEAD,DEAD,DEAD,DEAD,DEAD
		    endif ;remote
		  endif ;testbig

		D_addr = $$			;update address for next device in table

		xorg	P_addr			;Address for next protocol
		org	$$

Protocol_1FA:		        		;-- copy of Protocol 005A from 6960B00 ROM
		db	$43,$8B 		;38.095 kHz 33% duty cycle
		db	$31     		;3 Fixed, 1 Variable
		JR	L1FA_1
				    		;pf0.0-1: IrDev = All fixed data pd0 bits each
			        		;pf0.2-3: IrCmd = All variable data pd1 bits each
			        		;pf0.4-5: IrFmt = IrDev IrCmd
		db	$CF     		;pf0.6: pdA is total time
			        		;pf1.0~: No repeat when key held down
	  		        		;pf1.2-3: pdC is Lead In burst
		db	$44     		;pf1.6: Send iD4 burst (? '1') at end
		db	$08     		;pd0: Device Code bits
		db	$08     		;pd1: Command Code bits
		dw	$0118,$0106		;pd2: '1' Burst 560/524
		dw	$0118,$0339		;pd6: '0' Burst 560/1650
		dw	$D2DC   		;pdA: Total time 107960
		dw	$1194,$08B6		;pdC: Lead In Burst 9000/4460

L1FA_1:		INC	R01
		LD	W0,R03
		BTJRF	L1FA_3,W0.2
		CALL	0133   			;[Record]
		JRNC	L1FA_3
		BTJRT	L1FA_2,W0.5
		LD	R04,R05
		JR	L1FA_4
L1FA_2:		XOR	R04,#80
		XOR	R05,#80
L1FA_3:		BTJRT	L1FA_5,W0.5
		LD	R05,R04
L1FA_4:		COM	R05
L1FA_5:		LD	R07,R06
		COM	R07
		INC	R11
		BTJRF	L1FA_6,W0.3
		CALL	0104   			;[REW,FWD,CH+,CH-,VOL+,VOL-]
		JRC	L1FA_8
L1FA_6:		BTJRT	L1FA_9,W0.4
		BTJRF	L1FA_7,W0.1
		CALL	0149   			;Get P flags, Preprocess P data, Main IR engine
		CALL	0146  		 	;Main IR engine \F99F
L1FA_7:		BTJRT	L1FA_8,W0.0
		OR	R29,#0D
L1FA_8:		OR	R29,#01
		JP	0149   			;Get P flags, Preprocess P data, Main IR engine
L1FA_9:		LDW	R1E,R20
		BTJRT	L1FA_7,W0.0
		CALL	0149   			;Get P flags, Preprocess P data, Main IR engine
		LD	R28,#C1
		COM	R04
		LD	R12,#01
		JR	L1FA_8



		P_addr = $$			;update address for next protocol

		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$

	ifdef	builtin
		  dw	1451			;Type=TV, setupcode=$451=1105
		  else
		  dw	1C51			;Type=TV, Protocol>255, setupcode=$451=1105
		  endif
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1105			;address of device TV_1105

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1FA			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1FA		;address of protocol Protocol_1FA
		DT_index = DT_index+1		;update number of devices
		endif				;InclDebugDev

; ------------- Device/Protocol upgrades for ToadTog ------------------------------------

	ifdef	InclToadTog
		echo Device/Protocol: Installing device/protocol for ToadTog

; register and constant definitions for ToadTog protocol

		R_ToadTog	= RAE		;ToadTog toggle bits 
		R_ToadTogCtrl	= R2D		;ToadTog control bits
		R_ToadTogBuf	= R2D		;ToadTog key buffer loaded from keymove

		xorg	D_addr			;Address for next device
		org	$$
VCR_1800:	db	81			;Protocol = $181
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device in table

		xorg	P_addr			;Address for next protocol
		org	$$

Protocol_181:	db	00,00,01		;protocol header
		org	RAM

;L181_Start:					;go find keymove that got us here in EEPROM and load
;						;R0A=Key,R0C=$10 already when we get here
;		LD	R_AdvSearchDev,R07	;copy device from last search
;		LD	R_AdvSearchType,#10	;look for a keymove
;		LD	R_AdvSearchFlag,#07	;search key/dev/type
;		LDW	R02,NewKeyMoveArea	;where to search
;		LDW	R04,NewKeyMoveEnd
;
;		CALL	SearchHeader		;search for the ToadTog keymove in EEPROM
;		LDW	RCA,R5A			;copy address for read

L181_Start:	LDW	RCA,R_KMAddr		;fetch saved copy of keymove address
		ADD	RCB,#05			;move to the ToadTog Data
		ADC	RCA,#00
		LDW	RCC,#2D			;read the ToadTog Data into the bit buffer
		LD	RCE,R_AdvCodeLen	;length of keymove
		CALL	ReadWE			;Read the keymove to buffer R2D

		LD	W2,R_ToadTogCtrl	;Get the "HEX command" from the KeyMove
		SWAP	RC2			;Top digit selects bit number
		LD	W1,#01			;Start with bit 0
L181_1:		AND	RC2,#07			;Use low three bits as bit number, also handle
						; overflow when rotating 8 times for bit 0
		RL	RC1			;Rotate bit into position
		DJNZ	W2,L181_1		;Do it N time for 1 to 7, and 8 times for 0
		LD	W2,R_ToadTogCtrl	;save a copy of control bits for testing later

		LD	W3,R_ToadTogCtrl	;compute top of TRUE side buffer
		AND	RC3,#07
		LD	W0,#01			;bottom of true side
		TM	RC1,R_ToadTog		;is the toggle bit set for this toggle?
		JRNE	L181_3			;yes, copy true side keys to the macro buffer

		LD	W0,RC3			;compute bottom of FALSE side buffer
		INC	W0
		LD	W3,R_AdvCodeLen		;compute top of FALSE side buffer
		SUB	RC3,#03			; adjust to point to last key

L181_3:		CP	RC3,RC0			;selected side empty?
		JRLT	L181_Return		;yes, return

L181_7:		LD	W4,R_ToadTogBuf[W3]	;get a key code
		CP	R_Mac,AR_MacBuf		;Buffer full?
		JRULE	L181_4			;yes, finished
		PUSHUD	@R_Mac,RC4		;insert the keycode into pending keys
		DEC	RC3			;decrement pointer
		CP	RC3,RC0			;done copying?
		JRGE	L181_7			;no, go get another key
						;set or toggle bits in ToadTog register 

L181_4:		BTJRF	L181_5,W2.3		;Set requested?
		OR	R_ToadTog,RC1		;Yes: do it
L181_5:		BTJRT	L181_Return,W2.7	;Toggle requested?
		XOR	R_ToadTog,RC1		;Yes: do it
L181_Return:

	ifdef	debugtoadtog
		  LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		  LD	RCE,#D0			;length
		  LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		  CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		  CALL	WriteChecksum		;calculate and write checksum
		  CALL	Blink2Times
		  endif ;debugtoadtog
		RET


		P_addr = $$			;update address for next protocol

		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	2F08			;Type=VCR, Protocol>255, setup code = $708 = 1800
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	VCR_1800		;address of device VCR_1800

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	181			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_181		;address of protocol Protocol_181
		DT_index = DT_index+1		;update number of devices
		endif				;InclToadTog

; ------------- Device/Protocol upgrades for Device Specific Macro-----------------------
	ifdef	InclDSM
		echo Device/Protocol: Installing device/protocol for DSM

; register and constant definitions for DSM protocol

		R_DSMBuf	= R2C		;key buffer loaded from keymove

		xorg	D_addr			;address for next device
		org	$$
TV_1103:	db	FC			;Protocol = $1FC
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device

		xorg	P_addr			;address for next protocol
		org	$$

Protocol_1FC:	db	00,00,01		;protocol header
		org	RAM
;						;go find keymove that got us here in EEPROM and load
;						;R0A=Key,R0C=$10 already when we get here
;L1FC_Start:	LD	R_AdvSearchDev,R07	;copy device from last search
;		LD	R_AdvSearchType,#10	;look for a keymove
;		LD	R_AdvSearchFlag,#07	;search key/dev/type
;		LDW	R02,NewKeyMoveArea	;where to search
;		LDW	R04,NewKeyMoveEnd
;
;		CALL	SearchHeader		;search for the DSM keymove in EEPROM
;		LDW	RCA,R5A			;copy address for read

L1FC_Start:	LDW	RCA,R_KMAddr		;fetch saved copy of keymove address
		ADD	RCB,#05			;move to the DSM Data
		ADC	RCA,#00
		LDW	RCC,#2D			;read the DSM Data into the bit buffer
		LD	RCE,R_AdvCodeLen	;length of keymove
		CALL	ReadWE			;Read the keymove to buffer R2D

		LD	W3,R_AdvCodeLen		;Body length of keymove
		DJNZ	W3,L1FC_2		;adjust for 2-byte setup code before starting
L1FC_1:		CP	R_Mac,AR_MacBuf
		JRULE	L1FC_Return		;Pending buffer full, terminate adding keys
		LD	W4,R_DSMBuf[W3]		;Get a key code
		PUSHUD	@R_Mac,RC4		;Insert KeyCode into pending keys
L1FC_2:		DJNZ	W3,L1FC_1		;decrement count of bytes remaining, finished?
L1FC_Return:

	ifdef	debugDSM
		  LD	R06,RC2
		  LD	R07,RC3
		  LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		  LD	RCE,#D0			;length
		  LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		  CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		  CALL	WriteChecksum		;calculate and write checksum
		  CALL	Blink2Times
		  endif ;debugDSM
		RET

		P_addr = $$			;update address for next protocol

		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C4F			;Type=TV, Protocol>255, setup code = $44F = 1103
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1103			;address of device TV_1103

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1FC			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1FC		;address of Protocol_1FC
		DT_index = DT_index+1		;update number of devices
		endif				;InclDSM
; ------------- Device/Protocol upgrades for pause --------------------------------------
	ifdef	InclPause
		echo Device/Protocol: Installing device/protocol for Pause

; register and constant definitions for Pause protocol

		R_PauseDelay	= R2D		;Pause Delay Value

		xorg	D_addr			;address of next devcie
		org	$$

TV_1104:	db	FB			;Protocol = $1FB
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device

		xorg	P_addr			;address of next protocol
		org	$$

Protocol_1FB:	db	00,00,01		;protocol header
		org	RAM

L1FB_Start:	LD	RC2,R_Key		;get pause value from keymove (stored in R_Key)
L1FB_1:		LDW	RC0,Delay100ms		;100ms delay
		CALL	DelayWW0		;Pause by using Delay
		DJNZ	RC2,L1FB_1		;done delaying?  No, delay another 100ms

	ifdef	debugpause
		  LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		  LD	RCE,#D0			;length
		  LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		  CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		  CALL	WriteChecksum		;calculate and write checksum
		  CALL	Blink2Times
		  endif ;debugpause
		RET

		P_addr = $$			;update address for next protocol

		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C50			;Type=TV, Protocol>255, setup code = $450 = 1104
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1104			;address of TV_1104

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1FB			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1FB		;address of Protocol_1FB
		DT_index = DT_index+1		;update number of devices
		endif				;InclPause


; ------------- Device/Protocol upgrades for Long/Double Key Press ----------------------
	ifdef	InclLDKP
		echo Device/Protocol: Installing device/protocol for LDKP

; register and constant definitions for LDKP protocol

		R_LDKPCtrl	= R2D		;control byte for LDKP
		R_LDKPBuf	= R2D		;key buffer loaded from keymove
		LKP_Sens	= 5000		;sensitivity for long keypress

		xorg	D_addr			;address of next device
		org	$$

TV_1106:	db	F9			;Protocol = $1F9
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device

		xorg	P_addr			;address of next protocol
		org	$$

Protocol_1F9:	db	00,00,01		;Protocol header
		org	RAM
;						;go find keymove that got us here in EEPROM and load
;						;R0A=Key,R0C=$10 already when we get here
;L1F9_Start:	LD	R_AdvSearchDev,R07	;copy device from last search
;		LD	R_AdvSearchType,#10	;look for a keymove
;		LD	R_AdvSearchFlag,#07	;search key/dev/type
;		LDW	R02,NewKeyMoveArea	;where to search
;		LDW	R04,NewKeyMoveEnd
;
;		CALL	SearchHeader		;search for the LDKP keymove in EEPROM
;		LDW	RCA,R5A			;copy address for read

L1F9_Start:	LDW	RCA,R_KMAddr		;fetch saved copy of keymove address
		ADD	RCB,#05			;move to the LDKP Data
		ADC	RCA,#00
		LDW	RCC,#2D			;read the LDKP data into the bit buffer
		LD	RCE,R_AdvCodeLen	;length of keymove
		CALL	ReadWE			;Read the keymove to buffer R2D

		LD	R_T0,R_LDKPCtrl		;Get the control byte from the KeyMove
		SWAP	R_T0			;Timeout value in high nibble
		AND	R_T0,#0F		;Set timeout
		CALL	StartT0

		LD	W3,R_LDKPCtrl		;copy control byte, compute top of SHORT/SINGLE side buffer
		AND	RC3,#07			;
		LD	W2,#01			;bottom of SHORT/SINGLE side buffer
		TM	R_LDKPCtrl,#08		;double key press requested?
		JRNZ	L1F9_7			;yes, check for double key press

L1F9_1:		CALL	ScanKeypad		;Check for Long Key Press
		JRNC	L1F9_5			;Key is no longer pressed, use short side
L1F9_2:		TM	R_IFlags,#20		;Test timeout
		JRZ	L1F9_1			;no timeout yet, wait longer
		JR	L1F9_3			;timeout happened with key pressed, use long side
						; Check for Double Key Press
L1F9_7:		LDW	RC0,LKP_Sens		;Change this value to adjust sensitivity
		CALL	DelayWW0
		AND	R_IFlags,#7F		;Clear key interrupt test bit
		LD	P0ena,KeyIRQena		;Enable key sense interrupts
L1F9_6:		IDLE
		TM	R_IFlags,#80		;Test key interrupt
		JRNZ	L1F9_3			;second key pressed, load DOUBLE side
		TM	R_IFlags,#20		;Test timeout
		JRZ	L1F9_6			;no timeout, continue to test
		JR	L1F9_5			; after timeout, second key not pressed, use SINGLE/SHORT side

L1F9_3:		LD	W2,RC3			;compute bottom of LONG/DOUBLE side buffer
		INC	w2
		LD	W3,R_AdvCodeLen		;compute top of LONG/DOUBLE side buffer
		SUB	RC3,#3			

L1F9_5:		CP	RC3,RC2			;selected side empty?
		JRLT	L1F9_Return		;yes

L1F9_4:	 	LD	W4,R_LDKPBuf[W3]	;get a key code
		CP	R_Mac,AR_MacBuf		;Buffer full?
		JRULE	L1F9_Return		;yes, terminate the macro and return
		PUSHUD	@R_Mac,RC4		;insert the keycode into pending keys
		DEC	RC3			;decrement pointer
		CP	RC3,RC2			;done copying?
		JRGE	L1F9_4			;no, go get another key

L1F9_Return:

	ifdef	debugLDKP
		  LD 	R06,RC2
		  LD	R07,RC3
		  LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		  LD	RCE,#D0			;length
		  LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		  CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		  CALL	WriteChecksum		;calculate and write checksum
		  CALL	Blink2Times
		  endif
		RET

		P_addr = $$			;update address for next protocol
		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C52			;Type=TV, Protocol>255, setup code = $452 = 1106
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1106			;address of TV_1106

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1F9			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1F9		;address of Protocol_1F9
		DT_index = DT_index+1		;update number of devices
		endif				;InclLDKP


; ------------- Device/Protocol upgrades for write debug info  --------------------------
	ifdef	InclWriteDbg
		echo Device/Protocol: Installing device/protocol for write debug info
 
		xorg	D_addr			;address of next device
		org	$$

TV_1109:	db	FD			;Protocol = $1FD
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device

		xorg	P_addr			;address of next protocol
		org	$$

Protocol_1FD:	db	00,00,01		;Protocol header
		org	RAM
						
L1FD_Start:	LD 	R06,RCA	
		LD	R07,RCB
		LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		LD	RCE,#D0			;length
		LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		CALL	WriteChecksum		;calculate and write checksum
		CALL	Blink2Times
		RET

		P_addr = $$			;update address for next protocol
		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C55			;Type=TV, Protocol>255, setup code = $455 = 1109
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1109			;address of TV_1109

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1FD			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1FD		;address of Protocol_1FFF
		DT_index = DT_index+1		;update number of devices
		endif				;InclWriteDbg


; ------------- Device/Protocol upgrades for brighness control  -------------------------
	ifdef	InclBright
		echo Device/Protocol: Installing device/protocol for brightness control

; register and constant definitions for brightness control protocol

		BrightScr = 11			;screen with only device keys plus up, down and OK
 
		xorg	D_addr			;address of next device
		org	$$

TV_1110:	db	FF			;Protocol = $1FF
		db	0			;No digit map
		db	1			;No defined keys
		D_addr = $$			;update address for next device

		xorg	P_addr			;address of next protocol
		org	$$

Protocol_1FF:	db	00,00,01		;Protocol header
		org	RAM
						
L1FF_Start:	CALL	StopBlinkXmit		;stop blinking transmit lights
		LD	W4,R_Screen		;save current screen
		LD	R_Screen,BrightScr	;change screen to brightness control screen
		CALL	SetScreen

L1FF_1:		AND	R_IFlags,#7F		;Clear key interrupt test bit
		LD	P0ena,KeyIRQena		;Enable key sense interrupts
		IDLE
		TM	R_IFlags,#80		;Test key interrupt
		JRZ	L1FF_1			;not a key, wait again
		CALL	DebounceKeys		;scan keypad and debounce keys
		CP	R_Closures,#01		;exactly one key pressed
		JRUGT	L1FF_1

		LD	R_Key,R_Key1		;get the key
		CP	R_Key,OK		;is this the OK key? (done?)
		JREQ	L1FF_2			;yes, clean up and exit
		CALL	SetBright		;test for up/down, change brightness
		JR	L1FF_1			;wait for another keypress
L1FF_2:		LD	R_Screen,RC4		;restore previous screen
		CALL	SetScreen

L1FF_Return:


	ifdef	debugBright
		  LD 	R06,RC4			;saved screen
		  LDW	RCC,#0000		;write registers R00:RCF to EEPROM[WriteDbgAddr]
		  LD	RCE,#D0			;length
		  LDW	RCA,#WriteDbgAddr	;destination in EEPROM
		  CALL	WriteWE			;Write WE @WWC to EEPROM[WWA]
		  CALL	WriteChecksum		;calculate and write checksum
		  CALL	Blink2Times
		  endif ;debugBright
		RET

		P_addr = $$			;update address for next protocol
		xorg	D_table+2+DT_index+DT_index ;insert this device into the device table
		org	$$
		dw	1C56			;Type=TV, Protocol>255, setup code = $456 = 1110
		xorg	D_table2+DT_index+DT_index
		org	$$
		dw	TV_1110			;address of TV_1110

		xorg	P_table+2+DT_index+DT_index ;insert this protocol into the protocol table
		org	$$
		dw	1FF			;Protocol ID
		xorg	P_table2+DT_index+DT_index
		org	$$
		dw	Protocol_1FF		;address of Protocol_1FFF
		DT_index = DT_index+1		;update number of devices
		endif				;InclBright

; ------------- Finish filling in the device/protocol tables-----------------------------

		DT_Size = DT_index		;figure out the number of upgrades for each table
						;this assumes 1:1 Device:Protocol

		xorg	P_addr			;end of protocol table
		org	$$
D_table:	dw	DT_Size			;Number of devices
		D_table2 = D_table+2+DT_Size+DT_Size

		P_table  = D_table2+DT_Size+DT_Size
		xorg	P_table
		org	$$
		dw	DT_Size			;Number of protocols
		P_table2 = P_table+2+DT_Size+DT_Size
		xorg	P_table+DT_Size+DT_Size

; ------------- Extender Main - top of EEPROM -------------------------------------------

		org	RAM
		xorg	ee_main	
	 
Main:		LD	R_DevX,WC		;turn off temporary device index, WC=#FF after Read255

Start:		CALL	WaitNoKeys		;wait for no keys pressed or timeout, if successful disable interrupts
		JRC	ReadKey
		CLR	R_IFlags     		;Clear interrupt flags
		CLR	R_Closures		;clear number of keys pressed (this was in 9960B01, not in 6960B00)
		CLR	SP			;init stack
		DI				;disable future interrupts while processing
		LD	P0ena,KeyIRQena		;P0.0-6 enable interrupts for keypad
		CLR	P0pend     		;P0 clear pending interrupts
		LD	P2ena,#00		;P2 disable all interrupts (including motion)
		CLR	P2pend     		;P2 Clear pending interrupts
		LD	P3ena,#D0 		;P3 contrl: P3.0 raw input, P3.1 raw output.

		CALL	SelectTimeout		;Select a timeout value for Timer0, return in R60
		JRNC	Wait2   		;no timeout necessary
		LD	R_T0,R_BLTimer		;use backlight timer value for timeout
		CALL	StartT0			;Start Timer0

; below is the main loop for handling the remote when the backlight is on.  Either a kekypress or 
; a T0 timeout will wake the remote after the remote has gone into IDLE.  (IDLE is used here to keep the 
; clocks running for the T0 timer interrupt.

; when an interrupt happens here either process the key (key interrupt) or turn off backlight (T0 timeout)

Wait1:		EI	        		;prepare to idle waiting for interrupts
		CLR	R_IFlags     		;Clear interrupt flags
		IDLE	        		;wait for interrupt with clocks running
		DI	        		;disable further interrupts
		TM	R_IFlags,IFlag_keyset	;Was a key pressed?
		JRNE	ReadKey   		;yes, process the key
		TM	R_IFlags,IFlag_T0	;is there a T0 timeout?
		JREQ	Wait1   		;no, go back and idle
		CALL	HandleTimeout		;Handle the timeout, turn backlight off
GoStart:	JR	Start   		;after handle timeout, go back and idle again

; below is the main loop for handling the remote when the backlight is off.  A keypress or a motion interrut
; will wake the remote after the remote has gone into STOP state. STOP state is used here to minimzie power 
; consumption when the remote is doing nothing.

; When a motion interrupt happens here turn the backlight on and go back to IDLE state
; when a key interrupt happens here turn the backlight on and either go back to IDLE state or 
; if the UseFirstKey flag is on, process the key normally


Wait2:		CLR	R_IFlags     		;Clear interrupt flags	
		TM	R_VPTFlag,MotEna	;Motion enabled?
		JREQ	NoMotion		;no, don't enable motion interrupt
		OR	P2ena,#04		;enable motion interrupt
NoMotion:	CLR	P2pend     		;P2 Clear pending interrupts
		EI	
		LD	STOPena,#A5 		;Enable STOP
		STOP				;wait for interrupts with clock off
		NOP		
		NOP
		DI				;disable interrupts while processing
		TM	R_IFlags,IFlag_keymotion ;key press or motion detector?
		JRZ	Wait2			;no keypress or motion, go back and wait again

Int1:		CLR	P2ena     		;P2 Disable interrupts including motion
		OR	R_XFlags,#40		;what this does I don't know but it is necessary!
		CALL	BacklightOn		;turn backlight on
		TM	R_VPTFlag,UseFirstKey	;use the first keypress with light off?
		JRNZ	Start			;no, go back and idle again

ReadKey:	CALL	DebounceKeys		;scan keypad and debounce key

KeyProcess:	CP	R_Closures,#01		;exactly one key pressed?
		JRUGT	Start			;not one key, go back to backlight on wait loop

		LD	R_Key,R_Key1 		;Get key just read

Validate:					;the two remotes are different here because of
						; the entries in the lit keys list 
						; 6960 must validate the key before remapping
						; 9960 must validate the key after remapping
	if	remote eq 6960
		  CALL	ValidateKey		;is the key lit for the current screen?
		  JRNC	GoStart			;key is not lit, go back to backlight on wait loop
		  endif

		CALL	RemapKey 		;remap key if necessary based on key/screen/newkey list in ROM
		CP	R_Key,R_Key1		;did the key change?
		JREQ	NoRemap			;if equal, key was not remapped
		INC	R_Remapped		;set flag that key was remapped
NoRemap:

	if	remote eq 9960
		  CALL	ValidateKey		;is the key lit for the current screen?
		  JRNC	GoStart			;key is not lit, go back to backlight on wait loop
		  endif

		CALL	UpdateScreen		;update screen if necessary based on key/screen/screen list
		LD	R_Mac, AR_MacLim-1  	;Init macro pointer
		LD	R_MacLast,R_Key    	;put key in macro buffer
		OR	R_MacLast,R_SFlags 	;Shift the key if flag is set
		CLR	R_SFlags	    	;Clear shift bits

ChkShift:	CP	R_MacLast,Shift    	;Is this the shift key?;
		Shift_Key = $$-1		;remember address of shift_key  (needed by RDF)
		JRNE	ChkXShift		;no, not shift key, check Xshift
		LD	R_SFlags,ShiftMask	;yes, set shift flag for next key
		JR	GoStart			;shift flag set, go wait for another key with light on

ChkXShift:	CP	R_MacLast,XShift 	;Alternate shift?
		XShift_Key = $$-1		;remember address of xshift_key (needed by RDF)
		JRNE	ShiftDone		;no, not alt shift, move on
		LD	R_SFlags,XShiftMask	;yes, set xshift flag for next key 
		JR	GoStart			;XShiftflag set, go wait for another key with light on

ShiftDone:
LoadP2Enter2:	LDW	InstPtr,Enter2		;Load extender part2 and start at Enter2
LoadP2:		LDW	RCA, ee_part2		;EEPROM address of part2
		ENTER	Read255			;Read 255 bytes from eeprom to ram and start at InstPtr

ChkHTKeyset:	LD	R_Key,W_Key		;Get the KeyCode
 		AND	R_Key,#3F		;mask shift and xshift bits (only for checking keyset)
 		LD	W1,R_DevX		;Load temporary device index
		BTJRF	HTLoadDev,W1.3		;Branch if temporary DevIndex is valid

HTDevKey:	CALL	GetHTKeyset		;look up R_Key in HT key set, return index in W5
		JRNZ	HTSetDev		;found key, now set it
		LD	RC5,O_ -1		;use O_ device as default 
HTSetDev:	INC	RC5			;adjust index past temp devindex
		LD	W1,R_DevTbl[W5]		;store HT device in R_DevTbl
HTLoadDev:	LD	R_DevA,W1		;store in R_DevA
	
HTDone:		CP	R_Remapped,#00		;Was this a remapped key?
		JRZ	GoHTReturn		;no, go proceed back to ee_part2 at HT return
		OR	R_Key,#40		;put the remap bit back
		CLR	R_Remapped		;clear remapped key flag
GoHTReturn:	LDW	InstPtr,HTReturn	;Load and enter extender part 2 at HtReturn
		JR	LoadP2


; the 9960B01 does not have a settings register that stores a backlight timer, so we're going to have 
; to do it here

	if	remote eq 9960
BLTimer_Value:    db	32			;backlight timer, default is 5 seconds
		  BLTimerAddr = $$-1		;remember address of backlight timer (needed by RDF)
		  endif

		P1end=$$

		Part1RAM = $-RAM
		ee_main = ee_main + EepromSize - $$

;===========================================================================
;---- Extender part 2 - Lower EEPROM
;===========================================================================

		org	RAM
		xorg	ee_part2

; there are several blocks in this part of the extender that  JUMP to entry points in the ROM instead 
; of CALLing.  These ROM entry points then execute RET instructions when done.  The code at NormalKey
; sets up the return addresses and data on the stack to prepare for those RET instructions.

; this is done to facilitate the main code blocks in the ROM that load and use RAM, which overwrites
; the extender code.  If the extender were to CALL into these blocks there would be nothing left 
; to execute when it came back.

; When the extender gets to NormalKey it sets up the stack for the reload of the extender by 
; PUSHing onto the stack the entry point to Read255, then the EEPROM address of ee_part2 and 
; then the entry point for POPWBWA.  When the extender JUMPs into the ROM, the return path is:

; the first RET will return to PopWbWa which will POP the address of ee_part2 from the stack
; into WWA.  PopWbWa will then RET to Read255 which will read FF bytes from EEPROM at WWA (ee_part2)
; into RAM.  When Read255 exeucutes its RET instruction, the extender will enter ee_part2 at 
; ScrDone which was on the "adjusted" stack from the initial entry into ee_part2.  

HTReturn:					;<=== Returns here from HtDevKey
SearchHdr:	LDW	R02,NewKeyMoveArea	;EEProm address to search to see if this is a keymove, macro or FAV
		LDW	R04,NewKeyMoveEnd	;end of advanced code area
		LD	R0D,#01			;search flag,  key only
		LD	R0A,W_Key		;key to search

SearchNext:	CALL	SearchHeader		;search the EEPROM for a matching header, returns address in RR5A
						; and info in R_AdvCodexxx registers
		JRC	FoundHdr		;found an advance code in eeprom, go process it
DoKey:						;key not found in eeprom, process it normally
	ifdef	noxmit
		  JR	Blink2			;return via blinking and reloading extender to simulate DoNormalKey 
		  else
		  JP	DoNormalKey		;process the key, returns through reloading the extender
		  endif

FoundHdr:	LDW	R_KMAddr,R5A		;save Keymove address for use in special protocols
		INCW	R5A			;adjust EEPROM address past 3-byte header
		INCW	R5A
		INCW	R5A
		LDW	RCA,R5A			;copy address to prepare for EEPROM read
		LD	W1,R_AdvCodeType	;copy "type" to W1
		BTJRF	NotFav,W1.5		;if W1.5=0, this is not a favorite entry

Favorite:					;found a favorite list entry
						;RRCA = Address of header, Type=$30
DoFav:		AND	R_FavIndex,#0F		;get low nibble of favorite index
 		LD	WC,R_FavIndex		;compute byte offset for this favorite index
		MULT	RCC,#05			; by multiplying by 5-bytes (per fav entry)
		INC	R_FavIndex		;increment list pointer
		CP	R_FavIndex,R_FavNumber
		JRGT	DoFav			;if greater than number of favorites, cycle back to zero
		ADD	WB, WD			;if less or equal, adjust address to point to this entry
		ADC	WA, WC	
		LD	R_AdvCodeLen,#05	;length for read is 5 bytes for fav entry
		LD	R_DevX,R_FavDev		;set favorite device

Macro:		LD	WD,R_Mac		;Get previous macro pointer
 		SUB	RCD,R_AdvCodeLen	;Compute new start based on macro length
		CP	RCD,AR_MacBuf		;Would it fit?
		JRULT	GoSearchNext		;Nesting error or too big, ignore this macro 
		LD	R_Mac,WD		;adjust macro pointer to new macro buffer start
		LD	RCE,R_AdvCodeLen	;length of macro
 		JP	ReadWE			;read the macro into the macro buffer
						;returns through reloading the extender

NotFav:		BTJRF	Macro,W1.4		;if W1.4=0, this is a macro, go back and process macro
KeyMove:					;if w1.4=1, this is a keymove
						;RR5A = Address of first byte in keymove
		CP	R_AdvCodeDev,R_DevA	;is this the active device?
		JREQ	DoKM			;yes, do this keymove
		ADD	R5B,R_AdvCodeLen	;move past this keymove to search again
		ADC	R5A,#00
		LDW	R02,R5A			;new search address for SearchHeader
GoSearchNext:	JR	SearchNext

DoKM:						;found a keymove, process normally

	ifdef	noxmit
Blink2:		  JP	Blink2Times		;signal key processed, return through reloading extender
		  else
		  LDW	InstPtr,DoKeyMove	;prepare DoKeyMove when LoadKeyMove RETurns
		  ENTER	LoadKeyMove		;load then process keymove, will return through reloading extender
		  endif
NotHt:		CALL	ScrollScr		;check for scroll, if scroll screen, C=1=success
		JRC	Enter2			;if key was scroll we're done so get next key
						;not scroll key, process the key as a normal key
						
NormalKey:	LDW	RRC2,Read255		;Push ROM address of Read255 onto stack
		PUSH	RC3
		PUSH	RC2
		LDW	RRC2,ee_part2		;Push EEPROM address of extender part 2 onto stack
		PUSH	RC2
		PUSH	RC3
		LDW	RRC2,PopWbWa		;Push ROM address of PopWbWa onto stack
		PUSH	RC3
		PUSH	RC2

;		LD	R_Key,W_Key		;copy key to R_Key prior to checking HT keyset
		LDW	InstPtr,ChkHTKeyset	;lookup W_Key in HT keyset R_DevA
		JR	LoadP1			;returns above at HTReturn (out of order to save space)

NextKey:	LD	R_Closures,W0		;If 1, ROM will hold while pressed
		POPUI	W_Key,@R_Mac		;Get next key from macro
		TM	W_Key,W_Key		;Is it 00?
		JREQ	ChkNext			;Yes: Skip it, check to see if there are any more
		LD	W1,W_Key		;W1 now contains the key (or phantom key)
		SUB	RC1,PseudoBase		;Is it a command to change a DevIndex?
		JRUGE	ChgDev			;Yes, change device and scroll screen if necessary
		CP	W_Key,HT		;Is it the HT button?
		HT_Key = $$-1			;remember address of HT_key  (needed by RDF)
		JRNE	NotHt			;No
		LDW	R_ScreenCall,SelScrHT	;HT key pressed, enable HT screen processing	
		JR	NormalKey		;process the HT key as a normal key

ChgDev:		CLR	RC0			;Prepare for DIV, W1 contains key-PseudoBase
		DIV	RC0,NumHTkey		;divide by number of HT keysets, this will give W0=key index, W1=device index
		LD	R_DevTbl[W0],W1		;store device index into device table

	ifdef	writeback
		  CALL	SetupPtrs		;prepare to write setup data, get WWA, WWC and WE
		  CALL	WriteWE			;write setup data to EEPROM
		  CALL	WriteChecksum		;calculate and write EEPROM checksum
		  endif
		CP	RC0,O_			;Is this the "other" keyset?  If so, change screen
		JRNE	Enter2			;screen doesn't change, skip change screen
		LD	R_Dev,W1		;Change device index and then change screen
		CALL	@R_ScreenCall		;Process screen change (either normal or HT)

Enter2:						;main entry point into ee_part2 when initially loaded
		LD	SP,#FE			;adjust stack to repush Enter2 return address (already on stack)

ChkNext:	LD	W0,AR_MacLim		;Limit of macro buffer (if [R_Mac]=AR_MacLim, buffer is empty)
 		SUB	RC0,R_Mac		;compute number of keys left in macro buffer
	 	JRUGT	NextKey			;there are keys left, go process them

						;no keys left, clean up and return to ee_main
		LDW	R_ScreenCall,SelectScreen ;return to default screen handling
LoadP1Main:	LDW	InstPtr,Main		;Load and jump to Main in ee_main
LoadP1:		LDW	RCA, ee_main		;EEPROM address of extender first part
		ENTER	Read255			;enter ee_main at address in InstrPtr


		dw	version			;put the version number in ee_part2 at $FE/FF
		ver_addr = $$-2			;remember address of version number

		P2end=$$
		Part2RAM = $-RAM		
		ee_part2 = ee_part2+UpgradeArea-$$ ;load extender part 2 just below the upgrade area

