// ra demo program az lcd.c tesztelshez
// 48MHz-es rajellel pontos (USB)
// a belltst s a szkv kezelst rja meg mindenki magnak :)
// dv. Benjami
#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include "lcd.h"
#include "bootloaders.h"

unsigned int ev = 2011;
unsigned char honap = 12;
unsigned char nap = 27;
unsigned char ora = 23;
unsigned char perc = 58;
unsigned char masodperc = 0;
rom unsigned char honaphosszak[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

void main(void)
{
  unsigned char lastsec;
  LcdInit();                            // mkdsre brjuk az LCD-t
  OpenTimer2(TIMER_INT_ON & T2_PS_1_16 & T2_POST_1_15);
  PR2 = 199;                            // 4msec srsggel megszakts (48MHz)
  RCONbits.IPEN = 1;
  PIE1bits.TMR2IE = 1;
  INTCONbits.GIEH = 1;

  //                     "01020304050607080910111213141516"
  memcpypgm2ram(LcdText, "   eeee.hh.nn       oo:pp:mm    ", 32);
  lastsec = 255;
  while(1)
  {
    LcdUpdateChar();                    // ez mindig csak egy karaktert aktualizl az LCD-n (csak ezt srn teszi)

    if(lastsec != masodperc)
    {
      lastsec = masodperc;

      // jr az ra jr
      if(masodperc == 60)
      {
        masodperc = 0;
        if(++perc == 60)
        {
          perc = 0;
          if(++ora == 24)
          {
            ora = 0;
            if(++nap > honaphosszak[honap - 1])
            {
              nap = 1;
              if(++honap == 13)
              {
                honap = 1;
                ev++;
      } } } } }

      // szmjegyek kirsa
      itoa(ev, LcdText + 3);
      btoa(honap, LcdText + 8);
      btoa(nap, LcdText + 11);
      btoa(ora, LcdText + 20);
      btoa(perc, LcdText + 23);
      btoa(masodperc, LcdText + 26);

      // egyszmjegy szmok ktszmjegyv alaktsa
      if(!LcdText[9]) {LcdText[9]  = LcdText[8];  LcdText[8]  = '0';}
      if(!LcdText[12]){LcdText[12] = LcdText[11]; LcdText[11] = '0';}
      if(!LcdText[21]){LcdText[21] = LcdText[20]; LcdText[20] = '0';}
      if(!LcdText[24]){LcdText[24] = LcdText[23]; LcdText[23] = '0';}
      if(!LcdText[27]){LcdText[27] = LcdText[26]; LcdText[26] = '0';}

      // btoa ltal fellrt rsjelek ptlsa
      LcdText[7] = '.';
      LcdText[10] = '.';
      LcdText[22] = ':';
      LcdText[25] = ':';
    }
  }
}

#pragma interrupt YourHighPriorityISRCode
static unsigned char msec4 = 0;
void YourHighPriorityISRCode()
{
  if(PIR1bits.TMR2IF)                   // Timer2 interrupt ?
  {
    PIR1bits.TMR2IF = 0;                // interrupt jelzst trlni
    msec4++;
    if(msec4 == 250)                    // mivel 4*250msec = 1sec
    {
      masodperc++;
      msec4 = 0; 
    }
  }
}

#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
}

