//MPLAB SIM-hez (a valdi kijelz ezzel nem mkdik)
//#define MPLABSIM

#include <p18cxxx.h>
#include <delays.h>
#include "lcd.h"

#define INPUT_PIN        1
#define OUTPUT_PIN       0
#define SET_DDRAM_ADDR   0x80

char LcdText[LCD_WIDTH * LCD_LINES + 1];
unsigned char LcdPos;                   // Frisstsnl az aktulis karakter pozcija

void DelayMs(unsigned char ms)
{
  Delay10KTCYx(ms);
  Delay1KTCYx(ms);
  Delay1KTCYx(ms);
}

/*********************************************************************
Function Name:             char LcdBusy
Description:               LCD vezrl foglaltsgnak ellenrzse
                           (nem vrja meg mg szabad lesz)
Input parameters:          none
Return value:              1 ha a Busy flag is be van lltva (foglalt)
                           0 ha szabad (lehet adatot kldeni neki)
*********************************************************************/
char LcdBusy(void)
{
  /* Configure all pins as input */
  LCD_DATA4_TRIS = INPUT_PIN;
  LCD_DATA5_TRIS = INPUT_PIN;
  LCD_DATA6_TRIS = INPUT_PIN;
  LCD_DATA7_TRIS = INPUT_PIN;
#ifdef LCD_8_BIT_MODE
  LCD_DATA0_TRIS = INPUT_PIN;
  LCD_DATA1_TRIS = INPUT_PIN;
  LCD_DATA2_TRIS = INPUT_PIN;
  LCD_DATA3_TRIS = INPUT_PIN;
#endif // LCD_8_BIT_MODE

  Nop();
  LCD_RD_WR_O = 1;
  Nop();
  LCD_RS_O = 0;

  Nop();
  Nop();
  Nop();
  Nop();

  LCD_E_O = 1;
  Nop();
  Nop();
  Nop();
  Nop();

  #ifdef MPLABSIM
  if(0)                                 // MPLAB SIM-ben sosem foglalt az LCD
  #else
  if(LCD_DATA7_I)                       // busy flag
  #endif
  {
    LCD_E_O = 0;
#ifdef LCD_4_BIT_MODE
    Nop();
    Nop();
    Nop();
    Nop();
    LCD_E_O = 1;
    Nop();
    Nop();
    Nop();
    Nop();
    LCD_E_O = 0;
#endif // LCD_4_BIT_MODE
    return 1;                           // foglalt
  }
  LCD_E_O = 0;
#ifdef LCD_4_BIT_MODE
  Nop();
  Nop();
  Nop();
  Nop();
  LCD_E_O = 1;
  Nop();
  Nop();
  Nop();
  Nop();
  LCD_E_O = 0;
#endif // LCD_4_BIT_MODE
  return 0;                             // szabad
}

/******************************************************************************
 * Function:        void LcdWrite(unsigned char RS, unsigned char Data)
 * PreCondition:    LCDInit() inicializlni kell
 * Input:           RS - Register Select - 1:RAM, 0:Config registers
 *                  Data - 8 bits of data to write
 * Output:          None
 * Side Effects:    None
 * Overview:        I/O lbakon keresztl rja az LCD-t
 *****************************************************************************/
void LcdWrite(unsigned char RS, unsigned char Data)
{
  /* Configure all pins as output */
  LCD_RD_WR_O = 0;
  LCD_RS_O = RS;

  Nop();

  LCD_DATA4_TRIS = OUTPUT_PIN;
  LCD_DATA5_TRIS = OUTPUT_PIN;
  LCD_DATA6_TRIS = OUTPUT_PIN;
  LCD_DATA7_TRIS = OUTPUT_PIN;

#ifdef  LCD_8_BIT_MODE
  LCD_DATA0_TRIS = OUTPUT_PIN;
  LCD_DATA1_TRIS = OUTPUT_PIN;
  LCD_DATA2_TRIS = OUTPUT_PIN;
  LCD_DATA3_TRIS = OUTPUT_PIN;
#endif

  _asm movlw -3 _endasm                 // W = Data helye a frame pointerhez kpest
  _asm btfss PLUSW2, 4, 0 _endasm       // btfss [frame pointer + W], 4
  LCD_DATA4_O = 0;
  _asm btfsc PLUSW2, 4, 0 _endasm
  LCD_DATA4_O = 1;
  _asm btfss PLUSW2, 5, 0 _endasm
  LCD_DATA5_O = 0;
  _asm btfsc PLUSW2, 5, 0 _endasm
  LCD_DATA5_O = 1;
  _asm btfss PLUSW2, 6, 0 _endasm
  LCD_DATA6_O = 0;
  _asm btfsc PLUSW2, 6, 0 _endasm
  LCD_DATA6_O = 1;
  _asm btfss PLUSW2, 7, 0 _endasm
  LCD_DATA7_O = 0;
  _asm btfsc PLUSW2, 7, 0 _endasm
  LCD_DATA7_O = 1;

#ifdef  LCD_4_BIT_MODE
  Nop();
  LCD_E_O = 1;
  Nop();
  Nop();
  Nop();
  Nop();
  LCD_E_O = 0;

  _asm btfss PLUSW2, 0, 0 _endasm
  LCD_DATA4_O = 0;
  _asm btfsc PLUSW2, 0, 0 _endasm
  LCD_DATA4_O = 1;
  _asm btfss PLUSW2, 1, 0 _endasm
  LCD_DATA5_O = 0;
  _asm btfsc PLUSW2, 1, 0 _endasm
  LCD_DATA5_O = 1;
  _asm btfss PLUSW2, 2, 0 _endasm
  LCD_DATA6_O = 0;
  _asm btfsc PLUSW2, 2, 0 _endasm
  LCD_DATA6_O = 1;
  _asm btfss PLUSW2, 3, 0 _endasm
  LCD_DATA7_O = 0;
  _asm btfsc PLUSW2, 3, 0 _endasm
  LCD_DATA7_O = 1;
#endif // LCD_4_BIT_MODE

#ifdef  LCD_8_BIT_MODE
  _asm btfss PLUSW2, 0, 0 _endasm
  LCD_DATA0_O = 0;
  _asm btfsc PLUSW2, 0, 0 _endasm
  LCD_DATA0_O = 1;
  _asm btfss PLUSW2, 1, 0 _endasm
  LCD_DATA1_O = 0;
  _asm btfsc PLUSW2, 1, 0 _endasm
  LCD_DATA1_O = 1;
  _asm btfss PLUSW2, 2, 0 _endasm
  LCD_DATA2_O = 0;
  _asm btfsc PLUSW2, 2, 0 _endasm
  LCD_DATA2_O = 1;
  _asm btfss PLUSW2, 3, 0 _endasm
  LCD_DATA3_O = 0;
  _asm btfsc PLUSW2, 3, 0 _endasm
  LCD_DATA3_O = 1;
#endif // LCD_8_BIT_MODE
  Nop();
  LCD_E_O = 1;
  Nop();
  Nop();
  Nop();
  Nop();
  LCD_E_O = 0;
}

/******************************************************************************
 * Function:        void LcdInit(void)
 * PreCondition:    None
 * Input:           None
 * Output:          None
 * Side Effects:    None
 * Overview:        I/O lbak, TRIS regiszterek belltsa 
 *                  LCD kijelz bekapcsolsa s alapllapotba lltsa
 * Note:            None
 *****************************************************************************/
void LcdInit(void)
{
  unsigned char i;

  // I/O lbak belltsa
  LCD_E_O = 0;
  LCD_E_TRIS = OUTPUT_PIN;

  LCD_RS_O = 0;
  LCD_RS_TRIS = OUTPUT_PIN;

  LCD_RD_WR_O = 0;
  LCD_RD_WR_TRIS = OUTPUT_PIN;

  LCD_DATA4_TRIS = OUTPUT_PIN;
  LCD_DATA5_TRIS = OUTPUT_PIN;
  LCD_DATA6_TRIS = OUTPUT_PIN;
  LCD_DATA7_TRIS = OUTPUT_PIN;

  DelayMs(100);

  // 0011 (3x)
  LCD_RS_O = 0;
  LCD_DATA4_O = 1;
  LCD_DATA5_O = 1;
  LCD_DATA6_O = 0;
  LCD_DATA7_O = 0;
  Nop();
  for(i = 0; i < 3u; i++)
  {
    LCD_E_O = 1;
    Nop();
    Nop();
    Nop();
    Nop();
    LCD_E_O = 0;
    DelayMs(5);
  }
        
#ifdef  LCD_4_BIT_MODE
  // 0010
  LCD_DATA4_O = 0;
  LCD_DATA5_O = 1;
  LCD_DATA6_O = 0;
  LCD_DATA7_O = 0;
  Nop();
  LCD_E_O = 1;
  Nop();
  Nop();
  Nop();
  Nop();
  LCD_E_O = 0;
  DelayMs(5);

  while(LcdBusy());
#if  LCD_LINES == 1
  LcdWrite(0, 0x20);
#else
  LcdWrite(0, 0x28);
#endif // LCD_LINES
#endif // LCD_4_BIT_MODE
        
#ifdef  LCD_8_BIT_MODE
  while(LcdBusy());
#if  LCD_LINES == 1
  LcdWrite(0, 0x30);
#else
  LcdWrite(0, 0x38);
#endif // LCD_LINES
#endif // LCD_8_BIT_MODE

  // Set the entry mode
  while(LcdBusy());
  LcdWrite(0, 0x06);                    // Increment after each write, do not shift

  // Set the display control
  while(LcdBusy());
  LcdWrite(0, 0x0C);                    // Turn display on, no cusor, no cursor blink

  LcdPos = 0;
}

/******************************************************************************
 * Function:        void LcdUpdateChar(void)
 * PreCondition:    LCDInit() inicializlni kell
 * Input:           LcdText[]
 * Overview:        Ha szabad az LCD, egy karaktert tmsol az LcdText[] tmbbl 
 *                  az LCD kijelzre 
 * Note:            Nincs vrokozsi id, ezrt USB-s alkalmazsnl ezzel frissthet 
 *                  a kijelz.
 *****************************************************************************/
void LcdUpdateChar(void)
{
  static char LcdStatus = 0;
  char c;
  if(LcdBusy()) return;                 // LCD foglalt ?

  if(!LcdStatus)
  {
    c = LcdText[LcdPos];
    if (c == 0)
    {
      c = ' ';
      LcdText[LcdPos] = ' ';
    }
    LcdWrite(1, c);
    LcdPos++;

    #if LCD_LINES == 1
    if(LcdPos == LCD_WIDTH) LcdStatus = 1;
    #endif

    #if LCD_LINES == 2
    if((LcdPos == LCD_WIDTH) || (LcdPos == LCD_WIDTH * 2)) LcdStatus = 1;
    #endif

    #if LCD_LINES == 4
    if((LcdPos == LCD_WIDTH) || (LcdPos == LCD_WIDTH * 2) || (LcdPos == LCD_WIDTH * 3) || (LcdPos == LCD_WIDTH * 4)) LcdStatus = 1;
    #endif

  } // LcdStatus
  else // DDRAM lltgats
  {
    #if LCD_LINES == 1
    LcdWrite(0, SET_DDRAM_ADDR + 0x00); // DDRAM cm = 0
    LcdPos = 0;
    #endif // LCD_LINES == 1

    #if LCD_LINES == 2
    if(LcdPos == LCD_WIDTH)
      LcdWrite(0, SET_DDRAM_ADDR + 0x40);// DDRAM cm = 0x40
    else
    {
      LcdWrite(0, SET_DDRAM_ADDR + 0x00);// DDRAM cm = 0
      LcdPos = 0;
    }
    #endif // LCD_LINES == 2

    #if LCD_LINES == 4
    if(LcdPos == LCD_WIDTH)             // 1. sor vge ?
      LcdWrite(0, SET_DDRAM_ADDR + 0x40);// DDRAM cm = 0x40
    else if(LcdPos == LCD_WIDTH * 2)    // 2. sor vge ?
      LcdWrite(0, SET_DDRAM_ADDR + LCD_WIDTH);// DDRAM cm = LCD_WIDTH
    else if(LcdPos == LCD_WIDTH * 3)    // 3. sor vge ?
      LcdWrite(0, SET_DDRAM_ADDR + 0x40 + LCD_WIDTH);// DDRAM cm = 0x40 + LCD_WIDTH
    else if(LcdPos == LCD_WIDTH * 4)    // 4. sor vge ?
    {
      LcdWrite(0, SET_DDRAM_ADDR + 0x00);// DDRAM cm = 0x00
      LcdPos = 0;
    }
    #endif // LCD_LINES == 4

    LcdStatus = 0;
  }
}
