#ifndef __LCD_H
#define __LCD_H

// sorok szma (1, 2, 4 lehet)
#define LCD_LINES           2

// soronknti karakterek szma (16, 20, 24, 40 lehet)
#define LCD_WIDTH           16

// vlaszd ki hogy milyen mdon kapcsoldik a kijelz
#define LCD_4_BIT_MODE
//#define LCD_8_BIT_MODE

// I/O lbak
#define LCD_E_TRIS          TRISAbits.TRISA4
#define LCD_RD_WR_TRIS      TRISBbits.TRISB5
#define LCD_RS_TRIS         TRISBbits.TRISB4

#define LCD_E_O             LATAbits.LATA4
#define LCD_RD_WR_O         LATBbits.LATB5
#define LCD_RS_O            LATBbits.LATB4

#define LCD_DATA4_TRIS      TRISBbits.TRISB0
#define LCD_DATA5_TRIS      TRISBbits.TRISB1
#define LCD_DATA6_TRIS      TRISBbits.TRISB2
#define LCD_DATA7_TRIS      TRISBbits.TRISB3

#define LCD_DATA4_O         LATBbits.LATB0
#define LCD_DATA5_O         LATBbits.LATB1
#define LCD_DATA6_O         LATBbits.LATB2
#define LCD_DATA7_O         LATBbits.LATB3
#define LCD_DATA7_I         PORTBbits.RB3

// I/O lbak 8 bites zemmdhoz (4 bitesnl brmi lehet, nem fogja befordtani a kdba)
#ifdef  LCD_8_BIT_MODE
#define LCD_DATA0_TRIS      TRISDbits.TRISD0
#define LCD_DATA1_TRIS      TRISDbits.TRISD1
#define LCD_DATA2_TRIS      TRISDbits.TRISD2
#define LCD_DATA3_TRIS      TRISDbits.TRISD3

#define LCD_DATA0_O         LATDbits.LATD0
#define LCD_DATA1_O         LATDbits.LATD1
#define LCD_DATA2_O         LATDbits.LATD2
#define LCD_DATA3_O         LATDbits.LATD3
#endif  // LCD_8_BIT_MODE

// interface
extern char LcdText[LCD_WIDTH * LCD_LINES + 1];
void LcdInit(void);
void LcdUpdateChar(void);

#endif

