//*          Egg Timer              *
// 
// The 7 segments are at RB0 to RB6. RB7 is the output for the buzzer.
//
// This code is free to use, for more info   http://www.moty22.co.uk       
   
#include <htc.h>

#define _XTAL_FREQ 32000

//prototypes
void init(void);
void main(void);
void display(void);
void beep(void);
void bell(void);

__CONFIG(LVPDIS & MCLRDIS & WDTDIS & UNPROTECT & LP);

unsigned char min,min10;

void init(void){

	CMCON = 0b111;		//comparator off
	OPTION = 0b100;		//TMR0 1:32 prescale
	TRISB = 0;			 //RB all outputs
	TRISA = 0b11111100;
}
			
void main(void){
	unsigned char sec,min2;
	min=min10=0;
	init();
for(;;){
	TMR0=0; T0IF=0;	
	display();
	
	if(!RA2){		//advance minute count
		min++;					//reset/minutes button
		if(min==10){min=0;}
		TMR0=0; T0IF=0;
		while(!RA2){
			display();
			if(T0IF){
				T0IF=0;
				min++;		
				if(min==10){min=0;}
				}
		}
	}
					
	if(!RA3){		//advance minute x 10 count
		min10++;					//minutes x 10 button
		if(min10==10){min10=0;}
		TMR0=0; T0IF=0;
		while(!RA3){
			display();
			if(T0IF){
				T0IF=0;
				min10++;		
				if(min10==10){min10=0;}
				}
		}
	}	
							//start button works if display > 0
	if(!RA4 && (min || min10)){
		TMR0=0;
		sec=0;
		min2=min+1;
		beep();
		while(1){
			display();
			if(T0IF){
				T0IF=0;
				++sec;
				if(sec==60){sec=0; --min2;}       //minutes count
					if(min2==0){min2=10; --min10;}
			}
			min=min2-1;	
			if(!RA2){				//reset/minutes button
				min=min10=0;
				while(!RA2){display();}
				break;}
			if(min==0 && min10==0){bell(); break;}
		}	
	}
}		
}
						
void display(void){
	unsigned char digit[12];
	digit[0]=0b111111;		//7 segments for 0
	digit[1]=0b110;
	digit[2]=0b1011011;
	digit[3]=0b1001111;
	digit[4]=0b1100110;
	digit[5]=0b1101101;
	digit[6]=0b1111100;
	digit[7]=0b111;
	digit[8]=0b1111111;
	digit[9]=0b1100111;
	digit[10]=0b1110111;		//7 segments for A
	digit[11]=0b111000;			//7 segments for L
	
		PORTB=digit[min10];
		RA0=1;
		__delay_ms(4);
		RA0=0;
		PORTB=digit[min];
		RA1=1;
		__delay_ms(4);
		RA1=0;
}
	
void beep(void){
	unsigned char i; i=0;
	while(i<60){			//duration of beep	
		RB7=1;				//buzzer output 800hz 
		_delay(1);
		RB7=0;
//		_delay(1);
		i++;
	}
	RB7=0;
}
	
void bell(void){
	unsigned char i,j; i=0;
	min=11; min10=10;			//display AL
	while(i<25){			//rings
		i++;
		j=0;
		beep();
		__delay_ms(100);
		beep();
		while(j<25){
		j++;
		display();}
		if(!RA2){				//reset/minutes button
			while(!RA2){display();}
 			break;}
	}
	min=0; min10=0;
}				