; Filename: ADVSPI.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 1.0                              *
; * Date      Feb 6, 1996                      *
; **********************************************
; ****************************************************************************
; * This program shows examples of SPI transmission and reception            *
; ****************************************************************************
	LIST     P=16C74,F=INHX8M,R=DEC       ; Set processor to 16C74
	#INCLUDE C:/MPLAB/P16C74.INC ; Include processor INC file
	__CONFIG _XT_OSC&_WDT_OFF&_CP_OFF     ; Set up config bits
	__IDLOCS 5678			      ; Set up ID locations
	ERRORLEVEL 1,-302	   	      ; Turn OFF message ID 302

COUNT		EQU	20h	; Location of count variable to count bits
SPIDATAL	EQU	21h	; Location of SPI low byte data
SPIDATAH	EQU	22h	; Location of SPI high byte data
#define     	DOUT    PORTA,0 ; SPI port DOUT signal
#define     	CS      PORTA,1 ; SPI port CS signal
#define     	SCLK    PORTA,2 ; SPI port SCLK signal
#define     	DIN     PORTA,3 ; SPI port DIN signal

	ORG 0
	clrf	PORTA		; Clear output latch register
	bsf	STATUS,RP0	; Switch to bank 1
	movlw	b'11111000'	; Place PORTA direction data into W
	movwf	TRISB		; Set RA0-2 outputs, RA3 input
	movlw	7		; Place 7 into W
	movwf	ADCON1		; Make RAX digital inputs
	bcf	STATUS,RP0	; Switch to bank 0
mainloop
	movlw	b'01010101'	; Place alternating 1 and 0 into W
	movwf	SPIDATAL	; init SPI data low register
	movlw	b'00001111'	; Place 00001111 into W
	movwf	SPIDATAH	; init SPI data high register
	call 	spidataio	; Send/receive SPI data
	goto	mainloop	; Jump back and do it again!

;**************************************************
;* 16 bit SPI serial I/O xmit and receive routine *
;* Data to Transmit:     ADRESL, ADRESH           *
;* Data to Receive:      ADRESL, ADRESH           *
;* Time = (13 * 16) + 7 = 215 cycles              *
;**************************************************
spidataio
    	movlw   .16             ; Place bit count value into W
    	movwf   COUNT           ; W -> COUNT for counting bits
    	bcf     CS              ; Select the SPI device
loopspidata 
    	bcf     STATUS,C        ; Assume we are receiving a ZERO from SPI device
    	btfsc   DIN             ; Skip if we are receiving a ZERO from SPI device
    	bsf     STATUS,C        ; Receive a ONE from the DIN line
    	rlf     SPIDATAL,F      ; Rotate received bit into Low digit
    	rlf     SPIDATAH,F      ; Rotate high digit, place xmiit bit into carry
    	bcf     DOUT            ; Assume we are transmitting a ZERO to SPI device
    	btfsc   STATUS,C        ; Skip if we are senDOUTg a ZERO to SPI device
    	bsf     DOUT            ; Transmit a ONE onto the DOUT line
    	bsf     SCLK            ; Clock in the DOUT output
    	bcf     SCLK            ; Lets get ready to clock the next digit!
    	decfsz  COUNT,F         ; Skip if we have XMIT/RCV all 16 bits
    	goto    loopspidata     ; Not done yet so loop back for next bit
    	bsf     CS              ; De-select the SPI device
    	return                  ; DONE receiving/xmiting - GO HOME! 

    END  
