; Filename: ADVPOLL.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 1.0                              *
; * Date      Feb 6, 1996                      *
; **********************************************
; ********************************************************************
; * A program bemutatja:        				     *
; * 	- A PIC16C5x csaladnal hasznalhato taszkkezelest 	     *
; *     - A TMR0 idozitot hasznaljuk utemadonak                      *
; *     - scankeys 125 msec.-onkent fut 			     *
; * 	- inctime  1 mp.-kent					     *
; *	- Code converted to 16C74 for emulation only			     *
; ****************************************************************************
	list     P=16C74,F=INHX8M,R=DEC       	; Processzor  16C74
	#include p16c74.inc 			; A szuksges INC fajl
	__CONFIG _XT_OSC&_WDT_OFF&_CP_OFF     	; Konfiguracios bitek
	__IDLOCS 5678			      	; ID (azonosito)
	ERRORLEVEL 1,-302	   	      	; 302-es hibauzenet kikapcs.
	
	CBLOCK	0x20
	PREVTMR0	; TMR0 elozo erteke, mikor kiolvastuk
	CHANGETMR0	; TMR0 utolso olvasasa ota megvaltozott bitje
	SECTIME		; eltelt masodpercek szama
	ENDC
	
	ORG 0
init
	movlw	b'00000101'	; idozito, elooszto nincs, 64-es osztas
	option			; ertek OPTION-ba irasa
	clrf	TMR0		; TMR0 regiszter torlese
	clrf	PREVTMR0	; PREVTMR0 regiszter torlese
	clrf	CHANGETMR0	; CHANGETMR0 regiszter torlese
	clrf	SECTIME		; SECTIME  regiszter torlese
	clrw			; W  regiszter torlese
	tris	PORTB		; port B kimenet
	goto 	mainloop	; inicializalas kesz johet a fo hurok

mainloop
	movf   	TMR0,W    	; TMR0 aktualis erteke W-be
	xorwf 	PREVTMR0,W 	; Nezzuk, mely bitjei valtoztak...
	movwf 	CHANGETMR0    	; minden megvaltozott bit ide
	xorwf	PREVTMR0,F 	; Elozo TMR0 ertek frissitese
	btfsc 	CHANGETMR0,7   	; ugras, ha nem telt el egy mp.
	call	inctime		; masodpercszamlalo novelese 1-el
	btfsc	CHANGETMR0,4	; ugras, ha nem kell a billentyut figyeln
	call	scankeys	; billentyuzet figyelese
	goto	mainloop	; vissza a hurok elejere

; *******************************************************
; * Ez a rutin 125 mSec-kent fut 32 kHz-es orajelnel    *
; *******************************************************
scankeys
	bcf	PORTB,0		; RB0.0=L
	bsf	PORTB,0		; RB0.0=H
	retlw	0		; vissza

; **********************************************
; * Ez a rutin mp-kent fut 32 kHz-en           *
; **********************************************
inctime
	incf	SECTIME		; mp. szamlalo novelese
	retlw	0		; vissza
	
;Az utolso ket sor 16C5X szimulcio eseten kell, ekkor a P=16C54 es
;az include fajl is mas 
;	ORG	1ffh		; Origin at RESET vector
;	GOTO	init		; Execute initalization code
	END
