; Filename: ADVRELSW.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 1.0                              *
; * Date      Feb 6, 1996                      *
; **********************************************
; ****************************************************************************
; * A program bemutatja a megbizhato "bombabiztos" kodolasi technikat        *
; * 	- Bekapcsolaskor a WDT-vel reset-el, WDT tesztelesere		     *
; *     - Bekapcsolaskor minden regiszter ismert allapotba kerul             *
; *     - Nemhasznalt PROGRAM memoriat a WDT tulcsorsulasi kodjaval tolti fel*
; *     - Egyetlen egy CLRWDT utasitast hasznal a fohurokban                 *
; *     - A szubrutinhivasok szamat nyilvantartja, hiba eseten reset         *
; ****************************************************************************
	LIST     P=16C74,F=INHX8M,R=DEC       ; processzor: 16C74
	#INCLUDE C:/MPLAB/P16C74.INC          ; processzor definicios fajl
	__CONFIG _XT_OSC&_WDT_ON&_CP_OFF      ; config bitek WDT_ON !!!
	__IDLOCS 5678			      ; ID
	ERRORLEVEL 1,-306	   	      ; 302-es hibauzenet kikapcs.

CALLSUBCNT	EQU	20h	; A szubroutin hivasok szamlaloja
EXECSUBCNT	EQU	21h	; A szubroutin vegrehajtasok szamlaloja

	ORG	0		
; *******************************************************************
; Bekapcsolaskor a WDT-vel reset-el, WDT tesztelesere		     
; Bekapcsolaskor minden regiszter ismert allapotba kerul             
; *******************************************************************
	bsf	STATUS,RP0	; bank 1 valasztasa
	movlw   b'10001100'	; WDT 16-os osztoval
	movwf	OPTION_REG	;  /16 utooszto WDT-hez
	bcf	STATUS,RP0	; vissza bank 0-ra
initfileregs
	movlw  	20h		; 74-es elso fajlregiszter cime74 W-be
    	movwf  	FSR		; Ez lesz a mutato az indirekt cimzeshez
checkmem
    	movf    FSR,W		; W:=FSR
    	subwf   INDF,W		; A fajlreg. cimbol annak tartalmanak kivonasa
    	btfss   STATUS,Z	; Atlepes fajlreg.tartalom = fajlreg.cim
    	goto    initfilereg  	; Nem azonos, fajlreiszterek inic. es WDT reset
    	incf    FSR,F		; FSR novelese, eredmeny is oda (F)
    	btfss   FSR,7	 	; Atlepes, ha a cim mar 80h
    	goto    checkmem 	; ciklus
	goto	mainloop	; bank0 regiszterek tesztelve, ugras fohurokra
initfilereg
    	movf    FSR,W		; W:=FSR
    	movwf   INDF		; az FSR tartalma altal adott cimen levo
				; tartalom W-be leirva W=[FSR]
    	incf    FSR,F		; FSR novelese, eredmeny is oda (F)
	btfss   FSR,7		; Atlepes, ha a cim mar 80h
	goto    initfilereg	; ciklus
    	goto    wdtreset	; Done init so loop on self until WDT timeout

; ****************************************************************************
; *     - Egyetlen egy CLRWDT utasitast hasznal a fohurokban                 *
; *     - A szubrutinhivasok szamat nyilvantartja, hiba eseten reset         *
; ****************************************************************************
mainloop
	clrf	CALLSUBCNT	; szubrutin-hivas szamlalo torleser
	clrf	EXECSUBCNT	; szubrutin-vegrehajtas szamlalo torlese
	incf	CALLSUBCNT,F	; szubroutin-hivas szamlalo novelese
	call	subroutine1	; elso szubrutin
	incf	CALLSUBCNT,F	; szubroutin-hivas szamlalo novelese
	call	subroutine2	; masodik szubrutin
checksubcntrs
	movf	CALLSUBCNT,W	; szubrutin hivas szamlalo erteke W-br
	xorwf	EXECSUBCNT,W	; Xor a veghajtas szamlalo ertekevel
	btfss	STATUS,Z	; Atlepes, ha egyenlo
	goto	wdtreset	; nem egyforma! -> WDT reset
	clrwdt			; OK, WDT torlese
	goto	mainloop	; hurok

; ****************************************************************************
; * Mintarutinok, amelyek itt csak a vegrehajtas szamlalot novelik           *
; ****************************************************************************
subroutine1
	incf	EXECSUBCNT,F	; szubrutin vegrehajtasi regiszter novelese
				; Ide kerul a sajat kod!
	return			; vissza  hivohoz

subroutine2
	incf	EXECSUBCNT,F	; szubrutin vegrehajtasi regiszter noveleser
				; Ide kerul a sajat kod!
	return			; vissza  hivohoz

; ****************************************************************************
; * Nemhasznalt PROGRAM memoriat a WDT tulcsorsulasi kodjaval tolti fel      *
; * Lapozasos eszkozoknel a "goto wdtreset" utasitast minden lapon el kell   *
; * helyezni                                                                 *
; ****************************************************************************

	FILL	(goto	wdtreset), (7ffh-$)
	ORG	7ffh
wdtreset
	goto	wdtreset	;vegtelen hurok, a WDT reset miatt lep ki
	FILL	(goto	wdtreset), (1000h-$)
	END
