; PIC terminal v1.01

;A KVETKEZ, MEGJEGYZSEKKEL BSGESEN ELLTOTT PROGRAM-
;LISTA AZOKNAK KVN SEGTSGET NYJTANI, AKIK NEM CSAK 
;HASZNLNI AKARJK AZ LDR-KEY LETLTT, HANEM A MKD-
;ST MEG IS AKARJK RTENI. A LETLT HASZNLATHOZ EZT A
;PROGRAMOT KELL A KIVLASZTOTT PIC16F8XX TOK ELS HROM
;PROGRAMHELYRE S A LEGVGBE (AZ UTOLS 256 SZBA) 
;BEGETNI. EZ AKR A PICSTART PLUS AKR A MPLAB-ICD 
;DEBUGERREL MEGTEHET.
;
;A DEFINICIBAN MEGADOTT LBHOZ S A TPFESZLTSGHEZ 
;(+5V, GND) CSATLAKOZTATOTT LDR-KEY MR HASZNLHAT A 
;PC SOROS VONALN KERESZTL A DWNLDR.EXE WINDOWS-OS PROGRAM
;FELHASZNLSVAL  
;
;---------------[A LETLT MKDSE RVIDEN]-------------------
;
;MIVEL A FLASH PROGRAM-MEMRIAHELYEK PROGRAMOZSA HOSSZ IDEIG 
;TART EZRT A BEGETEND ADATOKAT TARTALMAZ HEX FJLT VAGY 
;OLYAN LASSAN TLTJK LE, HOGY KZBEN LEGYEN ELG ID A SZAVAK 
;PROGRAMOZSRA, VAGY MINDIG EGY SORT NAGY SEBESSGGEL EGY 
;PUFFERBE LETLTJK, MAJD EZT A SORT A PUFFERBL GETJK BE.
;AZ LDR-KEY EZ UTBBI MEGOLDST HASZNLJA.

;A PROGRAM MEGRTSHEZ AZ MPASM PIC ASSEMBELER ALAPFOK
;ISMERETE SZKSGES
;
;DVZLETTEL, A PROGRAM KSZTI:

;KLLS MT S DR. KNYA LSZL (S A MICROCHIP FEJLESZTI..;-))
;================================================================
	LIST P=16F877	; PROCESSZOR TPUS
;(AZ MPLAB OTIONS > DEVELOPMENT MODE... MENJNEK PROCESSOR 
;BELLTSA FELLBIRLJA!)
;
;-----------------[ MONITOR KEZDCIM PROCESSZORTIPUSOKNL ]------ 
IFDEF	TEST
#DEFINE		MONITOR		0X1E00
INCLUDE "P16F877.INC"
ELSE
  IFDEF __16F870
    #DEFINE	MONITOR		0X0700
    INCLUDE "P16F870.INC"
  ENDIF
  IFDEF __16F871
    #DEFINE	MONITOR		0X0700
    INCLUDE "P16F871.INC"
  ENDIF
  IFDEF __16F872
    #DEFINE	MONITOR		0X0700
    INCLUDE "P16F872.INC"
  ENDIF
  IFDEF __16F873
    #DEFINE	MONITOR		0X0F00
    INCLUDE "P16F873.INC"
  ENDIF
  IFDEF __16F874
    #DEFINE	MONITOR		0X0F00
    INCLUDE "P16F874.INC"
  ENDIF
  IFDEF __16F876
    #DEFINE	MONITOR		0X1F00
    INCLUDE "P16F876.INC"
  ENDIF
  IFDEF __16F877
    #DEFINE	MONITOR		0X1F00
    INCLUDE "P16F877.INC"
  ENDIF
ENDIF
;A LETLTTT PROGRAM NEM HASZNALHATJA A CONFIG DIREKTIVT!!!
;AZRT MERT AZT MOST FIXEN BELLTJUK. HA A BELLTS NEM J
;A LETLT BEGETSE ELTT ITT KELL MDOSTANI! 
	__CONFIG	_CP_OFF&_DEBUG_OFF&_WRT_ENABLE_ON&_CPD_OFF&_LVP_OFF&_BODEN_OFF&_PWRTE_ON&_WDT_OFF&_HS_OSC  
;
;-----------------[ DEFINICIK ]-------------------------------------

;#DEFINE		TEST		; DEBUG HASZNLATHOZ
;AZ ELZ SORRA CSAK A FEJLESZTS IDEJN VOLT SZKSG

#DEFINE		COMM_PIN	PORTB,7	; KOMMUNIKCIS PORTLB

;!!!	A FELHASZNLNAK EZT KELL "TESTRE SZABNIA"	!!!
;EZ A SOR MONDJA MEG, HOGY MELYIK LBAT SZERETNNK FELHASZNLNI
;-----------------[ VLTOZK ]---------------------------------------
;A LETLT MKDSEKOR HASZNLTAK, KLNBEN SZABADON HASZNLHATK A
;FELHASZNLI PROGRAMBAN

BUFFER	EQU	0X20	;PUFFER A LETOLTOTT HEX REKORDOKNAK

;A 70H...7FH CMEN LV REGISZTEREK MINDEN LAPRL ELRHETK (KZS)
CBLOCK	0X73		;DEFINICIOK A KOZOS ADATTERULETRE
	RXBYTE		;SOROS VONALON VETT ADATBJT
	BITCOUNTER	;BITSZMLL A SOROS VTELHEZ
	HBITTIMEL	;BITID IDZTS
	HBITTIMEH	;     "
	TEMP		;SEGDVLTOZ
	TEMP1		;   "
	BYTECOUNT	;A REKORDBAN LV BJTOK SZMA
	ADDRH		;LETLTSI CM FELS BJTJA
	ADDRL		;LETLTSI CM ALS BJTJA
	RECTYPE		;A LETLTTT REKORD TPUSA
	HEXDATAH	;A BERAND PROGRAMSZ FELS FELE
	HEXDATAL	;A BERAND PROGRAMSZ ALS FELE
	LINECHECKSUM	;A REKORD ELLENRZ SSZEGE
ENDC
;===================[ P R O G R A M  T E R  L E T E ]==============
;
	ORG	0X0000		;RESET UTN INNEN INDUL
IFDEF	TEST
	NOP			;HA MPLAB-ICD DEBUG VAN
ENDIF
	LGOTO	START		;UGRAS A LETLTBE
;===================[IDE FOG TLTDNI A FELHASZNLI PROGRAM!]======
USER_PROGRAM:			;0003 CIMEN VAN!
INTERRUPT:			;ITT KEZDDIK A MEGSZAKTSI PROGRAM
;EBBEN AZ ESETBEN A FELHASZNLI PROGRAM FELPTSE:
;	ORG	3
;	GOTO	MAIN	;UGRS A FPROGRAMBA
;	GOTO	IT_SERV		;MEGSZAKTS KISZOLGLS,
;MAIN:				;IDE JHET A FPROGRAM				
;
;===================[ MONITOR - LETLT ]===========================
;
	ORG	MONITOR		;A MEMRIA UTOLSO 256 SZAVA
DOWNLOAD_ERROR:			;LETLTSI HIBA KEZELSE
	BCF	COMM_PIN	; 
	BANKSEL	TRISA		;BANK1 VLASZTS
	BCF	COMM_PIN	;LED FOLYAMATOSAN VILGT
	GOTO	$		;VGTELEN CIKLUS RESET GOMBIG
;-------------------------------------------------------------------
START:	
	BTFSS	COMM_PIN	;GOMBOT NYOMTAK?
	GOTO	WAIT_RELEASE	;IGEN, VRJUK HOGY ELENGEDJK
	CLRF	PCLATH		;RESETKOR NEM NYOMTK MEG A AZ LDR-KEY
				;GOMBJT, ELS LAP KIVLASZTSA
	GOTO	USER_PROGRAM	;S UGRS A LETLTTT PROGRAMRA	
WAIT_RELEASE:	
	BTFSS	COMM_PIN	;A GOMB ELENGEDS VIZSGLATA
	GOTO	WAIT_RELEASE	;MG NEM
	MOVLW	0X02		;A LED KETTT FOG
	CALL	LED_BLINKING	;VILLANNI
;
;------------------[ BITID MRSE TMR1 MODULLAL ]-----------------
;
	CALL	SET_DELAY	;BITID MRS
	MOVLW	B'00001011'	;COMPARE CCP1IF SET TMR1 RESET
	MOVWF	CCP1CON		;CCP1 MODUL KONFIGURLSA
;
;------------------[ EZ A TNYLEGES LETLTRSZ KEZDETE]-----------
;
	CALL	DOWNLOADCODE	;FAJL LETLTS
	XORLW	0X00		;W=0, HA HIBTLAN
	BTFSS	STATUS,Z	
	GOTO	DOWNLOAD_ERROR	;HIBNL A LED FOLYAMATOSAN VILGIT
	MOVLW	0X03		;HRMAT VILLAN = SIKERES LETLTS
	CALL	LED_BLINKING
	GOTO	$		;ITT KERING, RESET-RE INDUL A PROG.
;
;===================[ S Z U B R U T I N O K ]======================
;
;------------------[LED-ET VILLOGTAT RUTIN ]----------------------
;W-BEN VAN, HOGY HNYAT VILLANJON 
LED_BLINKING:	
	MOVWF	BITCOUNTER	;VILLANSOK SZMA
	BSF	COMM_PIN	;KIMENETI TROL=1
	BANKSEL	TRISA		;BANK1
	BCF	COMM_PIN	;A LB KIMENET LESZ
	BANKSEL	PORTA		;BANK0	;LB MAGAS SZINT
BLINKING_LOOP:
	CALL	PAUSE		;SW IDZITS
	BCF	COMM_PIN	;VILGT
	CALL	PAUSE		;VR
	CALL	PAUSE		;VR
	BSF	COMM_PIN	;NEM VILGT
	DECFSZ	BITCOUNTER
	GOTO	BLINKING_LOOP	;
	BANKSEL	TRISA		;LB BEMENET
	BSF	COMM_PIN	;LESZ ISMT
	BANKSEL	PORTA		;A LB BEMENET A LETLTSHEZ
	RETURN
;---------------------[ SW KSLELTETS ]--------------------------
PAUSE:	CLRF	TEMP
	CLRF	TEMP1
LOOP1:	NOP		;65536 CIKLUS
	NOP
	NOP
	DECFSZ	TEMP1
	GOTO	LOOP1
	DECFSZ	TEMP
	GOTO	LOOP1
	RETURN
;-------------------[ HEX FJLT LETLT S BEGET RUTIN ]---------
;A LETLT A MICROCHIP TB25 ALKALMAZSI MEGJEGYZSBEN VOLT LERVA
;AZ EREDETI PROGRAMRSZEKRE A MEGHAGYOTT ANGOL NYELV SZVEG UTAL
DOWNLOADCODE:		;SW USART PC SOROS VONALRL VTEL
	BANKSEL	PORTA
RECORD_BEGIN
	CALL	RECEIVE_RECORD	;EGY REKORD BEOLVASSA SOROSRL
DCSTART				;S FELDOLGOZSA
	CALL	GETBYTE		;ITT MR A PUFFERBEN VAN A REKORD
	SUBLW	':'		;WAIT FOR COLON
	BTFSS	STATUS,Z
	GOTO	DCSTART

	CALL	GETHEX8		;READ BYTE COUNT
	MOVWF	BYTECOUNT	;STORE IN REGISTER
	MOVWF	LINECHECKSUM	;STORE IN LINE CHECKSUM
	BCF	STATUS,C
	RRF	BYTECOUNT,F	;DIVIDE BYTE COUNTER BY 2 TO GET WORDS
	CALL	GETHEX8		;READ HIGH BYTE OF 16-BIT ADDRESS
	MOVWF	ADDRH
	ADDWF	LINECHECKSUM,F	;ADD HIGH BYTE TO LINE CHECKSUM
	CALL	GETHEX8		;READ LOW BYTE OF 16-BIT ADDRESS
	MOVWF	ADDRL
	ADDWF	LINECHECKSUM,F	;ADD LOW BYTE TO LINE CHECKSUM
CONTINUE:
	CALL	GETHEX8		;READ RECORD TYPE
	MOVWF	RECTYPE
	ADDWF	LINECHECKSUM,F	;ADD TO LINE CHECKSUM
DATAREC				;DATA RECEPTION
	MOVF	RECTYPE,F	;CHECK FOR DATA RECORD (0H)
	BTFSS	STATUS,Z
	GOTO	ENDOFFILEREC	;OTHERWISE CHECK FOR EOF
	BCF	STATUS,C
	RRF	ADDRH
	RRF	ADDRL
;--------------------[ CMELLENRZS ]-----------------------------
;A LETLT NEM ENGEDI MEG, HOGY AZ LTALA HASZNLT TERLETRE RJUNK,
;MG HA EZ IS LENNE A HEX REKORDBAN 
	MOVLW	HIGH MONITOR	;
	XORWF	ADDRH,W
	BTFSC	STATUS,Z
	RETLW	0X02		;HA A MONITORRA AKAR RNI HIBA
	MOVF	ADDRH,F		;EZ AZ UTOLS 256 SZ
	BTFSS	STATUS,Z
	GOTO	DRLOOP
	MOVLW	LOW USER_PROGRAM;HA AZ 00...02 HELYRE AKAR IRNI, HIBA
	SUBWF	ADDRL,W
	BTFSS	STATUS,C	;
	RETLW	0X02		;02 HIBAKD: ROSSZ HELYRE RS
;--------------------[ PROGRAM RSA FLASH-BE ]--------------------
DRLOOP	
	MOVF	BYTECOUNT,F	;CHECK FOR BYTECOUNT = 0
	BTFSC	STATUS,Z
	GOTO	DRCKCHECKSUM	;IF ZERO, GOTO CHECKSUM VALIDATION
	CALL	GETHEX8		;READ LOWER BYTE OF DATA (2 CHARACTERS)
	MOVWF	HEXDATAL	;ADD RECEIVED DATA TO CHECKSUM
	ADDWF	LINECHECKSUM,F
	CALL	GETHEX8		;READ UPPER BYTE OF DATA (2 CHARACTERS)
	MOVWF	HEXDATAH	;ADD RECEIVED DATA TO CHECKSUM
	ADDWF	LINECHECKSUM,F
WRITEDATASEQUENCE		;WRITE SEQUENCE TO INTERNAL PROG. MEM FLASH
	BANKSEL	EEADRH
	MOVF	ADDRH,W		;WRITE ADDRESS TO EEADRH:EEADR REGISTERS
	MOVWF	EEADRH
	MOVF	ADDRL,W
	MOVWF	EEADR
	MOVF	HEXDATAH,W	;WRITE DATA TO EEDATH:EEDATA REGISTERS
	MOVWF	EEDATH
	MOVF	HEXDATAL,W
	MOVWF	EEDATA
	BANKSEL	EECON1		;WRITE SEQUENCE
	BSF	EECON1,EEPGD	;SET EEPGD TO INDICATE PROGRAM MEMORY
	BSF	EECON1,WREN	;ENABLE WRITES TO MEMORY
	BCF	INTCON,GIE	;MAKE SURE INTERRUPTS ARE DISABLED
	MOVLW	0X55		;REQUIRED WRITE SEQUENCE
	MOVWF	EECON2
	MOVLW	0XAA
	MOVWF	EECON2
	BSF	EECON1,WR	;START INTERNAL WRITE CYCLE
	NOP
	NOP
	BCF	EECON1,WREN	;DISABLE WRITES
	BANKSEL	EECON1		;READ SEQUENCE
	BSF	EECON1,EEPGD	;SET EEPGD TO INDICATE PROGRAM MEMORY
	BSF	EECON1,RD	;ENABLE READS FROM MEMORY
	BCF	STATUS,RP0
	NOP
	MOVF	EEDATH,W	;COMPARE MEMORY VALUE TO HEXDATAH:HEXDATAL
	SUBWF	HEXDATAH,W
	BTFSS	STATUS,Z
	RETLW	0XFF		;IF UPPER BYTE NOT EQUAL, RETURN FFH
	MOVF	EEDATA,W	;TO INDICATE PROGRAMMING FAILURE
	SUBWF	HEXDATAL,W
	BTFSS	STATUS,Z
	RETLW	0XFF		;IF LOWER BYTE NOT EQUAL, RETURN FFH
				;TO INDICATE PROGRAMMING FAILURE
	INCF	ADDRL,F		;INCREMENT ADDRESS FOR NEXT ITERATION
	BTFSC	STATUS,Z
	INCF	ADDRH,F
	DECF	BYTECOUNT,F	;DECREMENT BYTE COUNT
	GOTO	DRLOOP		;GO BACK TO CHECK FOR BYTECOUNT = 0
;----------------[ELLENRZ SSZEG ELLENRZSE ]---------------------
DRCKCHECKSUM			;CHECKSUM VERIFICATION
	CALL	GETHEX8		;READ IN CHECKSUM
	ADDWF	LINECHECKSUM,W	;ADD TO CALCULATED CHECKSUM
	BTFSS	STATUS,Z	;RESULT SHOULD BE 0
	RETLW	1		;IF NOT RETURN 1 TO INDICATE CHECKSUM FAIL
	GOTO	RECORD_BEGIN	;DO IT AGAIN
ENDOFFILEREC			;END OF FILE RECORD (01H)
	DECF	RECTYPE,W	;IF EOF RECORD, DECREMENT SHOULD = 0
	BTFSS	STATUS,Z
	GOTO	RECORD_BEGIN	;NOT VALID RECORD TYPE, WAIT FOR NEXT :
	CALL	GETHEX8		;READ IN CHECKSUM
	ADDWF	LINECHECKSUM,W	;ADD TO CALCULATED CHECKSUM
	BTFSS	STATUS,Z	;RESULT SHOULD BE 0
	RETLW	1		;IF NOT RETURN 1 TO INDICATE CHECKSUM FAIL
	RETLW	0		;OTHERWISE RETURN 0 TO INDICATE SUCCESS
;
;--------------------[ HEXA BJT BEOLVASS ]---------------------
GETHEX8				;THIS FUNCTION USES THE USART
	CALL	GETBYTE		;READ A CHARACTER FROM THE USART
	CALL	ASCII2HEX	;CONVERT THE CHARACTER TO BINARY
	MOVWF	TEMP		;STORE RESULT IN HIGH NIBBLE
	SWAPF	TEMP,F
	CALL	GETBYTE		;READ A CHARACTER FROM THE USART
	CALL	ASCII2HEX	;CONVERT THE CHARACTER TO BINARY
	IORWF	TEMP,F		;STORE RESULT IN LOW NIBBLE
	MOVF	TEMP,W		;MOVE RESULT INTO WREG
	RETURN
;--------------------[ KONVERTLS ] ----------------------------
ASCII2HEX			;CONVERT VALUE TO BINARY
	MOVWF	TEMP1		;SUBTRACT ASCII 0 FROM NUMBER
	MOVLW	'0'
	SUBWF	TEMP1,F
	MOVLW	0XF0		;IF NUMBER IS 0-9 RESULT, UPPER NIBBLE
	ANDWF	TEMP1,W		;SHOULD BE ZERO
	BTFSC	STATUS,Z
	GOTO	ASCIIOUT
	MOVLW	'A'-'0'-0X0A	;OTHERWISE, NUMBER IS A - F, SO
	SUBWF	TEMP1,F		;SUBTRACT OFF ADDITIONAL AMOUNT
ASCIIOUT
	MOVF	TEMP1,W		;VALUE SHOULD BE 0 - 15
	RETURN
;--------------------[ EGY BJT OLVASSA A PUFFERBL W-BE ]-----
GETBYTE
	BANKSEL PORTA
	MOVF	INDF,W
	INCF	FSR
	RETURN
;--------------------[ EGY REKORD BEOLVASSA A PUFFERBE ]-------
RECEIVE_RECORD:	
	MOVLW	BUFFER		;PUFFER KEZDCM
	MOVWF	FSR
NEXT_BYTE:
	CALL	RECEIVE_BYTE	;EGY BJT A SOROS VONALRL
	MOVF	RXBYTE,W
	MOVWF	INDF
	INCF	FSR,F
	MOVLW	0X0D		;WAIT FOR 0X0D
	SUBWF	RXBYTE,W	;A REKORDOT 0D TERMINLJA
	BTFSS	STATUS,Z
	GOTO	NEXT_BYTE
	MOVLW	BUFFER
	MOVWF	FSR
	RETURN
;--------------------[ BITID MEGHATROZSA ]-------------------
;KARAKTER: 0000111111 = START(0)-00011111-STOP(1)
;A NYOLC NULLA IDOTARTAMT MRJK 
SET_DELAY:
	CLRF	T1CON			
	CLRF	TMR1L
	CLRF	TMR1H
WAIT_LLEVEL:
	BTFSC	COMM_PIN	;MAGAS SZINT?
	GOTO	WAIT_LLEVEL	;IGEN	
	BSF	T1CON,TMR1ON	;NEM, MRS INDUL
WAIT_HLEVEL:
	BTFSS	COMM_PIN	;MRS MG ALACSONY
	GOTO	WAIT_HLEVEL
	BCF	T1CON,TMR1ON	;MRS LLJ
	BCF	STATUS,C
	RRF	TMR1H,F		;NULLID/2
	RRF	TMR1L,F
	BCF	STATUS,C
	RRF	TMR1H,W
	MOVWF	CCPR1H		;NULLID/4=BITID
	RRF	TMR1L,W
	MOVWF	CCPR1L		;BITIDO CCP-BE
	BCF	STATUS,C		
	RRF	CCPR1H,W		
	MOVWF	HBITTIMEH	;NULLIDO/8=FL BITID
	COMF	HBITTIMEH,F	;KOMPLEMENS KPZS
	RRF	CCPR1L,W
	MOVWF	HBITTIMEL
	COMF	HBITTIMEL,W	;FL BITIDO KOMPLEMENSE
	ADDLW	0X06		;KETTES KOMLEMENS +5 IDOZITESKORREKCIO
	MOVWF	HBITTIMEL
	BTFSC	STATUS,C
	INCF	HBITTIMEH	
	RETURN
;-----------------[BJT VTELE SOROS VONALON ] -------------------
RECEIVE_BYTE:
	BCF	T1CON,TMR1ON
	MOVLW	0X08
	MOVWF	BITCOUNTER
	MOVF	HBITTIMEL,W	;TIMER FELTOLTESE
	MOVWF	TMR1L
	MOVF	HBITTIMEH,W
	MOVWF	TMR1H
WAIT_SILENCE:
	BTFSS	COMM_PIN	;VRAKOZS HA ALACSONY
	GOTO	WAIT_SILENCE
WAIT_STARTBIT:
	BTFSC	COMM_PIN	;VRAKOZS HA MAGAS
	GOTO	WAIT_STARTBIT
	BSF	T1CON,TMR1ON	;STARTBIT JTT TIMER INDUL
NEXT_BIT:			;
	CALL	DELAY		;ELSZR MSFL BITIDNYI KSLEL!
	BCF	STATUS,C
	BTFSC	COMM_PIN
	BSF	STATUS,C
	RRF	RXBYTE
	DECFSZ	BITCOUNTER
	GOTO	NEXT_BIT
	RETURN
;--------------------[BITIDNYI KSLELTETS ]---------------------
DELAY:
	BCF	PIR1,CCP1IF
WAIT_CCP:	
	BTFSS	PIR1,CCP1IF
	GOTO	WAIT_CCP
	RETURN
;=================================================================
	END
