; Filename: ADVMACC.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 2.0                              *
; * Date      May 28, 1996                     *
; **********************************************
; ****************************************************************************
; * A program bemutatja:						     *
; *  	- Makrok hasznalatat a forraskod egyszerusitesere		     *
; *     - Felteteles assemblalas					     *
; *	- 8 * 8 szorzast a  definialt szorzo makro felhasznalasaval	     *
; * Megj: "/DTest" kifejezest a parancssorba kell irni a felteles forditas   *
; * Ez "Extra Options" a "Make Setup" menuben allithato			     * 
; ****************************************************************************

	LIST     P=16C74,F=INHX8M,R=DEC       	; proci 16C74
	#INCLUDE C:/MPLAB/P16C74.INC 	        ; Include proc. def.
	__CONFIG _XT_OSC&_WDT_OFF&_CP_OFF     	; config bitek beallitasa
	__IDLOCS 5678			      	; ID
	ERRORLEVEL 1,-302	   	      	; 302-es hibauzenet tiltasa

; **********  Valtozok definialasa     ********** 
	CBLOCK	0x20    
	VARA          ; 8 bites szorzando 0x20 cimen
	VARB          ; 8 bites szorzo 0x21
	VARC          ; 8 bites szorzando 0x22 cimen
	VARD          ; 8 bites szorzo 0x23 cimen
	HIBYTE        ; 16 bites szorzat felso bajtja 0x24
	LOBYTE        ; 16 bites szorzat felso bajtja 0x25
	COUNT         ; hurok szamlalo 0x26
	ENDC
; ***********************************************
;     8x8 szorzo rutin makro definialasa        *
;************************************************
;
; A makro ket parametere a szorzo " MULPLR ", 
; es a szorzo " MULCND " . A 16 bites eredmeny helye: HIBYTE es LOBYTE.
;
mulff   MACRO	MULCND, MULPLR
	local	mloop
	clrf    HIBYTE
	clrf    LOBYTE
	movlw   8
	movwf   COUNT
	movf    MULCND,W
	bcf     STATUS,C	; carry bit torlese
mloop   rrf     MULPLR
	btfsc   STATUS,C
	addwf   HIBYTE,F
	rrf     HIBYTE,F
	rrf     LOBYTE,F
	decfsz  COUNT
	goto    mloop
	ENDM

;************************************************

	ORG 0			; Indulas
	clrf	PORTB		; Nulla port kimeneti tarolojaba
	bsf	STATUS,RP0	;  bank 1-re
	clrf	TRISB		;  port B kimenet
	bcf	STATUS,RP0	;  bank 0-ra vissza
mainloop
	movlw   0x03
	movwf   VARA            ; szorzo=03
	movlw   0x0F             
	movwf   VARB		; szorzando=0F

	mulff	VARB,VARA       ; makro eredmeny -> HIBYTE, LOBYTE
                                
	IFDEF	Test		;Ha teszteles
	movf    LOBYTE,W	; LOBYTE -> PORTB
	movwf	PORTB
	ENDIF

	movlw   0x08		; kulonben...
	movwf   VARC            ; szorzo=08
	movlw   0x09             
	movwf   VARD		; szorzando=09

	mulff	VARD,VARC       ; makro eredmeny -> HIBYTE, LOBYTE

self    goto    self		;helybenfutas

        END        


