; Filename: ADVTASKI.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 1.0                              *
; * Date      Feb 6, 1996                      *
; **********************************************
; ****************************************************************************
; * A program bemutatja:						     *
; *	- Megszakitasos taszk kezelest, a taszkok az IT rutinban futnak      *
; *	- TMR0 megszakit 4 msec-onkent					     *
; *	- keyscan fut  52 msec-kent  (minden  13 megszakitasban		     *
; *	- inctime fut mp-kentt (250 megszakitasonkent)	          	     *
; *	- 4.096 MHz-es a kristaly                          			     *
; ****************************************************************************
	LIST     P=16C74,F=INHX8M,R=DEC       ; processzor 16C74
	#INCLUDE C:/MPLAB/P16C74.INC 	      ; processzor definicio
	__CONFIG _XT_OSC&_WDT_OFF&_CP_OFF     ; config bitek
	__IDLOCS 5678			      ; ID
	ERRORLEVEL 1,-306	   	      ; 306-os hibauzenet kikapcs.

KEYTIME		EQU	20h	; Billentyuzet idozito valtozo
ROTTIME		EQU	21h	; forgatas idozito valtozo

	ORG	0		; start
init
	clrf	PORTB		; PORTB kimenet nulla
	bsf	STATUS,RP0	; page 1-re
	clrf	TRISB		; PORTB kimenet
	goto	startprg	; ugras programstartra

	ORG	4		; megszakitasi rutin kezdocime
introutine
	bcf	INTCON,T0IF	; megszakitas jelzobit torlese
	incf	KEYTIME,F	; Bill. idozito novelese (52 msec)
	incf	ROTTIME,F	; forgatas idozito (1000 msec) novelese
	movlw	.13		; bill. idotartam  W-be
	xorwf	KEYTIME,W	; letelt?
	btfsc	STATUS,Z	; Atlep, ha meg nem erte el 
	call	scankeys        ; kulonben billentyuzet idozites
	movlw	.250            ; forgatas idotartam W-be
	xorwf	ROTTIME,W	; letelt?
	btfsc	STATUS,Z	; Atlep, ha meg nem erte el 
	call	rotate		; Execute rotate time routine
	retfie			; Done, so return

scankeys
	bsf	PORTB,0		; RB0 bit 1 - be
	clrf	KEYTIME		; Bill. idozito torlese
	return			; kesz, return!

rotate
	rlf	PORTB,F		; PORTB regiszter forgatasa
	clrf	ROTTIME		; forgato idozito torlese
	return

startprg
;	movlw	b'00000111'	; elooszto
	movlw	b'00000011'	; elooszto
	movwf	OPTION_REG	; OPTION regiszter inicializalasa
	bcf	STATUS,RP0	; 0-as lapra
	clrf	KEYTIME		; KEYTIME szamlalo torlese
	clrf	ROTTIME		; ROTTIME szamlalo torlese
	clrf	TMR0		; TMR0 regiszter torles
	BSF	INTCON,T0IE	; timer0 megszakitas engedelyezese
	BSF	INTCON,GIE	; globalis megszakitas engedelyezese
mainloop
	goto	mainloop	; itt a fo programhurok!
	END
