; Filename: ADVTASKM.ASM
; **********************************************
; * Advanced Seminar Sample File               *
; * Revision: 1.0                              *
; * Date      Feb 6, 1996                      *
; **********************************************
; ****************************************************************************
; * A program bemutatja:						     *
; *	- A foprogramban futo megszakitasos taszk-kezelest		     *
; *	- TMR0 4 msec-kent szakit meg					     *
; *	- keyscan jelzobit 52 msec.-kent lesz 1 (minden 13.-k IT)	     *
; *	- inctime jelzobit 1 sec.-kent lesz 1 (minden 250.-ik IT)	     *
; * 	- A fo hurokban figyeljuk ezeket a jelzobiteket es futtatjuk a rutint*
; *	- 4.096 MHz-es kristaly                          			     *
; ****************************************************************************
	LIST     P=16C74,F=INHX8M,R=DEC       ; proci 16C74
	#INCLUDE C:/MPLAB/P16C74.INC          ; processzor definicio
	__CONFIG _XT_OSC&_WDT_OFF&_CP_OFF     ; config bitek
	__IDLOCS 5678			      ; ID
	ERRORLEVEL 1,-306	   	      ; 306-os hibauzenet ki

KEYTIME		EQU	20h	; billentyuzet idozites
ROTTIME		EQU	21h	; forgatas idozites
FLAGS		EQU	22h	; jelzobit regiszter
#define		ROTBIT	FLAGS,0	; forgatas flag bit
#define		KEYBIT	FLAGS,1	; billentyu flag bit

	ORG	0		; reset
init
	clrf	PORTB		; PORTB kimeneti regiszterebe 0
	bsf	STATUS,RP0	; page 1-re
	clrf	TRISB		; PORTB kimenet
	goto	startprg	; program indul

	ORG	4		; megszakitasi rutin (ISR) kezdocime
introutine
	bcf	INTCON,T0IF	; timer IT jelzobit torlese
	incf	KEYTIME,F	; billentyuzet idozites szamlalo novelese
	incf	ROTTIME,F	; forgatas idozito novelese
	movlw	.13		; billentyuzet idozites lejartanak vizsgalata
	xorwf	KEYTIME,W	; 13?
	btfsc	STATUS,Z	; atlep ha meg nem 
	bsf	KEYBIT        	; bill. jelzobit -> 1
	movlw	.250            ; forgatas idozites ellenorzese
	xorwf	ROTTIME,W	; 250 (=1 sec)
	btfsc	STATUS,Z	; atlep, ha nem
	bsf	ROTBIT        	; forgatas jelzobit -> 1
	retfie			; IT szerviz kesz

scankeys
	bsf	PORTB,0		;  RB0 bit 1
	clrf	KEYTIME		; idozites torlese
	bcf	KEYBIT		; jelzobit torlese
	return			; kesz

rotate
	rlf	PORTB,F		; PORTB forgatasa
	clrf	ROTTIME		; idozites torlese
	bcf	ROTBIT		; jelzobit torlese
	return

startprg
;	movlw	b'00000111'	; elooszto beallitasa
	movlw	b'00000000'	; 
	movwf	OPTION_REG	; OPTION reg
	bcf	STATUS,RP0	; page 0-ra
	clrf	TMR0		; TMR0 reg. torlese
	BSF	INTCON,T0IE	; timer0 IT mehet
	BSF	INTCON,GIE	; global IT engedelyezese
mainloop
	btfsc	KEYBIT		; atlep ha keybit 0
	call	scankeys	; SCANKEYS rutin
	btfsc	ROTBIT		; atlep ha rotbit 0
	call	rotate		; rotate rutin
	goto	mainloop	; vissza!
	END
