;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    EEPROM.ASM                                        *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    PIC16F87x ADAT EEPROM MEMRIA R/OLVAS DEMO PROGRAM            *
;    -----------------------------------------------------            *
;    A program a 0, 1, 2 s 3 cm EEPROM rekeszekbe rendre a 66H,    *
;    77H, 88H illetve 99H bjtokat rja, majd a 2-es cm rekesz      *
;    tartalmt visszaolvassa az EEPROM_Data vltozba.		      *
;                                                                     *
;**********************************************************************
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;----------------------------------------------------------------------
;
EEPROM_Address	equ     0x7E              	; EEPROM cm tmeneti tr
EEPROM_Data	equ     0x7F             	; EEPROM adat tmeneti tr
;
; Megjegyzs:
; -----------
; 1. A PIC16F877 esetn a BANK0 70h..7Fh terlete minden BANK-bl elrhet.
; 2. A 70h valamint az 1EBh..1EFh memriaterlet foglalt az MPLAB-ICD szmra!
;
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             		; reset vektor
		nop				; MPLAB-ICD miatt szksges
;----------------------------------------------------------------------
; I/O portok konfigurlsa
;
Start		bsf	STATUS,RP0	
		bcf	STATUS,RP1		; bank1 kivlaszts
		movlw	14
		movwf	ADCON1			; RA0 analg bemenet !!!
		movlw	B'00111111'    		; PORTA bemenet
		movwf	TRISA
		bcf	STATUS,RP0		; bank0 kivlaszts
;----------------------------------------------------------------------
; EEPROM adatmemria rs/olvass
;
        	movlw   0			; cm bellts
        	movwf   EEPROM_Address
        	movlw   H'66'			; adat bellts
        	movwf   EEPROM_Data
        	call    EE_Write		; EEPROM rs
        	movlw   1
        	movwf   EEPROM_Address
        	movlw   H'77'
        	movwf   EEPROM_Data
        	call    EE_Write
        	movlw   2
        	movwf   EEPROM_Address
        	movlw   H'88'
        	movwf   EEPROM_Data
        	call    EE_Write
        	movlw   3
        	movwf   EEPROM_Address
        	movlw   H'99'
        	movwf   EEPROM_Data
        	call    EE_Write
;----------------------------------------------------------------------
        	movlw   2			; cm bellts
        	movwf   EEPROM_Address
        	call    EE_Read			; EEPROM olvass
;----------------------------------------------------------------------
Stop		goto    Stop			; vrakozs resetre
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;***************************** SZUBRUTINOK ****************************
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
EE_Write 	bcf     STATUS,RP0      
		bsf     STATUS,RP1		; bank2 kivlaszts
		movf	EEPROM_Address,0
		movwf	EEADR			; aktulis cm trolsa
		movf	EEPROM_Data,0
		movwf	EEDATA			; aktulis adat trolsa
		bsf     STATUS,RP0		; bank3 kivlaszts
        	bcf     EECON1,EEPGD		; adatmemria kivlaszts
        	bsf     EECON1,WREN		; rs engedlyezs
        	bcf	INTCON,GIE
;----------------------------------------------------------------------
        	movlw   0x55			; ********************
        	movwf   EECON2			; * rsi szekvencia *
        	movlw   0xAA			; *                  *
        	movwf   EECON2			; ********************
;----------------------------------------------------------------------
        	bsf     EECON1,WR		; rsi folyamat indtsa
        	bcf     STATUS,RP0      
		bcf     STATUS,RP1		; bank0 kivlaszts
Busy    	btfss   PIR2,EEIF            	; vr az nidzts rsi
        	goto    Busy			; folyamat vgre
;----------------------------------------------------------------------
        	bcf     PIR2,EEIF		; EEPROM rs komplett flag            
        	return				; trlse
;----------------------------------------------------------------------
EE_Read  	bcf     STATUS,RP0
		bsf     STATUS,RP1		; bank2 kivlaszts
		movf	EEPROM_Address,0
		movwf	EEADR			; aktulis cm trolsa
		bsf     STATUS,RP0		; bank3 kivlaszts
        	bcf     EECON1,EEPGD		; adatmemria kivlaszts
        	bsf     EECON1,RD		; EEPROM olvass
        	bcf     STATUS,RP0		; bank2 kivlaszts
        	movf    EEDATA,0
        	movwf	EEPROM_Data
        	return
;----------------------------------------------------------------------
                end

