#ifndef MAIN_H
#define MAIN_H 1
/*
 Copyright (C) 2009 Paul van der Hoeven.
 This is free software, licensed under the terms of the GNU General
 Public License as published by the Free Software Foundation.
*/

// F_CPU used by: uart, timer, lcd, delay
//#define F_CPU  4000000
//#define F_CPU  9216000
//#define F_CPU 10000000
#define F_CPU 8000000UL
//#define F_CPU 3000000

#include <avr/io.h>
#include <inttypes.h>
//------------- Prototypes. -------------------------------------------------
uint8_t HandlePacket(void);
uint16_t TemperatureRead(void);
void SendMessage(void);
void SendStatus(void);

//---------------------------------------------------------------------------
// User definitions for: main.h
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// User definitions for: timer
//---------------------------------------------------------------------------
//#ifdef TIMER_H
// TIMER_RESOLUTION in milli seconds  is one of: 1  2 (2.5)  5  10  20
#define TIMER_RESOLUTION 10
//#endif  // #ifdef TIMER_H

//---------------------------------------------------------------------------
// User definitions for Lcd
//---------------------------------------------------------------------------
//#ifdef LCD_H

//#define LCD_SIZE		LCD_SIZE_1x16	// Use one of these sizes.
#define LCD_SIZE		LCD_SIZE_2x16
//#define LCD_SIZE		LCD_SIZE_2x40

#define LCD_BYTEWIDE		0	// 1 for 8-bit 0 for 4 separate pins.
//#define USE_LIB_DELAY		1

#define LCD_RS_DDR		DDRD
#define LCD_RS_PORT		PORTD
#define LCD_RS_BIT		0

#define LCD_CS_DDR		DDRD	
#define LCD_CS_PORT		PORTD
#define LCD_CS_BIT		2

#if LCD_BYTEWIDE		// Data is a whole byte.
#define LCD_DATA_PORT	PORTB
#define LCD_DATA_DDR	DDRB
#define LCD_DATA_PIN	PINB

#else				// Data are 4 individual bits.
#define LCD_DATA_PORT_BIT4	PORTB
#define LCD_DATA_PORT_BIT5	PORTB
#define LCD_DATA_PORT_BIT6	PORTB
#define LCD_DATA_PORT_BIT7	PORTB

#define LCD_DATA_DDR_BIT4	DDRB
#define LCD_DATA_DDR_BIT5	DDRB
#define LCD_DATA_DDR_BIT6	DDRB
#define LCD_DATA_DDR_BIT7	DDRB

#define LCD_DATA_PIN_BIT4	PINB
#define LCD_DATA_PIN_BIT5	PINB
#define LCD_DATA_PIN_BIT6	PINB
#define LCD_DATA_PIN_BIT7	PINB

#define LCD_DATA_BIT4	3	/* Bit number of the output pin */
#define LCD_DATA_BIT5	2
#define LCD_DATA_BIT6	1
#define LCD_DATA_BIT7	0

#define USE_LCD_CLEAR	1

#endif	// #if LCD_BYTEWIDE
//#endif	// #ifdef LCD_H
//---------------------------------------------------------------------------
// User definitions for: .h
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// User definitions for: .h
//---------------------------------------------------------------------------

#endif // MAIN_H






