#ifndef LCD_H
#define LCD_H 1

/*---------------------------------------------------------------------------
P. vd Hoeven.
Target: AVR-GCC
Lcd routines door P van der Hoeven.

Reading from the lcd is disabled (R/W connected to gnd) so we must wait long
enough for each write operation to complete.

Copyright (C) 2009 Paul van der Hoeven.
This is free software, licensed under the terms of the GNU General
Public License as published by the Free Software Foundation.
---------------------------------------------------------------------------*/

#include <avr/pgmspace.h>
//#include "main.h"

// List of supported LCD_SIZE
#define LCD_SIZE_1x16		116
#define LCD_SIZE_2x16		216
#define LCD_SIZE_2x20		220
#define LCD_SIZE_2x40		240

#define LCD_LINE_1		0


#if   LCD_SIZE==LCD_SIZE_1x16
#define LCD_LINE_SIZE		16

#elif LCD_SIZE==LCD_SIZE_2x16
#define LCD_LINE_2		16
#define LCD_LINE_SIZE		16

#elif LCD_SIZE==LCD_SIZE_2x20
#define LCD_LINE_2		20
#define LCD_LINE_SIZE		20

#elif LCD_SIZE==LCD_SIZE_2x40
#define LCD_LINE_2		40
#define LCD_LINE_SIZE		40
#endif

#if LCD_SHOW_CURSOR
extern uint8_t Cursor;
#endif

//---------------------------------------------------------------------------
#define LCD_COMMAND_SET_DDRAM_ADRESS	0x80
#define LCD_COMMAND_SET_CGRAM_ADRESS	0x40
#define LCD_COMMAND_FUNCTION_SET	0x20
#define LCD_COMMAND_SHIFT		0x10
#define LCD_COMMAND_CURSOR_ON		0x0E
#define LCD_COMMAND_CURSOR_BLINK	0x0D
#define LCD_COMMAND_DISPLAY_ON		0x0E
#define LCD_COMMAND_CURSOR_OFF		0x0C
//---------------------------------------------------------------------------
void LcdWriteByte( uint8_t Data);	// Write a single byte to the LCD.
void LcdInit(void);		// Initialize the LCD.
#if USE_LCD_CLEAR
void LcdClear(void);		// Clear the LCD.
#endif
void LcdCommand(uint8_t Data);	// Send a command to the LCD.
void LcdSetCursor(uint8_t Pos);	// Move the Cursor around.
void LcdPutC(uint8_t Data);	// Write a single character to the LCD.
void LcdPutS(char *pS);		// Write a string to the LCD.
#if USE_LCD_PUT_X_HEX
void LcdPut1Hex(uint8_t C);	// Write a nibble to the LCD.
void LcdPut2Hex(uint8_t C);	// Write a byte (as 2 hex nibbles) to the LCD.
void LcdPut4Hex(uint16_t C);	// Write a int (as 4 hex digits) to the LCD.
#endif
void LcdWriteCgRam_P(uint8_t const *,uint8_t);	// Write custom char's to lcd.


/*
** macros for automatically storing string constant in program memory
** from Peter Fleury  <pfleury@gmx.ch>  http://jump.to/fleury 
*/
#ifndef P
#define P(s) ({static const char c[] __attribute__ ((progmem)) = s;c;})
#endif
#define LcdPutSP(__s)         lcd_puts_p(P(__s))


// Do not call this function directly, use LcdPutsP() instead
void lcd_puts_p(const char *progmem_s);

#endif
