LCD8_877.ASM
;***************************************************************************
;
;			PROGRAMA PARA ESCRITA EM LCD
;
;	DATA: 15/04/2001
;
;	DESENVOLVIDO POR GOR TSCHOEPKE GOEDEL - ESTAS ROTINAS PODEM SER
;	USADAS LIVREMENTE, DESDE QUE SEMPRE SEJA CITADO O AUTOR.
;
;	PROCESSADOR: PIC16F877
;
;	COMUNICAO EM 8 BITS, SEM O USO DE DELAYS VIA SOFTWARE (PORTANTO,
;	O CLOCK PODE SER ALTERADO SEM PROBLEMAS), POIS TODAS ROTINAS DE
;	ENVIO DE DADOS, ENDEREOS OU COMANDOS S RETORNAM QUANDO O BUSY FLAG
;	DO LCD INDICAR QUE ESTE EST LIVRE.
;
;	ESQUEMAS DE LIGAO:
;
;	RE0:	SADA, LIGADO AO PINO N 4 (RS) DO LCD
;	RE1:	SADA, LIGADO AO PINO N 5 (RW) DO LCD
;	RE2:	SADA, LIGADO AO PINO N 6 (E) DO LCD
;
;	RD0:	BIDIRECIONAL, LIGADO AO PINO N 7 (D0) DO LCD
;	RD1:	BIDIRECIONAL, LIGADO AO PINO N 8 (D1) DO LCD
;	RD2:	BIDIRECIONAL, LIGADO AO PINO N 9 (D2) DO LCD
;	RD3:	BIDIRECIONAL, LIGADO AO PINO N 10 (D3) DO LCD
;	RD4:	BIDIRECIONAL, LIGADO AO PINO N 11 (D4) DO LCD
;	RD5:	BIDIRECIONAL, LIGADO AO PINO N 12 (D5) DO LCD
;	RD6:	BIDIRECIONAL, LIGADO AO PINO N 13 (D6) DO LCD
;	RD7:	BIDIRECIONAL, LIGADO AO PINO N 14 (D7) DO LCD
;
;***************************************************************************

        INCLUDE "P16F877A.INC"

;DESLIGA A MENSAGEM DE AVISO N 302:
;"Register in operand not in bank 0.  Ensure that bank bits are correct"

	ERRORLEVEL	-302

RS		EQU     0X00	;REGISTER SELECT 1 = DADO, 0 = INSTRUO
RW		EQU     0X01	;READ/WRITE 1 = LEITURA 0 = ESCRITA
E		EQU     0X02	;ENABLE
BUSYFLAG	EQU	0X07	;BUSY FLAG 1 = OCUPADO 0 = LIVRE

	CBLOCK	0X20
		AUX1	;AUX1 E AUX2 SO VARIVEIS AUXILIARES USADAS NAS
		AUX2	;SEGUINTES ROTINAS: 'EL' (ENVIA LINHA) E 'DELAY'
		AUX3	;VARIVEL AUXILIAR USADA SOMENTE NA ROTINA 'DELAY'
	ENDC

	ORG	0X00		;VETOR DE RESET

INICIO
	BSF     STATUS,RP0	;VAI PARA O BANCO 1
	MOVLW	0X00
	MOVWF	TRISA		;CONFIGURA O PORTA TODO COMO SADA
	MOVWF	TRISB		;CONFIGURA O PORTB TODO COMO SADA
	MOVWF	TRISC		;CONFIGURA O PORTC TODO COMO SADA
	MOVWF	TRISD		;CONFIGURA O PORTD TODO COMO SADA
	MOVWF	TRISE		;CONFIGURA O PORTE TODO COMO SADA
	MOVLW	0X06		;CONFIGURA PORTA E PORTE SOMENTE
	MOVWF	ADCON1		;COMO I/O DIGITAL
	BCF	STATUS,RP0	;VOLTA PARA O BANCO 0

	MOVLW	0X38		;INCIO DA CONFIGURAO DO LCD
	CALL	EC		;CONFIGURA PARA:
	MOVLW	0X38		;DUAS LINHAS
	CALL	EC		;5 X 7 PONTOS
	MOVLW	0X06		;16 X 2 CARACTERES
	CALL	EC		;8 BITS
	MOVLW	0X0C		
	CALL	EC
	MOVLW	0X01
        CALL    EC              ;FIM DA CONFIGURAO DO LCD

	MOVLW	0X40		;COLOCA '' NA CGRAM
	CALL	EC
	MOVLW	0X02
	CALL	ED
	MOVLW	0X04
	CALL	ED
	MOVLW	0X1F
	CALL	ED
	MOVLW	0X04
	CALL	ED
	MOVLW	0X04
	CALL	ED
	MOVLW	0X04
	CALL	ED
	MOVLW	0X1F
	CALL	ED
	MOVLW	0X00
	CALL	ED
ESCREVE
	MOVLW	0X80		;ENDEREA A DDRAM DO LCD PARA O
	CALL	EE		;1 CARACTER DA 1 LINHA
	MOVLW   ' '		;ENVIA UMA LINHA INTEIRA ATRAVS DA
	CALL	ED		;ROTINA 'ED' QUE ENVIA S UM CARACTER
        MOVLW   ' '
	CALL	ED
	MOVLW	'T'
	CALL	ED
        MOVLW   'e'
	CALL	ED
        MOVLW   's'
	CALL	ED
        MOVLW   't'
	CALL	ED
        MOVLW   'e'
	CALL	ED
        MOVLW   ' '
	CALL	ED
        MOVLW   'd'
	CALL	ED
        MOVLW   'e'
	CALL	ED
        MOVLW   ' '
	CALL	ED
        MOVLW   'L'
	CALL	ED
        MOVLW   'C'
	CALL	ED
        MOVLW   'D'
	CALL	ED
        MOVLW   ' '
	CALL	ED
        MOVLW   ' '
	CALL	ED
        MOVLW   0XC0		;ENDEREA A DDRAM DO LCD PARA O
	CALL	EE		;1 CARACTER DA 2 LINHA
	MOVLW	LINHA1		;PE EM 'W' A POSIO DA TABELA 'LINHA1'
				;QUE DEVE ESTAR NA 1 PGINA DE MEMRIA
				;E CONTM 16 CARACTERES (UMA LINHA)
	CALL	EL		;ESCREVE UMA LINHA INTEIRA ATRAVS DA
				;ROTINA 'EL', QUE ENVIA TODA UMA LINHA

	CALL	DELAY		;DELAY DE 1,75 SEGUNDOS (@ 4MHz)

	MOVLW	0X80		;ENDEREA A DDRAM
	CALL	EE
	MOVLW	LINHA2
	CALL	EL
        MOVLW   0XC0
	CALL	EE
	MOVLW	LINHA3
	CALL	EL

	CALL	DELAY

	GOTO	ESCREVE

;******************************
;***     ROTINAS DO LCD     ***
;******************************

ED				;ESCREVE DADO QUE EST EM 'W' NA DDRAM DO LCD
	BSF		PORTE,RS
    BCF 	PORTE,RW
ENVIABYTE			;ROTINA PARA O ENVIO DE UM BYTE QUALQUER
	BSF		PORTE,E
	MOVWF	PORTD
	BCF		PORTE,E
	CALL    CHECABUSYFLAG
	RETURN

EC				;ENVIA O COMANDO QUE EST EM 'W' PARA O LCD
	BCF		PORTE,RS
    BCF     PORTE,RW
	CALL	ENVIABYTE
	RETURN

EE				;ESCREVE O ENDEREO QUE EST EM 'W' NO LCD
	BCF		PORTE,RS
    BCF     PORTE,RW
	CALL	ENVIABYTE
	RETURN

CHECABUSYFLAG			;ROTINA QUE S RETORNA QUANDO BUSYFLAG = 0
	BSF		STATUS,RP0	;VAI PARA O BANCO 1
	MOVLW	0XFF
	MOVWF	TRISD		;CONFIGURA O TRISD
	BCF		STATUS,RP0	;VOLTA PARA O BANCO 0
	BCF		PORTE,RS
	BSF		PORTE,RW
	BSF		PORTE,E
	BTFSS	PORTD,BUSYFLAG	;TESTA BUSY FLAG
	GOTO	RETORNO		;SE BUSYFLAG = 0 VAI PARA A ROTINA DE RETORNO
	BCF		PORTE,E
	GOTO	$ - 4		;LOOP PARA NOVO TESTE DO BUSY FLAG
RETORNO				;ROTINA PARA RETORNAR DE CHECABUSYFLAG
	BCF		PORTE,E
	BSF		STATUS,RP0	;VAI PARA O BANCO 1
	MOVLW	0X00
	MOVWF	TRISD		;CONFIGURA O TRISD
	BCF		STATUS,RP0	;VOLTA PARA O BANCO 0
	RETURN	

EL			;ROTINA QUE ENVIA UMA LINHA INTEIRA PARA O LCD
			;(S FUNCIONA ADEQUADAMENTE PARA LCD's 16 X 2)
	MOVWF	AUX2	;ESTA OTINA PODE SER EXCLUDA SEM ALTERAR AS
	CLRF	AUX1	;OUTRAS ROTINAS DO LCD
	DECF	AUX1,F
EL1
	INCF	AUX1,F
	BTFSC	AUX1,4
	RETURN
	MOVF	AUX2,W
	ADDWF	AUX1,W
	CALL	MSGS
	CALL	ED
	GOTO	EL1

MSGS	MOVWF	PCL	;'CABEALHO' DAS TABELAS DE CARACTERES

LINHA1	RETLW	'd'	;PRIMEIRA TABELA DE CARACTERES
	RETLW	'e'	;PODEM SER FEITAS NOVAS TABELAS E
	RETLW	's'	;ESTAS PODEM TER O SEU 'LABEL'
	RETLW	'e'	;COM O NOME QUE SE QUISER
	RETLW	'n'
	RETLW	'v'
	RETLW	'o'
	RETLW	'l'
	RETLW	'v'
	RETLW	'i'
	RETLW	'd'
	RETLW	'o'
	RETLW	' '
	RETLW	'p'
	RETLW	'o'
	RETLW	'r'

;******************************
;*** FIM DAS ROTINAS DO LCD ***
;******************************

;ESTAS TABELAS SO SOMENTE EXEMPLOS, PODENDO SER
;EXCLUDAS SEM AFETAR AS ROTINAS DE COMUNICAO

LINHA2	RETLW	' '
	RETLW	0X00	;CDIGO DO '' PREVIAMENTE GRAVADO NA CGRAM
	RETLW	'g'
	RETLW	'o'
	RETLW	'r'
	RETLW	' '
	RETLW	'T'
	RETLW	's'
	RETLW	'c'
	RETLW	'h'
	RETLW	'o'
	RETLW	'e'
	RETLW	'p'
	RETLW	'k'
	RETLW	'e'
	RETLW	' '

LINHA3	RETLW	' '
	RETLW	' '
	RETLW	' '
	RETLW	' '
	RETLW	' '
	RETLW	'G'
	RETLW	'o'
	RETLW	'e'
	RETLW	'd'
	RETLW	'e'
	RETLW	'l'
	RETLW	' '
	RETLW	' '
	RETLW	' '
	RETLW	' '
	RETLW	' '

DELAY				;DELAY DE APROXIMADAMENTE 1,75 SEGUNDOS
	CLRF	AUX3		;(@ 4MHz) ESTA ROTINA  USADA PARA PERDER
DELAY1				;TEMPO ENTRE O ENVIO DAS TELAS, PODENDO
	INCF	AUX3,F		;SER EXCLUDA SEM PREJUDICAR AS ROTINAS
	BTFSC	AUX3,3		;DE COMUNICAO COM O MDULO LCD
	RETURN
	MOVLW	0XFA
	MOVWF	AUX1
REPETE1
	MOVLW	0XF9
	MOVWF	AUX2
REPETE2
	NOP
	DECFSZ	AUX2,F
	GOTO	REPETE2
	DECFSZ	AUX1,F
	GOTO	REPETE1
	GOTO	DELAY1

	END			;FIM DO PROGRAMA