/* main.c - Software vector mode program using C isr for MPC56xxB/P/S */
/* Jan 15, 2009 S.Mihalik- Initial version based on previous AN2865 example */
/* Feb 02, 2009 S.Mihalik- Changed to run in RUN0 mode instead of all DRUN mode*/
/* May 22 2009 S. Mihalik- Simplifed by removing unneeded sysclk, PCTL code */
/* Jul 03 2009 S Mihalik - Simplified code */
/* Mar 14 2010 SM - modified initModesAndClock, updated header file */
/* Copyright Freescale Semiconductor, Inc. 2009. All rights reserved. */

#include "MPC5604B_0M27V_0102.h" /* Use proper include file */

extern IVOR4Handler();
extern uint32_t __IVPR_VALUE; /* Interrupt Vector Prefix vaue from link file*/
extern const vuint32_t IntcIsrVectorTable[];

    uint32_t Pit1Ctr = 0;   /* Counter for PIT 1 interrupts */
    uint32_t SWirq4Ctr = 0;	/* Counter for software interrupt 4 */

void initModesAndClock(void) {
  ME.MER.R = 0x0000001D;          /* Enable DRUN, RUN0, SAFE, RESET modes */
                                  /* Initialize PLL before turning it on: */
/* Use 1 of the next 2 lines depending on crystal frequency: */
  CGM.FMPLL_CR.R = 0x02400100;    /* 8 MHz xtal: Set PLL0 to 64 MHz */   
/*CGM.FMPLL_CR.R = 0x12400100;*/  /* 40 MHz xtal: Set PLL0 to 64 MHz */   
  ME.RUN[0].R = 0x001F0074;       /* RUN0 cfg: 16MHzIRCON,OSC0ON,PLL0ON,syclk=PLL */
  ME.RUNPC[1].R = 0x00000010; 	  /* Peri. Cfg. 1 settings: only run in RUN0 mode */
  
  ME.PCTL[68].R = 0x01;           /* SIUL: select ME_RUN_PC[1] */
  
  ME.PCTL[92].R = 0x01;           /* PIT, RTI: select ME_RUN_PC[1] */	    	
                                  /* Mode Transition to enter RUN0 mode: */
  ME.MCTL.R = 0x40005AF0;         /* Enter RUN0 Mode & Key */
  ME.MCTL.R = 0x4000A50F;         /* Enter RUN0 Mode & Inverted Key */  
  while (ME.GS.B.S_MTRANS) {}     /* Wait for mode transition to complete */    
                                  /* Note: could wait here using timer and/or I_TC IRQ */
  while(ME.GS.B.S_CURRENTMODE != 4) {} /* Verify RUN0 is the current mode */
}

void disableWatchdog(void) {
  SWT.SR.R = 0x0000c520;     /* Write keys to clear soft lock bit */
  SWT.SR.R = 0x0000d928; 
  SWT.CR.R = 0x8000010A;     /* Clear watchdog enable (WEN) */
}        

asm void initIrqVectors(void) {
  lis	   r3, __IVPR_VALUE@h   /* IVPR value is passed from link file */
  ori      r3, r3, __IVPR_VALUE@l 
  mtivpr   r3									 
}

void initINTC(void) {	
  INTC.MCR.B.HVEN = 0;       /* Single core: initialize for SW vector mode */
  INTC.MCR.B.VTES = 0;       /* Single core: Use default vector table 4B offsets */
  INTC.IACKR.R = (uint32_t) &IntcIsrVectorTable[0];    /* MPC555x: INTC ISR table base */
}

void initPIT(void) {
                            /* NOTE:  DIVIDER FROM SYSCLK TO PIT ASSUMES DEFAULT DIVIDE BY 1 */
  PIT.PITMCR.R = 0x00000001;       /* Enable PIT and configure timers to stop in debug mode */
  PIT.CH[1].LDVAL.R = 64000;       /* PIT1 timeout = 64000 sysclks x 1sec/64M sysclks = 1 msec */
  PIT.CH[1].TCTRL.R = 0x000000003; /* Enable PIT1 interrupt and make PIT active to count */ 
  INTC.PSR[60].R = 0x01;           /* PIT 1 interrupt vector with priority 1 */
}

void initSwIrq4(void) {
  INTC.PSR[4].R = 2;		/* Software interrupt 4 IRQ priority = 2 */
}

void enableIrq(void) {
  INTC.CPR.B.PRI = 0;          /* Single Core: Lower INTC's current priority */
  asm(" wrteei 1");	    	   /* Enable external interrupts */
}

void main (void) {	
  vuint32_t i = 0;			    /* Dummy idle counter */

  initModesAndClock();  /* MPC56xxP/B/S: Initialize mode entries, set sysclk = 64MHz*/
  disableWatchdog();    /* Disable watchdog */
  initIrqVectors();		/* Initialize exceptions: only need to load IVPR */
  initINTC();			/* Initialize INTC for software vector mode */
//  initPIT();		  	/* Initialize PIT1 for 1KHz IRQ, priority 2 */
 // initSwIrq4();			/* Initialize software interrupt 4 */
  enableIrq();		   	/* Ensure INTC current prority=0 & enable IRQ */		
  			SIU.PCR[74].R = 0x0102; //input buffer enable and pull down enable */
			SIU.IRER.R=0x400;		//interrupt request enable on eirq10 PE[10] */
			SIU.IREER.R=0x400;			//interrupt request rising edge event enable PE [10] */ 
			SIU.IFER.R=0x400;		//something filter */
			INTC.PSR[42].R = 0x01;           /* eirq interrupt vector with priority 1 */	
			SIU.ISR.R=0x400;	//Clear interrupt */
  while (1) { 
  	i++;
  }	
}

void EirqISR()	// function when is interrupt
	{
	while(1)
		{
		}
	SIU.ISR.R=0x400;	//Clear interrupt
	}

