{ +--------------------------------------------------------------------------+ }
{ | Tubes 1.01 * Electrontube catalogue                                      | }
{ | Copyright (C) 2008-2011 Pozsar Zsolt <info@pozsarzs.hu>                  | }
{ | frmhelppic.pp                                                            | }
{ | Gallery viewer                                                           | }
{ +--------------------------------------------------------------------------+ }

{
      This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

      This code is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

      A copy of the GNU General Public License is available on the World
    Wide Web at http://www.gnu.org/copyleft/gpl.html. You can also
    obtain it by writing to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit frmhelppic;
{$mode objfpc}{$H+}
interface
uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, Buttons,
  StdCtrls, ExtCtrls, IniPropStorage,
  dos;
type
  { TForm4 }
  TForm4 = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Image1: TImage;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    procedure Button1Click(Sender: TObject);
    procedure Form4Show(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 
var
  Form4: TForm4;
  b: byte;                                                   // general variable
  lang: string[2];                                      // language of programme
  pcount: byte;                                               // number of image
  pcountmax: byte;                                       // number of last image
  pnames: array[0..255] of string;                             // name of images

Resourcestring
  MESSAGE01='Gallery';
  MESSAGE02='&Close';
  MESSAGE03='There are not any pictures.';

implementation
uses frmMain;

{ TForm3 }

//-- close ---------------------------------------------------------------------
procedure TForm4.Button1Click(Sender: TObject);
begin
  Form4.Close;
end;

//-- paging --------------------------------------------------------------------
procedure TForm4.SpeedButton1Click(Sender: TObject);
begin
  if pcount>0 then pcount:=pcount-1;
  Form4.Caption:=MESSAGE01+' ('+Inttostr(pcount+1)+'/'+Inttostr(pcountmax+1)+')';
  if pcount>0 then SpeedButton1.Enabled:=True else SpeedButton1.Enabled:=False;
  if pcount>0 then SpeedButton3.Enabled:=True else SpeedButton3.Enabled:=False;
  if pcount<pcountmax then SpeedButton2.Enabled:=True else SpeedButton2.Enabled:=False;
  if pcount<pcountmax then SpeedButton4.Enabled:=True else SpeedButton4.Enabled:=False;
  try
  {$IFDEF LINUX}
    Image1.Picture.LoadFromFile(frmmain.exepath+'help/gallery/'+pnames[pcount]);
  {$ENDIF}
  {$IFDEF WINDOWS}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help\gallery\'+pnames[pcount]);
  {$ENDIF}
  except
    Image1.Picture.Clear;
  end;
end;

procedure TForm4.SpeedButton2Click(Sender: TObject);
begin
  if pcount<pcountmax then pcount:=pcount+1;
  Form4.Caption:=MESSAGE01+' ('+Inttostr(pcount+1)+'/'+Inttostr(pcountmax+1)+')';
  if pcount>0 then SpeedButton1.Enabled:=True else SpeedButton1.Enabled:=False;
  if pcount>0 then SpeedButton3.Enabled:=True else SpeedButton3.Enabled:=False;
  if pcount<pcountmax then SpeedButton2.Enabled:=True else SpeedButton2.Enabled:=False;
  if pcount<pcountmax then SpeedButton4.Enabled:=True else SpeedButton4.Enabled:=False;
  try
  {$IFDEF LINUX}
    Image1.Picture.LoadFromFile(frmmain.exepath+'help/gallery/'+pnames[pcount]);
  {$ENDIF}
  {$IFDEF WINDOWS}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help\gallery\'+pnames[pcount]);
  {$ENDIF}
  except
    Image1.Picture.Clear;
  end;
end;

procedure TForm4.SpeedButton3Click(Sender: TObject);
begin
  pcount:=0;
  Form4.Caption:=MESSAGE01+' ('+Inttostr(pcount+1)+'/'+Inttostr(pcountmax+1)+')';
  if pcount>0 then SpeedButton1.Enabled:=True else SpeedButton1.Enabled:=False;
  if pcount>0 then SpeedButton3.Enabled:=True else SpeedButton3.Enabled:=False;
  if pcount<pcountmax then SpeedButton2.Enabled:=True else SpeedButton2.Enabled:=False;
  if pcount<pcountmax then SpeedButton4.Enabled:=True else SpeedButton4.Enabled:=False;
  try
  {$IFDEF LINUX}
    Image1.Picture.LoadFromFile(frmmain.exepath+'help/gallery/'+pnames[pcount]);
  {$ENDIF}
  {$IFDEF WINDOWS}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help\gallery\'+pnames[pcount]);
  {$ENDIF}
  except
    Image1.Picture.Clear;
  end;
end;

procedure TForm4.SpeedButton4Click(Sender: TObject);
begin
  pcount:=pcountmax;
  Form4.Caption:=MESSAGE01+' ('+Inttostr(pcount+1)+'/'+Inttostr(pcountmax+1)+')';
  if pcount>0 then SpeedButton1.Enabled:=True else SpeedButton1.Enabled:=False;
  if pcount>0 then SpeedButton3.Enabled:=True else SpeedButton3.Enabled:=False;
  if pcount<pcountmax then SpeedButton2.Enabled:=True else SpeedButton2.Enabled:=False;
  if pcount<pcountmax then SpeedButton4.Enabled:=True else SpeedButton4.Enabled:=False;
  try
  {$IFDEF LINUX}
    Image1.Picture.LoadFromFile(frmmain.exepath+'help/gallery/'+pnames[pcount]);
  {$ENDIF}
  {$IFDEF WINDOWS}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help\gallery\'+pnames[pcount]);
  {$ENDIF}
  except
    Image1.Picture.Clear;
  end;
end;

//-- OnShow event --------------------------------------------------------------
procedure TForm4.Form4Show(Sender: TObject);
var
  searchresult: searchrec;
begin
  Form4.Caption:=MESSAGE01;
  Button1.Caption:=MESSAGE02;
  for pcount:=0 to 255 do
    pnames[pcount]:='';
  pcount:=0;
  pcountmax:=0;
  SpeedButton1.Enabled:=False;
  SpeedButton2.Enabled:=False;
  SpeedButton3.Enabled:=False;
  SpeedButton4.Enabled:=False;

  {$IFDEF LINUX}
  findfirst(frmmain.exepath+'help/gallery/*.png',anyfile,searchresult);
  while doserror=0 do
  begin
    with searchresult do
    begin
        pnames[pcount]:=name;
        if pcountmax<>254 then pcount:=pcount+1;
    end;
    findnext(searchresult);
  end;
  {$ENDIF}
  {$IFDEF WINDOWS}
  findfirst(frmmain.exepath+'help\gallery\*.png',anyfile,searchresult);
  while doserror=0 do
  begin
    with searchresult do
    begin
        pnames[pcount]:=name;
        if pcountmax<>254 then pcount:=pcount+1;
    end;
    findnext(searchresult);
  end;
  {$ENDIF}
  pcountmax:=pcount-1;
  pcount:=0;

  if pcountmax=0 then
  begin
    ShowMessage(MESSAGE03);
    Form4.Close;
  end;
  {$IFDEF LINUX}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help/gallery/'+pnames[0]);
  Form4.Caption:=MESSAGE01+' ('+Inttostr(pcount+1)+'/'+Inttostr(pcountmax+1)+')';
  {$ENDIF}
  {$IFDEF WINDOWS}
  Image1.Picture.LoadFromFile(frmmain.exepath+'help\gallery\'+pnames[0]);
  {$ENDIF}
  SpeedButton2.Enabled:=True;
  SpeedButton4.Enabled:=True;
end;

//-- Resize form ---------------------------------------------------------------
procedure TForm4.FormResize(Sender: TObject);
begin
  Bevel1.Height:=Height-45;
  Bevel1.Width:=Width-8;
  Image1.Height:=Bevel1.Height-2;
  Image1.Width:=Bevel1.Width-2;
  SpeedButton3.Top:=Height-29;
  SpeedButton1.Top:=Height-29;
  SpeedButton2.Top:=Height-29;
  SpeedButton4.Top:=Height-29;
  Button1.Top:=Height-29;
  Button1.Left:=Width-79;
end;

initialization
  {$I frmhelppic.lrs}
end.
