; Rs232/R/W mesztelen rutin
;Rem: a configurcios bellitsokat rtelemszeren kell bellitani
;
	list      p=16F877A       
  	#include <p16f877A.inc>		;proceszor definicios file behivsa  
	__CONFIG _CP_ALL & _WDT_OFF & _BODEN_OFF & _PWRTE_ON & _HS_OSC & _WRT_ENABLE_OFF & _LVP_OFF & _DEBUG_OFF & _CPD_OFF
    ERRORLEVEL -302
;**********************************************************************
#DEFINE		ini_rcsta	B'11010000'			;Rx bellits
#DEFINE		ini_txsta	B'01100000'			;Tx	bellits
#DEFINE		CLKFRQ		D'20000000'		;RAJEL
#DEFINE		BAUD(X)		(CLKFRQ/ (D'64'*X))-1		;rs 232 baudrate sebessge 
;*******************************************
;a felhasznlloi--/index/-- regiszterek definillsa
;*****************************************
Tx_dat		equ		0x5E			;a vett adat helye
Rx_dat		equ		0x5F			;a kldend adat helye
Timer0		equ		0x60
Timer1		equ		0x61

temp		EQU		0x67			;
temp1		EQU		0x68			;
Temp		EQU		0x69			;segd index


temp_st_m	EQU		0x6D	
Temp_W		EQU		0x6E			; Munka regiszter mentse
Temp_St		EQU		0x6F			; Status regiszter mentse
Temp_Pcl	EQU		0x71			; Pclath regiszter mentse,hogy minden laprl vissza menjen
Temp_Fsr	EQU		0x72			; File indirect regiszter mentse





;**********************************************************************
; PORTC kivezetsek
; RC6: TX
; RC7: RX
;**********************************************************************
		org	0x000				;hidegstart
		goto	Start			;megy konfigurlni
;**************************************************************************
		org	0x004
Megszakitas:
		bcf 	INTCON,GIE			; Megszakitsok letiltsa globlisan
		movwf	Temp_W				; Menti a work(munka) regiszter tartalmt(ezt elrontja)	
		swapf	STATUS,W			; Statusz beolvassa
		movwf	Temp_St				; Status mentse ( ha felttel elg. eltt jtt int kell)
		movf	PCLATH,W			; Pclath beolvassa ( a megszak. ms laprl is ltre jhet)
		movwf	Temp_Pcl			; Pclath elmentse
		clrf 	PCLATH				; Ugrskor ne ugorjon ms lapra( 0-s lap)
		clrf	STATUS				; Szintn a 0-s lap miatt (Ram is 0-as lapra)
		movf	FSR,W				; FSR beolvassa ( ha hasznl indirekt cimzst menteni kell)
		movwf	Temp_Fsr			; Fsr mentse	
;********************
int_feld:							;interrupt feldolgozs
		btfss	PIR1,RCIF
		goto	Int_feld_ret		;nem az Rx krt megszakitst vissza
		goto	Rx_olvas			;jtt adat megy olvasni
Int_feld_ret:	
		movf	Temp_Fsr,W
		movwf	FSR					; FSR vissza llitsa a megszakits eltti llapotra
		movf	Temp_Pcl,W
		movwf	PCLATH			; PCLATH vissza llitsa a megszakits eltti llapotra
		movf	Temp_St,W
		swapf	STATUS,W		; Status vissza llitsa a megszakits eltti llapotra
		movwf	STATUS
		swapf	Temp_W,F		; Work regiszer vissza llitsa a megszakits eltti llapotra
		swapf	Temp_W,W		; Azrt igy hogy a status ne vltozon meg
		
		bsf	    RCSTA,CREN		; vteli megszakits enged RS232
		banksel PIE1
		bsf	    PIE1,RCIE
		banksel INTCON
		movlw	B'11000000'
		movwf	INTCON
		retfie					
main:                          ;Ide jn a te programod		







;******************************************************************************************************
;			Rx- kezelse
;******************************************************************************************************
Rx_olvas:
		clrf	Rx_dat			;trli az tmeneti trat
		btfss	PIR1,5			;RCIF=1, HA BERKEZETT EGY KARAKTER
		goto	$-1
		movf	RCREG,0			;VETT ADAT A W-BEN VAN
		movwf	Rx_dat			;msol az Rx file registerbe tovbbi feldolgozsra
		clrw					;trli a W-t
;
;
;
;
;		a rutin annyiszor ahny byte fogads van
;		1 byte vtele
;
;
;
;****************************************
;		Tx-kezelse
;*****************************************
Dat_write:	
		clrf	temp
		clrf	temp1			;trli a tempet/parits/
firka:	
		movf	Tx_dat,0		;beolvassa az adni valo adatot a W-be
		call	Get_Paritas		;a parits kiszmmitsa
		bsf	STATUS,RP0
		bcf	TXSTA,TX9D			;
		btfss	temp,0
		bsf	TXSTA,TX9D		;Parits kiirsa
		bcf	STATUS,RP0	
		btfss	PIR1,4			;TXIF=1 HA KSZ AZ ADSRA
		goto	Pbyte1			;
		movwf	TXREG			;a kiirando adat a tx regiszterbe
		movlw	ini_rcsta
		movwf	RCSTA
        clrf	Tx_dat
		return					;vissza a main-ba
;
;
;		ha tbb byte-t kldesz akkor lptetmen kell
;		1 byte adsa
;
;************************************
Get_Paritas:
		movwf	temp
		movwf	temp1
		swapf	temp,w
		xorwf	temp,F
		rrf 	temp,W
		xorwf	temp,F
		btfsc	temp,2
		incf	temp,F
		movf	temp,W
;		comf	temp,F			;pros vagy pratlan parits
		movf	temp1,W
		return	
;****************************************
;		Konfig
;****************************************		
Start:						;trlsek s alaphelyzet
		clrf	STATUS
		clrf	PCLATH	
		movlw	0x20
		movwf	FSR
bank_torl:
		bcf		STATUS,IRP
		movlw	H'20'
		movf	FSR,0
		clrf	INDF
		incf	FSR,1
		movf	FSR,W
		xorlw	H'7F'
		btfss	STATUS,Z
		goto	bank_torl	
Init:								;portok definicioja
		bsf		STATUS,RP0			
		clrf	TRISB			;B alapon	
	   	movlw	B'10000000'		;C port	Rc7 bemenet Rc6 kimenet a tbbi tetszs szerint
	   	movwf	TRISC
		clrf	TRISD			;D alapon
		bcf		STATUS,RP0
		goto	init_port		;innen megy a port
init_port:							;Rx/TX definicioja
		bsf		STATUS,RP0		;bank1	
		movlw	BAUD(D'9600')	;Orajel 	
		movwf	SPBRG			;EZ 6 HA 9600 BIT/SEC-ESETN
		movlw	ini_txsta		;TX regiszter konfigurllsa
		movwf	TXSTA			;adat beitsa a regiszterbe
		bcf		STATUS,RP0		;bank0
		movlw	ini_rcsta		;RX  regiszter konfigurllsa
		movwf	RCSTA			;adat beitsa a regiszterbe
S_tart:	
		call	C_lear_dat			;az sszes adatindex trlse
		movlw	B'11000000'
		movwf	INTCON
		bsf		STATUS,RP0			;bank1
		movlw	B'00101000'
		movwf	PIE1
		bcf		OPTION_REG,INTEDG
		bcf		STATUS,RP0			;bank0
		call	C_lear_dat			
		goto	V_inic	
		
;**************************************************************************		
                end
