#include <REG932.H>
typedef unsigned char  	BYTE;
typedef unsigned short 	WORD;

static char ascii[] = "0123456789ABCDEF";

void UART_Init(void)
{
    P1M1 &= 0xFC;           /* TXD (P1.0) -> quasi bidir    */
//    P1M2 |= 0x01;           /* RXD (P1.1) -> quasi bidir    */

// BRG -> BRGR1,BRGR0 = (OSC / baudrate) - 16
// BRG -> BRGR1,BRGR0 = (7.373Mhz / 19200) - 16 = 0x170

    BRGR1  = 0x01;
    BRGR0  = 0x70;
    BRGCON = 3;
    AUXR1 |= 0x40;          /* enable break detect reset    */
    SCON = 0x52;            /* mode 1, receiver enable      */
}

char ua_inchar(void)	        /* this function looks if there is a character available*/
{
    if (!RI)
        return -1;
    else
    {
        RI = 0;
        return SBUF & 0x7F;
    }
}

char ua_getchar(void)		/* this function waits for a character */
{
  char	c;

	while (!RI)
		;
	c = SBUF & 0x7F;
	RI = 0;
	return c;
}

void ua_outchar(char c)		
{
    while (!TI)  ;
    SBUF = c;
    TI = 0;
}

void PrintByte(BYTE b, bit z)
{
    if (!z || ((b >> 4) != 0))
        ua_outchar(ascii[b >> 4]);

    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(WORD w)
{
    PrintByte((BYTE)(w>>8),0);
    PrintByte((BYTE)w,0);
}

void PrintLong(long l)
{
    PrintWord((WORD)(l>>16));
    PrintWord((WORD)l);
}

void PrintDecimal(BYTE b)
{
  BYTE p;

    p = ascii[b / 10];
    if (p != '0')
        ua_outchar(p);
    ua_outchar(ascii[b % 10]);
}

void PrintString(char *s)
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');         /* output a '\r' first               */
        ua_outchar(*s);
	s++;
    }
}
