/***************************************************************************/
/*  Name of module   : I2CDRIVR.C                                          */
/*  Program language : C51 (Keil version 7.03)                             */
/*  STATUS           : NOT TESTED !!!!                                     */
/*  Name             : P.H. Seerden                                        */
/*  Description      : Driver for the byte I2C hardware interface on       */
/*                     the Philips C51 microcontrollers.                   */
/*                     Part of the driver handling master bus transfers.   */
/*                     Everything between a Start and Stop condition is    */
/*                     called a TRANSFER. One transfer consists of one or  */
/*                     more MESSAGEs. To start a transfer call function    */
/*                     "I2C_Transfer".                                     */
/*                                                                         */
/*            (C) Copyright 2002 Philips Semiconductors B.V.               */
/*                                                                         */
/***************************************************************************/

#include <reg932.h>

#include "i2cexprt.h"


/*    Immediate data to write into I2CON                                   */
/*    CRSEL = 0 -> CLK determined by I2SCLH / L                            */

#define GENERATE_STOP        0x54     /* set STO, clear STA and SI         */
#define RELEASE_BUS_ACK      0x44     /* clear STO,STA,SI and set AA (ack) */
#define RELEASE_BUS_NOACK    0x40     /* clear STO, STA, SI and AA (noack) */
#define RELEASE_BUS_STA      0x64     /* generate (rep)START, set STA      */


static I2C_TRANSFER *tfr;             /* Ptr to active transfer block      */
static I2C_MESSAGE  *msg;             /* ptr to active message block       */

static BYTE msgCount;                 /* Number of messages to sent        */
static BYTE dataCount;                /* bytes send/received of message    */
	

void I2C_Interrupt(void) interrupt 6 using 1   // vector address = 0033h
{
    switch(I2STAT >> 3)
    {
      case 0x00:                         /* Bus Error has occured          */
        I2CON = GENERATE_STOP;
        break;
      case 0x01:                   /* (rep) Start condition transmitted    */
      case 0x02:                   /* Slave address + R/W are transmitted  */
        I2DAT = msg->address; 
        I2CON = RELEASE_BUS_ACK;
        break;
      case 0x03:               /* SLA+W or DATA transmitted, ACK received  */
      case 0x05:               /* DATA or STOP will be transmitted         */
        if (dataCount < msg->nrBytes)
        {
            I2DAT = msg->buf[dataCount++];           /* sent first byte    */
            I2CON = RELEASE_BUS_ACK;
        }
        else
        {
            if (msgCount < tfr->nrMessages)
            {
                dataCount = 0;
                msg = tfr->p_message[msgCount++];   /* next message        */
                I2CON = RELEASE_BUS_STA;            /* generate (rep)START */
            }
            else
            {
                I2CON = GENERATE_STOP;
                I2C_Ready(I2C_OK);
            }
        }
        break;
      case 0x04:
      case 0x09:              /* SLA+W/R transmitted, NOT ACK received     */
        I2C_Ready(I2C_NACK_ON_ADDRESS);      /* driver finished  */
        I2CON = GENERATE_STOP;
        break;
      case 0x06:              /* DATA transmitted, NOT ACK received        */
        I2C_Ready(I2C_NACK_ON_DATA);
        I2CON = GENERATE_STOP;
        break;
      case 0x07:              /* Arbitration lost in SLA+W or DATA         */
        I2CON = RELEASE_BUS_STA;                /* release bus, set STA    */
        break;
      case 0x08:                      /* SLA+R transmitted, ACK received   */
        if (msg->nrBytes == 1)
            I2CON = RELEASE_BUS_NOACK;          /* No ack on next byte     */
        else
            I2CON = RELEASE_BUS_ACK;            /* ACK on next byte        */
        break;
      case 0x0A:                /* DATA received, ACK has been returned    */
        msg->buf[dataCount++] = I2DAT;          /* read next data          */

        if (dataCount + 1 == msg->nrBytes)      /* next byte the last ?    */
            I2CON = RELEASE_BUS_NOACK;          /* No ack on next byte     */
        else
            I2CON = RELEASE_BUS_ACK;            /* return ACK              */
        break;
      case 0x0B:              /* DATA received, NOT ACK has been returned  */
        msg->buf[dataCount] = I2DAT;            /* read last data          */
        if (msgCount < tfr->nrMessages)
        {
            dataCount = 0;
            msg = tfr->p_message[msgCount++];     /* next message          */
            I2CON = RELEASE_BUS_STA;              /* generate (rep)START   */
        }
        else
        {
            I2CON = GENERATE_STOP;
            I2C_Ready(I2C_OK);
        }
        break;
      default: break;
    }
}

void I2C_Init(void)
/*****************/
{
// Fpclk = 7.373 Mhz internal oscillator
// I2c speed = Fpclk / (2*(I2SCLH+I2SCLL)

    P1M1 |= 0x0C;        /* Configure P1.2 and P1.3 to open drain    */
    P1M2 |= 0x0C;
    I2ADR = 0x26;        /* set default slave address                */
    I2SCLH = 19;         /* set I2C speed to ~100KHz, 50% duty cycle */
    I2SCLL = 19;
    I2CON = RELEASE_BUS_ACK;      /* enable I2C hardware             */
    EI2C  = 1;                    /* enable I2C interrupt            */
}

void I2C_Transfer(I2C_TRANSFER *p)
/*********************************
 * Input(s)   : p            address of IC transfer parameter block.
 * Description: Start an I2C transfer, containing 1 or more messages. The
 *              application must leave the transfer parameter block 
 *              untouched until the ready procedure is called.
 *              The first I2C message is started with sending a start
 *              condition followed by the slave address.
 ***************************************************************************/
{
    tfr = p;
    msgCount  = 0;
    dataCount = 0;
    msg = tfr->p_message[msgCount++];     /* first message to send         */

    I2CON = RELEASE_BUS_STA;              /* generate START condition      */
}
