
#include <avr/io.h>
#include <util/delay.h>
#include <inttypes.h>

#include "alcd.h"

char halfByte(unsigned char c) {
    unsigned char h;
    h=c&0xf;
    if(h>9)
        h+=('A'-10);
    else
        h+='0';
    return h;
}

void printhex(unsigned char c) {
    unsigned char d;
    d=halfByte(c>>4);
    lcd_putc(d);
    d=halfByte(c);
    lcd_putc(d);
}

unsigned char check(unsigned c) {
    unsigned char ret;
    unsigned char b1 = 0;
    unsigned char b2 = 0;
    unsigned char b3 = 0;
    unsigned char b4 = 0;

    switch(c) {
        case 0:
            b1=0;
            b2=0;
            b3=0;
            b4=0;
            break;
        case 1:
            b1=1;
            b2=1;
            b3=1;
            b4=1;
            break;
        case 2:
            b1=2;
            b2=2;
            b3=2;
            b4=2;
            break;
        case 3:
            b1=3;
            b2=3;
            b3=3;
            b4=3;
            break;
        case 4:
            b1=4;
            b2=4;
            b3=4;
            b4=4;
            break;
        case 5:
            b1=5;
            b2=5;
            b3=5;
            b4=5;
            break;
        case 6:
            b1=6;
            b2=6;
            b3=6;
            b4=6;
            break;
        case 7:
            b1=7;
            b2=7;
            b3=7;
            b4=7;
            break;
        case 8:
            b1=8;
            b2=8;
            b3=8;
            b4=8;
            break;
        case 9:
            b1=9;
            b2=9;
            b3=9;
            b4=9;
            break;
        case 10:
            b1=10;
            b2=10;
            b3=10;
            b4=10;
            break;
        case 11:
            b1=11;
            b2=11;
            b3=11;
            b4=11;
            break;
        case 12:
            b1=12;
            b2=12;
            b3=12;
            b4=12;
            break;
        case 13:
            b1=13;
            b2=13;
            b3=13;
            b4=13;
            break;
        case 14:
            b1=14;
            b2=14;
            b3=14;
            b4=14;
            break;
        case 15:
            b1=15;
            b2=15;
            b3=15;
            b4=15;
            break;
        default:
            break;
    }
    ret=b1|b2|b3|b4;
    return ret;
}

//-------------------------------------
int main(void) {
//-------------------------------------
    int i;
    unsigned char c;
    unsigned char chk;

    _delay_ms(10);

    lcd_init(LCD_DISP_ON);
    lcd_clrscr();

    c=0;
    while(1) {
        lcd_gotoxy(0,0);
        printhex(c);
        lcd_putc(' ');
        chk=check(c);
        printhex(chk);
        c++;
        if(c==16)
        {
            c=0;
        }
        for(i=0;i<100;i++)
        {
            _delay_ms(10);
        }
    }

}

