/*
Ez a header fjl 4 db 7szegmenses kijelz hasznlatt valsitja meg 74 595 -s shift regiszterrel.
Mivel a kijelzk 7 szegmensesek a regiszterek viszont 8bitesek ezrt figyelni kell ,hogy minden szmot 8 bit
reprezentl. Az utols bit teljesen mind1 ,hiszen nincs is bektve.

A fjl negatv logiks kijelzhz kszlt.

SH_CP = adat rajel, DS = adat, ST_CP = engedlyezs
*/

#define DS  PIN_B0
#define SH_CP PIN_B1
#define ST_CP PIN_B2
int1 kj = 1;  //kijelz be vagy kikapcsolt...

void clock(void){
output_low(SH_CP);
output_high(SH_CP);
}

void enabled(void){
output_low(ST_CP);
output_high(ST_CP);
}

void send_bit(int1 bit){
output_bit(DS, bit);
clock();

}

void init(void){
   int i;
   for(i = 0; i < 31; i++){
      send_bit(1);
   }
}

void send(int mit){
   send_bit(0); //a regiszteren lv nyolcadik bit miatt kell, ami nincs bektve.
   switch(mit){
      case 0:
         send_bit(1);   //g
         send_bit(0);   //f
         send_bit(0);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break;
      case 1:
         send_bit(1);   //g
         send_bit(1);   //f
         send_bit(1);   //e
         send_bit(1);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(1);   //a
         break;
      case 2:
         send_bit(0);   //g
         send_bit(1);   //f
         send_bit(0);   //e
         send_bit(0);   //d
         send_bit(1);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break; 
      case 3:
         send_bit(0);   //g
         send_bit(1);   //f
         send_bit(1);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break;  
      case 4:
         send_bit(0);   //g
         send_bit(0);   //f
         send_bit(1);   //e
         send_bit(1);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(1);   //a
         break; 
         case 5:
         send_bit(0);   //g
         send_bit(0);   //f
         send_bit(1);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(1);   //b
         send_bit(0);   //a
         break;
         case 6:
         send_bit(0);   //g
         send_bit(0);   //f
         send_bit(0);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(1);   //b
         send_bit(0);   //a
         break;
         case 7:
         send_bit(1);   //g
         send_bit(1);   //f
         send_bit(1);   //e
         send_bit(1);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break;
         case 8:
         send_bit(0);   //g
         send_bit(0);   //f
         send_bit(0);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break;
         case 9:
         send_bit(0);   //g
         send_bit(0);   //f
         send_bit(1);   //e
         send_bit(0);   //d
         send_bit(0);   //c
         send_bit(0);   //b
         send_bit(0);   //a
         break;
      default: 
         send_bit(0);   //g
         send_bit(1);   //f
         send_bit(1);   //e
         send_bit(1);   //d
         send_bit(1);   //c
         send_bit(1);   //b
         send_bit(1);   //a
         break;
   }
   
   
}

void ido(int ora, int perc){
   if(kj == 1){
      send(ora / 10);
      send(ora % 10);
   
      send(perc / 10);
      send(perc % 10);
   
      enabled();
   }
   else{
      init();
      enabled();
   }
}

void kj_toggle(void){
   if(kj == 1) kj = 0;
   else kj = 1;
}




